/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.util.DebugAbstractList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class DebugArrayList
extends DebugAbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long G = 8683452581122892189L;
    private transient Object[] F;
    private int E;

    public DebugArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.F = new Object[n];
    }

    public DebugArrayList() {
        this(10);
    }

    public DebugArrayList(Collection collection) {
        this.E = collection.size();
        this.F = new Object[(int)Math.min((long)this.E * 110L / 100L, Integer.MAX_VALUE)];
        collection.toArray(this.F);
    }

    public void trimToSize() {
        this.increaseModCount();
        int n = this.F.length;
        if (this.E < n) {
            Object[] objectArray = this.F;
            this.F = new Object[this.E];
            System.arraycopy(objectArray, 0, this.F, 0, this.E);
        }
    }

    public void ensureCapacity(int n) {
        this.increaseModCount();
        int n2 = this.F.length;
        if (n > n2) {
            Object[] objectArray = this.F;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.F = new Object[n3];
            System.arraycopy(objectArray, 0, this.F, 0, this.E);
        }
    }

    public int size() {
        return this.E;
    }

    public boolean isEmpty() {
        return this.E == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.E; ++i) {
                if (this.F[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.E; ++i) {
                if (!object.equals(this.F[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.E - 1; i >= 0; --i) {
                if (this.F[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.E - 1; i >= 0; --i) {
                if (!object.equals(this.F[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            DebugArrayList debugArrayList = (DebugArrayList)super.clone();
            debugArrayList.F = new Object[this.E];
            System.arraycopy(this.F, 0, debugArrayList.F, 0, this.E);
            debugArrayList.modCount = 0;
            return debugArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.E];
        System.arraycopy(this.F, 0, objectArray, 0, this.E);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.E) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.E);
        }
        System.arraycopy(this.F, 0, objectArray, 0, this.E);
        if (objectArray.length > this.E) {
            objectArray[this.E] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        this.B(n);
        return this.F[n];
    }

    public Object set(int n, Object object) {
        this.B(n);
        Object object2 = this.F[n];
        this.F[n] = object;
        return object2;
    }

    public boolean add(Object object) {
        this.ensureCapacity(this.E + 1);
        this.F[this.E++] = object;
        return true;
    }

    public void add(int n, Object object) {
        if (n > this.E || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.E);
        }
        this.ensureCapacity(this.E + 1);
        System.arraycopy(this.F, n, this.F, n + 1, this.E - n);
        this.F[n] = object;
        ++this.E;
    }

    public Object remove(int n) {
        this.B(n);
        this.increaseModCount();
        Object object = this.F[n];
        int n2 = this.E - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.F, n + 1, this.F, n, n2);
        }
        this.F[--this.E] = null;
        return object;
    }

    public void clear() {
        this.increaseModCount();
        for (int i = 0; i < this.E; ++i) {
            this.F[i] = null;
        }
        this.E = 0;
    }

    public boolean addAll(Collection collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacity(this.E + n);
        System.arraycopy(objectArray, 0, this.F, this.E, n);
        this.E += n;
        return n != 0;
    }

    public boolean addAll(int n, Collection collection) {
        if (n > this.E || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.E);
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacity(this.E + n2);
        int n3 = this.E - n;
        if (n3 > 0) {
            System.arraycopy(this.F, n, this.F, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.F, n, n2);
        this.E += n2;
        return n2 != 0;
    }

    protected void removeRange(int n, int n2) {
        this.increaseModCount();
        int n3 = this.E - n2;
        System.arraycopy(this.F, n2, this.F, n, n3);
        int n4 = this.E - (n2 - n);
        while (this.E != n4) {
            this.F[--this.E] = null;
        }
    }

    private void B(int n) {
        if (n >= this.E) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.E);
        }
    }

    private void A(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.F.length);
        for (int i = 0; i < this.E; ++i) {
            objectOutputStream.writeObject(this.F[i]);
        }
    }

    private void A(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.F = new Object[n];
        for (int i = 0; i < this.E; ++i) {
            this.F[i] = objectInputStream.readObject();
        }
    }
}

