/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class Files {
    public static final int FILTER_START = 1;
    public static final int FILTER_END = 2;
    public static final int FILTER_CONTAINED = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileContent(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("Source file does not exist");
        }
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        File file4 = file;
        synchronized (file4) {
            File file5 = file2;
            synchronized (file5) {
                FileInputStream fileInputStream = null;
                BufferedInputStream bufferedInputStream = null;
                FileOutputStream fileOutputStream = null;
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    int n;
                    fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    fileOutputStream = new FileOutputStream(file2);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    while ((n = bufferedInputStream.read()) != -1) {
                        bufferedOutputStream.write(n);
                    }
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Files.close(bufferedInputStream);
                    Files.close(fileInputStream);
                    Files.close(bufferedOutputStream);
                    Files.close(fileOutputStream);
                    throw throwable;
                }
                Files.close(bufferedInputStream);
                Files.close(fileInputStream);
                Files.close(bufferedOutputStream);
                Files.close(fileOutputStream);
            }
        }
    }

    public static void writeTextFile(File file, String string) throws IOException {
        Files.writeTextFile(file, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            Files.writeString(bufferedOutputStream, string, string2);
            bufferedOutputStream.flush();
            fileOutputStream.flush();
        }
        catch (Throwable throwable) {
            Files.close(fileOutputStream);
            Files.close(bufferedOutputStream);
            throw throwable;
        }
        Files.close(fileOutputStream);
        Files.close(bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            fileOutputStream.flush();
        }
        catch (Throwable throwable) {
            Files.close(fileOutputStream);
            Files.close(bufferedOutputStream);
            throw throwable;
        }
        Files.close(fileOutputStream);
        Files.close(bufferedOutputStream);
    }

    public static final byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] byArray;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        List list = CollectionFactory.createArrayList();
        int n = 256;
        int n2 = 0;
        int n3 = 0;
        while (n3 > -1) {
            byArray = new byte[256];
            n3 = bufferedInputStream.read(byArray, 0, 256);
            if (n3 > -1) {
                n2 += n3;
            }
            list.add(byArray);
        }
        bufferedInputStream.close();
        byArray = new byte[n2];
        n3 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] byArray2 = (byte[])iterator.next();
            for (int i = 0; i < byArray2.length && n3 < n2; ++n3, ++i) {
                byArray[n3] = byArray2[i];
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws FileNotFoundException, IOException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byArray = Files.readStream(bufferedInputStream);
        }
        catch (Throwable throwable) {
            Files.close(fileInputStream);
            Files.close(bufferedInputStream);
            throw throwable;
        }
        Files.close(fileInputStream);
        Files.close(bufferedInputStream);
        return byArray;
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        byte[] byArray;
        List list = CollectionFactory.createArrayList();
        int n = 0;
        int n2 = 0;
        while (n2 > -1) {
            byArray = new byte[64];
            n2 = inputStream.read(byArray, 0, 64);
            if (n2 > -1) {
                n += n2;
            }
            list.add(byArray);
        }
        byArray = new byte[n];
        n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] byArray2 = (byte[])iterator.next();
            for (int i = 0; i < byArray2.length && n2 < n; ++n2, ++i) {
                byArray[n2] = byArray2[i];
            }
        }
        return byArray;
    }

    public static String getSuffix(File file) {
        String string = file.getName();
        String string2 = Files.getSuffix(string);
        return string2;
    }

    public static String getSuffix(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(n + 1) : "";
        return string2;
    }

    public static boolean checkFolderExistence(String string, boolean bl) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                if (bl) {
                    return file.canWrite();
                }
                return true;
            }
            Services.logWarn("Given path does not denote a folder! " + string);
            return false;
        }
        return false;
    }

    public static File createFolder(String string) {
        File file = new File(string);
        try {
            if (file.mkdirs()) {
                return file;
            }
            return null;
        }
        catch (SecurityException securityException) {
            Services.logWarn("Not all directories could be created due to security problems. " + securityException.getMessage());
            return null;
        }
    }

    public static File checkExistenceOrCreateFolder(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return file;
            }
            Services.logWarn("Given path does not denote a folder! " + string);
            return null;
        }
        return Files.createFolder(string);
    }

    public static void clearDirectory(File file, boolean bl) {
        if (file.exists() && file.isDirectory()) {
            boolean bl2 = true;
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Services.logInfo("Could not access content of directory: " + file.getName());
                throw new IllegalArgumentException("No access rights for directory: " + file.getName());
            }
            if (!file.canWrite()) {
                Services.logInfo("Could not delete files in directory because of missing access rights: " + file.getName());
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (bl) {
                        try {
                            Files.clearDirectory(file2, bl);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            bl2 = false;
                        }
                    }
                    if (file2.listFiles().length != 0) continue;
                    if (!file2.canWrite()) {
                        bl2 = false;
                        continue;
                    }
                    bl2 &= file2.delete();
                    continue;
                }
                if (!file2.exists()) continue;
                bl2 &= file2.delete();
            }
            if (bl2) {
                Services.logInfo("All entries for directory deleted: " + file.getName());
            } else {
                Services.logInfo("Could not delete all entries for directory because of missing access rights: " + file.getName());
            }
        } else {
            throw new IllegalArgumentException("Given file is not a directory: " + file.getName());
        }
    }

    public static void deleteMatchingFiles(File file, String string, int n, boolean bl) {
        if (file.exists() && file.isDirectory()) {
            boolean bl2 = true;
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Services.logInfo("Could not access content of directory: " + file.getName());
                throw new IllegalArgumentException("No access rights for directory: " + file.getName());
            }
            if (!file.canWrite()) {
                Services.logInfo("Could not delete files in directory because of missing access rights: " + file.getName());
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (bl) {
                        try {
                            Files.deleteMatchingFiles(file2, string, n, bl);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            bl2 &= false;
                        }
                    }
                    if (!Files.A(file2, string, n) || file2.listFiles().length != 0) continue;
                    bl2 &= file2.delete();
                    continue;
                }
                if (!file2.exists() || !Files.A(file2, string, n)) continue;
                if (!file2.canWrite()) {
                    bl2 = false;
                    continue;
                }
                bl2 &= file2.delete();
            }
            if (bl2) {
                Services.logInfo("All entries for directory deleted: " + file.getName());
            } else {
                Services.logInfo("Could not delete all entries for directory because of missing access rights: " + file.getName());
            }
        } else {
            throw new IllegalArgumentException("Given file is not a directory: " + file.getName());
        }
    }

    private static boolean A(File file, String string, int n) {
        String string2 = file.getName();
        if (n == 1) {
            return string2.startsWith(string);
        }
        if (n == 2) {
            return string2.endsWith(string);
        }
        if (n == 3) {
            int n2 = string2.indexOf(string);
            return n2 >= 0;
        }
        throw new IllegalArgumentException("Filter position is invalid: " + n);
    }

    public static boolean isContained(File file, File file2, boolean bl) throws IOException {
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        String string3 = System.getProperty("file.separator");
        String string4 = string2 + string3;
        boolean bl2 = string.startsWith(string4);
        if (bl2 && !bl) {
            int n = string4.length();
            int n2 = string.indexOf(string3, n);
            bl2 = n2 == -1;
        }
        return bl2;
    }

    public static String readTextFile(File file) {
        String string = null;
        try {
            string = Files.readTextFile(file, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Services.logError("File " + file + " does not exist", fileNotFoundException);
        }
        catch (IOException iOException) {
            Services.logError("Problem reading " + file, iOException);
        }
        return string;
    }

    public static String readUtf8TextFile(File file) throws IOException {
        return Files.readTextFile(file, "utf-8");
    }

    public static String readAsciiTextFile(File file) throws IOException {
        return Files.readTextFile(file, "ISO-8859-15");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, String string) throws IOException {
        String string2;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            String string3;
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            string2 = string3 = Files.readString(bufferedInputStream, string);
        }
        catch (Throwable throwable) {
            Files.close(fileInputStream);
            Files.close(bufferedInputStream);
            throw throwable;
        }
        Files.close(fileInputStream);
        Files.close(bufferedInputStream);
        return string2;
    }

    public static String readString(InputStream inputStream, String string) throws IOException {
        return Files.readString(inputStream, string, Integer.MAX_VALUE);
    }

    public static String readString(InputStream inputStream, String string, int n) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n && (n2 = inputStreamReader.read()) != -1; ++i) {
            char c = (char)n2;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void writeString(OutputStream outputStream, String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string2);
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
    }

    public static String readStringFromUrl(URL uRL, int n) throws IOException {
        return Files.readStringFromUrl(uRL, "ISO-8859-15", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromUrl(URL uRL, String string, int n) throws IOException {
        String string2;
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            inputStream = uRL.openStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            string2 = Files.readString(bufferedInputStream, string, n);
        }
        catch (Throwable throwable) {
            Files.close(inputStream);
            Files.close(bufferedInputStream);
            throw throwable;
        }
        Files.close(inputStream);
        Files.close(bufferedInputStream);
        return string2;
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getCanonicalPath(String string) {
        String string2 = string;
        try {
            string2 = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            Services.logInfo(iOException);
        }
        return string2;
    }

    public static File getCanonicalFile(File file) {
        try {
            File file2 = file.getCanonicalFile();
            return file2;
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static File createTempDir(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        file = Files.getCanonicalFile(file);
        file.delete();
        file.mkdir();
        file.deleteOnExit();
        return file;
    }

    public static File getTmpDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string);
        return file;
    }
}

