/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.ToStringMapper;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class Strings {
    public static final int CONCATENATION_UNLIMITED = 0;
    private static final ToStringMapper C = new ToStringMapper(){

        public String toString(Object object) {
            String string = String.valueOf(object);
            return string;
        }

        public String toString() {
            return super.toString() + " [Strings.DEFAULT_TO_STRING_MAPPER]";
        }
    };
    public static final ToStringMapper FILE_TO_STRING_MAPPER = new ToStringMapper(){

        public String toString(Object object) throws NullPointerException {
            File file = (File)object;
            String string = file.getAbsolutePath();
            return string;
        }

        public String toString() {
            return super.toString() + " [Strings.FILE_TO_STRING_MAPPER]";
        }
    };
    private static String D = "ISO-8859-1";
    private static String B = "utf-8";
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int A = 20;
    public static final String ELLIPSIS = "...";
    public static final Comparator STRING_IGNORE_CASE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            String string = String.valueOf(object);
            String string2 = String.valueOf(object2);
            int n = Strings.compare(string, string2, false);
            return n;
        }
    };

    private Strings() {
    }

    public static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Strings.replaceAll(stringBuffer, string2, string3);
        return new String(stringBuffer);
    }

    public static String replaceFirst(String string, String string2, String string3) {
        int n;
        String string4 = string;
        if (string2.length() > 0 && (n = string.indexOf(string2)) >= 0) {
            string4 = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string4;
    }

    public static String join(Collection collection, String string) throws NullPointerException {
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 20);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static int indexOf(StringBuffer stringBuffer, String string, int n) {
        int n2 = new String(stringBuffer).indexOf(string, n);
        return n2;
    }

    public static void replaceAll(StringBuffer stringBuffer, String string, String string2) {
        if (string.length() > 0) {
            int n = 0;
            int n2 = string.length();
            int n3 = string2.length();
            while ((n = Strings.indexOf(stringBuffer, string, n)) >= 0) {
                stringBuffer.replace(n, n + n2, string2);
                n += n3;
            }
        }
    }

    public static String upperFirstChar(String string) {
        char c;
        String string2 = string;
        if (string.length() > 0 && Character.isLowerCase(c = string.charAt(0))) {
            string2 = Character.toUpperCase(c) + string.substring(1);
        }
        return string2;
    }

    public static String lowerFirstChar(String string) {
        char c;
        String string2 = string;
        if (string.length() > 0 && Character.isUpperCase(c = string.charAt(0))) {
            string2 = Character.toLowerCase(c) + string.substring(1);
        }
        return string2;
    }

    public static boolean isEmpty(String string) {
        boolean bl = string == null || string.length() == 0;
        return bl;
    }

    public static boolean equals(String string, String string2) {
        boolean bl = string == null && string2 == null || string != null && string.equals(string2);
        return bl;
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        boolean bl = string == null && string2 == null || string != null && string.equalsIgnoreCase(string2);
        return bl;
    }

    public static String substring(String string, int n) {
        String string2;
        if (n > string.length()) {
            string2 = "";
        } else {
            int n2 = Math.max(0, n);
            string2 = string.substring(n2);
        }
        return string2;
    }

    public static String substring(String string, int n, int n2) {
        String string2;
        int n3 = string.length();
        if (n >= n3 || n >= n2) {
            string2 = "";
        } else {
            int n4 = Math.max(0, n);
            int n5 = Math.min(n3, n2);
            string2 = string.substring(n4, n5);
        }
        return string2;
    }

    public static String left(String string, int n) {
        return Strings.substring(string, 0, n);
    }

    public static String right(String string, int n) {
        int n2 = string.length();
        int n3 = Math.min(n, n2);
        return string.substring(n2 - n3);
    }

    public static String mid(String string, int n, int n2) {
        int n3 = n2 > 0 ? n : n + n2;
        int n4 = n2 > 0 ? n + n2 : n;
        return Strings.substring(string, n3, n4);
    }

    public static String center(String string, int n) {
        return Strings.center(string, n, ' ');
    }

    public static String center(String string, int n, char c) {
        String string2;
        int n2 = string.length();
        if (n2 >= n) {
            string2 = string;
        } else {
            int n3 = Math.max(0, n - n2);
            string2 = Strings.repeat(c, n3 / 2) + string + Strings.repeat(c, n3 / 2 + n3 % 2);
        }
        return string2;
    }

    public static String rightPad(String string, int n) {
        return Strings.rightPad(string, n, ' ');
    }

    public static String rightPad(String string, int n, char c) {
        String string2;
        int n2 = string.length();
        if (n2 >= n) {
            string2 = string;
        } else {
            int n3 = Math.max(0, n - n2);
            string2 = string + Strings.repeat(c, n3);
        }
        return string2;
    }

    public static String leftPad(String string, int n) {
        return Strings.leftPad(string, n, ' ');
    }

    public static String leftPad(String string, int n, char c) {
        String string2;
        int n2 = string.length();
        if (n2 >= n) {
            string2 = string;
        } else {
            int n3 = Math.max(0, n - n2);
            string2 = Strings.repeat(c, n3) + string;
        }
        return string2;
    }

    public static String escape(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                stringBuffer.append("\\u" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append("\\u0" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f' && bl) {
                stringBuffer.append("\\u00" + Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('b');
                        break;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        break;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        break;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        break;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringBuffer.append("\\u00" + Integer.toHexString(c));
                            break;
                        }
                        stringBuffer.append("\\u000" + Integer.toHexString(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\'');
                    continue block12;
                }
                case '\"': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\"');
                    continue block12;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block12;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        String string2 = new String(stringBuffer);
        return string2;
    }

    public static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        String string2 = new String(stringBuffer);
        return string2;
    }

    public static int countMatches(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n2) + 1) > 0) {
                ++n;
            }
        }
        return n;
    }

    public static boolean isAlpha(String string) {
        return Strings.isAlpha(string, null);
    }

    public static boolean isAlpha(String string, String string2) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; bl && i < n; ++i) {
            char c = string.charAt(i);
            bl = Character.isLetter(c) || string2 != null && string2.indexOf(c) >= 0;
        }
        return bl;
    }

    public static boolean isAlphanumeric(String string) {
        return Strings.isAlphanumeric(string, null);
    }

    public static boolean isAlphanumeric(String string, String string2) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; bl && i < n; ++i) {
            char c = string.charAt(i);
            bl = Character.isLetterOrDigit(c) || string2 != null && string2.indexOf(c) >= 0;
        }
        return bl;
    }

    public static boolean isNumeric(String string) {
        return Strings.isNumeric(string, null);
    }

    public static boolean isNumeric(String string, String string2) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; bl && i < n; ++i) {
            char c = string.charAt(i);
            bl = Character.isDigit(c) || string2 != null && string2.indexOf(c) >= 0;
        }
        return bl;
    }

    public static String noNull(String string) {
        return string == null ? "" : string;
    }

    public static String noNull(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static String reverse(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.reverse();
        return new String(stringBuffer);
    }

    public static boolean containsOnly(String string, char[] cArray) {
        int n = string.length();
        int n2 = cArray.length;
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            bl = false;
            for (int j = 0; !bl && j < n2; ++j) {
                bl = cArray[j] == string.charAt(i);
            }
        }
        return bl;
    }

    public static boolean containsAny(String string, char[] cArray) {
        int n = string.length();
        int n2 = cArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (cArray[j] != string.charAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] getAsciiBytes(String string) {
        try {
            byte[] byArray = string.getBytes(D);
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Services.logError(D + " encoding not supported! ", unsupportedEncodingException);
            return null;
        }
    }

    public static String createStringFromAsciiBytes(byte[] byArray) {
        return Strings.createStringFromAsciiBytes(byArray, 0, byArray.length);
    }

    public static String createStringFromAsciiBytes(byte[] byArray, int n, int n2) {
        try {
            String string = new String(byArray, n, n2, D);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Services.logError(D + " encoding not supported! ", unsupportedEncodingException);
            return null;
        }
    }

    public static byte[] getUtf8Bytes(String string) {
        try {
            byte[] byArray = string.getBytes(B);
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Services.logError(B + " encoding not supported! ", unsupportedEncodingException);
            return null;
        }
    }

    public static String createStringFromUtf8Bytes(byte[] byArray) {
        try {
            String string = new String(byArray, B);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Services.logError(B + " encoding not supported! ", unsupportedEncodingException);
            return null;
        }
    }

    public static int compare(String string, String string2, boolean bl) {
        boolean bl2 = Strings.isEmpty(string);
        boolean bl3 = Strings.isEmpty(string2);
        int n = bl2 && bl3 ? 0 : (bl2 ? -1 : (bl3 ? 1 : (bl ? string.compareTo(string2) : string.compareToIgnoreCase(string2))));
        return n;
    }

    public static String wrap(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        for (int i = 0; i < n2; i += n) {
            String string3 = Strings.mid(string, i, n);
            stringBuffer.append(string2);
            stringBuffer.append(string3);
            string2 = "\n";
        }
        return new String(stringBuffer);
    }

    public static String encodeForXml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append(Strings.A(c));
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (i == 0 && c == '/') {
                stringBuffer.append(Strings.A(c));
                continue;
            }
            if (c >= ' ' && c < '\u0080') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(Strings.A(c));
        }
        return new String(stringBuffer);
    }

    private static String A(char c) {
        return "&#" + Integer.toString(c) + ";";
    }

    public static String trimLeft(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) <= ' '; ++n) {
        }
        return n == 0 ? string : string.substring(n);
    }

    public static String trimRight(String string) {
        int n;
        int n2;
        for (n2 = n = string.length() - 1; n2 >= 0 && string.charAt(n2) <= ' '; --n2) {
        }
        return n2 == n ? string : string.substring(0, n2 + 1);
    }

    public static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) != 92) {
                stringBuffer.append((char)n3);
                continue;
            }
            if ((n3 = string.charAt(n2++)) == 117) {
                int n4 = 0;
                for (int i = 0; i < 4; ++i) {
                    n3 = string.charAt(n2++);
                    int n5 = Strings.B((char)n3);
                    n4 = (n4 << 4) + n5;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            if (n3 == 116) {
                n3 = 9;
            } else if (n3 == 114) {
                n3 = 13;
            } else if (n3 == 110) {
                n3 = 10;
            } else if (n3 == 102) {
                n3 = 12;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private static int B(char c) {
        int n;
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                n = c - 48;
                break;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                n = c - 97 + 10;
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                n = c - 65 + 10;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a hex digit.");
            }
        }
        return n;
    }

    public static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Not a hex digit value: " + n);
        }
        return HEX_DIGITS[15];
    }

    public static String createConcatenation(Collection collection, String string) {
        return Strings.createConcatenation(collection, string, 0, null);
    }

    public static String createConcatenation(Collection collection, String string, int n) {
        return Strings.createConcatenation(collection, string, n, null);
    }

    public static String createConcatenation(Collection collection, String string, int n, ToStringMapper toStringMapper) throws NullPointerException {
        if (toStringMapper == null) {
            toStringMapper = C;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        boolean bl = n > 0;
        Iterator iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && (!bl || i < n); ++i) {
            Object e = iterator.next();
            String string3 = toStringMapper.toString(e);
            stringBuffer.append(string2);
            stringBuffer.append(string3);
            string2 = string;
        }
        if (bl && collection.size() > n) {
            stringBuffer.append(string2);
            stringBuffer.append(ELLIPSIS);
        }
        return stringBuffer.toString();
    }

    public static List mapToString(Collection collection, ToStringMapper toStringMapper) throws NullPointerException {
        if (toStringMapper == null) {
            toStringMapper = C;
        }
        List list = CollectionFactory.createArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = toStringMapper.toString(e);
            list.add(string);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAsciiArt(Font font, String string) {
        try {
            if (string == null) {
                string = "(null)";
            }
            int n = 4;
            string = string.replaceAll("\\t", Strings.repeat(' ', 4));
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = string.split("\n|\r\n", 0);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string2);
                Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                int n2 = (int)rectangle2D.getWidth();
                int n3 = (int)rectangle2D.getHeight();
                if (string2.length() == 0) {
                    stringBuffer.append(Strings.repeat('\n', n3));
                    continue;
                }
                TextLayout textLayout = new TextLayout(string2, font, fontRenderContext);
                float f = textLayout.getAscent();
                BufferedImage bufferedImage = new BufferedImage(n2, n3, 12);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                try {
                    graphics2D.drawGlyphVector(glyphVector, 0.0f, f);
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    int[] nArray = new int[1];
                    for (int j = 0; j < n3; ++j) {
                        for (int k = 0; k < n2; ++k) {
                            writableRaster.getPixel(k, j, nArray);
                            int n4 = nArray[0];
                            stringBuffer.append(n4 > 0 ? (char)'#' : ' ');
                        }
                        stringBuffer.append('\n');
                    }
                    continue;
                }
                finally {
                    graphics2D.dispose();
                }
            }
            return new String(stringBuffer);
        }
        catch (RuntimeException runtimeException) {
            return string;
        }
    }
}

