/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.Services;
import com.gentleware.services.swingx.MessageFrame;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.util.Geometry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SwingUtil {
    private static int A;

    private SwingUtil() {
    }

    public static void centerOnScreen(Window window) {
        SwingUtil.centerOnScreen(window, 0.5f, 0.5f);
    }

    public static void centerOnScreen(Window window, float f, float f2) {
        int n;
        int n2;
        Rectangle rectangle;
        Container container = window.getParent();
        if (container == null) {
            rectangle = SwingUtil.getPrimaryScreenBounds();
        } else {
            n2 = container.getWidth();
            n = container.getHeight();
            Point point = new Point(n2 / 2, n / 2);
            SwingUtilities.convertPointToScreen(point, container);
            rectangle = SwingUtil.getScreenBounds(point.x, point.y, false);
        }
        n2 = rectangle.x;
        n = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = window.getWidth();
        int n6 = window.getHeight();
        int n7 = (int)((float)n2 + f * (float)(n3 - n5));
        int n8 = (int)((float)n + f2 * (float)(n4 - n6));
        n7 = Math.min(n7, n2 + n3 - n5);
        n8 = Math.min(n8, n + n4 - n6);
        n7 = Math.max(n7, n2);
        n8 = Math.max(n8, n);
        window.setLocation(n7, n8);
    }

    public static void makePreferSameSize(JComponent[] jComponentArray) {
        Dimension dimension;
        JComponent jComponent;
        int n;
        Dimension dimension2 = new Dimension(0, 0);
        for (n = 0; n < jComponentArray.length; ++n) {
            jComponent = jComponentArray[n];
            jComponent.setPreferredSize(null);
            jComponent.setMaximumSize(null);
            dimension = jComponent.getPreferredSize();
            dimension2.width = Math.max(dimension2.width, dimension.width);
            dimension2.height = Math.max(dimension2.height, dimension.height);
        }
        if (jComponentArray.length > 1) {
            for (n = 0; n < jComponentArray.length; ++n) {
                jComponent = jComponentArray[n];
                jComponent.setPreferredSize(dimension2);
                dimension = jComponent.getMaximumSize();
                int n2 = Math.max(dimension.width, dimension2.width);
                int n3 = Math.max(dimension.height, dimension2.height);
                if (n2 == dimension.width && (double)n3 == dimension.getHeight()) continue;
                jComponent.setMaximumSize(new Dimension(n2, n3));
            }
        }
    }

    public static synchronized int showConfirmDialog(final Component component, final Object object, final String string, final int n, final int n2, final Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            A = JOptionPane.showConfirmDialog(component, object, string, n, n2, icon);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    A = JOptionPane.showConfirmDialog(component, object, string, n, n2, icon);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Services.logError("[SwingUtil]", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Services.logError("[SwingUtil]", invocationTargetException);
        }
        return A;
    }

    public static synchronized int showConfirmDialog(final Component component, final Object object, final String string, final int n, final int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            A = JOptionPane.showConfirmDialog(component, object, string, n, n2);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    A = JOptionPane.showConfirmDialog(component, object, string, n, n2);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Services.logError("[SwingUtil]", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Services.logError("[SwingUtil]", invocationTargetException);
        }
        return A;
    }

    public static synchronized int showConfirmDialog(final Component component, final Object object, final String string, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            A = JOptionPane.showConfirmDialog(component, object, string, n);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    A = JOptionPane.showConfirmDialog(component, object, string, n);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Services.logError("[SwingUtil]", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Services.logError("[SwingUtil]", invocationTargetException);
        }
        return A;
    }

    public static synchronized int showOptionDialog(final Component component, final Object object, final String string, final int n, final int n2, final Icon icon, final Object[] objectArray, final Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            A = JOptionPane.showOptionDialog(component, object, string, n, n2, icon, objectArray, object2);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    A = JOptionPane.showOptionDialog(component, object, string, n, n2, icon, objectArray, object2);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Services.logError("[SwingUtil]", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Services.logError("[SwingUtil]", invocationTargetException);
        }
        return A;
    }

    public static synchronized void showMessageFrame(JFrame jFrame, String string, ResourceId resourceId) {
        SwingUtil.showMessageFrame(jFrame, string, resourceId, true);
    }

    public static synchronized void showMessageFrame(final Frame frame, final String string, final ResourceId resourceId, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            new MessageFrame(frame, string, resourceId, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        new MessageFrame(frame, string, resourceId, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Services.logError("[SwingUtil]", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Services.logError("[SwingUtil]", invocationTargetException);
            }
        }
    }

    public static Dimension getPrimaryScreenSize() {
        Rectangle rectangle = SwingUtil.getPrimaryScreenBounds();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        return dimension;
    }

    public static Rectangle getPrimaryScreenBounds() {
        GraphicsConfiguration graphicsConfiguration;
        Rectangle rectangle;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        Rectangle rectangle2 = graphicsDevice == null ? new Rectangle(0, 0, 800, 600) : ((rectangle = (graphicsConfiguration = graphicsDevice.getDefaultConfiguration()).getBounds()) == null ? new Rectangle(0, 0, 800, 600) : rectangle);
        return rectangle2;
    }

    public static void setToolTipText(JComponent jComponent, String string) {
        jComponent.setToolTipText(null);
        jComponent.setToolTipText(string);
    }

    public static Rectangle getScreenBounds(int n, int n2, boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle rectangle = null;
        double d = 2.147483647E9;
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            Cloneable cloneable;
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            if (!bl) {
                cloneable = toolkit.getScreenInsets(graphicsConfiguration);
                rectangle2.x += ((Insets)cloneable).left;
                rectangle2.y += ((Insets)cloneable).top;
                rectangle2.width -= ((Insets)cloneable).left + ((Insets)cloneable).right;
                rectangle2.height -= ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            }
            if (rectangle2.contains(n, n2)) {
                return rectangle2;
            }
            rectangle = rectangle2;
            cloneable = Geometry.getClosestPointOnRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n, n2);
            double d2 = Point2D.distance(n, n2, ((Point2D)cloneable).getX(), ((Point2D)cloneable).getY());
            if (!(d2 < d)) continue;
            d = d2;
            rectangle = rectangle2;
        }
        return rectangle;
    }

    public static Component findComponentByClass(Container container, Class clazz) {
        Component component = null;
        if (clazz.isInstance(container)) {
            component = container;
        } else {
            int n = container.getComponentCount();
            for (int i = 0; component == null && i < n; ++i) {
                Component component2 = container.getComponent(i);
                if (!(component2 instanceof Container)) continue;
                component = SwingUtil.findComponentByClass((Container)component2, clazz);
            }
        }
        return component;
    }

    public static void scrollByBlock(JScrollBar jScrollBar, int n) {
        int n2 = jScrollBar.getValue();
        int n3 = jScrollBar.getBlockIncrement(n);
        int n4 = n3 * (n > 0 ? 1 : -1);
        jScrollBar.setValue(n2 + n4);
    }

    public static void scrollByUnits(JScrollBar jScrollBar, int n, int n2) {
        int n3 = n2;
        n3 = n > 0 ? (n3 *= jScrollBar.getUnitIncrement(n)) : (n3 *= -jScrollBar.getUnitIncrement(n));
        int n4 = jScrollBar.getValue();
        int n5 = n4 + n3;
        if (n3 > 0 && n5 < n4) {
            n5 = jScrollBar.getMaximum();
        } else if (n3 < 0 && n5 > n4) {
            n5 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n5);
    }

    public static GraphicsDevice getGraphicsDevice(Point point) {
        GraphicsDevice graphicsDevice = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; graphicsDevice == null && i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice2 = graphicsDeviceArray[i];
            GraphicsConfiguration graphicsConfiguration = graphicsDevice2.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (!rectangle.contains(point)) continue;
            graphicsDevice = graphicsDevice2;
        }
        return graphicsDevice;
    }

    public static void invokeNowOrLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
            Thread.yield();
        }
    }

    public static void registerEscapeKeystroke(AbstractButton abstractButton) {
        InputMap inputMap = abstractButton.getInputMap(2);
        ActionMap actionMap = abstractButton.getActionMap();
        String string = "do-click";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "do-click");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                abstractButton.doClick();
            }
        };
        actionMap.put("do-click", abstractAction);
    }

    public static void expandCompleteTree(JTree jTree) {
        int n = jTree.getRowCount();
        for (int i = 0; i < n; ++i) {
            jTree.expandRow(i);
            n = jTree.getRowCount();
        }
    }
}

