/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.Strings;
import com.gentleware.services.util.UnicodeEncoding;
import com.gentleware.services.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UnicodeProperties {
    private static final String I = " \t\r\n\f";
    private static final String H = "=: \t\r\n\f";
    private static final String B = "=:";
    private static final String G = "=: \t\r\n\f#!";
    private String E;
    private final Map F = CollectionFactory.createHashMap();
    private final List C = CollectionFactory.createArrayList();
    private UnicodeEncoding A;
    private UnicodeProperties D;

    public UnicodeProperties() {
    }

    public UnicodeProperties(File file) throws IOException {
        this(null, file);
    }

    public UnicodeProperties(String string, File file) throws IOException {
        this.load(string, file);
    }

    public UnicodeProperties(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    public UnicodeProperties(String string, InputStream inputStream) throws IOException {
        this.load(string, inputStream);
    }

    public UnicodeProperties(UnicodeProperties unicodeProperties) {
        this.D = unicodeProperties;
    }

    public void setDefaults(UnicodeProperties unicodeProperties) {
        this.D = unicodeProperties;
    }

    public void store(File file) throws IOException {
        this.store(file, false);
    }

    public void store(File file, boolean bl) throws IOException {
        this.store(file, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, boolean bl, UnicodeEncoding unicodeEncoding) throws IOException {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.store(bufferedOutputStream, bl, unicodeEncoding);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void store(OutputStream outputStream) throws IOException {
        this.store(outputStream, false, null);
    }

    public void store(OutputStream outputStream, boolean bl) throws IOException {
        this.store(outputStream, bl, null);
    }

    public void store(OutputStream outputStream, boolean bl, UnicodeEncoding unicodeEncoding) throws IOException {
        UnicodeEncoding unicodeEncoding2 = unicodeEncoding != null ? unicodeEncoding : (this.A != null ? this.A : UnicodeEncoding.UTF_8);
        unicodeEncoding2.writeBom(outputStream);
        String string = unicodeEncoding2.getCharsetName();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        if (this.E != null) {
            this.A(bufferedWriter, this.E);
            bufferedWriter.write("\n");
        }
        if (bl) {
            Collections.sort(this.C);
        }
        Iterator iterator = this.C.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            entry.A(bufferedWriter);
        }
        bufferedWriter.flush();
    }

    private void A(BufferedWriter bufferedWriter, String string) throws IOException {
        String[] stringArray = string.split("\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            bufferedWriter.write("# ");
            bufferedWriter.write(string2);
            bufferedWriter.write("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string, File file) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.load(string, bufferedInputStream);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void load(String string, InputStream inputStream) throws IOException {
        String string2;
        if (string == null) {
            this.A = UnicodeEncoding.readBom(inputStream, UnicodeEncoding.UTF_8);
            string = this.A.getCharsetName();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        StringBuffer stringBuffer = null;
        boolean bl = true;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            if ((string2 = Strings.trimLeft(string2)).length() == 0) {
                if (!bl) continue;
                if (stringBuffer != null) {
                    this.E = new String(stringBuffer);
                    stringBuffer = null;
                }
                bl = false;
                continue;
            }
            char c = string2.charAt(0);
            if (c == '#' || c == '!') {
                String string3 = string2.length() > 1 && string2.charAt(1) == ' ' ? string2.substring(2) : string2.substring(1);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string3);
                stringBuffer.append('\n');
                continue;
            }
            bl = false;
            if (this.B(string2)) {
                string2 = string2.substring(0, string2.length() - 1);
                StringBuffer stringBuffer2 = new StringBuffer(string2);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!this.B(string2)) {
                        stringBuffer2.append(Strings.trimLeft(string2));
                        break;
                    }
                    string2 = string2.substring(0, string2.length() - 1);
                    stringBuffer2.append(Strings.trimLeft(string2));
                }
                string2 = new String(stringBuffer2);
            }
            int n3 = string2.length();
            for (n2 = 0; n2 < n3; ++n2) {
                n = string2.charAt(n2);
                if (n == 92) {
                    ++n2;
                    continue;
                }
                if (H.indexOf(n) != -1) break;
            }
            for (n = n2; n < n3 && I.indexOf(string2.charAt(n)) != -1; ++n) {
            }
            if (n < n3 && B.indexOf(string2.charAt(n)) != -1) {
                ++n;
            }
            while (n < n3 && I.indexOf(string2.charAt(n)) != -1) {
                ++n;
            }
            String string4 = string2.substring(0, n2);
            String string5 = n < n3 ? string2.substring(n, n3) : "";
            String string6 = Strings.unescape(string4);
            String string7 = Strings.unescape(string5);
            String string8 = null;
            if (stringBuffer != null) {
                string8 = Strings.unescape(new String(stringBuffer));
                stringBuffer = null;
            }
            this.addEntry(string8, string6, string7);
        }
    }

    private String A(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(Strings.toHexDigit(c >> 12 & 0xF));
                        stringBuffer.append(Strings.toHexDigit(c >> 8 & 0xF));
                        stringBuffer.append(Strings.toHexDigit(c >> 4 & 0xF));
                        stringBuffer.append(Strings.toHexDigit(c & 0xF));
                        continue block8;
                    }
                    if (G.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private boolean B(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n;
        }
        boolean bl = n % 2 == 1;
        return bl;
    }

    public String getComment() {
        return this.E;
    }

    public void setComment(String string) {
        this.E = string;
    }

    public Entry getEntry(String string) {
        Entry entry = (Entry)this.F.get(string);
        if (entry == null && this.D != null) {
            return this.D.getEntry(string);
        }
        return entry;
    }

    public String getProperty(String string) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public String getProperty(String string, String string2) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return string2;
        }
        return entry.getValue();
    }

    public void setProperty(String string, String string2) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            this.addEntry(null, string, string2);
        } else {
            entry.setValue(string2);
        }
    }

    public void setProperty(String string, String string2, String string3) {
        Entry entry = this.getEntry(string2);
        if (entry == null) {
            this.addEntry(string, string2, string3);
        } else {
            entry.setComment(string);
            entry.setValue(string3);
        }
    }

    public String getComment(String string) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getComment();
    }

    public int getEntryCount() {
        return this.F.size();
    }

    public Entry getEntry(int n) {
        Entry entry = (Entry)this.C.get(n);
        return entry;
    }

    public Entry addEntry(String string, String string2, String string3) {
        this.A(string2);
        Entry entry = new Entry(string, string2, string3);
        this.C.add(entry);
        this.F.put(entry.getKey(), entry);
        return entry;
    }

    private void A(String string) {
        if (string == null) {
            this.C("Key must not be null.");
            return;
        }
        if (string.length() == 0) {
            this.C("Key must not be empty.");
            return;
        }
        if (this.F.containsKey(string)) {
            this.C("Duplicate key: " + string);
            return;
        }
    }

    private void C(String string) {
        Services.logError(string, new Exception());
    }

    public List getKeys() {
        List list = CollectionFactory.createArrayList();
        for (int i = 0; i < this.C.size(); ++i) {
            Entry entry = (Entry)this.C.get(i);
            list.add(entry.getKey());
        }
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnicodeProperties)) {
            return false;
        }
        UnicodeProperties unicodeProperties = (UnicodeProperties)object;
        if (!Utils.equals(this.E, unicodeProperties.E)) {
            return false;
        }
        if (this.C.size() != unicodeProperties.C.size()) {
            return false;
        }
        int n = this.C.size();
        for (int i = 0; i < n; ++i) {
            Entry entry;
            Entry entry2 = (Entry)this.C.get(i);
            if (entry2.equals(entry = unicodeProperties.getEntry(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        n = this.E != null ? this.E.hashCode() : n;
        int n2 = this.C.size();
        for (int i = 0; i < n2; ++i) {
            Entry entry = (Entry)this.C.get(i);
            n = 29 * n + entry.hashCode();
        }
        return n;
    }

    public class Entry
    implements Comparable {
        private String C;
        private String B;
        private String A;

        private Entry(String string, String string2, String string3) {
            this.C = string;
            this.B = string2;
            this.A = string3;
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            String string = this.A(this.B);
            String string2 = this.A(entry.B);
            return string.compareTo(string2);
        }

        private String A(String string) {
            try {
                return string.toLowerCase(Locale.ENGLISH);
            }
            catch (Exception exception) {
                return string;
            }
        }

        public String getComment() {
            return this.C;
        }

        public void setComment(String string) {
            this.C = string;
        }

        public String getKey() {
            return this.B;
        }

        public void setKey(String string) {
            UnicodeProperties.this.A(string);
            UnicodeProperties.this.F.remove(this.B);
            this.B = string;
            UnicodeProperties.this.F.put(this.B, this);
        }

        public String getValue() {
            return this.A;
        }

        public void setValue(String string) {
            this.A = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.C != null ? !this.C.equals(entry.C) : entry.C != null) {
                return false;
            }
            if (!this.B.equals(entry.B)) {
                return false;
            }
            return this.A.equals(entry.A);
        }

        public int hashCode() {
            int n = this.C != null ? this.C.hashCode() : 0;
            n = 29 * n + this.B.hashCode();
            n = 29 * n + this.A.hashCode();
            return n;
        }

        private void A(BufferedWriter bufferedWriter) throws IOException {
            if (this.C != null) {
                UnicodeProperties.this.A(bufferedWriter, this.C);
            }
            bufferedWriter.write(UnicodeProperties.this.A(this.B, true));
            bufferedWriter.write(61);
            bufferedWriter.write(UnicodeProperties.this.A(this.A, false));
            bufferedWriter.write(10);
        }
    }
}

