/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.services.util;

import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.Strings;
import com.gentleware.services.util.TopLevelDomain;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class Utils {
    private static final double A = 1.0E-10;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;

    public static String makeDateString(Date date) {
        return Utils.makeDateString(date, 3, 2);
    }

    public static String makeDateString(Date date, int n, int n2) {
        DateFormat dateFormat = DateFormat.getDateInstance(n, Locale.getDefault());
        DateFormat dateFormat2 = DateFormat.getTimeInstance(n2, Locale.getDefault());
        String string = dateFormat.format(date);
        String string2 = dateFormat2.format(date);
        String string3 = string + "  " + string2;
        return string3;
    }

    public static void addDaysToDate(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, n);
        date.setTime(gregorianCalendar.getTime().getTime());
    }

    public static int getDateDifferenceInDays(Date date, Date date2) {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = l2 - l;
        int n = (int)(l3 / 86400000L);
        return n;
    }

    public static boolean checkEmail(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return false;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 < 0 || n2 < n + 2 || n2 > string.length() - 3) {
            return false;
        }
        String string2 = string.substring(n2 + 1);
        return TopLevelDomain.isValidDomainName(string2);
    }

    public static boolean isWindowsOs() {
        String string = System.getProperty("os.name");
        boolean bl = string.toLowerCase().startsWith("windows");
        return bl;
    }

    public static boolean isMacOs() {
        String string = System.getProperty("mrj.version");
        boolean bl = string != null;
        return bl;
    }

    public static boolean isLinuxOs() {
        String string = System.getProperty("os.name");
        boolean bl = string.toLowerCase().startsWith("linux");
        return bl;
    }

    public static String filenameToUri(String string) {
        char c;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && string.charAt(1) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    public static String stripJunk(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 && Character.isJavaIdentifierPart(string.charAt(n4))) {
            ++n4;
            ++n3;
        }
        if (n3 == n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(string.charAt(n));
        }
        for (n = n3 + 1; n < n2; ++n) {
            char c = string.charAt(n);
            if (!Character.isJavaIdentifierPart(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getPathToContainingJar(Class clazz) {
        String string = clazz.getName();
        string = string.replace('.', '/');
        URL uRL = clazz.getClassLoader().getResource(string + ".class");
        String string2 = uRL.toString();
        int n = string2.indexOf(33);
        if (n > 0) {
            string2 = string2.substring(0, n);
        } else {
            String string3 = "/" + string + ".class";
            if (string2.endsWith(string3)) {
                string2 = string2.substring(0, string2.length() - string3.length());
            }
        }
        return string2;
    }

    public static URL fileToUrl(File file) throws MalformedURLException, IOException {
        String string = file.getCanonicalPath();
        String string2 = Utils.filenameToUri(string);
        URL uRL = new URL("file", "", string2);
        return uRL;
    }

    public static URL convertFileToUrl(File file) {
        try {
            URI uRI = file.toURI();
            URL uRL = uRI.toURL();
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            Services.logError(malformedURLException);
            return null;
        }
    }

    public static URL exchangeUrlExtension(URL uRL, String string) throws MalformedURLException {
        if (!uRL.getFile().endsWith(string)) {
            uRL = Utils.fixUrlExtension(uRL, string);
        }
        return Utils.stripUrlExtension(uRL);
    }

    public static URL stripUrlExtension(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        string = string.substring(0, string.lastIndexOf(46));
        uRL = new URL(uRL, string);
        return uRL;
    }

    public static URL fixUrlExtension(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.getFile();
        if (!string2.endsWith(string)) {
            int n = string2.lastIndexOf(File.pathSeparatorChar);
            int n2 = string2.lastIndexOf(".", n);
            uRL = n2 >= 0 ? new URL(uRL, string2.substring(0, n2) + string) : new URL(uRL, string2 + string);
        }
        return uRL;
    }

    public static String removeDots(String string) {
        if (string.lastIndexOf(46) <= 0) {
            return string;
        }
        int n = string.indexOf(46);
        String string2 = string.substring(0, n) + Utils.removeDots(string.substring(n + 1));
        return string2;
    }

    public static float getFileIncrementor(File file) {
        int n = 0;
        n = file.isDirectory() ? (n += Utils.getFileCount(file)) : ++n;
        return 100 / n;
    }

    public static int getFileCount(File file) {
        int n = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return 0;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    n += Utils.getFileCount(fileArray[i]);
                    continue;
                }
                if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith(".java")) continue;
                ++n;
            }
        }
        return n;
    }

    public static List getAllFilenames(File file, String string) {
        List list = CollectionFactory.createArrayList();
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        Utils.A(file, list, string);
        return list;
    }

    public static List getJavaFilenames(File file) {
        List list = CollectionFactory.createArrayList();
        Utils.A(file, list, ".java");
        return list;
    }

    private static void A(File file, List list, String string) {
        File[] fileArray;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Utils.A(fileArray[i], list, string);
                    continue;
                }
                if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith(string)) continue;
                list.add(fileArray[i].getPath());
            }
        }
    }

    public static boolean canWriteImage(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        return iterator != null && iterator.hasNext();
    }

    public static void writeImage(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException, IllegalArgumentException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("Unsupported image format: " + string);
        }
        ImageWriter imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(renderedImage);
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public static BufferedImage readImage(URL uRL) throws IOException, IllegalArgumentException {
        String string = uRL.getPath();
        int n = string.lastIndexOf(".");
        if (n <= 0) {
            throw new IllegalArgumentException("[Utils] readImage(): Cannot get format from url suffix" + uRL);
        }
        String string2 = string.substring(n + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("Unsupported image format: " + string2);
        }
        ImageReader imageReader = iterator.next();
        InputStream inputStream = uRL.openStream();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0);
        inputStream.close();
        imageInputStream.close();
        imageReader.dispose();
        return bufferedImage;
    }

    public static int getSign(double d) {
        return d < 0.0 ? -1 : (d == 0.0 ? 0 : 1);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public static int compare(double d, double d2) {
        return Utils.compare(d, d2, 1.0E-10);
    }

    public static int compare(double d, double d2, double d3) {
        double d4 = d - d2;
        if (Math.abs(d4) < d3) {
            return 0;
        }
        return d < d2 ? -1 : 1;
    }

    public static boolean equals(double d, double d2) {
        return Utils.equals(d, d2, 1.0E-10);
    }

    public static boolean equals(double d, double d2, double d3) {
        double d4 = d - d2;
        boolean bl = Math.abs(d4) < d3;
        return bl;
    }

    public static File urlToFile(URL uRL) {
        File file;
        boolean bl;
        String string = uRL.toExternalForm();
        boolean bl2 = string.indexOf(32) >= 0;
        boolean bl3 = bl = string.indexOf("%20") >= 0;
        if (bl2) {
            int n;
            file = new File(uRL.getFile());
            String string2 = file.getPath();
            if (bl) {
                string2 = Strings.replaceAll(string2, "%20", " ");
            }
            if ((n = string2.indexOf(".jar!")) > 0) {
                string2 = string2.substring(0, n + 4);
            }
            if (string2.startsWith("file:")) {
                string2 = string2.substring("file:".length());
            }
            file = new File(string2);
        } else {
            int n;
            String string3 = uRL.toExternalForm();
            if (string3.startsWith("jar:") && (n = string3.lastIndexOf(33)) > 4) {
                string3 = string3.substring(4, n);
            }
            if (Utils.isWindowsOs()) {
                string3 = string3.replace('\\', '/');
            }
            if (string3.startsWith("file:") && !string3.startsWith("file:/")) {
                string3 = "file:///" + string3.substring("file:".length());
            }
            try {
                URI uRI = new URI(string3);
                file = new File(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                Services.logError(uRISyntaxException);
                file = null;
            }
        }
        return file;
    }

    public static float getColorSimilarity(Color color, Color color2) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        Utils.A(fArray);
        Utils.A(fArray2);
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return f4;
    }

    private static void A(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = (float)((double)f * 2.0 * Math.PI);
        double d = 0.5 * (double)f2 * (double)f3;
        fArray[0] = (float)(d * Math.cos(f4));
        fArray[1] = (float)(d * Math.sin(f4));
        fArray[2] = (float)((double)fArray[2] / Math.sqrt(0.75));
    }

    public static String createUniqueId() {
        return new UID().toString();
    }

    public static Object findFirstCommonObject(Collection collection, Collection collection2) throws IllegalArgumentException {
        int n;
        int n2 = collection.size();
        if (n2 != (n = collection2.size())) {
            throw new IllegalArgumentException("Collections must not differ in size (" + n2 + " != " + n + ").");
        }
        Object var4_4 = null;
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            if (!e2.equals(e = iterator2.next())) continue;
            var4_4 = e2;
        }
        return var4_4;
    }

    public static short getUnsignedByte(byte by) {
        short s = by;
        if (s < 0) {
            s = (short)(s + 256);
        }
        return s;
    }

    public static byte getSignedByte(short s) {
        byte by = s > 127 ? (byte)(s - 256) : (byte)s;
        return by;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        boolean bl = object.equals(object2);
        return bl;
    }

    public static File getInstallationDirectory(Class clazz) {
        String string = System.getProperty("poseidon.inst.dir");
        if (string != null && !"".equals(string)) {
            File file = new File(string);
            return file;
        }
        String string2 = clazz.getName();
        String string3 = string2.replace('.', '/') + ".class";
        int n = string3.lastIndexOf(47);
        URL uRL = clazz.getClassLoader().getResource(string3);
        File file = null;
        File file2 = Utils.urlToFile(uRL);
        if (file2 != null) {
            File file3;
            Object object;
            int n2;
            String string4 = file2.getPath();
            String string5 = null;
            if (Utils.isWindowsOs()) {
                string4 = string4.replace('\\', '/');
            }
            if (string4.endsWith(".jar")) {
                file2 = file2.getParentFile();
                string4 = file2.getPath();
                if (Utils.isWindowsOs()) {
                    string4 = string4.replace('\\', '/');
                }
                if (string4.endsWith("/")) {
                    string4 = string4.substring(0, string4.length() - "/".length());
                }
                if (string4.endsWith("/lib")) {
                    string4 = string4.substring(0, string4.length() - "/lib".length());
                }
                if (string4.endsWith("/lib_build")) {
                    string4 = string4.substring(0, string4.length() - "/lib_build".length());
                }
                string5 = string4;
            } else if (string4.endsWith(".class")) {
                n2 = string4.lastIndexOf(47);
                string5 = string4.substring(0, n2);
                if (n > 0 && string5.endsWith((String)(object = string3.substring(0, n)))) {
                    string5 = string5.substring(0, string5.length() - ((String)object).length());
                }
                if (string5.endsWith("/build/classes/")) {
                    string5 = string5.substring(0, string5.length() - "/build/classes/".length());
                }
            }
            if (string5 != null) {
                if (Utils.isWindowsOs()) {
                    if (string5.startsWith("/")) {
                        string5 = string5.substring("/".length());
                    }
                    if ((string5 = string5.replace('/', File.separatorChar)).endsWith("\\")) {
                        string5 = string5.substring(0, string5.length() - "\\".length()) + "/";
                    }
                }
                file = new File(string5);
            }
            n2 = 1;
            if (file != null) {
                object = new File(file, "lib_build" + File.separator + "poseidonCore.jar");
                file3 = new File(file, "lib" + File.separator + "poseidonCore.jar");
                int n3 = n2 = !file3.exists() && !((File)object).exists() ? 1 : 0;
            }
            if (n2 != 0 && (object = System.getProperty("poseidon.lib")) != null) {
                file3 = new File((String)object);
                file = file3.getParentFile();
            }
            try {
                if (file != null) {
                    file = file.getCanonicalFile();
                }
            }
            catch (IOException iOException) {
                Services.logInfo("Ignoring exception.", iOException);
            }
        }
        if (file == null || !file.exists()) {
            // empty if block
        }
        return file;
    }

    public static String getConfigDir(String string, String string2) {
        return Utils.getConfigDir(string, string2, true);
    }

    public static String getConfigDir(String string, String string2, boolean bl) {
        File file;
        String string3 = System.getProperty("user.home") + File.separatorChar + string + File.separatorChar + string2;
        String string4 = System.getProperty("poseidon.user.dir." + string2);
        String string5 = string4 != null && !"".equals(string4) ? string4 : string3;
        if (bl && !(file = new File(string5)).exists()) {
            file.mkdirs();
        }
        return string5;
    }

    public static String getRootConfigDir() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".poseidon");
        String string2 = file.getPath();
        return string2;
    }

    public static String getConfigDir(String string) {
        return Utils.getConfigDir(".poseidon", string, true);
    }

    public static String getPoseidon2ConfigDir(String string) {
        return Utils.getConfigDir("poseidon2", string, false);
    }

    public static Date installationDate(int n, Class clazz) {
        File file = Utils.getInstallationDirectory(clazz);
        long l = file.lastModified();
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, n);
        Date date2 = gregorianCalendar.getTime();
        return date2;
    }

    public static void intersect(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection2.contains(e)) continue;
            iterator.remove();
        }
    }

    public static void addAtIndex(Collection collection, int n, Object object) {
        int n2;
        if (collection instanceof List) {
            List list = (List)collection;
            list.add(n, object);
            return;
        }
        int n3 = collection.size();
        if (n == n3) {
            collection.add(object);
            return;
        }
        List list = CollectionFactory.createArrayList(n3 - n);
        Iterator iterator = collection.iterator();
        for (n2 = 0; n2 < n; ++n2) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            list.add(e);
            iterator.remove();
        }
        collection.add(object);
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            Object e = list.get(n2);
            collection.add(e);
        }
    }

    public static Object removeAtIndex(Collection collection, int n) {
        if (collection instanceof List) {
            List list = (List)collection;
            Object e = list.remove(n);
            return e;
        }
        Iterator iterator = collection.iterator();
        Object var3_5 = null;
        for (int i = 0; i <= n; ++i) {
            var3_5 = iterator.next();
        }
        iterator.remove();
        return var3_5;
    }

    public static Object getAtIndex(Collection collection, int n) {
        if (collection instanceof List) {
            List list = (List)collection;
            Object e = list.get(n);
            return e;
        }
        Iterator iterator = collection.iterator();
        Object var3_5 = null;
        for (int i = 0; i <= n; ++i) {
            var3_5 = iterator.next();
        }
        return var3_5;
    }

    public static int indexOf(Collection collection, Object object) {
        if (collection instanceof List) {
            List list = (List)collection;
            int n = list.indexOf(object);
            return n;
        }
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (object == e) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isValidLocaleSpec(String string) {
        String[] stringArray = string.split("_", 3);
        if (stringArray.length == 0) {
            return true;
        }
        if (!Utils.A(stringArray[0])) {
            return false;
        }
        return stringArray.length <= 1 || Utils.B(stringArray[1]);
    }

    public static Locale createLocale(String string) {
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("_", 3);
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        String string4 = stringArray.length > 2 ? stringArray[2] : "";
        Locale locale = new Locale(string2, string3, string4);
        return locale;
    }

    public static String getLocaleSpec(Locale locale, boolean bl) {
        if (locale == null) {
            return "";
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        StringBuffer stringBuffer = new StringBuffer();
        if (!Strings.isEmpty(string)) {
            if (bl) {
                stringBuffer.append('_');
            }
            stringBuffer.append(string);
            if (!Strings.isEmpty(string2)) {
                stringBuffer.append('_');
                stringBuffer.append(string2);
                if (!Strings.isEmpty(string3)) {
                    stringBuffer.append('_');
                    stringBuffer.append(string3);
                }
            }
        }
        return new String(stringBuffer);
    }

    private static boolean A(String string) {
        return string.length() == 2 && string.equals(string.toLowerCase());
    }

    private static boolean B(String string) {
        return string.length() == 2 && string.equals(string.toUpperCase());
    }

    public static boolean validPathnameForOperatingSystem(String string) {
        File file = new File(string);
        String string2 = file.getName();
        return !string2.equals(string);
    }

    public static String getExceptionFullDescription(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(exception.getMessage());
        exception.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static String getFilenameFromUrl(URL uRL, int n, boolean bl, String string) {
        String string2;
        if (uRL == null) {
            string2 = string;
        } else {
            String string3;
            String string4;
            String string5;
            Comparable<File> comparable;
            String string6 = uRL.toExternalForm();
            String string7 = System.getProperty("file.separator");
            String string8 = uRL.getProtocol();
            if ("file".equals(string8)) {
                comparable = Utils.urlToFile(uRL);
                string5 = ((File)comparable).getName();
                string4 = Strings.noNull(((File)comparable).getParent());
                string3 = string4.equals(string7) ? "" : string4;
            } else {
                int n2 = string6.lastIndexOf(47);
                if (n2 > 0) {
                    string7 = "/";
                } else {
                    n2 = string6.lastIndexOf(string7);
                }
                if (n2 <= 0) {
                    string5 = string6;
                    string3 = "";
                } else {
                    string5 = string6.substring(n2 + 1);
                    string3 = string6.substring(0, n2);
                }
            }
            if (bl) {
                boolean bl2;
                comparable = new StringBuffer();
                string4 = "...";
                int n3 = "...".length();
                int n4 = string5.length();
                int n5 = string7.length();
                int n6 = string3.length();
                int n7 = n6 + n5 + n4;
                int n8 = n3 + n5;
                boolean bl3 = bl2 = n > 0 && n7 > n;
                if (bl2) {
                    boolean bl4;
                    int n9 = n - n4 - n8;
                    boolean bl5 = bl4 = n9 <= 0;
                    if (bl4) {
                        ((StringBuffer)comparable).append("...");
                    } else {
                        boolean bl6;
                        boolean bl7 = bl6 = n9 < n6;
                        if (bl6) {
                            ((StringBuffer)comparable).append(string3.substring(0, n9));
                            ((StringBuffer)comparable).append("...");
                        } else {
                            ((StringBuffer)comparable).append(string3);
                        }
                    }
                    ((StringBuffer)comparable).append(string7);
                    ((StringBuffer)comparable).append(string5);
                } else {
                    ((StringBuffer)comparable).append(string3);
                    ((StringBuffer)comparable).append(string7);
                    ((StringBuffer)comparable).append(string5);
                }
                string2 = ((StringBuffer)comparable).toString();
            } else {
                string2 = string5;
            }
        }
        return string2;
    }
}

