/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr;

import com.gentleware.mdr.MdrFacade;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.Strings;
import com.gentleware.xmi.conversion.ConvertMetamodel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.netbeans.api.mdr.DTDProducer;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIOutputConfig;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;
import org.netbeans.lib.jmi.xmi.SchemaProducer;

public final class RepositoryHelper {
    private static RepositoryHelper B = null;
    static final Map D = CollectionFactory.createHashMap();
    private static final String A = "Package$Impl";
    private static final String C = "Class$Impl";

    public static String formatMetaclassName(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1);
        }
        if (string.endsWith(A)) {
            string = string.substring(0, string.length() - A.length());
        } else if (string.endsWith(C)) {
            string = string.substring(0, string.length() - C.length());
        }
        if (string.startsWith("Uml")) {
            string = string.substring(3);
        }
        return string;
    }

    public static String translateMetaPackageName(String string) {
        return (String)D.get(string);
    }

    public static RepositoryHelper getInstance() {
        if (B == null) {
            B = new RepositoryHelper();
        }
        return B;
    }

    private RepositoryHelper() {
    }

    public static void writeXmi(String string, RefPackage refPackage) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            RepositoryHelper.writeXmi((OutputStream)fileOutputStream, refPackage, null);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing file '" + string + "'", exception);
        }
    }

    public static void writeXmi(OutputStream outputStream, RefPackage refPackage, XMIReferenceProvider xMIReferenceProvider) {
        try {
            XMIWriter xMIWriter = XMIWriterFactory.getDefault().createXMIWriter();
            XMIOutputConfig xMIOutputConfig = xMIWriter.getConfiguration();
            xMIOutputConfig.setEncoding("UTF-8");
            if (xMIReferenceProvider != null) {
                xMIOutputConfig.setReferenceProvider(xMIReferenceProvider);
            }
            xMIWriter.write(outputStream, refPackage, "1.2");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing XMI file", exception);
        }
    }

    public static void writeXmi(OutputStream outputStream, Collection collection, XMIReferenceProvider xMIReferenceProvider) {
        try {
            XMIWriter xMIWriter = XMIWriterFactory.getDefault().createXMIWriter();
            XMIOutputConfig xMIOutputConfig = xMIWriter.getConfiguration();
            xMIOutputConfig.setEncoding("UTF-8");
            if (xMIReferenceProvider != null) {
                xMIOutputConfig.setReferenceProvider(xMIReferenceProvider);
            }
            xMIWriter.write(outputStream, collection, "1.2");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing XMI file", exception);
        }
    }

    public static void readXmi(URL uRL, RefPackage refPackage) throws IOException, MalformedXMIException {
        XMIReaderFactory xMIReaderFactory = XMIReaderFactory.getDefault();
        XMIReader xMIReader = xMIReaderFactory.createXMIReader();
        xMIReader.read(uRL.toString(), refPackage);
    }

    public static MofPackage findMofPackage(ModelPackage modelPackage, String string) {
        Iterator iterator = modelPackage.getMofPackage().refAllOfClass().iterator();
        while (iterator.hasNext()) {
            ModelElement modelElement = (ModelElement)iterator.next();
            String string2 = modelElement.getName();
            if (Strings.isEmpty((String)string2) || !string2.equals(string)) continue;
            return (MofPackage)modelElement;
        }
        return null;
    }

    public static ModelElement findModelElement(ModelPackage modelPackage, String string, Class clazz) {
        return RepositoryHelper.findModelElement(modelPackage, string, clazz, null);
    }

    public static ModelElement findModelElement(ModelPackage modelPackage, String string, Class clazz, Namespace namespace) {
        Iterator iterator = modelPackage.getModelElement().refAllOfType().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                boolean bl;
                ModelElement modelElement = (ModelElement)iterator.next();
                if (modelElement == null) continue;
                boolean bl2 = clazz.isInstance(modelElement);
                String string2 = modelElement.getName();
                boolean bl3 = bl = !Strings.isEmpty((String)string2) && string.equals(string2);
                if (!bl2 || !bl || namespace != null && namespace != modelElement.getContainer()) continue;
                return modelElement;
            }
        }
        throw new IllegalStateException("ModelElement " + string + ":" + clazz + "not found in container" + namespace);
    }

    public static Collection findModelElements(ModelPackage modelPackage, String string, Class clazz) {
        List list = CollectionFactory.createArrayList();
        Iterator iterator = modelPackage.getModelElement().refAllOfType().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ModelElement modelElement = (ModelElement)iterator.next();
                if (modelElement == null) continue;
                boolean bl = clazz.isInstance(modelElement);
                boolean bl2 = string.equals(modelElement.getName());
                if (!bl || !bl2) continue;
                list.add(modelElement);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeModelAsDTD(RefPackage refPackage, String string) {
        File file = new File(string);
        BufferedOutputStream bufferedOutputStream = null;
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        DTDProducer.getDefault().generate(bufferedOutputStream, refPackage);
        Object var6_4 = null;
        if (bufferedOutputStream == null) return;
        try {
            bufferedOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            Services.logError((Object)iOException);
        }
        return;
        {
            catch (FileNotFoundException fileNotFoundException) {
                Services.logError((Object)fileNotFoundException);
                Object var6_5 = null;
                if (bufferedOutputStream == null) return;
                try {
                    bufferedOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    Services.logError((Object)iOException);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                bufferedOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Services.logError((Object)iOException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeModelAsSchema(RefPackage refPackage, String string) {
        Services.logInfo((Object)("Writing schema to " + string));
        File file = new File(string);
        BufferedOutputStream bufferedOutputStream = null;
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        SchemaProducer schemaProducer = new SchemaProducer();
        schemaProducer.generate(bufferedOutputStream, refPackage);
        Object var6_7 = null;
        if (bufferedOutputStream == null) return;
        try {
            bufferedOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            Services.logError((Object)iOException);
        }
        return;
        {
            catch (FileNotFoundException fileNotFoundException) {
                Services.logError((Object)fileNotFoundException);
                Object var6_8 = null;
                if (bufferedOutputStream == null) return;
                try {
                    bufferedOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    Services.logError((Object)iOException);
                }
                return;
            }
            catch (IOException iOException) {
                Services.logError((Object)"IOException was thrown!", (Throwable)iOException);
                Object var6_9 = null;
                if (bufferedOutputStream == null) return;
                try {
                    bufferedOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    Services.logError((Object)iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                bufferedOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Services.logError((Object)iOException);
            }
            throw throwable;
        }
    }

    public static void addNsUriToAllPackages(RefPackage refPackage) {
        String string = "org.omg.xmi.nsURI";
        String string2 = "http://www.omg.org/XMI";
        ModelElement modelElement = (ModelElement)refPackage.refMetaObject();
        ModelPackage modelPackage = (ModelPackage)modelElement.refImmediatePackage();
        ConvertMetamodel.createTag((ModelPackage)modelPackage, (Namespace)((Namespace)modelElement), (ModelElement)modelElement, (String)"org.omg.xmi.nsURI", (String)"http://www.omg.org/XMI");
        Collection collection = refPackage.refAllPackages();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RefPackage refPackage2 = (RefPackage)iterator.next();
            RepositoryHelper.addNsUriToAllPackages(refPackage2);
        }
    }

    public static RefPackage findOrCreateRefPackageExtent(MDRepository mDRepository, String string) {
        return RepositoryHelper.findOrCreateRefPackageExtent(mDRepository, string, null, null);
    }

    public static RefPackage findOrCreateRefPackageExtent(MDRepository mDRepository, String string, URL uRL) {
        return RepositoryHelper.findOrCreateRefPackageExtent(mDRepository, string, uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefPackage findOrCreateRefPackageExtent(MDRepository mDRepository, String string, URL uRL, RefObject refObject) {
        if (uRL == null) {
            throw new IllegalArgumentException("No valid path to metamodel description given");
        }
        RefPackage refPackage = null;
        boolean bl = true;
        MdrFacade.getInstance().beginTransaction();
        try {
            refPackage = mDRepository.getExtent(string);
            if (refPackage == null) {
                refPackage = mDRepository.createExtent(string, refObject);
                RepositoryHelper.readXmi(uRL, refPackage);
            }
            bl = false;
        }
        catch (Exception exception) {
            Services.logInfo((Object)exception);
        }
        finally {
            MdrFacade.getInstance().endTransaction(bl);
        }
        return refPackage;
    }

    public static boolean isElementStillValid(RefBaseObject refBaseObject) {
        try {
            refBaseObject.refMetaObject();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static RefPackage getNestedPackage(String string, RefPackage refPackage) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            refPackage = refPackage.refPackage(string2);
        }
        return refPackage;
    }

    static {
        D.put("Core", "Core");
        D.put("ModelManagement", "Model_Management");
        D.put("CommonBehavior", "Common_Behavior");
        D.put("DataTypes", "Data_Types");
        D.put("DiagramInterchange", "Diagram_Interchange");
        D.put("Collaborations", "Collaborations");
        D.put("ActivityGraphs", "Activity_Graphs");
        D.put("UseCases", "Use_Cases");
        D.put("StateMachines", "State_Machines");
    }
}

