/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.kernel;

import com.gentleware.poseidon.kernel.PoseidonProject;
import java.io.OutputStream;
import java.net.URL;

public abstract class ProjectMember {
    protected String _name;
    protected PoseidonProject _project = null;

    public ProjectMember(String string, PoseidonProject poseidonProject) {
        this.setName(string);
        this._project = poseidonProject;
    }

    public String getName() {
        String string = this._name;
        if (!this.hasValidFileExtension(string)) {
            string = string + this.getFileExtension();
        }
        return string;
    }

    public String getName(int n2) {
        String string = this._name;
        if (!this.hasValidFileExtension(string = string + "_" + n2)) {
            string = string + this.getFileExtension();
        }
        return string;
    }

    public String getSimpleName() {
        return this._name;
    }

    public String getQuotedName(int n2) {
        String string = this.getName(n2);
        string.replace('\"', '_');
        return string;
    }

    public void setName(String string) {
        this._name = string;
    }

    public PoseidonProject getProject() {
        return this._project;
    }

    public void remove() {
        this._project = null;
    }

    public void updateProjectName() {
        if (this._name == null) {
            return;
        }
        if (this._name.indexOf("_") >= 0) {
            this._name = this._name.substring(this._name.indexOf("_") + 1);
        }
        this._name = this._project.getName() + "_" + this._name;
    }

    public abstract String getType();

    public abstract String getFileExtension();

    public abstract boolean hasValidFileExtension(String var1);

    public URL getURL() {
        return this.getProject().findMemberURLInSearchPath(this.getName());
    }

    public abstract void save(String var1, boolean var2);

    public abstract void save(String var1, boolean var2, OutputStream var3);
}

