/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.kernel.settings;

import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.services.util.CollectionFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class CustomJavaImportSettings {
    private PoseidonProject F;
    private static final String E = File.pathSeparator;
    private static final String D = "java.lang.*" + E + "java.io.*" + E + "java.util.*" + E + "java.net.*";
    private static final String C = "javaimportsettings/import_as_attributes";
    private static final String A = "javaimportsettings/import_as_datatypes";
    private static final String B = "javaimportsettings/import_as_attributes_description";

    public CustomJavaImportSettings(PoseidonProject poseidonProject, String string, String string2, String string3) {
        this.F = poseidonProject;
        this.setImportAsAttributes(string);
        this.setImportAsDatatypes(string2);
        this.setImportAsAttributesDescription(string3);
    }

    public CustomJavaImportSettings(CustomJavaImportSettings customJavaImportSettings) {
        this(customJavaImportSettings.getProject(), customJavaImportSettings.getImportAsAttributes(), customJavaImportSettings.getImportAsDatatypes(), customJavaImportSettings.getImportAsAttributesDescription());
    }

    public CustomJavaImportSettings(PoseidonProject poseidonProject) {
        this.F = poseidonProject;
        this.setImportAsAttributes(false);
        this.setImportAsDatatypes(true);
        this.setImportAsAttributesDescription(D);
    }

    public String getImportAsAttributes() {
        return this.F.getConfiguration().getString(C);
    }

    public void setImportAsAttributes(String string) {
        this.F.getConfiguration().putString(C, string);
    }

    public String getImportAsDatatypes() {
        return this.F.getConfiguration().getString(A);
    }

    public void setImportAsDatatypes(String string) {
        this.F.getConfiguration().put(A, string);
    }

    public boolean isImportAsAttributes() {
        return this.F.getConfiguration().getBoolean(C);
    }

    public void setImportAsAttributes(boolean bl) {
        this.F.getConfiguration().putBoolean(C, bl);
    }

    public boolean isImportAsDatatypes() {
        return this.F.getConfiguration().getBoolean(A);
    }

    public void setImportAsDatatypes(boolean bl) {
        this.F.getConfiguration().putBoolean(A, bl);
    }

    public String getImportAsAttributesDescription() {
        return this.F.getConfiguration().getString(B);
    }

    public void setImportAsAttributesDescription(String string) {
        this.F.getConfiguration().putString(B, string);
    }

    public List getImportAsAttributesList() {
        Pattern pattern = Pattern.compile(E);
        String string = this.getImportAsAttributesDescription();
        boolean bl = false;
        if (string == null) {
            string = D;
            bl = true;
        }
        String[] stringArray = pattern.split(string);
        List<String> list = Arrays.asList(stringArray);
        List list2 = CollectionFactory.createArrayList(list);
        if (bl) {
            this.convertImportAsAttributesList2String(list2);
        }
        return list2;
    }

    public void convertImportAsAttributesList2String(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(string2);
            string = E;
        }
        this.setImportAsAttributesDescription(stringBuffer.toString());
    }

    public void addImportAsAttributesPackage(String string) {
        List list = this.getImportAsAttributesList();
        list.add(string);
        this.convertImportAsAttributesList2String(list);
    }

    public boolean removeImportAsAttributesPackage(String string) {
        List list = this.getImportAsAttributesList();
        boolean bl = list.remove(string);
        if (bl) {
            this.convertImportAsAttributesList2String(list);
        }
        return bl;
    }

    public PoseidonProject getProject() {
        return this.F;
    }
}

