/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.kernel.settings;

import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.services.Services;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomJavaRoundtripSettings {
    public static final String EXCLUDED_FROM_ROUNDTRIP_STRING = "--excluded from roundtrip--";
    public static final String EXCLUDED_FROM_ROUNDTRIP_KEY = "0";
    private static final String C = "roundtrip/java/time_interval";
    private static final String D = "roundtrip/java/is_undoable";
    private static final String F = "roundtrip/java/auto_synch_enabled";
    private static final String E = "roundtrip/java/show_settings_information_dialog";
    public static final String ENABLED_KEY = "roundtrip/java/enabled";
    private static final String A = "roundtrip/java/project_root";
    public static final String SOURCE_PATH_KEY_PREFIX = "roundtrip/java/source_path/p";
    private Configuration B;
    public static final String ROUNDTRIP_PREFIX = "roundtrip/";
    public static final String KEY_LAST_RT_GENERATION = "roundtrip/lastGeneration";
    public static final String KEY_LAST_RT_IMPORT = "roundtrip/lastImport";
    public static int NOT_SPECIFIED_TIMESTAMP = -1;
    public static final String KEY_AUTOMATICALLY_CLOSE_CODE_GENERATION_LOG = "roundtrip/automatically_close_code_generation_log";

    public CustomJavaRoundtripSettings(PoseidonProject poseidonProject, String string, String string2, String string3, String string4, String string5, String string6) {
        this(poseidonProject);
        try {
            int n2 = Integer.parseInt(string);
            this.setTimeInterval(n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            boolean bl = Boolean.valueOf(string2);
            this.setRoundtripIsUndoable(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolean bl = Boolean.valueOf(string3);
            this.setRoundtripEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolean bl = Boolean.valueOf(string4);
            this.setAutoSynchEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolean bl = Boolean.valueOf(string5);
            this.setShowSettingsInformationDialog(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProjectRoot(string6);
    }

    public CustomJavaRoundtripSettings(PoseidonProject poseidonProject) {
        this.B = poseidonProject.getConfiguration();
    }

    public int getTimeInterval() {
        return this.B.getInteger(C, 5);
    }

    public void setTimeInterval(int n2) {
        this.B.putInteger(C, n2);
    }

    public boolean isRoundtripIsUndoable() {
        return this.B.getBoolean(D, false);
    }

    public void setRoundtripIsUndoable(boolean bl) {
        this.B.putBoolean(D, bl);
    }

    public boolean isRoundtripEnabled() {
        return this.B.getBoolean(ENABLED_KEY, false);
    }

    public void setRoundtripEnabled(boolean bl) {
        this.B.putBoolean(ENABLED_KEY, bl);
    }

    public boolean isAutoSynchEnabled() {
        return false;
    }

    public void setAutoSynchEnabled(boolean bl) {
        this.B.putBoolean(F, bl);
    }

    public boolean isShowSettingsInformationDialog() {
        return this.B.getBoolean(E, true);
    }

    public void setShowSettingsInformationDialog(boolean bl) {
        this.B.putBoolean(E, bl);
    }

    public Collection getRelativeSourceRoots() {
        Map map = this.B.getAllEntriesMatching(SOURCE_PATH_KEY_PREFIX);
        Collection collection = map.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || "".equals(string)) continue;
            list.add(string);
        }
        return list;
    }

    public Set getLogicalSourceRoots() {
        Set set = CollectionFactory.createHashSet();
        Map map = this.B.getAllEntriesMatching(SOURCE_PATH_KEY_PREFIX);
        Set set2 = map.keySet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring(SOURCE_PATH_KEY_PREFIX.length());
            set.add(string2);
        }
        return set;
    }

    public void addLogical2RelativeSourceRootPair(String string, String string2) {
        this.B.putString(SOURCE_PATH_KEY_PREFIX + string, string2);
    }

    public void changeRelativeSourceRoot(String string, String string2) {
        if (EXCLUDED_FROM_ROUNDTRIP_STRING.equals(string2)) {
            return;
        }
        this.addLogical2RelativeSourceRootPair(string, string2);
    }

    public void removeLogicalAndRelativeSourceRootPair(String string) {
        this.B.removeKey(SOURCE_PATH_KEY_PREFIX + string);
    }

    public void unassignRelativeSourceRoot(String string) {
        this.changeRelativeSourceRoot(string, "");
    }

    public String getLogicalSourceRootForRelativeSourceRoot(String string) {
        return this.getLogicalSourceRootForRelativeSourceRoot(string, null);
    }

    public String getLogicalSourceRootForRelativeSourceRoot(String string, Map map) {
        if (EXCLUDED_FROM_ROUNDTRIP_STRING.equals(string)) {
            return EXCLUDED_FROM_ROUNDTRIP_KEY;
        }
        Map map2 = map;
        if (map2 == null) {
            map2 = this.B.getAllEntriesMatching(SOURCE_PATH_KEY_PREFIX);
        }
        Set set = map2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getValue();
            if (!Strings.equals((String)string2, (String)string)) continue;
            String string3 = (String)entry.getKey();
            String string4 = string3.substring(SOURCE_PATH_KEY_PREFIX.length());
            return string4;
        }
        return null;
    }

    public int getBiggestLogicalSourceRoot() {
        int n2 = 0;
        Map map = this.B.getAllEntriesMatching(SOURCE_PATH_KEY_PREFIX);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring(SOURCE_PATH_KEY_PREFIX.length());
            int n3 = 0;
            try {
                n3 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Services.logInfo((Object)"Warning: NotANumber when getting biggest key");
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public String getRelativeSourceRootForLogicalSourceRoot(String string) {
        if (EXCLUDED_FROM_ROUNDTRIP_KEY.equals(string)) {
            return EXCLUDED_FROM_ROUNDTRIP_STRING;
        }
        String string2 = this.B.getString(SOURCE_PATH_KEY_PREFIX + string);
        return string2;
    }

    public String getExcludedSourceRootEntry() {
        return EXCLUDED_FROM_ROUNDTRIP_STRING;
    }

    public String getProjectRoot() {
        return this.B.getString(A, "");
    }

    public void setProjectRoot(String string) {
        this.B.putString(A, string);
    }

    public long getLastGenerationTime() {
        return this.B.getLong(KEY_LAST_RT_GENERATION, (long)NOT_SPECIFIED_TIMESTAMP);
    }

    public void setLastGenerationTime(long l2) {
        this.B.putLong(KEY_LAST_RT_GENERATION, l2);
    }

    public long getLastImportTime() {
        return this.B.getLong(KEY_LAST_RT_IMPORT, (long)NOT_SPECIFIED_TIMESTAMP);
    }

    public void setLastImportTime(long l2) {
        this.B.putLong(KEY_LAST_RT_IMPORT, l2);
    }

    public boolean isAutomaticallyCloseCodeGenerationLog() {
        return this.B.getBoolean(KEY_AUTOMATICALLY_CLOSE_CODE_GENERATION_LOG, false);
    }

    public void setAutomaticallyCloseCodeGenerationLog(boolean bl) {
        this.B.putBoolean(KEY_AUTOMATICALLY_CLOSE_CODE_GENERATION_LOG, bl);
    }
}

