/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.model_management;

import java.util.List;
import java.util.StringTokenizer;

public abstract class DocumentationManager {
    public static final String DOCUMENTATION_TAG_NAME = "documentation";
    public static final String OBJECT_OPENER = "@poseidon-object-id [";
    public static final String OBJECT_CLOSER = "]";
    public static final String LINE_SEP = "\n";
    public static final String DOC_BODY_START = "/**";
    protected static final char DOC_ASTERISK = '*';
    protected static final String DOC_BODY_END = "*/";
    protected static final String HTML_INTRO = "<p>\n";
    protected static final String HTML_INTRO_NO_LINE_SEP = "<p>";
    protected static final String HTML_EXTRO = "\n</p>";
    protected static final String HTML_EXTRO_NO_LINE_SEP = "</p>";
    protected static final String HTML_LINE_SEP = "\n</p><p>\n";
    protected static final char JAVADOC_TAG_IDENTIFIER = '@';

    public final String getDocs(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHTMLDocs(object, null));
        return this.addBodyEnclosure(this.addLeadingAsterisks(stringBuffer));
    }

    public abstract String getHTMLDocs(Object var1, String var2);

    public abstract String getHTMLDocs(Object var1, boolean var2, String var3);

    protected String checkHTMLFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith(DOC_BODY_START)) {
            stringBuffer.append(this.makeHTMLCompliant(DocumentationManager.stripBodyEnclosure(string)));
        } else {
            stringBuffer.append(this.makeHTMLCompliant(string));
        }
        return stringBuffer.toString();
    }

    protected String freeOfDocEnds(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DOC_BODY_END);
        StringBuffer stringBuffer = new StringBuffer("");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public abstract String getDocsOrNull(Object var1);

    public abstract void setDocs(Object var1, String var2);

    public String removeObjectID(String string) {
        if (string == null) {
            return null;
        }
        int n2 = OBJECT_CLOSER.length();
        int n3 = string.indexOf(OBJECT_OPENER);
        int n4 = string.indexOf(OBJECT_CLOSER, n3) + n2;
        if (n3 == -1 || n4 < n2) {
            return string;
        }
        return string.substring(0, n3) + string.substring(n4);
    }

    protected abstract String removeNotes(String var1);

    protected abstract String removeConstraints(String var1);

    protected abstract List javadocToConstraintsVector(String var1);

    public final String getDocAndNotes(Object object) {
        return this.getSingletonDocAndNotes(object, null);
    }

    public final String getDocAndNotes(Object object, String string) {
        return this.getSingletonDocAndNotes(object, string);
    }

    protected String getSingletonDocAndNotes(Object object, String string) {
        String string2 = this.getHTMLDocs(object, string);
        String[] stringArray = this.bisectComment(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0] + LINE_SEP + this.getBareNotes(object) + stringArray[1]);
        return this.addBodyEnclosure(this.addLeadingAsterisks(stringBuffer));
    }

    protected String defaultFor(Object object) {
        return this.addBodyEnclosure(this.defaultHTMLFor(object));
    }

    protected String defaultHTMLFor(Object object) {
        return HTML_INTRO + this.defaultBodyFor(object) + LINE_SEP + HTML_EXTRO_NO_LINE_SEP;
    }

    protected abstract String defaultBodyFor(Object var1);

    protected int getFirstOok(String string) {
        int n2 = -1;
        int n3 = string.indexOf(64, n2);
        while (n3 != -1) {
            int n4;
            for (n4 = n3 - 1; n4 > -1 && (string.charAt(n4) == ' ' || string.charAt(n4) == '*'); --n4) {
            }
            if (n4 > -1 && string.charAt(n4) == '\n') {
                return n4 + 1;
            }
            n2 = n3 + 1;
            n3 = string.indexOf(64, n2);
        }
        return -1;
    }

    protected String commentToDescriptionSection(String string) {
        int n2 = this.getFirstOok(string);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    protected String commentToTagSection(String string) {
        int n2 = this.getFirstOok(string);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2);
    }

    protected String[] bisectComment(String string) {
        int n2 = this.getFirstOok(string);
        String[] stringArray = new String[2];
        if (n2 == -1) {
            stringArray[0] = string;
            stringArray[1] = "";
        } else {
            stringArray[0] = string.substring(0, n2 - 1);
            stringArray[1] = LINE_SEP + string.substring(n2);
        }
        return stringArray;
    }

    protected abstract String getBareNotes(Object var1);

    protected String addLeadingAsterisks(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, " * ");
        }
        for (int i2 = stringBuffer.length() - 2; i2 > 0; --i2) {
            if (stringBuffer.charAt(i2) != '\n') continue;
            stringBuffer.insert(i2 + 1, " * ");
        }
        return stringBuffer.toString();
    }

    public static String stripBodyEnclosure(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = string.lastIndexOf(DOC_BODY_END);
        if (n2 == -1) {
            return "";
        }
        int n3 = string.indexOf(DOC_BODY_START);
        if (n3 == -1) {
            return "";
        }
        int n4 = DOC_BODY_START.length();
        return string.substring(n3 + n4, n2).trim();
    }

    public static String stripLeadingAsterisks(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SEP, false);
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = stringTokenizer.hasMoreTokens();
        while (bl) {
            block9: {
                int n2;
                String string2 = stringTokenizer.nextToken();
                int n3 = string2.length();
                for (n2 = 0; n2 < n3 && Character.isWhitespace(string2.charAt(n2)); ++n2) {
                }
                if (n2 >= n3) {
                    stringBuffer.append(string2);
                } else if (string2.charAt(n2) == '*') {
                    ++n2;
                    try {
                        if (string2.charAt(n2) == '/') {
                            stringBuffer.append(string2.trim());
                            break block9;
                        }
                        stringBuffer.append(string2.substring(n2).trim());
                    }
                    catch (Exception exception) {
                        stringBuffer.append("");
                    }
                } else {
                    stringBuffer.append(string2);
                }
            }
            if (!(bl = stringTokenizer.hasMoreTokens())) continue;
            stringBuffer.append(LINE_SEP);
        }
        return stringBuffer.toString();
    }

    public String makeHTMLCompliant(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SEP, false);
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = null;
        boolean bl = stringTokenizer.hasMoreTokens();
        while (bl) {
            block9: {
                int n2;
                String string3 = stringTokenizer.nextToken();
                int n3 = string3.length();
                for (n2 = 0; n2 < n3 && (string3.charAt(n2) == ' ' || string3.indexOf("\t") == n2); ++n2) {
                }
                if (n2 >= n3) {
                    stringBuffer.append("");
                } else if (string3.charAt(n2) == '*') {
                    ++n2;
                    try {
                        if (string3.charAt(n2) == '/') {
                            string2 = string3.trim();
                            stringBuffer.append(string2);
                            break block9;
                        }
                        string2 = string3.substring(n2).trim();
                        stringBuffer.append(string2);
                    }
                    catch (Exception exception) {
                        string2 = "";
                        stringBuffer.append("");
                    }
                } else {
                    string2 = string3.trim();
                    stringBuffer.append(string2);
                }
            }
            bl = stringTokenizer.hasMoreTokens();
            if (this.A(string2) || !bl) continue;
            stringBuffer.append(LINE_SEP);
        }
        return stringBuffer.toString();
    }

    private boolean A(String string) {
        if (string != null) {
            return string.indexOf(64) == 0;
        }
        return false;
    }

    protected String addBodyEnclosure(String string) {
        if (string.equals("")) {
            return "";
        }
        if (string.endsWith(LINE_SEP)) {
            return "/**\n" + string + " " + DOC_BODY_END;
        }
        return "/**\n" + string + "\n " + DOC_BODY_END;
    }

    protected String getNotes(Object object) {
        return this.addBodyEnclosure(this.getBareNotes(object));
    }

    public final String getComments(Object object) {
        return this.getNotes(object);
    }
}

