/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui.treeview;

import com.gentleware.poseidon.ui.treeview.F;
import com.gentleware.poseidon.ui.treeview.TreePerspective;
import com.gentleware.poseidon.ui.treeview.TreeView;
import com.gentleware.poseidon.ui.treeview.TreeViewModel;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.MultiHashMap;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.InvalidObjectException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class DefaultTreeView
implements TreeView {
    private Object D;
    private List C;
    private boolean B;
    private TreeViewModel F;
    private TreePerspective A;
    private TreeView E;
    private MultiHashMap G = new MultiHashMap();

    public DefaultTreeView() {
    }

    public DefaultTreeView(Object object) {
        this.setViewedObject(object);
    }

    public Object clone() {
        DefaultTreeView defaultTreeView = null;
        try {
            defaultTreeView = (DefaultTreeView)super.clone();
            if (this.C != null) {
                defaultTreeView.C = CollectionFactory.createArrayList();
                Iterator iterator = this.C.iterator();
                while (iterator.hasNext()) {
                    Object object = ((TreeView)iterator.next()).clone();
                    defaultTreeView.C.add(object);
                }
            }
            defaultTreeView.G = new MultiHashMap((Map)this.G);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Services.logDebug((Object)"[DefaultTreeView] clone:", (Throwable)cloneNotSupportedException);
        }
        return defaultTreeView;
    }

    public void setPerspective(TreePerspective treePerspective) {
        this.A = treePerspective;
    }

    public TreePerspective getPerspective() {
        if (this.A != null) {
            return this.A;
        }
        if (this.getParent() != null) {
            return ((TreeView)this.getParent()).getPerspective();
        }
        return this.F.A();
    }

    public boolean insert(TreeView treeView) {
        return this.insert(treeView, false);
    }

    public boolean insert(TreeView treeView, boolean bl) {
        this.collectChildren().add(treeView);
        if (bl) {
            this.sortChildren();
            this.updateChildrenBelow(this);
            if (this.getChildCount() > 1) {
                F f2 = (F)this.getTreeModel();
                f2.A(treeView.getPathToRoot(), treeView, this.getIndex(treeView));
            } else {
                F f3 = (F)this.getTreeModel();
                if (f3 != null && treeView != null) {
                    f3.A(treeView.getPathToRoot());
                }
            }
        }
        return true;
    }

    public boolean shouldElementBeViewed(Object object) {
        TreeView treeView = this.getChildFor(object);
        if (treeView != null || object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        Collection collection = this.getFilterFor(clazz);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                TreePerspective.Filter filter = (TreePerspective.Filter)iterator.next();
                boolean bl = filter.A(object);
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public void remove(TreeView treeView) {
        List list = this.getChildren();
        if (list != null) {
            list.remove(treeView);
        }
        treeView.removeAllListeners();
    }

    public abstract void sortChildren();

    public Object getViewedObject() {
        return this.D;
    }

    public void setViewedObject(Object object) {
        this.D = object;
    }

    public void setParent(TreeView treeView) {
        this.E = treeView;
    }

    public void setTreeModel(TreeViewModel treeViewModel) {
        this.F = treeViewModel;
    }

    public TreeViewModel getTreeModel() {
        return this.F;
    }

    public TreePath getPathToRoot() {
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        for (TreeNode treeNode = this.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            linkedList.addFirst(treeNode);
        }
        return new TreePath(linkedList.toArray());
    }

    public TreeView getChildFor(Object object) {
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeView treeView = (TreeView)enumeration.nextElement();
            Object object2 = treeView.getViewedObject();
            if (object2 != object) continue;
            return treeView;
        }
        return null;
    }

    public void addChild(TreeNode treeNode) {
        this.C.add(treeNode);
    }

    public Enumeration children() {
        return new _A(this.collectChildren().iterator());
    }

    public boolean getAllowsChildren() {
        return this.B;
    }

    public TreeNode getChildAt(int n2) {
        return (TreeNode)this.collectChildren().get(n2);
    }

    public int getChildCount() {
        return this.collectChildren().size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.collectChildren().indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.E;
    }

    public boolean isLeaf() {
        return this.C != null ? this.C.isEmpty() : this.computeIsLeaf();
    }

    protected boolean computeIsLeaf() {
        return this.collectChildren().isEmpty();
    }

    public String toString() {
        return this.getViewedObject().toString();
    }

    protected List collectChildren() {
        if (this.C == null) {
            this.C = CollectionFactory.createArrayList();
            try {
                this.initChildren();
            }
            catch (InvalidObjectException invalidObjectException) {
                Services.logError((Object)"Tree: prevented UI lockup through initChildren()");
            }
            try {
                this.sortChildren();
            }
            catch (InvalidObjectException invalidObjectException) {
                Services.logError((Object)"Tree: prevented UI lockup through sortChildren()");
            }
        }
        return this.C;
    }

    public List getChildren() {
        return this.C;
    }

    protected abstract void initChildren();

    protected void setChildren(List list) {
        this.C = list;
    }

    protected boolean isAllowsChildren() {
        return this.B;
    }

    protected void setAllowsChildren(boolean bl) {
        this.B = bl;
    }

    public boolean isEditable() {
        return true;
    }

    public Icon getIcon() {
        return null;
    }

    public void addFilter(Class clazz, TreePerspective.Filter filter) {
        this.G.put((Object)clazz, (Object)filter);
    }

    public Collection getFilterFor(Class clazz) {
        Collection collection = null;
        if (!this.G.isEmpty()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length && (collection = (Collection)this.G.get(classArray[i2])) == null; ++i2) {
            }
        }
        return collection;
    }

    protected void updateChildrenBelow(final DefaultTreeView defaultTreeView) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                F f2 = (F)DefaultTreeView.this.getTreeModel();
                int n2 = defaultTreeView.getChildCount();
                if (f2 != null) {
                    int[] nArray = new int[n2];
                    TreeNode[] treeNodeArray = new TreeNode[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        nArray[i2] = i2;
                        treeNodeArray[i2] = (TreeNode)f2.getChild(defaultTreeView, i2);
                    }
                    f2.B(DefaultTreeView.this.getPathToRoot(), treeNodeArray, nArray);
                }
            }
        });
    }

    private class _A
    implements Enumeration {
        private Iterator A;

        _A(Iterator iterator) {
            this.A = iterator;
        }

        public boolean hasMoreElements() {
            return this.A.hasNext();
        }

        public Object nextElement() {
            return this.A.next();
        }
    }
}

