/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui.treeview;

import com.gentleware.jboogie.kernel.A;
import com.gentleware.jboogie.ui.IconProvider;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.ui.treeview.TreeView;
import com.gentleware.services.Services;
import com.gentleware.services.util.Strings;
import com.gentleware.services.util.SwingUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class TreeViewCellRenderer
extends DefaultTreeCellRenderer {
    private IconProvider E;
    private final Color A = new Color(255, 0, 0, 80);
    private final Color D = new Color(0, 255, 0, 80);
    private Color C = Color.gray;
    private static final Color B = Color.white;

    public TreeViewCellRenderer(IconProvider iconProvider) {
        this.E = iconProvider;
    }

    public void setIconRenderer(IconProvider iconProvider) {
        this.E = iconProvider;
    }

    public synchronized Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (object == null) {
            SwingUtil.setToolTipText((JComponent)this, (String)"(anon) ");
            SwingUtil.setToolTipText((JComponent)jTree, (String)"(anon) ");
            return null;
        }
        boolean bl5 = this.hasGeneratedDefaultName(object);
        TreePath treePath = jTree.getLeadSelectionPath();
        bl4 = treePath == null ? false : treePath.getLastPathComponent() == object;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
        Icon icon = this.getIcon(object);
        this.setIcon(icon);
        this.setOpaque(false);
        Color color = this.getForegroundColor(object, bl5, bl, bl4);
        this.setForeground(color);
        String string = this.getText(object);
        this.setText(string);
        this.highlightViewedObject(object, poseidonProject);
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setLeafIcon(icon);
        String string2 = this.getToolTipText(object, poseidonProject);
        SwingUtil.setToolTipText((JComponent)this, (String)(string2 + " "));
        SwingUtil.setToolTipText((JComponent)jTree, (String)(string2 + " "));
        return this;
    }

    protected String getText(Object object) {
        String string = object.toString();
        String string2 = Strings.isEmpty((String)string) ? "" : "<html>" + Strings.encodeForXml((String)string) + "</html>";
        return string2;
    }

    protected Icon getIcon(Object object) {
        Icon icon = null;
        try {
            icon = object instanceof TreeView ? ((TreeView)object).getIcon() : this.E.getIcon(object);
        }
        catch (Throwable throwable) {
            Services.logError((Object)"[TreeViewCellRenderer reports an exception:]", (Throwable)throwable);
        }
        return icon;
    }

    protected Color getForegroundColor(Object object, boolean bl, boolean bl2, boolean bl3) {
        if (bl && !bl2 && !bl3) {
            return this.C;
        }
        if (!bl2) {
            return this.getTextNonSelectionColor();
        }
        return this.getTextSelectionColor();
    }

    protected boolean highlightViewedObject(Object object, PoseidonProject poseidonProject) {
        boolean bl = false;
        if (object instanceof TreeView) {
            TreeView treeView = (TreeView)object;
            Object object2 = treeView.getViewedObject();
            if (poseidonProject != null) {
                A a2 = poseidonProject.getHighlightManager();
                if (a2.D(object2)) {
                    this.setBackground(this.A);
                    bl = true;
                }
                if (a2.A(object2)) {
                    this.setBackground(this.D);
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.setBackground(B);
        }
        return bl;
    }

    protected abstract boolean hasGeneratedDefaultName(Object var1);

    protected abstract String getToolTipText(Object var1, PoseidonProject var2);

    public Color getBackgroundNonSelectionColor() {
        return null;
    }

    public Icon getDefaultLeafIcon() {
        return this.getIcon();
    }

    public Icon getDefaultOpenIcon() {
        return this.getIcon();
    }

    public Icon getDefaultClosedIcon() {
        return this.getIcon();
    }

    public void updateUI() {
        super.updateUI();
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }
}

