/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.util;

import com.gentleware.poseidon.util.ChildGenerator;
import com.gentleware.poseidon.util.Predicate;
import com.gentleware.poseidon.util.PredicateTrue;
import com.gentleware.services.util.CollectionFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class VectorSet
implements Serializable {
    public static final int TC_LIMIT = 50;
    private List A;

    public VectorSet() {
        this.A = CollectionFactory.createArrayList();
    }

    public VectorSet(int n2) {
        this.A = CollectionFactory.createArrayList((int)n2);
    }

    public VectorSet(Object object) {
        this.A = CollectionFactory.createArrayList();
        this.addElement(object);
    }

    public void addElement(Object object) {
        if (!this.contains(object)) {
            this.A.add(object);
        }
    }

    public void addAllElements(Collection collection) {
        if (collection == null) {
            return;
        }
        this.addAllElements(collection.iterator());
    }

    public void addAllElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public void addAllElements(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addElement(iterator.next());
        }
    }

    public void addAllElementsSuchThat(Enumeration enumeration, Predicate predicate) {
        if (predicate instanceof PredicateTrue) {
            this.addAllElements(enumeration);
        } else {
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (!predicate.predicate(e2)) continue;
                this.addElement(e2);
            }
        }
    }

    public void addAllElementsSuchThat(Iterator iterator, Predicate predicate) {
        if (predicate instanceof PredicateTrue) {
            this.addAllElements(iterator);
        } else {
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!predicate.predicate(e2)) continue;
                this.addElement(e2);
            }
        }
    }

    public void addAllElements(VectorSet vectorSet) {
        this.addAllElements(vectorSet.elements());
    }

    public void addAllElementsSuchThat(VectorSet vectorSet, Predicate predicate) {
        this.addAllElementsSuchThat(vectorSet.elements(), predicate);
    }

    public void remove(Object object) {
        if (object != null) {
            this.A.remove(object);
        }
    }

    public void removeElement(Object object) {
        if (object != null) {
            this.A.remove(object);
        }
    }

    public void removeAllElements() {
        this.A.clear();
    }

    public boolean contains(Object object) {
        if (object != null) {
            return this.A.contains(object);
        }
        return false;
    }

    public boolean containsSuchThat(Predicate predicate) {
        return this.findSuchThat(predicate) != null;
    }

    public Object findSuchThat(Predicate predicate) {
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!predicate.predicate(e2)) continue;
            return e2;
        }
        return null;
    }

    public Iterator elements() {
        return this.A.iterator();
    }

    public Object elementAt(int n2) {
        return this.A.get(n2);
    }

    public List asVector() {
        return this.A;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VectorSet)) {
            return false;
        }
        VectorSet vectorSet = (VectorSet)object;
        return !(this.A != null ? !((Object)this.A).equals(vectorSet.A) : vectorSet.A != null);
    }

    public int hashCode() {
        return this.A != null ? ((Object)this.A).hashCode() : 0;
    }

    public Object firstElement() {
        if (this.A.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.A.get(0);
    }

    public int size() {
        return this.A.size();
    }

    public String toString() {
        String string = "Set{";
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            string = string + iterator.next().toString();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string + "}";
    }

    public VectorSet transitiveClosure(ChildGenerator childGenerator) {
        return this.transitiveClosure(childGenerator, 50, PredicateTrue.theInstance());
    }

    public VectorSet reachable(ChildGenerator childGenerator) {
        return this.reachable(childGenerator, 50, PredicateTrue.theInstance());
    }

    public VectorSet reachable(ChildGenerator childGenerator, int n2, Predicate predicate) {
        VectorSet vectorSet = new VectorSet();
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            vectorSet.addAllElementsSuchThat(childGenerator.gen(e2), predicate);
        }
        return vectorSet.transitiveClosure(childGenerator, n2, predicate);
    }

    public VectorSet transitiveClosure(ChildGenerator childGenerator, int n2, Predicate predicate) {
        int n3 = 0;
        int n4 = -1;
        VectorSet vectorSet = new VectorSet();
        VectorSet vectorSet2 = this;
        vectorSet.addAllElements(this);
        while (n3 < n2 && vectorSet.size() > n4) {
            ++n3;
            n4 = vectorSet.size();
            VectorSet vectorSet3 = new VectorSet();
            Iterator iterator = vectorSet2.elements();
            while (iterator.hasNext()) {
                Iterator iterator2 = childGenerator.gen(iterator.next());
                vectorSet3.addAllElementsSuchThat(iterator2, predicate);
            }
            vectorSet.addAllElements(vectorSet3);
            vectorSet2 = vectorSet3;
        }
        return vectorSet;
    }
}

