/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator;

import com.gentleware.poseidon.generator.ElementPreparator;
import com.gentleware.poseidon.generator.ExternalEntryStrategy;
import com.gentleware.poseidon.generator.PreparationCheckingException;
import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.generator.PreparedElement;
import com.gentleware.poseidon.util.PoseidonUtils;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.util.Iterator;
import java.util.Map;

public abstract class A
implements ElementPreparator {
    private boolean A;
    private Map E;
    private Map D;
    private Map C;
    private ExternalEntryStrategy B;

    public boolean checkEnabled() {
        return this.A;
    }

    public void setCheckEnabled(boolean bl) {
        this.A = bl;
    }

    public void init() {
        this.E = CollectionFactory.createHashMap();
        this.D = CollectionFactory.createHashMap();
        this.C = CollectionFactory.createHashMap();
        this.B = null;
        this.initPreparedElementClasses();
    }

    public Map getPreparedElements() {
        return this.E;
    }

    public PreparedElement getPreparedElement(Object object) {
        return (PreparedElement)this.E.get(object);
    }

    public PreparedElement getOrCreatePreparedElement(Object object) {
        PreparedElement preparedElement = (PreparedElement)this.E.get(object);
        if (preparedElement != null) {
            return preparedElement;
        }
        try {
            preparedElement = this.prepare(object);
            this.E.put(object, preparedElement);
        }
        catch (PreparationException preparationException) {
            Services.logError((Object)("[ElementPreparatorImpl.getOrCreatePreparedElement]: cannot create PreparedElement for " + object), (Throwable)preparationException);
        }
        return preparedElement;
    }

    public void addPreparedElement(Object object, PreparedElement preparedElement) {
        this.E.put(object, preparedElement);
    }

    public Map getPreparedElementClassMap() {
        return this.D;
    }

    public Class getPreparedElementClass(Class clazz) {
        try {
            Object t = clazz.newInstance();
            return this.getPreparedElementClass(t);
        }
        catch (Exception exception) {
            Services.logError((Object)"Exception when trying to simulate Poseidon V1.4.1.");
            return null;
        }
    }

    public Class getPreparedElementClass(Object object) {
        Iterator iterator = this.D.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!PoseidonUtils.isIdenticalClass(object.getClass(), (Class)clazz)) continue;
            return (Class)this.getPreparedElementClassMap().get(clazz);
        }
        return null;
    }

    public void addPreparedElementClass(Class clazz, Class clazz2) {
        this.getPreparedElementClassMap().put(clazz, clazz2);
    }

    public void addExternalElementClasses(String string, Map map) {
        this.C.put(string, map);
    }

    public void removeExternalElementClasses(String string) {
        this.C.remove(string);
    }

    public PreparedElement getPreparedElementInstance(Class clazz) {
        try {
            Object t = clazz.newInstance();
            return this.getPreparedElementInstance(t);
        }
        catch (Exception exception) {
            Services.logError((Object)"Exception when trying to simulate Poseidon V1.4.1.", (Throwable)exception);
            return null;
        }
    }

    public PreparedElement getPreparedElementInstance(Object object) {
        Class clazz = this.getPreparedElementClass(object);
        if (clazz == null) {
            Services.logDebug((Object)("[ElementPreparatorImpl] No preparedElementInstance for class " + object.getClass().getName() + " available."));
            return null;
        }
        PreparedElement preparedElement = null;
        try {
            preparedElement = (PreparedElement)clazz.newInstance();
        }
        catch (Exception exception) {
            Services.logWarn((Object)("Could not find preparator class for " + object.getClass().getName()), (Throwable)exception);
        }
        return preparedElement;
    }

    public void reloadPreparedElementClasses() {
        this.D = CollectionFactory.createHashMap();
        this.initPreparedElementClasses();
        if (this.C.size() > 0) {
            Iterator iterator = this.C.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.useExternalEntries(string)) continue;
                this.D.putAll((Map)this.C.get(string));
            }
        }
    }

    protected void initPreparedElementClasses() {
    }

    protected boolean useExternalEntries(String string) {
        if (this.B == null) {
            return false;
        }
        return this.B.usePreparationClassesFrom(string);
    }

    public void setExternalPreparationClassStrategy(ExternalEntryStrategy externalEntryStrategy) {
        this.B = externalEntryStrategy;
    }

    public String check(Object object) throws PreparationCheckingException {
        PreparedElement preparedElement = (PreparedElement)this.getPreparedElements().get(object);
        if (preparedElement == null) {
            throw new PreparationCheckingException("prepared element of " + object + " is null", object);
        }
        return preparedElement.check();
    }
}

