/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator;

import com.gentleware.poseidon.generator.FileNameHolder;
import com.gentleware.poseidon.generator.GenerateException;
import com.gentleware.poseidon.generator.GeneratorFactory;
import com.gentleware.services.Services;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class CodeTemplate {
    protected static final int MAX_UNDERSCORE_INDENT_LEVEL = 40;
    protected static final char UNDERSCORE_INDENT_CHAR = '_';
    private Template D;
    private String E;
    private VelocityContext C;
    private Object A;
    private String B;

    public CodeTemplate(String string, String string2) {
        this.E = string;
        this.B = string2;
    }

    public String getName() {
        if (this.B != null) {
            return this.B;
        }
        return this.E.substring(this.E.indexOf(47) + 1, this.E.indexOf("Template"));
    }

    public void setName(String string) {
        this.B = string;
    }

    public void setTemplate(Template template) {
        this.D = template;
    }

    public Template getTemplate() {
        return this.D;
    }

    public void setTemplatePath(String string) {
        this.E = string;
    }

    public String getTemplatePath() {
        return this.E;
    }

    public void setContext(VelocityContext velocityContext) {
        this.C = velocityContext;
    }

    public void addContext(String string, Object object) {
        this.C.put(string, object);
    }

    public VelocityContext getContext() {
        return this.C;
    }

    public void updateTemplate() throws GenerateException {
        try {
            GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
            VelocityEngine velocityEngine = generatorFactory.A();
            this.D = velocityEngine.getTemplate(this.E);
        }
        catch (Exception exception) {
            Services.logError((Object)"[CodeTemplate: updateTemplate", (Throwable)exception);
            throw new GenerateException("error in updating template " + this.E, exception);
        }
    }

    public void initContext() {
        this.C = new VelocityContext();
        this.addContext("fileNameHolder", FileNameHolder.getInstance());
        this.addIndentationSpaces();
    }

    protected void addIndentationSpaces() {
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = 40; i > 0; --i) {
            stringBuffer.append('_');
            this.addContext(stringBuffer.toString(), "");
        }
    }

    public void generate(Writer writer) throws GenerateException {
        if (this.C == null) {
            throw new GenerateException("context is null");
        }
        if (this.D == null) {
            this.updateTemplate();
        }
        if (this.D == null) {
            throw new GenerateException("template is null");
        }
        try {
            this.D.merge((Context)this.C, writer);
        }
        catch (Exception exception) {
            Services.logError((Object)"[CodeTemplate.generate: ]", (Throwable)exception);
            throw new GenerateException("error in merging template " + this.E + " with context");
        }
    }

    public Object getPredicate() {
        return this.A;
    }

    public void setPredicate(Object object) {
        this.A = object;
    }

    public String toString() {
        return "CodeTemplate with path " + this.E + ", predicate " + this.A + ", name " + this.B;
    }
}

