/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator;

import com.gentleware.poseidon.generator.CoreGeneratorController;
import com.gentleware.poseidon.generator.GeneratorController;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.velocity.app.VelocityEngine;

public class GeneratorFactory {
    private Map D = CollectionFactory.createHashMap();
    private Map F = CollectionFactory.createHashMap();
    private List B = CollectionFactory.createArrayList();
    private List C = CollectionFactory.createArrayList();
    private static GeneratorFactory A = null;
    public static final String CONFIGURATION_PREFIX = "poseidon/codeGen/";
    private VelocityEngine E = new VelocityEngine();

    public boolean addGeneratorController(String string, GeneratorController generatorController) {
        if (this.D.containsKey(string)) {
            this.D.remove(string);
        }
        this.D.put(string, generatorController);
        return this.D.containsKey(string);
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.B.contains(actionListener)) {
            this.B.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.B.remove(actionListener);
    }

    public void removeAllListeners() {
        this.B.clear();
    }

    public boolean treatAsUnencrypted(String string) {
        return this.C.contains(string);
    }

    public void addUnencryptedTemplateOrLibrary(String string) {
        this.C.remove(string);
        this.C.add(string);
    }

    public void removeUnencryptedTemplateOrLibrary(String string) {
        this.C.remove(string);
    }

    public boolean removeGeneratorController(String string) {
        this.D.remove(string);
        String string2 = this.getConfigurationEntry(CONFIGURATION_PREFIX + string + "/generate");
        Services.logDebug((Object)("[" + this.getClass().getName() + "] generate entry = " + string2));
        if ("true".equals(string2)) {
            this.setConfigurationEntry("poseidon/codeGen." + string + "/generate", "false");
            this.setConfigurationEntry("poseidon/codeGen/java/generate", "true");
        }
        return !this.D.containsKey(string);
    }

    public void addMacroLibrary(String string) {
        this.addMacroLibrary(string, false);
    }

    public void addMacroLibrary(String string, boolean bl) {
        if (bl) {
            this.C.remove(string);
            this.C.add(string);
        }
        try {
            this.E.getTemplate(string);
        }
        catch (Exception exception) {
            Services.logError((Object)("[" + this.getClass() + "] exception caught while adding macro library!"), (Throwable)exception);
        }
    }

    public void removeMacroLibrary(String string) {
        this.C.remove(string);
    }

    public List getMacroLibraries() {
        return null;
    }

    VelocityEngine A() {
        return this.E;
    }

    public void reloadMacros() {
        this.E = new VelocityEngine();
        GeneratorController generatorController = this.getGeneratorController();
        if (generatorController == null) {
            return;
        }
        if (generatorController instanceof CoreGeneratorController) {
            generatorController.reloadMacros();
        }
    }

    public String getLanguage() {
        return this.getConfigurationEntry("poseidon/codeGen/language");
    }

    public void setLanguage(String string) {
        this.setConfigurationEntry("poseidon/codeGen/language", string);
    }

    public GeneratorController getGeneratorController() {
        Map map = Services.getInstance().getConfiguration().getAllEntriesMatching(CONFIGURATION_PREFIX + this.getLanguage());
        List list = CollectionFactory.createArrayList();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            if (string2.indexOf("generate") <= -1 || !"true".equals(map.get(string2))) continue;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(string);
                stringBuffer.append("/");
            }
            string = stringBuffer.toString();
            GeneratorController generatorController = this.getGeneratorController(string = string.substring(0, string.length() - 1));
            if (generatorController == null) continue;
            list.add(generatorController);
        }
        if (list.size() > 1) {
            Services.logError((Object)"too many selected generation attributes, no GeneratorController will be used!");
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        return (GeneratorController)list.get(0);
    }

    public void fireGenerationDone() {
        if (this.B == null || this.B.size() == 0) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 999, "GenerationDone");
        Iterator iterator = this.B.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public Map getConfiguration() {
        return this.F;
    }

    public void updateConfiguration() {
        this.F = Services.getInstance().getConfiguration().getAllEntriesMatching(CONFIGURATION_PREFIX);
    }

    private GeneratorFactory() {
    }

    public static GeneratorFactory getInstance() {
        if (A == null) {
            A = new GeneratorFactory();
            A.updateConfiguration();
            A.reloadMacros();
        }
        return A;
    }

    public String getConfigurationEntry(String string) {
        if (Services.getInstance().getConfiguration().containsKey(string)) {
            return Services.getInstance().getConfiguration().get(string);
        }
        return "";
    }

    public GeneratorController getGeneratorController(String string) {
        return (GeneratorController)this.D.get(string);
    }

    public Set getRegisteredLanguages() {
        return this.D.keySet();
    }

    public String getSourceExtension() {
        return this.getConfigurationEntry(CONFIGURATION_PREFIX + this.getLanguage() + "/sourceFileSuffix");
    }

    public List getSourceExtensionList() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getSourceExtension(), " ,;:");
        List list = CollectionFactory.createArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        return list;
    }

    public String getCompiledExtension() {
        return this.getConfigurationEntry(CONFIGURATION_PREFIX + this.getLanguage() + "/compFileSuffix");
    }

    public void setConfigurationEntry(String string, String string2) {
        Services.getInstance().getConfiguration().put(string, string2);
    }
}

