/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.generator.ui;

import com.gentleware.jboogie.openapi.Project;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.poseidon.B;
import com.gentleware.poseidon.generator.Generator;
import com.gentleware.poseidon.generator.GeneratorController;
import com.gentleware.poseidon.generator.GeneratorFactory;
import com.gentleware.poseidon.generator.ui.A;
import com.gentleware.poseidon.generator.ui.F;
import com.gentleware.poseidon.generator.ui.GenerationResourceBundle;
import com.gentleware.poseidon.generator.ui.H;
import com.gentleware.poseidon.generator.ui.TemplateTester;
import com.gentleware.poseidon.generator.ui.TreeRenderingStrategy;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.CheckNode;
import com.gentleware.poseidon.util.PoseidonUtils;
import com.gentleware.services.Services;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.swingx.ResourceId;
import com.gentleware.services.util.CollectionFactory;
import com.gentleware.services.util.Files;
import com.gentleware.services.util.Utils;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.tree.MutableTreeNode;

public class DialogController {
    public static final String CODE_GEN_KEY = "codeGen";
    public static final String DOCUMENT_AUTHORS_KEY = "documentAuthors";
    public static final String EXTERNAL_LINK_BASE_KEY = "externalLinkBase";
    public static final String EXTERNAL_LINK_BASE_DEFAULT_VALUE = "http://java.sun.com/j2se/1.4.2/docs/api";
    public static final String GENERATE_EXTERNAL_LINKS_KEY = "showExternalLinks";
    private static final String E = "umldoc";
    protected static final String M = Services.localize((ResourceId)GenerationResourceBundle.CodeGeneration);
    protected static final String I;
    protected static final String H;
    protected static final String D;
    public static final String KEY_TEMPLATE_DIR;
    public static final String DOCUMENT_AUTHORS;
    public static final String EXTERNAL_LINK_BASE;
    public static final String GENERATE_EXTERNAL_LINKS;
    private static DialogController B;
    private Map G = CollectionFactory.createHashMap();
    private Map A = CollectionFactory.createHashMap();
    private Map C = CollectionFactory.createHashMap();
    private Map F = CollectionFactory.createHashMap();
    private Map L = CollectionFactory.createHashMap();
    private H K = new H();
    private static final int J = 1024;

    public void addLanguage(String string) {
        if (this.G.get(string) == null) {
            String string2 = this.getLanguageKey(string);
            if (string2 == null) {
                string2 = this.getConfigurationCompatibleString(string);
                this.A.put(string, string2);
            }
            this.F.put(string2, string);
            this.G.put(string, CollectionFactory.createArrayList());
            this.K.A(string);
            PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
            if (poseidonProject != null) {
                poseidonProject.setSourcepath(PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath(), string2);
            } else {
                Services.logWarn((Object)"Current project is null. Not setting source path.", (Throwable)new Exception());
            }
            Services.logDebug((Object)("languageName " + string + " installed, shortname " + string2));
        } else {
            Services.logInfo((Object)("The languageName " + string + " is already installed."));
        }
    }

    public void addLanguage(String string, ResourceId resourceId) {
        if (this.G.get(string) == null) {
            ResourceId resourceId2;
            String string2 = this.getLanguageKey(string);
            if (string2 == null) {
                string2 = this.getConfigurationCompatibleString(string);
                this.A.put(string, string2);
            }
            if ((resourceId2 = this.getLanguageResourceId(string)) == null) {
                this.C.put(string, resourceId);
            }
            this.F.put(string2, string);
            this.G.put(string, CollectionFactory.createArrayList());
            this.K.A(string);
            PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
            if (poseidonProject != null) {
                poseidonProject.setSourcepath(PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath(), string2);
            } else {
                Services.logWarn((Object)"Current project is null. Not setting source path.", (Throwable)new Exception());
            }
            Services.logDebug((Object)("languageName " + string + " installed, shortname " + string2));
        } else {
            Services.logInfo((Object)("The languageName " + string + " is already installed."));
        }
    }

    public void removeLanguage(String string) {
        List list = (List)this.G.get(string);
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            Services.logInfo((Object)("The language " + string + " still has subsettings and therefore is not removed."));
            return;
        }
        this.G.remove(string);
        this.K.G(string);
    }

    public void removeLanguageEntries(String string) {
        String string2 = (String)this.F.get(string);
        this.F.remove(string);
        this.A.remove(string2);
        this.C.remove(string2);
    }

    public void addSettingsPanel(String string, JPanel jPanel, String string2, ResourceId resourceId) {
        if (jPanel != null) {
            this.K.A(string, jPanel, string2);
        }
    }

    public boolean hasPanel(String string) {
        return this.K.C(string);
    }

    public void removeSettingsPanel(String string, String string2) {
        this.K.A(string, string2);
    }

    public void removeSettingsPanels(String string) {
        this.K.D(string);
    }

    public Map getLanguagePanels(String string) {
        return this.K.F(string);
    }

    public Map getRelevantGeneralPanels(Set set) {
        Map map = CollectionFactory.createHashMap((int)set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.L.get(string);
            if (v == null) {
                Services.logError((Object)("Code gen. settings panels: non-existent panel requested for " + string), (Throwable)new Exception());
                continue;
            }
            map.put(string, v);
        }
        return map;
    }

    public List getAllLanguages() {
        return this.K.A();
    }

    protected int A() {
        return this.K.B();
    }

    protected void A(JToggleButton jToggleButton, String string) {
        String string2 = Services.getInstance().getConfiguration().makeKey(CODE_GEN_KEY, string, jToggleButton.getName());
        jToggleButton.setSelected(Services.getInstance().getConfiguration().getBoolean(string2));
    }

    public List getSubBoxes(String string) {
        return (List)this.G.get(string);
    }

    public static boolean getCleanDirectory() {
        return Services.getInstance().getConfiguration().getBoolean(I, false);
    }

    public static void setCleanDirectory(boolean bl) {
        Services.getInstance().getConfiguration().putBoolean(I, bl);
    }

    public static String getOutputDir() {
        String string = PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath();
        if ("".equals(string)) {
            string = System.getProperty("user.home") + File.separator + "temp";
            Services.logWarn((Object)("Given output-path is empty. Using default-path: \"" + string + "\"."));
        }
        String string2 = Files.getCanonicalPath((String)string);
        return string2;
    }

    public static String getOutputDir(String string) {
        String string2 = PoseidonApplicationState.getInstance().getCurrentProject().getSourcepath(string);
        if ("".equals(string2)) {
            string2 = System.getProperty("user.home") + File.separator + "temp";
            Services.logWarn((Object)("Given output-path is empty. Using default-path: \"" + string2 + "\"."));
        }
        String string3 = Files.getCanonicalPath((String)string2);
        return string3;
    }

    public static void setOutputDir(String string) {
        PoseidonApplicationState.getInstance().getCurrentProject().setSourcepath(string);
    }

    public static void setOutputDir(String string, String string2) {
        PoseidonApplicationState.getInstance().getCurrentProject().setSourcepath(string, string2);
    }

    public static void setDeselectedNodes(CheckNode checkNode) {
        Set set = CollectionFactory.createHashSet((int)1024);
    }

    public static String getTemplateDir() {
        String string;
        if (PoseidonUtils.isWebStart()) {
            string = PoseidonUtils.getInstallationDirectory().getAbsolutePath();
            Services.logInfo((Object)("WebStart installation path:" + string));
        } else {
            string = PoseidonUtils.getInstallationDirectory().getAbsolutePath() + File.separator + "lib";
        }
        String string2 = Services.getInstance().getConfiguration().getString(KEY_TEMPLATE_DIR);
        File file = new File(string2);
        if (!file.exists()) {
            return Files.getCanonicalPath((String)string);
        }
        return Files.getCanonicalPath((String)string2);
    }

    public static void setTemplateDir(String string) {
        if ((string = DialogController.D(string)) == null) {
            string = PoseidonUtils.isWebStart() ? PoseidonUtils.getInstallationDirectory().getAbsolutePath() : PoseidonUtils.getInstallationDirectory().getAbsolutePath() + File.separator + "lib";
        }
        Services.getInstance().getConfiguration().put(KEY_TEMPLATE_DIR, Files.getCanonicalPath((String)string));
    }

    private boolean B(String string) {
        boolean bl = DialogController.D(string) != null;
        return bl;
    }

    private static String D(String string) {
        TemplateTester templateTester = com.gentleware.poseidon.B._() ? new F() : new A();
        string = templateTester.validate(string);
        return string;
    }

    public static void resetTemplateDir() {
        String string = PoseidonUtils.getInstallationDirectory().getAbsolutePath() + File.separator + "lib";
        Services.getInstance().getConfiguration().put(KEY_TEMPLATE_DIR, Files.getCanonicalPath((String)string));
    }

    public static boolean getShowProgressBar() {
        return Services.getInstance().getConfiguration().getBoolean(H, false);
    }

    public static void setShowProgessBar(boolean bl) {
        Services.getInstance().getConfiguration().putBoolean(H, bl);
    }

    public static boolean getDoCompilation() {
        return Services.getInstance().getConfiguration().getBoolean(D, false);
    }

    public static void setDoCompilation(boolean bl) {
        Services.getInstance().getConfiguration().putBoolean(D, bl);
    }

    public static CheckNode getTreeRoot() {
        return DialogController.createTree();
    }

    public static CheckNode getTreeRoot(String string) {
        return DialogController.createTree(string);
    }

    protected void A(String string) {
        this.transferLanguage(string);
        Iterator iterator = this.G.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.getLanguageKey(string2);
            if (string3 == null) {
                string3 = string2;
            }
            Iterator iterator2 = ((List)this.G.get(string2)).iterator();
            while (iterator2.hasNext()) {
                JToggleButton jToggleButton = (JToggleButton)iterator2.next();
                if ("".equals(jToggleButton.getName()) || (string2 + ".basic").equalsIgnoreCase(jToggleButton.getName())) continue;
                String string4 = Services.getInstance().getConfiguration().makeKey(CODE_GEN_KEY, string3, jToggleButton.getName());
                Services.getInstance().getConfiguration().putBoolean(string4, jToggleButton.isSelected());
            }
        }
        GeneratorFactory.getInstance().updateConfiguration();
    }

    public void transferLanguage(String string) {
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        String string2 = configuration.makeKey(CODE_GEN_KEY, "language");
        String string3 = configuration.getString(string2);
        configuration.put(string2, string);
        String string4 = configuration.makeKey(CODE_GEN_KEY, string3, "generate");
        configuration.putBoolean(string4, false);
        this.E(string);
        String string5 = configuration.makeKey(CODE_GEN_KEY, string, "generate");
        configuration.putBoolean(string5, true);
        this.C(string);
    }

    protected void C(String string) {
        List list = this.getSubBoxes(string);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        while (iterator.hasNext()) {
            JToggleButton jToggleButton = (JToggleButton)iterator.next();
            if (!(jToggleButton instanceof JRadioButton)) continue;
            String string2 = this.getLanguageKey(string);
            if (!jToggleButton.isSelected() || jToggleButton.getName().equals(string2 + ".basic")) continue;
            String string3 = configuration.makeKey(CODE_GEN_KEY, string2, "generate");
            configuration.putBoolean(string3, false);
            String string4 = configuration.makeKey(CODE_GEN_KEY, string2, jToggleButton.getName(), "generate");
            configuration.putBoolean(string4, true);
        }
    }

    protected void E(String string) {
        List list = this.getSubBoxes(string);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JToggleButton jToggleButton = (JToggleButton)iterator.next();
            if (!(jToggleButton instanceof JRadioButton) || jToggleButton.getName().equals(string + ".basic")) continue;
            String string2 = Services.getInstance().getConfiguration().makeKey(CODE_GEN_KEY, this.getLanguageKey(string), jToggleButton.getName(), "generate");
            Services.getInstance().getConfiguration().putBoolean(string2, false);
        }
    }

    public void generateCode(String string, CheckNode checkNode, JTextArea jTextArea) {
        String string2 = DialogController.getTemplateDir();
        if (checkNode == null) {
            return;
        }
        jTextArea.append("TemplatePath: " + string2);
        if (!this.B(string2)) {
            jTextArea.append("Template path is not valid!");
            return;
        }
        Enumeration enumeration = checkNode.preorderEnumeration();
        List list = CollectionFactory.createArrayList();
        List list2 = CollectionFactory.createArrayList();
        while (enumeration.hasMoreElements()) {
            CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
            if (checkNode2.getUserObject() instanceof Project) continue;
            if (checkNode2.isSelected()) {
                list.add(checkNode2.getUserObject());
                continue;
            }
            list2.add(checkNode2.getUserObject());
        }
        if (list.size() == 0) {
            jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.nothingToDo));
        } else {
            jTextArea.setText("");
            boolean bl = true;
            if (DialogController.getCleanDirectory()) {
                bl = this.A(string, list, list2, jTextArea);
            }
            if (!bl) {
                jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.NothingGenerated));
                return;
            }
            GeneratorController generatorController = GeneratorFactory.getInstance().getGeneratorController();
            GeneratorFactory.getInstance().reloadMacros();
            if (generatorController == null) {
                jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.GeneratorNotAvailable));
            } else {
                generatorController.generateCode(list, (CheckNode)checkNode.getFirstChild(), jTextArea);
            }
        }
    }

    private boolean A(String string, List list, List list2, JTextArea jTextArea) {
        Object object;
        int n;
        boolean bl = false;
        String string2 = DialogController.getOutputDir(string);
        List list3 = GeneratorFactory.getInstance().getSourceExtensionList();
        String string3 = GeneratorFactory.getInstance().getCompiledExtension();
        List list4 = CollectionFactory.createArrayList();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            list4.addAll(Utils.getAllFilenames((File)new File(string2), (String)((String)iterator.next())));
        }
        Generator generator = GeneratorFactory.getInstance().getGeneratorController().getGenerator();
        generator.initInternal();
        for (n = 0; n < list.size() + list2.size(); ++n) {
            object = n < list.size() ? list.get(n) : list2.get(n - list.size());
            iterator = list3.iterator();
            while (iterator.hasNext()) {
                String string4 = generator.getPlainFilenameForElement(object, string2) + "." + iterator.next();
                list4.remove(string4);
            }
        }
        if (list4.size() == 0) {
            bl = true;
        } else {
            jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.FoundExistingFiles));
            for (n = 0; n < list4.size(); ++n) {
                object = (String)list4.get(n);
                jTextArea.append("  '" + object + "'\n");
            }
            Frame frame = PoseidonUIConnector.getApplicationWindow();
            int n2 = JBoogieUtils.showConfirmDialog((Component)frame, (Object)Services.localize((ResourceId)GenerationResourceBundle.OtherFilesFound), (String)M, (int)1, (int)2);
            if (n2 == 0) {
                jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.Deleting));
                for (int i = 0; i < list4.size(); ++i) {
                    String string5 = (String)list4.get(i);
                    jTextArea.append("  " + string5 + " ... ");
                    iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        String string6 = (String)iterator.next();
                        if (!string6.equals(string3) && !"".equals(string3)) continue;
                        String string7 = string5.substring(0, string5.lastIndexOf(string6)) + string3;
                        new File(string7).delete();
                    }
                    if (new File(string5).delete()) {
                        jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.done));
                        continue;
                    }
                    jTextArea.append(Services.localize((ResourceId)GenerationResourceBundle.ErrorLeavingItThere));
                }
                bl = true;
            } else if (n2 == 1) {
                bl = true;
            }
        }
        return bl;
    }

    private DialogController() {
        this.A.put("Java", "java");
        this.A.put("C++", "cpp");
        this.A.put("C#", "csharp");
    }

    public Set getLanguageNamesSet() {
        return this.F.keySet();
    }

    public String getLanguageKey(String string) {
        return (String)this.A.get(string);
    }

    public String getLanguageName(String string) {
        return (String)this.F.get(string);
    }

    public ResourceId getLanguageResourceId(String string) {
        return (ResourceId)this.C.get(string);
    }

    public String getConfigurationCompatibleString(String string) {
        string.replace('.', '_');
        string.replace('=', '_');
        return string.toLowerCase();
    }

    public static DialogController getInstance() {
        if (B == null) {
            B = new DialogController();
        }
        return B;
    }

    public static CheckNode createTree() {
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
        GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
        GeneratorController generatorController = generatorFactory.getGeneratorController();
        if (generatorController == null) {
            Services.logError((Object)"internal confusion: no GeneratorController set", (Throwable)new Exception());
            return null;
        }
        TreeRenderingStrategy treeRenderingStrategy = generatorController.getTreeRenderingStrategy();
        if (!treeRenderingStrategy.isTreeElement(poseidonProject)) {
            Services.logDebug((Object)"[DialogController] project not wanted");
            return null;
        }
        CheckNode checkNode = DialogController.A(poseidonProject, treeRenderingStrategy);
        return checkNode;
    }

    public static CheckNode createTree(String string) {
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
        GeneratorFactory generatorFactory = GeneratorFactory.getInstance();
        GeneratorController generatorController = generatorFactory.getGeneratorController(string);
        if (generatorController == null) {
            Services.logError((Object)"internal confusion: no GeneratorController set", (Throwable)new Exception());
            return null;
        }
        TreeRenderingStrategy treeRenderingStrategy = generatorController.getTreeRenderingStrategy();
        if (!treeRenderingStrategy.isTreeElement(poseidonProject)) {
            Services.logDebug((Object)"[DialogController] project not wanted");
            return null;
        }
        CheckNode checkNode = DialogController.A(poseidonProject, treeRenderingStrategy);
        return checkNode;
    }

    private static CheckNode A(Object object, TreeRenderingStrategy treeRenderingStrategy) {
        CheckNode checkNode = new CheckNode(object);
        Collection collection = treeRenderingStrategy.getChildren(object);
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                boolean bl = treeRenderingStrategy.isTreeElement(e);
                if (!bl) continue;
                CheckNode checkNode2 = DialogController.A(e, treeRenderingStrategy);
                checkNode.add((MutableTreeNode)checkNode2);
            }
        }
        return checkNode;
    }

    static {
        Services services = Services.getInstance();
        Configuration configuration = services.getConfiguration();
        I = configuration.makeKey(CODE_GEN_KEY, "cleanDirectory");
        H = configuration.makeKey(CODE_GEN_KEY, "showProgressBar");
        D = configuration.makeKey(CODE_GEN_KEY, "compile");
        KEY_TEMPLATE_DIR = configuration.makeKey(CODE_GEN_KEY, "templateFolder");
        DOCUMENT_AUTHORS = configuration.makeKey(CODE_GEN_KEY, E, DOCUMENT_AUTHORS_KEY);
        EXTERNAL_LINK_BASE = configuration.makeKey(CODE_GEN_KEY, E, EXTERNAL_LINK_BASE_KEY);
        GENERATE_EXTERNAL_LINKS = configuration.makeKey(CODE_GEN_KEY, E, GENERATE_EXTERNAL_LINKS_KEY);
    }
}

