/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.mdr.trovememoryimpl;

import com.gentleware.mdr.trovememoryimpl.PrimaryIndexLogStrategy;
import com.gentleware.mdr.trovememoryimpl.SinglevaluedIndexLogStrategyImpl;
import gnu.trove.TLongObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.TransactionSingleValueLog;
import org.netbeans.mdr.util.Logger;

public class PrimaryIndexLogStrategyImpl
extends SinglevaluedIndexLogStrategyImpl
implements PrimaryIndexLogStrategy {
    private ByteArrayOutputStream baoStrm = new ByteArrayOutputStream();
    private DataOutputStream daoStrm = new DataOutputStream(this.baoStrm);
    private Storage _storage;

    PrimaryIndexLogStrategyImpl(SinglevaluedIndex singlevaluedIndex, Storage storage) {
        this._storage = storage;
    }

    public void putLog(Object old, Object key) {
        if (old == null) {
            this._transSingleValueLog.logAdd(key);
        } else {
            PrimaryValueLog valueLog = this._transSingleValueLog.isLogged(key) ? null : this.createValueLog((Streamable)old);
            this._transSingleValueLog.logReplace(key, (Object)valueLog);
        }
    }

    public void replaceLog(Object original, long serialNumber, Object key) throws StorageException {
        PrimaryValueLog valueLog = this._transSingleValueLog.isLogged(key) ? null : this.createValueLog((Streamable)original);
        this._transSingleValueLog.logReplace(key, (Object)valueLog);
    }

    public void removeLog(boolean valueRemoved, Object key, Object oldValue) {
        if (valueRemoved) {
            PrimaryValueLog valueLog = this._transSingleValueLog.isLogged(key) ? null : this.createValueLog((Streamable)oldValue);
            this._transSingleValueLog.logRemove(key, (Object)valueLog);
        }
    }

    public void willChange(Object key, TLongObjectHashMap entries, long serialNumber) throws StorageException {
        if (!this._transSingleValueLog.isLogged(key)) {
            Object value = entries.get(serialNumber);
            PrimaryValueLog valueLog = value != null ? this.createValueLog((Streamable)value) : null;
            this._transSingleValueLog.logValue(key, (Object)valueLog);
        }
        this._transSingleValueLog.setDirty(key);
    }

    private PrimaryValueLog createValueLog(Streamable value) {
        this.baoStrm.reset();
        try {
            value.write((OutputStream)this.daoStrm);
        }
        catch (RuntimeException e) {
        }
        catch (StorageException e) {
            Logger.getDefault().notify((Throwable)e);
        }
        return new PrimaryValueLog(this.baoStrm.toByteArray(), value, this._storage);
    }

    private static class PrimaryValueLog
    implements TransactionSingleValueLog.ValueLog {
        private byte[] bytes;
        private Streamable obj;
        private Storage storage;

        PrimaryValueLog(byte[] bytes, Streamable obj, Storage storage) {
            this.bytes = bytes;
            this.obj = obj;
            this.storage = storage;
        }

        public Object resolveOriginalValue() throws StorageException {
            ByteArrayInputStream baiStrm = new ByteArrayInputStream(this.bytes);
            DataInputStream daiStrm = new DataInputStream(baiStrm);
            if (this.obj instanceof StorageClient) {
                ((StorageClient)this.obj).setStorage(this.storage);
            }
            this.obj.read((InputStream)daiStrm);
            return this.obj;
        }
    }
}

