/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.Serializable;

public final class CharsBuffer
implements Serializable {
    private char[] value;
    private int count;

    public CharsBuffer() {
        this(16);
    }

    public CharsBuffer(int length) {
        this.value = new char[length];
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public synchronized void append(char[] str, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newCount;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

