/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.Reference;
import javax.jmi.model.RefersTo;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.util.TagProvider;
import org.netbeans.lib.jmi.xmi.DefaultWriter;
import org.netbeans.lib.jmi.xmi.ElementsCache;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaProducer {
    private static String FIXED_SCHEMA_FILE = "resources/fixed_schema.xml";
    private OutputStreamWriter streamWriter;
    private DefaultWriter writer;
    private TagProvider tagProvider;
    private RefPackage extent;
    private ElementsCache elementsCache;
    private Set trackedPackages;
    private Map classHierarchy;
    private Map allSubtypes_cache;
    private Map namespaces;
    private Map nsPrefixToURI;
    private Set enumerations;
    private boolean elementStarted;
    private String elementName;
    private AttributesImpl attributes = new AttributesImpl();

    private void startElement(String name) {
        if (this.elementStarted) {
            this.writeStartElement();
        }
        this.elementName = name;
        this.elementStarted = true;
    }

    private void endElement(String name) {
        if (this.elementStarted) {
            this.writeStartElement();
        }
        try {
            this.writer.endElement(null, null, name);
        }
        catch (SAXException e) {
            throw new DebugException(e.getMessage());
        }
    }

    private void addAttribute(String name, String value) {
        this.attributes.addAttribute(null, null, name, null, value);
    }

    private void characters(String text) {
        if (this.elementStarted) {
            this.writeStartElement();
        }
        try {
            this.writer.characters(text.toCharArray(), 0, text.length());
        }
        catch (SAXException e) {
            throw new DebugException(e.getMessage());
        }
    }

    private void writeStartElement() {
        try {
            this.writer.startElement(null, null, this.elementName, this.attributes);
        }
        catch (SAXException e) {
            throw new DebugException(e.getMessage());
        }
        this.elementStarted = false;
        this.attributes.clear();
    }

    public void init() {
        this.writer = new DefaultWriter(this.streamWriter, null);
        this.elementStarted = false;
        this.elementName = null;
        this.attributes.clear();
        this.enumerations = AbstractCollectionFactory.getCollectionFactory().createHashSet();
        this.tagProvider = new TagProvider();
        this.elementsCache = new ElementsCache(this.extent);
        this.trackedPackages = AbstractCollectionFactory.getCollectionFactory().createHashSet();
        this.classHierarchy = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.allSubtypes_cache = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.namespaces = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.nsPrefixToURI = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.findNamespaces(this.extent);
        this.trackedPackages.clear();
    }

    public void generate(OutputStream stream, RefPackage extent) throws IOException {
        this.streamWriter = new OutputStreamWriter(stream);
        this.extent = extent;
        this.init();
        try {
            this.writer.startDocument();
            this.startElement("xsd:schema");
            this.addAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            this.addAttribute("xmlns:xmi", "http://www.omg.org/XMI");
            this.startElement("xsd:import");
            this.addAttribute("namespace", "http://www.omg.org/XMI");
            this.endElement("xsd:import");
            this.writePackageSchema(extent);
            Iterator iter = this.enumerations.iterator();
            while (iter.hasNext()) {
                this.writeEnumerationSchema((EnumerationType)iter.next());
            }
            this.endElement("xsd:schema");
            try {
                this.writer.endDocument();
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            stream.flush();
            stream.close();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void writePackageSchema(RefPackage pkg) {
        if (this.trackedPackages.contains(pkg)) {
            return;
        }
        this.trackedPackages.add(pkg);
        Iterator iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.writePackageSchema((RefPackage)iter.next());
        }
        iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            this.writeClassSchema((RefClass)iter.next());
        }
        this.writePackageElementDef(pkg);
    }

    public void writeClassSchema(RefClass proxy) {
        Reference reference;
        List references;
        Attribute attr;
        Iterator iter;
        List instAttrs;
        StringBuffer buffer = new StringBuffer();
        MofClass meta = (MofClass)proxy.refMetaObject();
        String className = this.objectName((ModelElement)meta);
        String contentType = this.getContentType((ModelElement)meta);
        boolean useExtensions = this.isUseSchemaExtensions((ModelElement)meta);
        boolean isChoice = this.isMaxMultiplicityEnforced((ModelElement)meta) || this.isMinMultiplicityEnforced((ModelElement)meta);
        this.findEnumerations((Namespace)meta);
        this.startElement("xsd:complexType");
        this.addAttribute("name", meta.getName());
        if (contentType != null && contentType.equals("mixed")) {
            this.addAttribute("mixed", "true");
        }
        if (useExtensions) {
            this.startElement("xsd:complexContent");
            this.startElement("xsd:extension");
            List supers = meta.getSupertypes();
            if (supers.size() != 1) {
                // empty if block
            }
            String base = this.objectName((ModelElement)((MofClass)supers.iterator().next()));
            this.addAttribute("base", base);
        }
        if (isChoice) {
            this.startElement("xsd:choice");
            this.addAttribute("minOccurs", "0");
            this.addAttribute("maxOccurs", "unbounded");
        } else {
            this.startElement("xsd:sequence");
        }
        if (contentType == null) {
            instAttrs = useExtensions ? this.elementsCache.localInstanceAttributes(meta) : this.elementsCache.instanceAttributes(meta);
            iter = instAttrs.iterator();
            while (iter.hasNext()) {
                Classifier type;
                attr = (Attribute)iter.next();
                this.startElement("xsd:element");
                this.addAttribute("name", attr.getName());
                if (this.isNillable((ModelElement)attr)) {
                    this.addAttribute("nillable", "true");
                }
                if (this.isMinMultiplicityEnforced((ModelElement)attr)) {
                    this.addAttribute("minOccurs", this.multToString(attr.getMultiplicity().getLower()));
                }
                if (this.isMaxMultiplicityEnforced((ModelElement)attr)) {
                    this.addAttribute("maxOccurs", this.multToString(attr.getMultiplicity().getUpper()));
                }
                if ((type = this.getType((TypedElement)attr)) instanceof MofClass) {
                    String schemaType = this.getSchemaType((ModelElement)attr);
                    if (schemaType != null) {
                        this.addAttribute("type", schemaType);
                    } else {
                        this.writeAnyElement();
                    }
                } else if (type instanceof EnumerationType) {
                    this.addAttribute("type", type.getName());
                } else {
                    this.addAttribute("type", "xsd:string");
                }
                this.endElement("xsd:element");
            }
            references = useExtensions ? this.elementsCache.localReferences(meta) : this.elementsCache.references(meta);
            iter = references.iterator();
            while (iter.hasNext()) {
                String contType;
                reference = (Reference)iter.next();
                this.startElement("xsd:element");
                this.addAttribute("name", reference.getName());
                if (this.isMinMultiplicityEnforced((ModelElement)reference)) {
                    this.addAttribute("minOccurs", this.multToString(reference.getMultiplicity().getLower()));
                }
                if (this.isMaxMultiplicityEnforced((ModelElement)reference)) {
                    this.addAttribute("maxOccurs", this.multToString(reference.getMultiplicity().getUpper()));
                }
                if ((contType = this.getContentType((ModelElement)reference)) != null && contType.equals("complex") || this.isUseSchemaExtensions((ModelElement)reference)) {
                    this.addAttribute("type", this.getType((TypedElement)reference).getName());
                } else {
                    this.writeAnyElement();
                }
                this.endElement("xsd:element");
            }
            this.startElement("xsd:element");
            this.addAttribute("ref", "xmi:extension");
            this.endElement("xsd:element");
        } else if (contentType.equals("any")) {
            this.startElement("xsd:any");
            this.addAttribute("minOccurs", "0");
            this.addAttribute("maxOccurs", "unbounded");
            this.addAttribute("processContents", this.getProcessContents((ModelElement)meta));
            this.endElement("xsd:any");
        }
        this.endElement(isChoice ? "xsd:choice" : "xsd:sequence");
        this.writeFixedAttribs((ModelElement)meta);
        references = useExtensions ? this.elementsCache.localReferences(meta) : this.elementsCache.references(meta);
        iter = references.iterator();
        while (iter.hasNext()) {
            reference = (Reference)iter.next();
            if (AggregationKindEnum.COMPOSITE.equals((Object)reference.getReferencedEnd().getAggregation())) continue;
            this.startElement("xsd:attribute");
            this.addAttribute("name", reference.getName());
            MultiplicityType mult = reference.getMultiplicity();
            if (mult.getLower() == 1 && mult.getUpper() == 1 && this.isMinMultiplicityEnforced((ModelElement)reference)) {
                this.addAttribute("type", "xsd:IDREFS");
                this.addAttribute("use", "optional");
            } else {
                this.addAttribute("type", "xsd:IDREF");
                this.addAttribute("use", "required");
            }
            this.endElement("xsd:attribute");
        }
        instAttrs = useExtensions ? this.elementsCache.localInstanceAttributes(meta) : this.elementsCache.instanceAttributes(meta);
        iter = instAttrs.iterator();
        while (iter.hasNext()) {
            String val;
            attr = (Attribute)iter.next();
            Classifier type = this.getType((TypedElement)attr);
            if (type instanceof MofClass) continue;
            MultiplicityType mult = attr.getMultiplicity();
            boolean required = mult.getLower() == 1 && mult.getUpper() == 1 && this.isMinMultiplicityEnforced((ModelElement)attr);
            this.startElement("xsd:attribute");
            this.addAttribute("name", attr.getName());
            if (type instanceof EnumerationType) {
                this.addAttribute("type", this.objectName((ModelElement)type));
                val = this.getDefaultValue((ModelElement)attr);
                if (val != null) {
                    this.addAttribute("use", "default");
                    this.addAttribute("value", val);
                } else {
                    this.addAttribute("use", required ? "required" : "optional");
                }
            } else {
                this.addAttribute("type", "xsd:string");
                this.addAttribute("use", required ? "required" : "optional");
                val = this.getDefaultValue((ModelElement)attr);
                if (val != null) {
                    this.addAttribute("default", val);
                }
                if ((val = this.getFixedValue((ModelElement)attr)) != null) {
                    this.addAttribute("fixed", val);
                }
                if ((val = this.getForm((ModelElement)attr)) != null) {
                    this.addAttribute("form", val);
                }
            }
            this.endElement("xsd:attribute");
        }
        if (useExtensions) {
            this.endElement("xsd:extension");
            this.endElement("xsd:complexContent");
        }
        this.endElement("xsd:complexType");
        this.startElement("xsd:attributeGroup");
        this.addAttribute("ref", "xmi:ObjectAttribs");
        this.endElement("xsd:attributeGroup");
        this.startElement("xsd:element");
        this.addAttribute("name", meta.getName());
        this.addAttribute("type", this.objectName((ModelElement)meta));
        this.endElement("xsd:element");
    }

    public void writeAnyElement() {
        this.startElement("xsd:complexType");
        this.startElement("xsd:choice");
        this.addAttribute("minOccurs", "0");
        this.addAttribute("maxOccurs", "unbounded");
        this.startElement("xsd:any");
        this.addAttribute("processContents", "skip");
        this.endElement("xsd:any");
        this.endElement("xsd:choice");
        this.endElement("xsd:complexType");
    }

    public void writeFixedAttribs(ModelElement elem) {
        this.startElement("xsd:attribute");
        String idName = this.getIdName(elem);
        if (idName == null) {
            this.addAttribute("ref", "xmi:id");
        } else {
            this.addAttribute("name", idName);
            this.addAttribute("type", "xsd:ID");
        }
        this.addAttribute("use", "optional");
        this.endElement("xsd:attribute");
    }

    public void writeAssociationSchema(Association assoc) {
        this.startElement("xsd:element");
        this.addAttribute("name", assoc.getName());
        this.startElement("xsd:complexType");
        this.startElement("xsd:choice");
        this.addAttribute("minOccurs", "0");
        this.addAttribute("maxOccurs", "unbounded");
        Iterator iter = assoc.getContents().iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (!(elem instanceof AssociationEnd)) continue;
            this.writeAssociationEndDef((AssociationEnd)elem);
        }
        this.startElement("xsd:extension");
        this.addAttribute("ref", "xmi:extension");
        this.endElement("xsd:extension");
        this.endElement("xsd:choice");
        this.writeFixedAttribs((ModelElement)assoc);
        this.endElement("xsd:complexType");
        this.endElement("xsd:element");
    }

    public void writeAssociationEndDef(AssociationEnd end) {
        this.startElement("xsd:element");
        this.addAttribute("name", end.getName());
        this.startElement("xsd:complexType");
        this.writeFixedAttribs((ModelElement)end);
        this.endElement("xsd:complexType");
        this.endElement("xsd:element");
    }

    public void writeEnumerationSchema(EnumerationType enumerationType) {
        this.startElement("xsd:simpleType");
        this.addAttribute("name", enumerationType.getName());
        this.startElement("xsd:restriction");
        this.addAttribute("base", "xsd:string");
        Iterator iter = enumerationType.getLabels().iterator();
        while (iter.hasNext()) {
            String label = (String)iter.next();
            this.startElement("xsd:enumeration");
            this.addAttribute("value", label);
            this.endElement("xsd:enumeration");
        }
        this.endElement("xsd:restriction");
        this.endElement("xsd:simpleType");
    }

    public void writeFixedContent() throws SAXException {
        URL fixedSchema = this.getClass().getResource(FIXED_SCHEMA_FILE);
        if (fixedSchema == null) {
            throw new DebugException("Resource not found: " + FIXED_SCHEMA_FILE);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(fixedSchema.openStream(), (DefaultHandler)new FixedContentHandler());
        }
        catch (IOException e) {
            Logger.getDefault().log("Unable to open " + FIXED_SCHEMA_FILE + ": " + e.getMessage());
            throw new DebugException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void writeNamespaces() {
    }

    public void writePackageElementDef(RefPackage pkg) {
        MofPackage meta = (MofPackage)pkg.refMetaObject();
        String packageName = this.packageName(meta);
        this.findEnumerations((Namespace)meta);
        this.startElement("xsd:element");
        this.addAttribute("name", meta.getName());
        this.startElement("xsd:complexType");
        this.startElement("xsd:choice");
        this.addAttribute("minOccurs", "0");
        this.addAttribute("maxOccurs", "unbounded");
        Iterator iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            RefObject metaObject = ((RefClass)iter.next()).refMetaObject();
            MofClass mofClass = (MofClass)(metaObject instanceof AliasType ? this.getType((TypedElement)((AliasType)metaObject)) : metaObject);
            this.startElement("xsd:element");
            this.addAttribute("name", this.objectName((ModelElement)mofClass));
            this.addAttribute("type", mofClass.getName());
            this.endElement("xsd:element");
        }
        iter = this.getFreeAssociations(pkg).iterator();
        while (iter.hasNext()) {
            this.writeAssociationSchema((Association)iter.next());
        }
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.startElement("xsd:element");
            this.addAttribute("ref", this.packageName((MofPackage)((RefPackage)iter.next()).refMetaObject()));
            this.endElement("xsd:element");
        }
        this.startElement("xsd:extension");
        this.addAttribute("ref", "xmi:extension");
        this.endElement("xsd:extension");
        this.endElement("xsd:choice");
        this.endElement("xsd:complexType");
        this.endElement("xsd:element");
    }

    protected void findNamespaces(RefPackage pkg) {
        Iterator iter;
        if (this.trackedPackages.contains(pkg)) {
            return;
        }
        MofPackage metaPackage = (MofPackage)pkg.refMetaObject();
        String name = this.getNsPrefixTag((ModelElement)metaPackage);
        if (name == null) {
            name = this.tagProvider.getTagValue((ModelElement)metaPackage, "org.omg.xmi.namespace");
        }
        if (name != null) {
            iter = metaPackage.getQualifiedName().iterator();
            String fqName = (String)iter.next();
            while (iter.hasNext()) {
                fqName = fqName.concat(".").concat((String)iter.next());
            }
            this.namespaces.put(fqName, name);
            String uri = this.getNsURITag((ModelElement)metaPackage);
            if (uri == null) {
                throw new DebugException("A tag defining namespace uri not found, package " + metaPackage.getName());
            }
            this.nsPrefixToURI.put(name, uri);
        }
        this.trackedPackages.add(pkg);
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findNamespaces((RefPackage)iter.next());
        }
    }

    public String elementName(ModelElement element) {
        Namespace container = element.getContainer();
        return this.objectName((ModelElement)container) + '.' + this.getXmiName(element);
    }

    public String objectName(ModelElement element) {
        String namespace = (String)this.namespaces.get(element.getContainer());
        if (namespace != null) {
            return namespace + ":" + this.getXmiName(element);
        }
        return this.qualifiedName(element);
    }

    public String packageName(MofPackage pkg) {
        String namespace = (String)this.namespaces.get(pkg);
        if (namespace != null) {
            return namespace + ":" + this.getXmiName((ModelElement)pkg);
        }
        return this.qualifiedName((ModelElement)pkg);
    }

    public String qualifiedName(ModelElement element) {
        Iterator iter = element.getQualifiedName().iterator();
        String name = (String)iter.next();
        while (iter.hasNext()) {
            name = name.concat(".").concat((String)iter.next());
        }
        return name;
    }

    public Classifier getType(TypedElement elem) {
        Classifier type = elem.getType();
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        return type;
    }

    public Set getFreeAssociations(RefPackage pkg) {
        ModelPackage model = (ModelPackage)pkg.refMetaObject().refImmediatePackage();
        RefersTo refersTo = model.getRefersTo();
        Set set = AbstractCollectionFactory.getCollectionFactory().createHashSet();
        Iterator iter = pkg.refAllAssociations().iterator();
        while (iter.hasNext()) {
            Association assoc = (Association)((RefAssociation)iter.next()).refMetaObject();
            boolean found = false;
            Iterator it = assoc.getContents().iterator();
            while (it.hasNext()) {
                Collection col;
                Object elem = it.next();
                if (!(elem instanceof AssociationEnd) || (col = refersTo.getReferent((AssociationEnd)elem)) == null || col.size() <= 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            set.add(assoc);
        }
        return set;
    }

    public String multToString(int multiplicity) {
        return multiplicity == -1 ? "unbounded" : "" + multiplicity;
    }

    public void findEnumerations(Namespace elem) {
        Iterator iter = elem.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EnumerationType)) continue;
            this.enumerations.add(obj);
        }
    }

    public String getContentScopedTagValue(ModelElement elem, String tagId) {
        String value = null;
        while (value == null && elem != null) {
            value = this.tagProvider.getTagValue(elem, tagId);
            elem = elem.getContainer();
        }
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public boolean isMaxMultiplicityEnforced(ModelElement elem) {
        String s = this.getContentScopedTagValue(elem, "org.omg.xmi.enforceMaximumMultiplicity");
        return s != null && s.equals("true");
    }

    public boolean isMinMultiplicityEnforced(ModelElement elem) {
        String s = this.getContentScopedTagValue(elem, "org.omg.xmi.enforceMinimumMultiplicity");
        return s != null && s.equals("true");
    }

    public boolean isUseSchemaExtensions(ModelElement elem) {
        String s = this.getContentScopedTagValue(elem, "org.omg.xmi.useSchemaExtensions");
        return s != null && s.equals("true");
    }

    public boolean isNillable(ModelElement elem) {
        String s = this.getContentScopedTagValue(elem, "org.omg.xmi.includeNils");
        return s == null || s.equals("true");
    }

    public String getProcessContents(ModelElement elem) {
        String s = this.getContentScopedTagValue(elem, "org.omg.xmi.processContents");
        if (s == null) {
            return "strict";
        }
        return s;
    }

    public String getIdName(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.idName");
    }

    public String getForm(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.form");
    }

    public String getFixedValue(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.fixedValue");
    }

    public String getNsPrefixTag(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.nsPrefix");
    }

    public String getNsURITag(ModelElement elem) {
        return this.getContentScopedTagValue(elem, "org.omg.xmi.nsURI");
    }

    public String getDefaultValue(ModelElement elem) {
        return this.tagProvider.getTagValue(elem, "org.omg.xmi.defaultValue");
    }

    public String getXmiName(ModelElement elem) {
        String name = this.tagProvider.getTagValue(elem, "org.omg.xmi.xmiName");
        if (name == null) {
            return elem.getName();
        }
        return name;
    }

    public String getContentType(ModelElement elem) {
        return this.tagProvider.getTagValue(elem, "org.omg.xmi.contentType");
    }

    public String getSchemaType(ModelElement elem) {
        return this.tagProvider.getTagValue(elem, "org.omg.xmi.schemaType");
    }

    private class FixedContentHandler
    extends DefaultHandler {
        private int depth = 0;

        private FixedContentHandler() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if (this.depth > 0) {
                SchemaProducer.this.writer.startElement(namespaceURI, sName, qName, attrs);
            }
            ++this.depth;
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            --this.depth;
            if (this.depth > 0) {
                SchemaProducer.this.writer.endElement(namespaceURI, sName, qName);
            }
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            for (int x = offset; x < offset + len; ++x) {
                if (Character.isWhitespace(buf[x])) continue;
                SchemaProducer.this.writer.characters(buf, offset, len);
                break;
            }
        }
    }
}

