/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Attribute;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.Namespace;
import javax.jmi.model.Reference;
import javax.jmi.model.StructuralFeature;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.XmiConstants;
import org.netbeans.lib.jmi.xmi.XmiUtils;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public abstract class XmiMofUtils
extends XmiUtils
implements XmiConstants {
    public static StructuralFeature getMetaFeature(String attributeName, RefClass proxyClass) {
        StructuralFeature result = null;
        ModelElement metaObject = null;
        MofClass metaProxyClass = (MofClass)proxyClass.refMetaObject();
        try {
            metaObject = metaProxyClass.lookupElementExtended(XmiMofUtils.getShortName(attributeName));
            if (metaObject instanceof StructuralFeature) {
                result = (StructuralFeature)metaObject;
            }
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    public static void showAllAttributes(Collection attributes) {
        Logger.getDefault().log("Attributes - length : " + attributes.size());
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            Object att = it.next();
            if (att instanceof ModelElement) {
                Logger.getDefault().log("Attributes : " + ((ModelElement)att).getName());
                continue;
            }
            if (att != null) {
                Logger.getDefault().log("Attributes : " + att + " - of class : " + att.getClass());
                continue;
            }
            Logger.getDefault().log("Attributes : NULLLLLLLLL ");
        }
    }

    public static String showCollectionAsString(Collection attributes, String separator) {
        String message = null;
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            Object att = it.next();
            message = message + separator + message;
        }
        message = message.substring(message.indexOf(separator) + separator.length());
        return message;
    }

    public static Collection getAllSupertypesContainedObjects(RefClass proxyClass) {
        List result = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        List allContainedObjects = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        MofClass metaProxyClass = (MofClass)proxyClass.refMetaObject();
        List superClasses = metaProxyClass.allSupertypes();
        Namespace namespace = null;
        Iterator it = superClasses.iterator();
        while (it.hasNext()) {
            namespace = (Namespace)it.next();
            allContainedObjects.addAll(namespace.getContents());
        }
        allContainedObjects.addAll(metaProxyClass.getContents());
        it = allContainedObjects.iterator();
        while (it.hasNext()) {
            RefObject refObject = (RefObject)it.next();
            if (!(refObject instanceof Attribute) || ((Attribute)refObject).isDerived()) continue;
            result.add(refObject);
        }
        allContainedObjects.clear();
        allContainedObjects = null;
        return result;
    }

    public static Reference getReferenceMetaFeature(String referenceNodeName, RefClass proxyClass) {
        Reference result = null;
        StructuralFeature metaFeature = XmiMofUtils.getMetaFeature(referenceNodeName, proxyClass);
        if (metaFeature instanceof Reference) {
            result = (Reference)metaFeature;
        }
        return result;
    }

    public static Attribute getAttributeMetaFeature(String referenceNodeName, RefClass proxyClass) {
        Attribute result = null;
        StructuralFeature metaFeature = XmiMofUtils.getMetaFeature(referenceNodeName, proxyClass);
        if (metaFeature instanceof Attribute) {
            result = (Attribute)metaFeature;
        }
        return result;
    }
}

