/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.util.parameterdatabase.types.DoubleRange;

public class DoubleRangeEditor
extends DefaultCellEditor
implements ActionListener {
    private JTextField minField;
    private JTextField maxField;

    public DoubleRangeEditor() {
        super(new JCheckBox());
        this.editorComponent = this.makeForm();
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object value) {
                DoubleRange range = null;
                if (value instanceof DoubleRange) {
                    range = (DoubleRange)value;
                }
                DoubleRangeEditor.this.setState(range);
            }

            public Object getCellEditorValue() {
                return DoubleRangeEditor.this.getState();
            }
        };
        this.minField.addActionListener(this);
        this.maxField.addActionListener(this);
    }

    public void setState(DoubleRange range) {
        if (range != null) {
            this.minField.setText(Double.toString(range.getMinimum()));
            this.maxField.setText(Double.toString(range.getMaximum()));
        } else {
            this.minField.setText(Double.toString(-1.7976931348623157E308));
            this.maxField.setText(Double.toString(Double.MAX_VALUE));
        }
    }

    public DoubleRange getState() {
        DoubleRange retVal = null;
        String minString = this.minField.getText().trim();
        String maxString = this.maxField.getText().trim();
        try {
            double min = !minString.equals("") ? Double.parseDouble(minString) : -1.7976931348623157E308;
            double max = !maxString.equals("") ? Double.parseDouble(maxString) : Double.MAX_VALUE;
            retVal = new DoubleRange(min, max);
        }
        catch (NumberFormatException except) {
            // empty catch block
        }
        return retVal;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.editorComponent != null && this.editorComponent instanceof DialogWrapper) {
            DialogWrapper wrapper = (DialogWrapper)this.editorComponent;
            wrapper.hideDialog();
        }
        this.delegate.actionPerformed(event);
    }

    private JComponent makeForm() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel main = new JPanel();
        main.setLayout(new GridBagLayout());
        JLabel label = new JLabel("min.:");
        this.minField = new JTextField();
        this.minField.setPreferredSize(new Dimension(50, 15));
        label.setLabelFor(this.minField);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.5;
        main.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.5;
        main.add((Component)this.minField, constraints);
        label = new JLabel("max.:");
        this.maxField = new JTextField();
        this.maxField.setPreferredSize(new Dimension(50, 15));
        label.setLabelFor(this.maxField);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.5;
        main.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.5;
        main.add((Component)this.maxField, constraints);
        return new DialogWrapper(main, this);
    }

    private class DialogWrapper
    extends JComponent
    implements WindowListener {
        private JDialog dialog;
        private ActionListener parent;

        public DialogWrapper(JComponent component, ActionListener parent) {
            this.parent = parent;
            this.dialog = new JDialog();
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(this);
            this.dialog.setContentPane(component);
        }

        public void validate() {
            super.validate();
            this.dialog.pack();
            this.dialog.setVisible(true);
            this.dialog.validate();
        }

        public void hideDialog() {
            this.dialog.hide();
        }

        public void windowClosing(WindowEvent e) {
            this.parent.actionPerformed(new ActionEvent(this, 0, "WindowClosed"));
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

