/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.StringMap;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

public class DrawLayerFactory {
    public static final String SYNTAX_LAYER_NAME = "syntax-layer";
    public static final int SYNTAX_LAYER_VISIBILITY = 1000;
    public static final String BOOKMARK_LAYER_NAME = "bookmark-layer";
    public static final int BOOKMARK_LAYER_VISIBILITY = 2000;
    public static final String ANNOTATION_LAYER_NAME = "annotation-layer";
    public static final int ANNOTATION_LAYER_VISIBILITY = 2100;
    public static final String HIGHLIGHT_SEARCH_LAYER_NAME = "highlight-search-layer";
    public static final int HIGHLIGHT_SEARCH_LAYER_VISIBILITY = 9000;
    public static final String INC_SEARCH_LAYER_NAME = "inc-search-layer";
    public static final int INC_SEARCH_LAYER_VISIBILITY = 9500;
    public static final String CARET_LAYER_NAME = "caret-layer";
    public static final int CARET_LAYER_VISIBILITY = 10000;
    public static final String GUARDED_LAYER_NAME = "guarded-layer";
    public static final int GUARDED_LAYER_VISIBILITY = 1400;

    public static class AnnotationLayer
    extends DrawLayer.AbstractLayer {
        private Coloring coloring = null;
        private MarkChain markChain;

        public AnnotationLayer(BaseDocument baseDocument) {
            super(DrawLayerFactory.ANNOTATION_LAYER_NAME);
            this.markChain = new MarkChain(baseDocument, DrawLayerFactory.ANNOTATION_LAYER_NAME);
        }

        public final MarkChain getMarkChain() {
            return this.markChain;
        }

        public boolean extendsEOL() {
            return true;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n;
            this.coloring = null;
            if (drawMark == null) {
                return false;
            }
            if (drawContext.getEditorUI().getComponent() == null || !drawMark.activateLayer) {
                return false;
            }
            BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
            AnnotationDesc annotationDesc = baseDocument.getAnnotations().getActiveAnnotation(drawMark);
            if (annotationDesc == null) {
                return false;
            }
            int n2 = -1;
            try {
                n2 = Utilities.getRowStart(baseDocument, drawContext.getFragmentOffset(), 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (annotationDesc.isWholeLine()) {
                n = n2;
            } else {
                n = drawContext.getFragmentOffset() + annotationDesc.getLength();
                if (n > n2) {
                    n = n2;
                }
            }
            this.setNextActivityChangeOffset(n);
            this.coloring = annotationDesc.getColoring();
            return true;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }
    }

    public static class WordColoringLayer
    extends DrawLayer.AbstractLayer {
        protected StringMap stringMap = new StringMap();

        public WordColoringLayer(String string) {
            super(string);
        }

        public void put(String string, Coloring coloring) {
            this.stringMap.put(string, coloring);
        }

        public void put(String[] stringArray, Coloring coloring) {
            int n = 0;
            while (n < stringArray.length) {
                this.put(stringArray[n], coloring);
                ++n;
            }
        }

        public void put(List list, Coloring coloring) {
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            this.put(stringArray, coloring);
        }

        public void init(DrawContext drawContext) {
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            return true;
        }

        public void updateContext(DrawContext drawContext) {
            Coloring coloring = (Coloring)this.stringMap.get(drawContext.getBuffer(), drawContext.getTokenOffset(), drawContext.getTokenLength());
            if (coloring != null) {
                coloring.apply(drawContext);
            }
        }
    }

    public static class StyleLayer
    extends DrawLayer.AbstractLayer {
        protected Style style;
        protected MarkChain markChain;
        protected Color backColor;
        protected Color foreColor;

        public StyleLayer(String string, BaseDocument baseDocument, Style style) {
            super(string);
            this.style = style;
            this.markChain = new MarkChain(baseDocument, string);
        }

        public boolean extendsEOL() {
            return true;
        }

        public final MarkChain getMarkChain() {
            return this.markChain;
        }

        public void init(DrawContext drawContext) {
            this.foreColor = StyleConstants.getForeground(this.style);
            this.backColor = StyleConstants.getBackground(this.style);
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = false;
            if (drawMark != null) {
                boolean bl2 = bl = drawContext.getEditorUI().getComponent() != null && drawMark.activateLayer;
                if (bl) {
                    try {
                        BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                        int n = Utilities.getRowStart(baseDocument, drawContext.getFragmentOffset(), 1);
                        if (n < 0) {
                            n = Integer.MAX_VALUE;
                        }
                        this.setNextActivityChangeOffset(n);
                    }
                    catch (BadLocationException badLocationException) {
                        bl = false;
                    }
                }
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.foreColor != null) {
                drawContext.setForeColor(this.foreColor);
            }
            if (this.backColor != null) {
                drawContext.setBackColor(this.backColor);
            }
        }

        public String toString() {
            return super.toString() + (this.markChain != null ? ", " + this.markChain : "");
        }
    }

    static class GuardedLayer
    extends ColorLineLayer {
        GuardedDocument doc;

        GuardedLayer() {
            super(DrawLayerFactory.GUARDED_LAYER_NAME);
        }

        public void init(DrawContext drawContext) {
            super.init(drawContext);
            this.doc = (GuardedDocument)drawContext.getEditorUI().getDocument();
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = drawMark != null ? drawMark.activateLayer : this.doc.isPosGuarded(drawContext.getFragmentOffset());
            return bl;
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return drawContext.getEditorUI().getColoring("guarded");
        }
    }

    public static class BookmarkLayer
    extends ColorLineLayer {
        public BookmarkLayer() {
            super(DrawLayerFactory.BOOKMARK_LAYER_NAME);
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return drawContext.getEditorUI().getColoring("bookmark");
        }
    }

    public static class IncSearchLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;
        int pos;
        int len;
        boolean enabled;

        public IncSearchLayer() {
            super(DrawLayerFactory.INC_SEARCH_LAYER_NAME);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        void setArea(int n, int n2) {
            this.pos = n;
            this.len = n2;
        }

        int getOffset() {
            return this.pos;
        }

        int getLength() {
            return this.len;
        }

        public void init(DrawContext drawContext) {
            this.setNextActivityChangeOffset(this.enabled ? this.pos : Integer.MAX_VALUE);
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = false;
            if (this.enabled && drawContext.getFragmentOffset() == this.pos) {
                bl = true;
                this.setNextActivityChangeOffset(this.pos + this.len);
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring == null) {
                this.coloring = drawContext.getEditorUI().getColoring("inc-search");
            }
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }
    }

    public static class HighlightSearchLayer
    extends DrawLayer.AbstractLayer {
        int[] blocks = new int[]{-1, -1};
        Coloring coloring;
        int curInd;
        boolean enabled;

        public HighlightSearchLayer() {
            super(DrawLayerFactory.HIGHLIGHT_SEARCH_LAYER_NAME);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void init(DrawContext drawContext) {
            if (this.enabled) {
                try {
                    BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                    this.blocks = FindSupport.getFindSupport().getBlocks(this.blocks, baseDocument, drawContext.getStartOffset(), drawContext.getEndOffset());
                }
                catch (BadLocationException badLocationException) {
                    this.blocks = new int[]{-1, -1};
                }
                this.coloring = null;
                this.curInd = 0;
            }
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl;
            if (this.enabled) {
                int n = drawContext.getFragmentOffset();
                if (n == this.blocks[this.curInd]) {
                    bl = true;
                    this.setNextActivityChangeOffset(this.blocks[this.curInd + 1]);
                } else if (n == this.blocks[this.curInd + 1]) {
                    bl = false;
                    this.curInd += 2;
                    this.setNextActivityChangeOffset(this.blocks[this.curInd]);
                    if (n == this.blocks[this.curInd]) {
                        this.setNextActivityChangeOffset(this.blocks[this.curInd + 1]);
                        bl = true;
                    }
                } else {
                    this.setNextActivityChangeOffset(this.blocks[this.curInd]);
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            int n = drawContext.getFragmentOffset();
            if (n >= this.blocks[this.curInd] && n < this.blocks[this.curInd + 1]) {
                if (this.coloring == null) {
                    this.coloring = drawContext.getEditorUI().getColoring("highlight-search");
                }
                if (this.coloring != null) {
                    this.coloring.apply(drawContext);
                }
            }
        }
    }

    public static class CaretLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;

        public CaretLayer() {
            super(DrawLayerFactory.CARET_LAYER_NAME);
        }

        public boolean extendsEmptyLine() {
            return true;
        }

        public void init(DrawContext drawContext) {
            this.coloring = null;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            JTextComponent jTextComponent;
            boolean bl = drawMark != null ? drawMark.activateLayer : (jTextComponent = drawContext.getEditorUI().getComponent()) != null && jTextComponent.getCaret().isSelectionVisible() && drawContext.getFragmentOffset() >= jTextComponent.getSelectionStart() && drawContext.getFragmentOffset() < jTextComponent.getSelectionEnd();
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring == null) {
                this.coloring = drawContext.getEditorUI().getColoring("selection");
            }
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }
    }

    public static abstract class ColorLineLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;

        public ColorLineLayer(String string) {
            super(string);
        }

        public boolean extendsEOL() {
            return true;
        }

        public void init(DrawContext drawContext) {
            this.coloring = null;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl;
            if (drawMark != null) {
                boolean bl2 = bl = drawContext.getEditorUI().getComponent() != null && drawMark.activateLayer;
                if (bl) {
                    try {
                        BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                        int n = Utilities.getRowStart(baseDocument, drawContext.getFragmentOffset(), 1);
                        if (n < 0) {
                            n = Integer.MAX_VALUE;
                        }
                        this.setNextActivityChangeOffset(n);
                    }
                    catch (BadLocationException badLocationException) {
                        bl = false;
                    }
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring == null) {
                this.coloring = this.getColoring(drawContext);
            }
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }

        protected abstract Coloring getColoring(DrawContext var1);
    }

    public static class SyntaxLayer
    extends DrawLayer.AbstractLayer {
        public SyntaxLayer() {
            super(DrawLayerFactory.SYNTAX_LAYER_NAME);
        }

        public void init(DrawContext drawContext) {
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            return true;
        }

        public void updateContext(DrawContext drawContext) {
            TokenID tokenID = drawContext.getTokenID();
            TokenContextPath tokenContextPath = drawContext.getTokenContextPath();
            if (tokenID != null && tokenContextPath != null) {
                String string = tokenContextPath.getFullTokenName(tokenID);
                Coloring coloring = drawContext.getEditorUI().getColoring(string);
                if (coloring != null) {
                    coloring.apply(drawContext);
                } else {
                    TokenCategory tokenCategory = tokenID.getCategory();
                    if (tokenCategory != null) {
                        string = tokenContextPath.getFullTokenName(tokenCategory);
                        coloring = drawContext.getEditorUI().getColoring(string);
                        if (coloring != null) {
                            coloring.apply(drawContext);
                        }
                    }
                }
            }
        }
    }
}

