/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;

public class MarkChain {
    protected MarkFactory.ChainDrawMark chain;
    protected MarkFactory.ChainDrawMark curMark;
    protected BaseDocument doc;
    protected String layerName;
    private MarkFactory.ChainDrawMark recentlyAddedMark;

    public MarkChain(BaseDocument baseDocument, String string) {
        this.doc = baseDocument;
        this.layerName = string;
    }

    public final MarkFactory.ChainDrawMark getChain() {
        return this.chain;
    }

    public final MarkFactory.ChainDrawMark getCurMark() {
        return this.curMark;
    }

    public int compareMark(int n) {
        try {
            int n2;
            if (this.curMark == null) {
                this.curMark = this.chain;
                if (this.curMark == null) {
                    return -1;
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            while ((n2 = this.curMark.compare(n)) != 0) {
                if (n2 > 0) {
                    if (bl2) {
                        return n2;
                    }
                    if (this.curMark.prev != null) {
                        bl = true;
                        this.curMark = this.curMark.prev;
                        continue;
                    }
                    return n2;
                }
                if (bl) {
                    return n2;
                }
                if (this.curMark.next != null) {
                    bl2 = true;
                    this.curMark = this.curMark.next;
                    continue;
                }
                return n2;
            }
            return 0;
        }
        catch (InvalidMarkException invalidMarkException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                invalidMarkException.printStackTrace();
            }
            return -1;
        }
    }

    protected MarkFactory.ChainDrawMark createAndInsertNewMark(int n) throws BadLocationException {
        MarkFactory.ChainDrawMark chainDrawMark;
        block2: {
            chainDrawMark = this.createMark();
            try {
                this.doc.op.insertMark(chainDrawMark, n);
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                invalidMarkException.printStackTrace();
            }
        }
        return chainDrawMark;
    }

    protected MarkFactory.ChainDrawMark createMark() {
        MarkFactory.ChainDrawMark chainDrawMark = new MarkFactory.ChainDrawMark(this.layerName, null);
        chainDrawMark.backwardBias = true;
        chainDrawMark.activateLayer = true;
        return chainDrawMark;
    }

    public boolean addMark(int n) throws BadLocationException {
        int n2 = this.compareMark(n);
        if (n2 == 0) {
            this.recentlyAddedMark = this.curMark;
            return false;
        }
        if (n2 > 0) {
            MarkFactory.ChainDrawMark chainDrawMark;
            this.recentlyAddedMark = chainDrawMark = this.createAndInsertNewMark(n);
            if (this.curMark != null) {
                if (this.curMark == this.chain) {
                    this.chain = this.curMark.insertChain(chainDrawMark);
                } else {
                    this.curMark.insertChain(chainDrawMark);
                }
            } else {
                this.chain = chainDrawMark;
            }
        } else {
            MarkFactory.ChainDrawMark chainDrawMark;
            this.recentlyAddedMark = chainDrawMark = this.createAndInsertNewMark(n);
            if (this.curMark != null) {
                if (this.curMark.next != null) {
                    this.curMark.next.insertChain(chainDrawMark);
                } else {
                    this.curMark.setNextChain(chainDrawMark);
                }
            } else {
                this.chain = chainDrawMark;
            }
        }
        return true;
    }

    public MarkFactory.ChainDrawMark getAddedMark() {
        return this.recentlyAddedMark;
    }

    public boolean removeMark(int n) {
        int n2 = this.compareMark(n);
        if (n2 == 0) {
            boolean bl = this.curMark == this.chain;
            this.curMark = this.curMark.removeChain();
            if (bl) {
                this.chain = this.curMark;
            }
            return true;
        }
        return false;
    }

    public boolean isMark(int n) {
        return this.compareMark(n) == 0;
    }

    public boolean toggleMark(int n) throws BadLocationException {
        int n2 = this.compareMark(n);
        if (n2 == 0) {
            this.removeMark(n);
            return false;
        }
        this.addMark(n);
        return true;
    }

    public String toString() {
        return "MarkChain: curMark=" + this.curMark + ", mark chain: " + (this.chain != null ? "\n" + this.chain.toStringChain() : "Empty");
    }
}

