/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JCUtilities {
    private static final int javaTokenIDsLength = JavaTokenContext.context.getTokenIDs().length;
    private static final boolean[][] primitivesAssignable = new boolean[javaTokenIDsLength][];
    private static final JCClass[][] primitivesCommonClass = new JCClass[javaTokenIDsLength][];

    private static boolean stringEqual(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    private static boolean classEqual(JCClass jCClass, JCClass jCClass2) {
        return jCClass == null ? jCClass2 == null : jCClass.equals(jCClass2);
    }

    private static boolean typeEqual(JCType jCType, JCType jCType2) {
        return jCType == null ? jCType2 == null : JCUtilities.classEqual(jCType.getClazz(), jCType2.getClazz()) && jCType.getArrayDepth() == jCType2.getArrayDepth();
    }

    private static boolean parameterEqual(JCParameter jCParameter, JCParameter jCParameter2) {
        return jCParameter == null ? jCParameter2 == null : JCUtilities.typeEqual(jCParameter.getType(), jCParameter2.getType()) && JCUtilities.stringEqual(jCParameter.getName(), jCParameter2.getName());
    }

    private static boolean constructorEqual(JCConstructor jCConstructor, JCConstructor jCConstructor2) {
        return jCConstructor == null ? jCConstructor2 == null : jCConstructor.getClazz().equals(jCConstructor2.getClazz()) && jCConstructor.getModifiers() == jCConstructor2.getModifiers() && JCUtilities.parameterArrayEqual(jCConstructor.getParameters(), jCConstructor2.getParameters()) && JCUtilities.classArrayEqual(jCConstructor.getExceptions(), jCConstructor2.getExceptions());
    }

    private static boolean parameterArrayEqual(JCParameter[] jCParameterArray, JCParameter[] jCParameterArray2) {
        if (jCParameterArray.length != jCParameterArray2.length) {
            return false;
        }
        int n = jCParameterArray.length - 1;
        while (n >= 0) {
            if (!JCUtilities.parameterEqual(jCParameterArray[n], jCParameterArray2[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static boolean classArrayEqual(JCClass[] jCClassArray, JCClass[] jCClassArray2) {
        if (jCClassArray.length != jCClassArray2.length) {
            return false;
        }
        int n = jCClassArray.length - 1;
        while (n >= 0) {
            if (!JCUtilities.classEqual(jCClassArray[n], jCClassArray2[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static boolean fieldArraysEqual(JCField[] jCFieldArray, JCField[] jCFieldArray2) {
        if (jCFieldArray.length != jCFieldArray2.length) {
            return false;
        }
        int n = jCFieldArray.length - 1;
        while (n >= 0) {
            JCField jCField = jCFieldArray[n];
            JCField jCField2 = jCFieldArray2[n];
            if (!JCUtilities.parameterEqual(jCField, jCField2) || !jCField.getClazz().equals(jCField2.getClazz()) || jCField.getModifiers() != jCField2.getModifiers()) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static boolean constructorArrayEqual(JCConstructor[] jCConstructorArray, JCConstructor[] jCConstructorArray2) {
        if (jCConstructorArray.length != jCConstructorArray2.length) {
            return false;
        }
        int n = jCConstructorArray.length - 1;
        while (n >= 0) {
            if (!JCUtilities.constructorEqual(jCConstructorArray[n], jCConstructorArray2[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static boolean methodArraysEqual(JCMethod[] jCMethodArray, JCMethod[] jCMethodArray2) {
        if (jCMethodArray.length != jCMethodArray2.length) {
            return false;
        }
        int n = jCMethodArray.length - 1;
        while (n >= 0) {
            JCMethod jCMethod = jCMethodArray[n];
            JCMethod jCMethod2 = jCMethodArray2[n];
            if (!(JCUtilities.constructorEqual(jCMethod, jCMethod2) && JCUtilities.stringEqual(jCMethod.getName(), jCMethod2.getName()) && JCUtilities.typeEqual(jCMethod.getReturnType(), jCMethod2.getReturnType()))) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static boolean equal(JCClass jCClass, JCClass jCClass2) {
        if (jCClass == null && jCClass2 == null) {
            return true;
        }
        if (jCClass == null || jCClass2 == null) {
            return false;
        }
        if (!jCClass.equals(jCClass2) || jCClass.isInterface() != jCClass2.isInterface() || jCClass.getModifiers() != jCClass2.getModifiers() || !JCUtilities.classEqual(jCClass.getSuperclass(), jCClass2.getSuperclass())) {
            return false;
        }
        return JCUtilities.fieldArraysEqual(jCClass.getFields(), jCClass2.getFields()) && JCUtilities.constructorArrayEqual(jCClass.getConstructors(), jCClass2.getConstructors()) && JCUtilities.methodArraysEqual(jCClass.getMethods(), jCClass2.getMethods()) && JCUtilities.classArrayEqual(jCClass.getInterfaces(), jCClass2.getInterfaces());
    }

    public static String dumpClass(JCClass jCClass) {
        JCMethod[] jCMethodArray;
        JCConstructor[] jCConstructorArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(jCClass.getModifiers()));
        stringBuffer.append(jCClass.isInterface() ? " interface " : " class ");
        stringBuffer.append(jCClass);
        stringBuffer.append(" extends ");
        stringBuffer.append(jCClass.getSuperclass());
        JCClass[] jCClassArray = jCClass.getInterfaces();
        int n = jCClassArray.length - 1;
        if (n >= 0) {
            stringBuffer.append(" implements ");
            int n2 = 0;
            while (n2 <= n) {
                stringBuffer.append(jCClassArray[n2].toString());
                if (n2 < n) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
        }
        stringBuffer.append('\n');
        String string = "    ";
        JCField[] jCFieldArray = jCClass.getFields();
        if (jCFieldArray.length > 0) {
            stringBuffer.append("FIELDS:\n");
            int n3 = 0;
            while (n3 < jCFieldArray.length) {
                stringBuffer.append(string);
                stringBuffer.append(jCFieldArray[n3]);
                stringBuffer.append('\n');
                ++n3;
            }
        }
        if ((jCConstructorArray = jCClass.getConstructors()).length > 0) {
            stringBuffer.append("CONSTRUCTORS:\n");
            int n4 = 0;
            while (n4 < jCConstructorArray.length) {
                stringBuffer.append(string);
                stringBuffer.append(jCConstructorArray[n4]);
                stringBuffer.append('\n');
                ++n4;
            }
        }
        if ((jCMethodArray = jCClass.getMethods()).length > 0) {
            stringBuffer.append("METHODS:\n");
            int n5 = 0;
            while (n5 < jCMethodArray.length) {
                stringBuffer.append(string);
                stringBuffer.append(jCMethodArray[n5]);
                stringBuffer.append('\n');
                ++n5;
            }
        }
        return stringBuffer.toString();
    }

    public static JCClass getExactClass(JCFinder jCFinder, String string, String string2) {
        return jCFinder.getExactClass(string2.length() != 0 ? string2 + "." + string : string);
    }

    public static List filterMethods(List list, List list2, boolean bl) {
        if (list2 == null) {
            return list;
        }
        ArrayList<JCConstructor> arrayList = new ArrayList<JCConstructor>();
        int n = list2.size();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            JCConstructor jCConstructor = (JCConstructor)list.get(n3);
            JCParameter[] jCParameterArray = jCConstructor.getParameters();
            if (jCParameterArray.length == n || bl && jCParameterArray.length >= n) {
                boolean bl2 = true;
                boolean bl3 = !bl;
                int n4 = 0;
                while (bl2 && n4 < n) {
                    JCType jCType = jCParameterArray[n4].getType();
                    JCType jCType2 = (JCType)list2.get(n4);
                    if (jCType2 != null) {
                        if (!jCType2.equals(jCType)) {
                            bl3 = false;
                            if (!JCUtilities.isAssignable(jCType2, jCType)) {
                                bl2 = false;
                                break;
                            }
                        }
                    } else {
                        bl3 = false;
                    }
                    ++n4;
                }
                if (bl2) {
                    if (bl3) {
                        arrayList.clear();
                    }
                    arrayList.add(jCConstructor);
                    if (bl3) break;
                }
            }
            ++n3;
        }
        return arrayList;
    }

    public static List getConstructors(JCClass jCClass) {
        TreeSet<JCConstructor> treeSet = new TreeSet<JCConstructor>();
        JCConstructor[] jCConstructorArray = jCClass.getConstructors();
        int n = jCConstructorArray.length - 1;
        while (n >= 0) {
            treeSet.add(jCConstructorArray[n]);
            --n;
        }
        return new ArrayList(treeSet);
    }

    public static List getAllInterfaces(JCClass jCClass) {
        ArrayList arrayList = new ArrayList();
        JCUtilities.collectInterfaces(jCClass, arrayList);
        return arrayList;
    }

    private static void collectInterfaces(JCClass jCClass, ArrayList arrayList) {
        JCClass[] jCClassArray = jCClass.getInterfaces();
        if (jCClassArray != null) {
            JCFinder jCFinder = JavaCompletion.getFinder();
            int n = 0;
            while (n < jCClassArray.length) {
                if (!arrayList.contains(jCClassArray[n])) {
                    arrayList.add(jCClassArray[n]);
                    jCClass = jCFinder.getExactClass(jCClassArray[n].getFullName());
                    if (jCClass != null) {
                        JCUtilities.collectInterfaces(jCClass, arrayList);
                    }
                }
                ++n;
            }
        }
    }

    public static List getSuperclasses(JCClass jCClass) {
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        JCFinder jCFinder = JavaCompletion.getFinder();
        jCClass = jCFinder.getExactClass(jCClass.getFullName());
        if (jCClass != null) {
            jCClass = jCClass.getSuperclass();
        }
        while (jCClass != null && arrayList.indexOf(jCClass) < 0) {
            arrayList.add(jCClass);
            jCClass = jCFinder.getExactClass(jCClass.getFullName());
            if (jCClass == null) continue;
            jCClass = jCClass.getSuperclass();
        }
        return arrayList;
    }

    public static boolean isAssignable(JCType jCType, JCType jCType2) {
        JCClass jCClass = jCType.getClazz();
        JCClass jCClass2 = jCType2.getClazz();
        if (jCClass.equals(JavaCompletion.NULL_CLASS)) {
            return jCType2.getArrayDepth() > 0 || !JavaCompletion.isPrimitiveClass(jCClass2);
        }
        if (jCClass2.equals(JavaCompletion.OBJECT_CLASS)) {
            return jCType.getArrayDepth() > jCType2.getArrayDepth() || jCType.getArrayDepth() == jCType2.getArrayDepth() && !JavaCompletion.isPrimitiveClass(jCClass);
        }
        if (jCType.getArrayDepth() != jCType2.getArrayDepth()) {
            return false;
        }
        if (jCClass.equals(jCClass2)) {
            return true;
        }
        if (jCClass.isInterface()) {
            return jCClass2.isInterface() && JCUtilities.getAllInterfaces(jCClass).indexOf(jCClass2) >= 0;
        }
        TokenID tokenID = JavaTokenContext.getKeyword(jCClass.getName());
        if (tokenID != null) {
            TokenID tokenID2 = JavaTokenContext.getKeyword(jCClass2.getName());
            return tokenID2 != null && primitivesAssignable[tokenID.getNumericID()][tokenID2.getNumericID()];
        }
        if (jCClass2.isInterface()) {
            return JCUtilities.getAllInterfaces(jCClass).indexOf(jCClass2) >= 0;
        }
        return JCUtilities.getSuperclasses(jCClass).indexOf(jCClass2) >= 0;
    }

    public static JCType getCommonType(JCType jCType, JCType jCType2) {
        if (jCType.equals(jCType2)) {
            return jCType;
        }
        TokenID tokenID = JavaTokenContext.getKeyword(jCType.getClazz().getName());
        TokenID tokenID2 = JavaTokenContext.getKeyword(jCType2.getClazz().getName());
        if (tokenID == null && tokenID2 == null) {
            if (JCUtilities.isAssignable(jCType, jCType2)) {
                return jCType;
            }
            if (JCUtilities.isAssignable(jCType2, jCType)) {
                return jCType2;
            }
            return null;
        }
        if (jCType.getArrayDepth() != jCType2.getArrayDepth()) {
            return null;
        }
        if (tokenID != null && tokenID2 != null) {
            return JavaCompletion.getType(primitivesCommonClass[tokenID.getNumericID()][tokenID2.getNumericID()], jCType.getArrayDepth());
        }
        return null;
    }

    public static JCClass createSimpleClass(Class clazz) {
        if (clazz == null || clazz.getName() == null) {
            return JavaCompletion.INVALID_CLASS;
        }
        return JCUtilities.createSimpleClassImpl(clazz.getName());
    }

    private static JCClass createSimpleClassImpl(String string) {
        int n = string.lastIndexOf(46);
        return JavaCompletion.getSimpleClass(string.replace('$', '.'), n >= 0 ? n : 0);
    }

    public static JavaCompletion.BaseType createType(Class clazz) {
        if (clazz == null) {
            return JavaCompletion.INVALID_TYPE;
        }
        String string = clazz.getName();
        int n = 0;
        while (string.length() > 0 && string.charAt(0) == '[') {
            ++n;
            string = string.substring(1);
        }
        if (n > 0) {
            switch (string.charAt(0)) {
                case 'L': {
                    string = string.substring(1, string.length() - 1);
                    break;
                }
                case 'B': {
                    string = "byte";
                    break;
                }
                case 'C': {
                    string = "char";
                    break;
                }
                case 'D': {
                    string = "double";
                    break;
                }
                case 'F': {
                    string = "float";
                    break;
                }
                case 'I': {
                    string = "int";
                    break;
                }
                case 'J': {
                    string = "long";
                    break;
                }
                case 'S': {
                    string = "short";
                    break;
                }
                case 'Z': {
                    string = "boolean";
                }
            }
        }
        return new JavaCompletion.BaseType(JCUtilities.createSimpleClassImpl(string), n);
    }

    public static List getClassList(List list, boolean bl, int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            block5: {
                String string = (String)iterator.next();
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Class '" + string + "' not found.");
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    System.err.println("Exception thrown during class rebuild:");
                    throwable.printStackTrace();
                    if (!(throwable instanceof OutOfMemoryError)) break block5;
                    throw (OutOfMemoryError)throwable;
                }
            }
            if (clazz == null) continue;
            arrayList.addAll(JCUtilities.createClassList(clazz, bl, n, n2, n3));
        }
        return arrayList;
    }

    private static String strip(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        if (string.startsWith(string2)) {
            n = string2.length();
        }
        if (string.endsWith(string3)) {
            n2 = string3.length();
        }
        return string.substring(n, string.length() - n2);
    }

    private static String separatorToDot(String string) {
        return string.replace(File.separatorChar, '.');
    }

    private static List createClassList(Class clazz, boolean bl, int n, int n2, int n3) {
        ArrayList<BaseJCClass> arrayList = new ArrayList<BaseJCClass>();
        if (clazz == null) {
            return arrayList;
        }
        if (JavaCompletion.getLevel(clazz.getModifiers()) >= n) {
            arrayList.add(new BaseJCClass(clazz, n, n2, n3));
        }
        if (bl) {
            try {
                Class<?>[] classArray = clazz.getDeclaredClasses();
                int n4 = 0;
                while (n4 < classArray.length) {
                    if (JavaCompletion.getLevel(classArray[n4].getModifiers()) >= n) {
                        arrayList.addAll(JCUtilities.createClassList(classArray[n4], bl, n, n2, n3));
                    }
                    ++n4;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        return arrayList;
    }

    public static List getClassNameList(String string) {
        File file = new File(string);
        ArrayList arrayList = new ArrayList();
        string = string + File.separator;
        if (file.exists()) {
            JCUtilities.getClassListFromSourcesRec(arrayList, string, file);
        }
        return arrayList;
    }

    private static void getClassListFromSourcesRec(final List list, final String string, File file) {
        file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    JCUtilities.getClassListFromSourcesRec(list, string, file);
                }
                if (file.getName().endsWith(".java")) {
                    list.add(JCUtilities.separatorToDot(JCUtilities.strip(file.getAbsolutePath(), string, ".java")));
                }
                return false;
            }
        });
    }

    static {
        int[] nArray = new int[]{63, 64, 65, 66, 67, 68, 69, 70, 71};
        boolean[][] blArrayArray = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {false, true, false, true, true, true, true, true, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false}, {false, false, false, true, true, true, true, false, false}, {false, false, false, true, true, false, true, false, false}, {false, false, false, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, true}};
        JCClass[][] jCClassArrayArray = new JCClass[][]{{JavaCompletion.BOOLEAN_CLASS, null, null, null, null, null, null, null, null}, {null, JavaCompletion.BYTE_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.CHAR_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, null}, {null, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.SHORT_CLASS, null}, {null, null, null, null, null, null, null, null, JavaCompletion.VOID_CLASS}};
        int n = 0;
        while (n < nArray.length) {
            JCUtilities.primitivesAssignable[nArray[n]] = new boolean[javaTokenIDsLength];
            JCUtilities.primitivesCommonClass[nArray[n]] = new JCClass[javaTokenIDsLength];
            int n2 = 0;
            while (n2 < nArray.length) {
                JCUtilities.primitivesAssignable[nArray[n]][nArray[n2]] = blArrayArray[n][n2];
                JCUtilities.primitivesCommonClass[nArray[n]][nArray[n2]] = jCClassArrayArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public static class BaseJCClass
    extends JavaCompletion.AbstractClass {
        Class c;
        int classLevel;
        int fieldLevel;
        int methodLevel;

        public BaseJCClass(Class clazz, int n, int n2, int n3) {
            this.c = clazz;
            this.classLevel = n;
            this.fieldLevel = n2;
            this.methodLevel = n3;
            JCClass jCClass = JCUtilities.createSimpleClass(clazz);
            this.name = jCClass.getName();
            this.packageName = jCClass.getPackageName();
            this.modifiers = clazz.getModifiers();
            if (clazz.isInterface()) {
                this.modifiers |= 0x40000000;
            }
        }

        protected void init() {
            int n;
            Class<?>[] classArray;
            Object[] objectArray;
            JCParameter[] jCParameterArray;
            int n2;
            AccessibleObject[] accessibleObjectArray;
            this.body = new JavaCompletion.AbstractClass.Body();
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            this.body.superClass = JCUtilities.createSimpleClass(this.c.getSuperclass());
            Class<?>[] classArray2 = this.c.getInterfaces();
            int n3 = 0;
            while (n3 < classArray2.length) {
                if (JavaCompletion.getLevel(classArray2[n3].getModifiers()) >= this.classLevel) {
                    arrayList.add(JCUtilities.createSimpleClass(classArray2[n3]));
                }
                ++n3;
            }
            this.body.interfaces = new JCClass[arrayList.size()];
            arrayList.toArray(this.body.interfaces);
            arrayList.clear();
            try {
                accessibleObjectArray = this.c.getDeclaredFields();
                n2 = 0;
                while (n2 < accessibleObjectArray.length) {
                    if (JavaCompletion.getLevel(((Field)accessibleObjectArray[n2]).getModifiers()) >= this.fieldLevel) {
                        arrayList.add(new JavaCompletion.BaseField(this, ((Field)accessibleObjectArray[n2]).getName(), JCUtilities.createType(((Field)accessibleObjectArray[n2]).getType()), ((Field)accessibleObjectArray[n2]).getModifiers()));
                    }
                    ++n2;
                }
                this.body.fields = new JCField[arrayList.size()];
                arrayList.toArray(this.body.fields);
                arrayList.clear();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            try {
                accessibleObjectArray = this.c.getDeclaredConstructors();
                n2 = 0;
                while (n2 < accessibleObjectArray.length) {
                    if (JavaCompletion.getLevel(((Constructor)accessibleObjectArray[n2]).getModifiers()) >= this.methodLevel) {
                        jCParameterArray = JavaCompletion.EMPTY_PARAMETERS;
                        try {
                            objectArray = ((Constructor)accessibleObjectArray[n2]).getParameterTypes();
                            jCParameterArray = new JCParameter[objectArray.length];
                            int n4 = 0;
                            while (n4 < objectArray.length) {
                                jCParameterArray[n4] = new JavaCompletion.BaseParameter("", JCUtilities.createType((Class)objectArray[n4]));
                                ++n4;
                            }
                        }
                        catch (SecurityException securityException) {
                            securityException.printStackTrace();
                        }
                        objectArray = JavaCompletion.EMPTY_CLASSES;
                        try {
                            classArray = ((Constructor)accessibleObjectArray[n2]).getExceptionTypes();
                            objectArray = new JCClass[classArray.length];
                            n = 0;
                            while (n < classArray.length) {
                                objectArray[n] = JCUtilities.createSimpleClass(classArray[n]);
                                ++n;
                            }
                        }
                        catch (SecurityException securityException) {
                            securityException.printStackTrace();
                        }
                        arrayList.add(new JavaCompletion.BaseConstructor(this, ((Constructor)accessibleObjectArray[n2]).getModifiers(), jCParameterArray, (JCClass[])objectArray));
                    }
                    ++n2;
                }
                this.body.constructors = new JCConstructor[arrayList.size()];
                arrayList.toArray(this.body.constructors);
                arrayList.clear();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            try {
                accessibleObjectArray = this.c.getDeclaredMethods();
                n2 = 0;
                while (n2 < accessibleObjectArray.length) {
                    if (JavaCompletion.getLevel(((Method)accessibleObjectArray[n2]).getModifiers()) >= this.methodLevel) {
                        jCParameterArray = JavaCompletion.EMPTY_PARAMETERS;
                        try {
                            objectArray = ((Method)accessibleObjectArray[n2]).getParameterTypes();
                            jCParameterArray = new JCParameter[objectArray.length];
                            int n5 = 0;
                            while (n5 < objectArray.length) {
                                jCParameterArray[n5] = new JavaCompletion.BaseParameter("", JCUtilities.createType((Class)objectArray[n5]));
                                ++n5;
                            }
                        }
                        catch (SecurityException securityException) {
                            securityException.printStackTrace();
                        }
                        objectArray = JavaCompletion.EMPTY_CLASSES;
                        try {
                            classArray = ((Method)accessibleObjectArray[n2]).getExceptionTypes();
                            objectArray = new JCClass[classArray.length];
                            n = 0;
                            while (n < classArray.length) {
                                objectArray[n] = JCUtilities.createSimpleClass(classArray[n]);
                                ++n;
                            }
                        }
                        catch (SecurityException securityException) {
                            securityException.printStackTrace();
                        }
                        arrayList.add(new JavaCompletion.BaseMethod(this, ((Method)accessibleObjectArray[n2]).getName(), ((Method)accessibleObjectArray[n2]).getModifiers(), JCUtilities.createType(((Method)accessibleObjectArray[n2]).getReturnType()), jCParameterArray, (JCClass[])objectArray));
                    }
                    ++n2;
                }
                this.body.methods = new JCMethod[arrayList.size()];
                arrayList.toArray(this.body.methods);
                arrayList.clear();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            this.c = null;
        }
    }
}

