/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.java.JavaFormatSupport;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaFormatter
extends ExtFormatter {
    public JavaFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JavaSyntax;
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null) {
            if ("e".equals(string)) {
                try {
                    int n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
                    if (n2 >= 0 && n2 + 4 == n && "else".equals(baseDocument.getText(n2, 4))) {
                        nArray = new int[]{n2, n2 + 4};
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else if (":".equals(string)) {
                try {
                    int n3 = Utilities.getRowFirstNonWhite(baseDocument, n);
                    if (n3 >= 0 && n3 + 4 <= baseDocument.getLength() && "case".equals(baseDocument.getText(n3, 4))) {
                        nArray = new int[]{n3, n3 + 4};
                    } else if (n3 >= 0 & n3 + 7 <= baseDocument.getLength() && "default".equals(baseDocument.getText(n3, 7))) {
                        nArray = new int[]{n3, n3 + 7};
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                nArray = super.getReformatBlock(jTextComponent, string);
            }
        }
        return nArray;
    }

    protected void initFormatLayers() {
        this.addFormatLayer(new StripEndWhitespaceLayer());
        this.addFormatLayer(new JavaLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new JavaFormatSupport(formatWriter);
    }

    public class JavaLayer
    extends AbstractFormatLayer {
        public JavaLayer() {
            super("java-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new JavaFormatSupport(formatWriter);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void format(FormatWriter formatWriter) {
            try {
                JavaFormatSupport javaFormatSupport = (JavaFormatSupport)this.createFormatSupport(formatWriter);
                FormatTokenPosition formatTokenPosition = javaFormatSupport.getFormatStartPosition();
                if (javaFormatSupport.isIndentOnly()) {
                    javaFormatSupport.indentLine(formatTokenPosition);
                    return;
                }
                while (true) {
                    if (formatTokenPosition == null) {
                        return;
                    }
                    javaFormatSupport.indentLine(formatTokenPosition);
                    this.formatLine(javaFormatSupport, formatTokenPosition);
                    FormatTokenPosition formatTokenPosition2 = javaFormatSupport.findLineEnd(formatTokenPosition);
                    if (formatTokenPosition2 == null) return;
                    if (formatTokenPosition2.getToken() == null) {
                        return;
                    }
                    formatTokenPosition = javaFormatSupport.getNextPosition(formatTokenPosition2, Position.Bias.Forward);
                    if (formatTokenPosition == formatTokenPosition2) {
                        return;
                    }
                    if (formatTokenPosition == null) return;
                    if (formatTokenPosition.getToken() == null) {
                        return;
                    }
                    FormatTokenPosition formatTokenPosition3 = javaFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                    if (formatTokenPosition3 != null) {
                        formatTokenPosition = formatTokenPosition3;
                        continue;
                    }
                    formatTokenPosition = javaFormatSupport.findLineStart(formatTokenPosition);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        protected void formatLine(JavaFormatSupport javaFormatSupport, FormatTokenPosition formatTokenPosition) {
            TokenItem tokenItem = javaFormatSupport.findLineStart(formatTokenPosition).getToken();
            while (tokenItem != null) {
                if (tokenItem.getTokenContextPath() == javaFormatSupport.getTokenContextPath()) {
                    block0 : switch (tokenItem.getTokenID().getNumericID()) {
                        case 57: {
                            FormatTokenPosition formatTokenPosition2;
                            Object object;
                            Object object2;
                            if (javaFormatSupport.isIndentOnly()) break;
                            if (javaFormatSupport.getFormatNewlineBeforeBrace()) {
                                object2 = javaFormatSupport.getPosition(tokenItem, 0);
                                object = javaFormatSupport.findImportant((FormatTokenPosition)object2, null, true, true);
                                if (object == null || object.getToken().getTokenContextPath() != javaFormatSupport.getTokenContextPath()) break;
                                switch (object.getToken().getTokenID().getNumericID()) {
                                    case 7: 
                                    case 8: {
                                        break block0;
                                    }
                                }
                                formatTokenPosition2 = javaFormatSupport.findImportant((FormatTokenPosition)object2, null, true, false);
                                if (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && formatTokenPosition2.getToken().getTokenID() == JavaTokenContext.RBRACE) break;
                                if (javaFormatSupport.canInsertToken(tokenItem)) {
                                    javaFormatSupport.insertToken(tokenItem, javaFormatSupport.getValidWhitespaceTokenID(), javaFormatSupport.getValidWhitespaceTokenContextPath(), "\n");
                                    javaFormatSupport.removeLineEndWhitespace((FormatTokenPosition)object);
                                    javaFormatSupport.indentLine((FormatTokenPosition)object2);
                                }
                                tokenItem = object.getToken();
                                break;
                            }
                            object2 = javaFormatSupport.getPosition(tokenItem, 0);
                            if (javaFormatSupport.findNonWhitespace((FormatTokenPosition)object2, null, true, true) != null || javaFormatSupport.getNextPosition((FormatTokenPosition)object2) != null && javaFormatSupport.findImportant(javaFormatSupport.getNextPosition((FormatTokenPosition)object2), null, true, false) != null || (formatTokenPosition2 = javaFormatSupport.getPreviousPosition((FormatTokenPosition)(object = javaFormatSupport.findLineStart((FormatTokenPosition)object2)))) == null || formatTokenPosition2.getToken().getTokenID() != JavaTokenContext.WHITESPACE) break;
                            object = javaFormatSupport.findLineStart(formatTokenPosition2);
                            if ((object = javaFormatSupport.findImportant((FormatTokenPosition)object2, (FormatTokenPosition)object, false, true)) == null || (object = javaFormatSupport.findNonWhitespace(formatTokenPosition2, null, true, true)).getToken().getTokenID() == JavaTokenContext.LINE_COMMENT || object.getToken().getTokenID() == JavaTokenContext.LBRACE) break;
                            boolean bl = true;
                            while (bl) {
                                if (tokenItem.getPrevious() == formatTokenPosition2.getToken()) {
                                    bl = false;
                                }
                                if (!javaFormatSupport.canRemoveToken(tokenItem.getPrevious())) break;
                                javaFormatSupport.removeToken(tokenItem.getPrevious());
                            }
                            if (!javaFormatSupport.canInsertToken(tokenItem)) break;
                            javaFormatSupport.insertSpaces(tokenItem, 1);
                            break;
                        }
                        case 53: {
                            Object object;
                            Object object2;
                            if (javaFormatSupport.getFormatSpaceBeforeParenthesis()) {
                                object2 = tokenItem.getPrevious();
                                if (object2 == null || object2.getTokenID() != JavaTokenContext.IDENTIFIER && object2.getTokenID() != JavaTokenContext.THIS && object2.getTokenID() != JavaTokenContext.SUPER || !javaFormatSupport.canInsertToken(tokenItem)) break;
                                javaFormatSupport.insertToken(tokenItem, javaFormatSupport.getWhitespaceTokenID(), javaFormatSupport.getWhitespaceTokenContextPath(), " ");
                                break;
                            }
                            object2 = tokenItem.getPrevious();
                            if (object2 == null || object2.getTokenID() != JavaTokenContext.WHITESPACE || object2.getImage().length() != 1 || (object = object2.getPrevious()) == null || object.getTokenID() != JavaTokenContext.IDENTIFIER && object.getTokenID() != JavaTokenContext.THIS && object.getTokenID() != JavaTokenContext.SUPER || !javaFormatSupport.canRemoveToken((TokenItem)object2)) break;
                            javaFormatSupport.removeToken((TokenItem)object2);
                        }
                    }
                }
                tokenItem = tokenItem.getNext();
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("java-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new JavaFormatSupport(formatWriter);
        }

        /*
         * Unable to fully structure code
         */
        public void format(FormatWriter var1_1) {
            block2: {
                var2_2 = (JavaFormatSupport)this.createFormatSupport(var1_1);
                var3_3 = var2_2.getFormatStartPosition();
                if (!var2_2.isIndentOnly()) ** GOTO lbl9
                break block2;
lbl-1000:
                // 1 sources

                {
                    var4_4 = var3_3;
                    if ((var3_3 = var2_2.removeLineEndWhitespace(var3_3)).getToken() != null) {
                        var3_3 = var2_2.getNextPosition(var3_3);
                    }
                    if (var4_4.equals(var3_3)) break;
lbl9:
                    // 2 sources

                    ** while (var3_3.getToken() != null)
                }
            }
        }
    }
}

