/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

final class IconManager {
    private static final Object NO_ICON;
    private static final HashMap map;
    private static final HashMap reverseMap;
    private static final Set extraInitialSlashes;
    private static ClassLoader currentLoader;
    private static Lookup.Result loaderQuery;
    private static boolean noLoaderWarned;
    private static final Component component;
    private static final MediaTracker tracker;
    private static int mediaTrackerID;
    static final /* synthetic */ boolean $assertionsDisabled;

    IconManager() {
    }

    private static ClassLoader getLoader() {
        if (currentLoader == null) {
            Iterator it;
            if (loaderQuery == null) {
                loaderQuery = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
                loaderQuery.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        currentLoader = null;
                    }
                });
            }
            if ((it = loaderQuery.allInstances().iterator()).hasNext()) {
                currentLoader = (ClassLoader)it.next();
            } else if (!noLoaderWarned) {
                noLoaderWarned = true;
                ErrorManager.getDefault().log(16, "No ClassLoader instance found in " + Lookup.getDefault());
            }
        }
        return currentLoader;
    }

    static Image getIcon(String name) {
        Object img = map.get(name);
        if (img == NO_ICON) {
            return null;
        }
        if (img != null) {
            img = ((Reference)img).get();
        }
        if (img != null) {
            return (Image)img;
        }
        ClassLoader loader = IconManager.getLoader();
        return IconManager.getIcon(name, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String name, ClassLoader loader) {
        Object img = map.get(name);
        if (img == NO_ICON) {
            return null;
        }
        if (img != null) {
            img = ((Reference)img).get();
        }
        if (img != null) {
            return (Image)img;
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            String n;
            boolean warn;
            img = map.get(name);
            if (img == NO_ICON) {
                return null;
            }
            if (img != null) {
                img = ((Reference)img).get();
            }
            if (img != null) {
                return (Image)img;
            }
            if (name.startsWith("/")) {
                warn = true;
                n = name.substring(1);
            } else {
                warn = false;
                n = name;
            }
            URL url = loader != null ? loader.getResource(n) : IconManager.class.getClassLoader().getResource(n);
            Image image = img = url == null ? null : Toolkit.getDefaultToolkit().createImage(url);
            if (img != null) {
                if (warn && extraInitialSlashes.add(name)) {
                    ErrorManager.getDefault().log(16, "Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                Image img2 = IconManager.toBufferedImage((Image)img);
                ActiveRef r = new ActiveRef(img2);
                map.put(name, r);
                return img2;
            }
            map.put(name, NO_ICON);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Image mergeImages(Image im1, Image im2, int x, int y) {
        CompositeImageKey k = new CompositeImageKey(im1, im2, x, y);
        HashMap hashMap = map;
        synchronized (hashMap) {
            Image cached;
            Reference r = (Reference)map.get(k);
            if (r != null && (cached = (Image)r.get()) != null) {
                return cached;
            }
            cached = IconManager.doMergeImages(im1, im2, x, y);
            r = new ActiveRef(cached);
            map.put(k, r);
            reverseMap.put(r, k);
            return cached;
        }
    }

    static final Image toBufferedImage(Image img) {
        new ImageIcon(img);
        BufferedImage rep = IconManager.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            if (!$assertionsDisabled && tracker.statusID(id, false) != 8) {
                throw new AssertionError((Object)"Image loaded");
            }
            tracker.removeImage(image, id);
        }
    }

    private static final Image doMergeImages(Image image1, Image image2, int x, int y) {
        IconManager.ensureLoaded(image1);
        IconManager.ensureLoaded(image2);
        int w = Math.max(image1.getWidth(null), x + image2.getWidth(null));
        int h = Math.max(image1.getHeight(null), y + image2.getHeight(null));
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, x, y, null);
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.getOperatingSystem() == 2048) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    static {
        $assertionsDisabled = !IconManager.class.desiredAssertionStatus();
        NO_ICON = new Object();
        map = new HashMap();
        reverseMap = new HashMap();
        extraInitialSlashes = new HashSet(200);
        currentLoader = null;
        loaderQuery = null;
        noLoaderWarned = false;
        component = new Component(){};
        tracker = new MediaTracker(component);
    }

    private static final class ActiveRef
    extends SoftReference
    implements Runnable {
        public ActiveRef(Object o) {
            super(o, Utilities.activeReferenceQueue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashMap hashMap = map;
            synchronized (hashMap) {
                Object k = reverseMap.remove(this);
                map.remove(k);
            }
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

