/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.util.MutexException;
import org.openide.util.Utilities;

public final class Mutex {
    public static final Mutex EVENT = new Mutex();
    private static final int NONE = 0;
    private static final int CHAIN = 1;
    private static final int X = 2;
    private static final int S = 3;
    private static final int MODE_COUNT = 4;
    private static final boolean[][] cmatrix = new boolean[][]{null, null, {true, false, false, false}, {true, false, false, true}};
    private int grantedMode = 0;
    private Object LOCK;
    private Map registeredThreads;
    private int readersNo = 0;
    private List waiters;

    private static boolean compatibleLocks(int granted, int requested) {
        return cmatrix[requested][granted];
    }

    public Mutex(Object lock) {
        this.init(lock);
    }

    public Mutex() {
        this.init(new InternalLock());
    }

    public Mutex(Privileged privileged) {
        if (privileged == null) {
            throw new IllegalArgumentException("privileged == null");
        }
        this.init(new InternalLock());
        privileged.setParent(this);
    }

    private void init(Object lock) {
        this.LOCK = lock;
        this.registeredThreads = new HashMap(7);
        this.waiters = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readAccess(Action action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException e) {
                InternalError err = new InternalError("Exception from non-Exception Action");
                ErrorManager.getDefault().annotate((Throwable)err, e.getException());
                throw err;
            }
        }
        Thread t = Thread.currentThread();
        this.readEnter(t);
        try {
            Object object = action.run();
            return object;
        }
        finally {
            this.leave(t);
        }
    }

    public Object readAccess(ExceptionAction action) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(action);
        }
        Thread t = Thread.currentThread();
        this.readEnter(t);
        try {
            Object object = action.run();
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MutexException(e);
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAccess(Runnable action) {
        if (this == EVENT) {
            Mutex.doEvent(action);
            return;
        }
        Thread t = Thread.currentThread();
        this.readEnter(t);
        try {
            action.run();
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object writeAccess(Action action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException e) {
                InternalError err = new InternalError("Exception from non-Exception Action");
                ErrorManager.getDefault().annotate((Throwable)err, e.getException());
                throw err;
            }
        }
        Thread t = Thread.currentThread();
        this.writeEnter(t);
        try {
            Object object = action.run();
            return object;
        }
        finally {
            this.leave(t);
        }
    }

    public Object writeAccess(ExceptionAction action) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(action);
        }
        Thread t = Thread.currentThread();
        this.writeEnter(t);
        try {
            Object object = action.run();
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MutexException(e);
        }
        finally {
            this.leave(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAccess(Runnable action) {
        if (this == EVENT) {
            Mutex.doEvent(action);
            return;
        }
        Thread t = Thread.currentThread();
        this.writeEnter(t);
        try {
            action.run();
        }
        finally {
            this.leave(t);
        }
    }

    public void postReadRequest(Runnable run) {
        this.postRequest(3, run);
    }

    public void postWriteRequest(Runnable run) {
        this.postRequest(2, run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this == EVENT) {
            return "Mutex.EVENT";
        }
        String newline = System.getProperty("line.separator");
        StringBuffer sbuff = new StringBuffer(512);
        Object object = this.LOCK;
        synchronized (object) {
            sbuff.append("threads: ").append(this.registeredThreads).append(newline);
            sbuff.append("readersNo: ").append(this.readersNo).append(newline);
            sbuff.append("waiters: ").append(this.waiters).append(newline);
            sbuff.append("grantedMode: ").append(this.grantedMode).append(newline);
        }
        return sbuff.toString();
    }

    private void writeEnter(Thread t) {
        this.enter(2, t, true);
    }

    private void readEnter(Thread t) {
        this.enter(3, t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enter(int requested, Thread t, boolean block) {
        QueueCell cell = null;
        int loopc = 0;
        while (true) {
            ++loopc;
            Object object = this.LOCK;
            synchronized (object) {
                ThreadInfo info = this.getThreadInfo(t);
                if (info != null) {
                    IllegalStateException e;
                    if (this.grantedMode == 0) {
                        throw new IllegalStateException();
                    }
                    if (info.mode == 3 && this.grantedMode == 2 || info.mode == 2 && this.grantedMode == 3) {
                        throw new IllegalStateException();
                    }
                    if (info.mode == 2 || info.mode == requested) {
                        if (info.forced) {
                            info.forced = false;
                        } else {
                            int n = requested;
                            info.counts[n] = info.counts[n] + 1;
                            if (requested == 3 && info.counts[requested] == 1) {
                                ++this.readersNo;
                            }
                        }
                        return true;
                    }
                    if (this.canUpgrade(info.mode, requested)) {
                        e = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                        ErrorManager.getDefault().notify(e);
                        info.mode = 2;
                        int n = requested;
                        info.counts[n] = info.counts[n] + 1;
                        info.rsnapshot = info.counts[3];
                        if (this.grantedMode == 3) {
                            this.grantedMode = 2;
                        } else if (this.grantedMode == 2) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    e = new IllegalStateException("WARNING: Going from readAccess to writeAccess through queue, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                    ErrorManager.getDefault().notify(e);
                } else if (this.isCompatible(requested)) {
                    this.grantedMode = requested;
                    info = new ThreadInfo(t, requested);
                    this.registeredThreads.put(t, info);
                    if (requested == 3) {
                        ++this.readersNo;
                    }
                    return true;
                }
                if (!block) {
                    return false;
                }
                this.grantedMode = 1;
                cell = this.chain(requested, t, 0);
            }
            cell.sleep();
        }
    }

    private boolean reenter(Thread t, int mode) {
        boolean chainFromLeaveX;
        if (mode == 3) {
            if (this.grantedMode != 0 && this.grantedMode != 3) {
                throw new IllegalStateException(this.toString());
            }
            this.enter(mode, t, true);
            return false;
        }
        ThreadInfo tinfo = this.getThreadInfo(t);
        boolean bl = chainFromLeaveX = this.grantedMode == 1 && tinfo != null && tinfo.counts[2] > 0;
        if (this.grantedMode == 2 || this.grantedMode == 0 || chainFromLeaveX) {
            this.enter(mode, t, true);
            return false;
        }
        if (this.readersNo == 0) {
            throw new IllegalStateException(this.toString());
        }
        ThreadInfo info = new ThreadInfo(t, mode);
        this.registeredThreads.put(t, info);
        this.readersNo += 2;
        this.grantedMode = 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privilegedEnter(Thread t, int mode) {
        boolean decrease = true;
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo info = this.getThreadInfo(t);
        }
        while (true) {
            QueueCell cell;
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (decrease) {
                    decrease = false;
                    this.readersNo -= 2;
                }
                this.grantedMode = 1;
                cell = this.chain(mode, t, Integer.MAX_VALUE);
                if (this.readersNo == 0) {
                    if (this.waiters.get(0) == cell) {
                        this.waiters.remove(0);
                        return;
                    }
                    this.grantedMode = 0;
                    this.wakeUpOthers();
                }
            }
            cell.sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave(Thread t) {
        ThreadInfo info;
        int postedMode = 0;
        boolean needLock = false;
        Object object = this.LOCK;
        synchronized (object) {
            int runsize;
            info = this.getThreadInfo(t);
            switch (this.grantedMode) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    if (info.counts[2] > 0) {
                        postedMode = this.leaveX(info);
                        break;
                    }
                    if (info.counts[3] > 0) {
                        postedMode = this.leaveS(info);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    postedMode = this.leaveX(info);
                    break;
                }
                case 3: {
                    postedMode = this.leaveS(info);
                }
            }
            if (postedMode != 0 && (runsize = info.getRunnableCount(postedMode)) != 0) {
                needLock = this.reenter(t, postedMode);
            }
        }
        if (postedMode != 0 && info.getRunnableCount(postedMode) > 0) {
            try {
                if (needLock) {
                    this.privilegedEnter(t, postedMode);
                }
                List runnables = info.dequeue(postedMode);
                int size = runnables.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        Runnable r = (Runnable)runnables.get(i);
                        r.run();
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(e);
                        continue;
                    }
                    catch (LinkageError e) {
                        ErrorManager.getDefault().notify(e);
                        continue;
                    }
                    catch (StackOverflowError e) {
                        e.printStackTrace();
                        ErrorManager.getDefault().notify(e);
                    }
                }
                runnables = null;
            }
            finally {
                this.leave(t);
            }
        }
    }

    private int leaveX(ThreadInfo info) {
        if (info.counts[2] <= 0 || info.rsnapshot > info.counts[3]) {
            throw new IllegalStateException();
        }
        if (info.rsnapshot == info.counts[3]) {
            info.counts[2] = info.counts[2] - 1;
            if (info.counts[2] == 0) {
                info.rsnapshot = 0;
                if (info.counts[3] > 0) {
                    this.grantedMode = 3;
                    info.mode = 3;
                } else {
                    this.grantedMode = 0;
                    info.mode = 0;
                    this.registeredThreads.remove(info.t);
                }
                if (info.getRunnableCount(3) > 0) {
                    return 3;
                }
                this.wakeUpOthers();
            }
        } else {
            if (info.counts[3] <= 0) {
                throw new IllegalStateException();
            }
            info.counts[3] = info.counts[3] - 1;
            if (info.counts[3] == 0) {
                if (this.readersNo <= 0) {
                    throw new IllegalStateException();
                }
                --this.readersNo;
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int leaveS(ThreadInfo info) {
        if (info.counts[3] <= 0 || info.counts[2] > 0) {
            throw new IllegalStateException();
        }
        info.counts[3] = info.counts[3] - 1;
        if (info.counts[3] == 0) {
            info.mode = 0;
            this.registeredThreads.remove(info.t);
            if (this.readersNo <= 0) {
                throw new IllegalStateException();
            }
            --this.readersNo;
            if (this.readersNo == 0) {
                this.grantedMode = 0;
                if (info.getRunnableCount(2) > 0) {
                    return 2;
                }
                this.wakeUpOthers();
            } else {
                if (info.getRunnableCount(2) > 0) {
                    return 2;
                }
                if (this.grantedMode == 1 && this.readersNo == 1) {
                    for (int i = 0; i < this.waiters.size(); ++i) {
                        QueueCell qc;
                        QueueCell queueCell = qc = (QueueCell)this.waiters.get(i);
                        synchronized (queueCell) {
                            if (qc.isGotOut()) {
                                this.waiters.remove(i--);
                                continue;
                            }
                            ThreadInfo tinfo = this.getThreadInfo(qc.t);
                            if (tinfo != null && tinfo.mode == 3) {
                                if (qc.mode != 2) {
                                    throw new IllegalStateException();
                                }
                                if (this.waiters.size() == 1) {
                                    this.grantedMode = 2;
                                }
                                tinfo.mode = 2;
                                this.waiters.remove(i);
                                qc.wakeMeUp();
                            }
                            break;
                        }
                    }
                }
            }
        }
        return 0;
    }

    private QueueCell chain(int requested, Thread t, int priority) {
        QueueCell qc = new QueueCell(requested, t);
        qc.priority2 = priority;
        int size = this.waiters.size();
        if (size == 0) {
            this.waiters.add(qc);
        } else if (qc.getPriority() == Integer.MAX_VALUE) {
            this.waiters.add(0, qc);
        } else {
            int i = 0;
            do {
                QueueCell cursor;
                if ((cursor = (QueueCell)this.waiters.get(i)).getPriority() >= qc.getPriority()) continue;
                this.waiters.add(i, qc);
                break;
            } while (++i < size);
            if (i == size) {
                this.waiters.add(qc);
            }
        }
        return qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpOthers() {
        if (this.grantedMode == 2 || this.grantedMode == 1) {
            throw new IllegalStateException();
        }
        if (this.waiters.size() == 0) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell qc;
            QueueCell queueCell = qc = (QueueCell)this.waiters.get(i);
            synchronized (queueCell) {
                if (qc.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (Mutex.compatibleLocks(this.grantedMode, qc.mode)) {
                    this.waiters.remove(i--);
                    qc.wakeMeUp();
                    this.grantedMode = qc.mode;
                    if (this.getThreadInfo(qc.t) == null) {
                        ThreadInfo ti = new ThreadInfo(qc.t, qc.mode);
                        ti.forced = true;
                        if (qc.mode == 3) {
                            ++this.readersNo;
                        }
                        this.registeredThreads.put(qc.t, ti);
                    }
                } else {
                    this.grantedMode = 1;
                    break;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRequest(int mutexMode, Runnable run) {
        ThreadInfo info;
        if (this == EVENT) {
            Mutex.doEventRequest(run);
            return;
        }
        Thread t = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            info = this.getThreadInfo(t);
            if (info != null) {
                if (mutexMode == info.mode && info.counts[5 - mutexMode] == 0) {
                    this.enter(mutexMode, t, true);
                } else {
                    info.enqueue(mutexMode, run);
                    return;
                }
            }
        }
        if (info == null) {
            this.enter(mutexMode, t, true);
            try {
                run.run();
            }
            finally {
                this.leave(t);
            }
            return;
        }
        try {
            run.run();
        }
        finally {
            this.leave(t);
        }
    }

    private boolean isCompatible(int requested) {
        return Mutex.compatibleLocks(this.grantedMode, requested);
    }

    private ThreadInfo getThreadInfo(Thread t) {
        return (ThreadInfo)this.registeredThreads.get(t);
    }

    private boolean canUpgrade(int threadGranted, int requested) {
        return threadGranted == 3 && requested == 2 && this.readersNo == 1;
    }

    private static void doEvent(Runnable run) {
        if (EventQueue.isDispatchThread()) {
            run.run();
        } else {
            EventQueue.invokeLater(run);
        }
    }

    private static void doEventRequest(Runnable run) {
        EventQueue.invokeLater(run);
    }

    private static Object doEventAccess(final ExceptionAction run) throws MutexException {
        if (Mutex.isDispatchThread()) {
            try {
                return run.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MutexException(e);
            }
        }
        final Throwable[] arr = new Throwable[1];
        try {
            final Object[] res = new Object[1];
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        res[0] = run.run();
                    }
                    catch (Exception e) {
                        arr[0] = e;
                    }
                    catch (LinkageError e) {
                        arr[0] = e;
                    }
                    catch (StackOverflowError e) {
                        arr[0] = e;
                    }
                }
            });
            if (arr[0] == null) {
                return res[0];
            }
        }
        catch (InterruptedException e) {
            arr[0] = e;
        }
        catch (InvocationTargetException e) {
            arr[0] = e;
        }
        if (arr[0] instanceof RuntimeException) {
            throw (RuntimeException)arr[0];
        }
        throw Mutex.notifyException(4096, arr[0]);
    }

    static boolean isDispatchThread() {
        boolean dispatch = EventQueue.isDispatchThread();
        if (!dispatch && Utilities.getOperatingSystem() == 8) {
            dispatch = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
        }
        return dispatch;
    }

    private static final MutexException notifyException(int severity, Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = Mutex.unfoldInvocationTargetException((InvocationTargetException)t);
        }
        if (t instanceof Error) {
            Mutex.annotateEventStack(t);
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            Mutex.annotateEventStack(t);
            throw (RuntimeException)t;
        }
        MutexException exc = new MutexException((Exception)t);
        ErrorManager.getDefault().annotate((Throwable)exc, t);
        return exc;
    }

    private static final void annotateEventStack(Throwable t) {
        ErrorManager.getDefault().annotate(t, new Exception("Caught here in mutex"));
    }

    private static final Throwable unfoldInvocationTargetException(InvocationTargetException e) {
        Throwable ret;
        while ((e = (ret = e.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)ret : null) != null) {
        }
        return ret;
    }

    public static final class Privileged {
        private Mutex parent;

        final void setParent(Mutex parent) {
            this.parent = parent;
        }

        public void enterReadAccess() {
            this.parent.readEnter(Thread.currentThread());
        }

        public void enterWriteAccess() {
            this.parent.writeEnter(Thread.currentThread());
        }

        public void exitReadAccess() {
            this.parent.leave(Thread.currentThread());
        }

        public void exitWriteAccess() {
            this.parent.leave(Thread.currentThread());
        }
    }

    private static final class QueueCell {
        int mode;
        Thread t;
        boolean signal;
        boolean left;
        int priority2;

        public QueueCell(int mode, Thread t) {
            this.mode = mode;
            this.t = t;
            this.left = false;
            this.priority2 = 0;
        }

        public String toString() {
            return super.toString() + " mode: " + this.mode + " thread: " + this.t;
        }

        public long getPriority() {
            return this.priority2 == 0 ? this.t.getPriority() : this.priority2;
        }

        public boolean isGotOut() {
            return this.left;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void sleep() {
            block7: {
                while (true) {
                    if (this.signal) break block7;
                    try {
                        this.wait();
                        return;
                    }
                    catch (InterruptedException e) {
                        ErrorManager.getDefault().notify(e);
                    }
                }
                finally {
                    this.left = true;
                }
            }
        }

        public void wakeMeUp() {
            this.signal = true;
            this.notifyAll();
        }
    }

    private static final class InternalLock {
        InternalLock() {
        }
    }

    private static final class ThreadInfo {
        boolean forced;
        final Thread t;
        int mode;
        int[] counts;
        List[] queues;
        int rsnapshot;

        public ThreadInfo(Thread t, int mode) {
            this.t = t;
            this.mode = mode;
            this.counts = new int[4];
            this.queues = new List[4];
            this.counts[mode] = 1;
        }

        public String toString() {
            return super.toString() + " thread: " + this.t + " mode: " + this.mode + " X: " + this.counts[2] + " S: " + this.counts[3];
        }

        public void enqueue(int mode, Runnable run) {
            if (this.queues[mode] == null) {
                this.queues[mode] = new ArrayList(13);
            }
            this.queues[mode].add(run);
        }

        public List dequeue(int mode) {
            List ret = this.queues[mode];
            this.queues[mode] = null;
            return ret;
        }

        public int getRunnableCount(int mode) {
            return this.queues[mode] == null ? 0 : this.queues[mode].size();
        }
    }

    public static interface ExceptionAction {
        public Object run() throws Exception;
    }

    public static interface Action
    extends ExceptionAction {
        public Object run();
    }
}

