/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml;

import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.openapi.Project;
import com.gentleware.poseidon.generator.ui.DialogController;
import com.gentleware.poseidon.model_management.DocumentationManager;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.poseidon.uml.ui.documentation.JavaDocTagDocumentationList;
import com.gentleware.poseidon.uml.ui.documentation.JavaDocTagProvider;
import com.gentleware.services.Services;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.util.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmiimpl.omg.uml.foundation.core.CommentImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;
import org.omg.uml.behavioralelements.commonbehavior.UmlException;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.ParameterDirectionKindEnum;
import org.omg.uml2.diagraminterchange.Diagram;

public class UmlDocumentationManager
extends DocumentationManager {
    public static final String umlNoteOpenerPre = "<ID=\"UML note. note-id=[";
    public static final String umlNoteOpenerPost = "] \">";
    public static final String umlNoteCloser = "<BR></ID>";
    public static final String umlConstraintOpenerPre = "<ID=\"UML constraint. constraint-id=[";
    public static final String umlConstraintOpenerPost = "] \">";
    public static final String umlConstraintOpener = "<ID=\"UML constraint. Changes will be overwritten.\">";
    public static final String umlConstraintCloser = "<BR></ID>";
    private final UmlProject C;
    public static final String TagUUID = "element.uuid";
    public static final String TAG_DOCUMENTATION = "documentation";
    private static final String A = "\n@poseidon-type ";
    private static final String B = "\n";

    public UmlDocumentationManager(UmlProject umlProject) {
        this.C = umlProject;
    }

    protected UmlProject getProject() {
        return this.C;
    }

    public static boolean documentAuthors() {
        Configuration configuration = Services.getInstance().getConfiguration();
        return configuration.getBoolean(DialogController.DOCUMENT_AUTHORS, true);
    }

    public String getHTMLDocs(Object object, String string) {
        return this.getHTMLDocs(object, true, string);
    }

    public String getHTMLDocs(Object object, boolean bl, String string) {
        String string2 = "";
        if (!this.getProject().getDiAccessory().isModelElementStillValid((RefObject)object)) {
            return string2;
        }
        if (object instanceof ModelElement || object instanceof Diagram) {
            string2 = this.getDocsOrNull(object);
            if (string2 != null) {
                if (!string2.startsWith("<p")) {
                    string2 = this.checkHTMLFormat(string2);
                }
                Services.logDebug((Object)("[DocumentationManager.getHTMLDocs].retval=" + string2));
                if (string2.indexOf("*/") > -1) {
                    string2 = this.freeOfDocEnds(string2);
                }
            } else {
                string2 = this.defaultHTMLFor(object);
            }
        }
        String string3 = "";
        if (bl) {
            string3 = this.getHTMLJavaDocTags(object);
        }
        String string4 = string2 + string3;
        if (string != null) {
            String string5 = A + string + B;
            string4 = string4 + string5;
        }
        return string4;
    }

    public String getHTMLJavaDocTags(Object object) {
        String string = this.getFormattedThrowsTags(object);
        String string2 = this.getFormattedParamTags(object);
        String string3 = this.getFormattedJavaDocTags(object);
        return string + string2 + string3;
    }

    public String getFormattedParamTags(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Operation) {
            stringBuffer.append(B);
            Operation operation = (Operation)object;
            Iterator iterator = operation.getParameter().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                Classifier classifier = parameter.getType();
                if (classifier == null || "void".equals(classifier.getName())) continue;
                String string = this.getProject().getUml1SmAccessory().getTaggedValue(parameter, TAG_DOCUMENTATION);
                String string2 = "param " + parameter.getName();
                if (parameter.getKind() == ParameterDirectionKindEnum.PDK_RETURN) {
                    boolean bl = this.C.getUml1SmAccessory().isConstructor(operation);
                    if (bl) continue;
                    string2 = "return";
                }
                stringBuffer.append(this.A(string2, UmlDocumentationManager.stripHTMLIntroAndExtro(string)));
            }
        }
        return new String(stringBuffer);
    }

    public String getFormattedThrowsTags(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Operation) {
            stringBuffer.append(B);
            Uml1SmAccessory uml1SmAccessory = this.C.getUml1SmAccessory();
            Operation operation = (Operation)object;
            List list = Uml1SmAccessory.getThrownExceptions(operation);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                UmlException umlException = (UmlException)iterator.next();
                Classifier classifier = (Classifier)umlException.getNamespace();
                boolean bl = !Uml1SmAccessory.hasStereotype(umlException, "gentleware-type-unqualified");
                String string2 = classifier.getName();
                if (bl) {
                    string = uml1SmAccessory.generateFullyQualifiedJavaName(classifier);
                    if (!string.equals("java.lang." + string2)) {
                        string2 = string;
                    }
                } else {
                    string2 = classifier.getName();
                }
                string = this.getProject().getUml1SmAccessory().getTaggedValue(umlException, TAG_DOCUMENTATION);
                String string3 = "throws " + string2;
                stringBuffer.append(this.A(string3, UmlDocumentationManager.stripHTMLIntroAndExtro(string)));
            }
        }
        return new String(stringBuffer);
    }

    public String getFormattedJavaDocTags(Object object) {
        List list;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ModelElement && (list = JavaDocTagProvider.getPureJavaDocTags()) != null) {
            JavaDocTagDocumentationList javaDocTagDocumentationList = new JavaDocTagDocumentationList(list);
            javaDocTagDocumentationList.setAccessory(this.getProject().getUml1SmAccessory());
            javaDocTagDocumentationList.update((ModelElement)object);
            for (int j = 0; j < javaDocTagDocumentationList.size(); ++j) {
                String string = javaDocTagDocumentationList.getTag(j);
                String string2 = javaDocTagDocumentationList.getDocumentation(j);
                stringBuffer.append(this.A(string, string2));
            }
        }
        return new String(stringBuffer);
    }

    private String A(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return new String("\n@" + string + " " + string2);
    }

    public static String stripHTMLIntroAndExtro(String string) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("^(?:<p>[\n]*)+(.*?)(?:[\n]*</p>)++[\n]*$", 32);
        String string2 = null;
        if (string != null && (matcher = pattern.matcher(string)).matches()) {
            try {
                string2 = matcher.group(1);
            }
            catch (IllegalStateException illegalStateException) {
                Services.logInfo((Object)("[UmlDocumentationManager]: No Match: " + pattern.pattern() + " - " + string));
                string2 = null;
            }
        }
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getDocsOrNull(Object object) {
        String string;
        Object object2;
        if (object instanceof ModelElement && this.getProject().getDiAccessory().isModelElementStillValid((RefObject)object)) {
            object2 = (ModelElement)object;
            string = null;
            try {
                string = this.C.getUml1SmAccessory().getTaggedValue((ModelElement)object2, TAG_DOCUMENTATION);
            }
            catch (NullPointerException nullPointerException) {
                Services.logError((Object)("Tagged value read error: model element " + object2.getName() + " id " + object2.refMofId()));
            }
            if (string != null) {
                return string;
            }
        }
        if (object instanceof Diagram) {
            object2 = (DiagramImpl)object;
            string = this.getProject().getStyle().getDocumentation().get((LayoutableElement)object2);
            return string;
        }
        return null;
    }

    public void setDocs(Object object, String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getFormattedDocumentation(string);
        if (object instanceof Diagram) {
            DiagramImpl diagramImpl = (DiagramImpl)object;
            diagramImpl.setProperty((Project)this.C, TAG_DOCUMENTATION, string2);
        } else {
            ModelElement modelElement = (ModelElement)object;
            this.C.getSmHelpers().setTaggedValue(modelElement, TAG_DOCUMENTATION, string2);
        }
    }

    public String getFormattedDocumentation(String string) {
        if (null == string) {
            return "";
        }
        if (string.indexOf("/**") >= 0) {
            string = UmlDocumentationManager.stripBodyEnclosure((String)UmlDocumentationManager.stripLeadingAsterisks((String)string));
        }
        string = this.B(string);
        String string2 = this.removeConstraints(this.removeNotes(this.removeObjectID(string)));
        return string2;
    }

    private String B(String string) {
        if (string == null) {
            return null;
        }
        int n = B.length();
        int n2 = string.indexOf(A);
        if (n2 == -1) {
            return string;
        }
        String string2 = string.substring(0, n2);
        int n3 = string.indexOf(B, n2 + 3);
        if (n3 == -1) {
            return string2;
        }
        int n4 = n3 + n;
        String string3 = string.substring(n4);
        String string4 = string2 + string3;
        return string4;
    }

    private String A(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n + string2.length());
        int n3 = string.indexOf(string4, n2 + string3.length()) + string4.length();
        if (n == -1 || n2 == -1 || n3 < string4.length()) {
            return string;
        }
        if (n3 + 2 < string.length() && string.charAt(n3 + 1) == '\n') {
            ++n3;
        }
        String string5 = string.substring(0, n);
        String string6 = string.substring(n3);
        return this.A(string5 + string6, string2, string3, string4);
    }

    protected String removeNotes(String string) {
        return this.A(string, umlNoteOpenerPre, "] \">", "<BR></ID>");
    }

    protected String removeConstraints(String string) {
        return this.A(string, umlConstraintOpenerPre, "] \">", "<BR></ID>");
    }

    protected List javadocToConstraintsVector(String string) {
        List list = CollectionFactory.createArrayList();
        int n = 0;
        int n2 = string.indexOf("] \">", 0);
        while (n2 > -1) {
            int n3 = string.indexOf("<BR></ID>", n);
            if (n3 > n2) {
                String string2 = string.substring(n2 + "] \">".length(), n3);
                list.add(string2);
            }
            n = n3 + "<BR></ID>".length();
            n2 = string.indexOf("] \">", n);
        }
        return list;
    }

    protected String defaultHTMLFor(Object object) {
        return this.defaultBodyFor(object);
    }

    protected String defaultBodyFor(Object object) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        if (object instanceof Attribute) {
            stringBuffer.append("Represents ...");
        }
        if (object instanceof Operation) {
            stringBuffer.append("Does ...");
        }
        return new String("<p>" + stringBuffer + "</p>");
    }

    protected String getBareNotes(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ModelElement) {
            Collection collection = ((ModelElement)object).getComment();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CommentImpl commentImpl = (CommentImpl)iterator.next();
                boolean bl = commentImpl.hasStereotype("gentleware-source-code-comment") || commentImpl.hasStereotype("gentleware-source-file-comment");
                if (bl) continue;
                this.getBareNotesHook(stringBuffer, commentImpl);
            }
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }

    protected void getBareNotesHook(StringBuffer stringBuffer, Comment comment) {
        if (comment.getBody() != null) {
            stringBuffer.append(comment.getBody() + B);
        } else {
            stringBuffer.append(B);
        }
    }
}

