/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator;

import com.gentleware.poseidon.generator.ElementPreparator;
import com.gentleware.poseidon.generator.PreparedElement;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.model_management.DocumentationManager;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.omg.uml.foundation.core.AssociationEnd;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;

public class PreparedModelElement
extends PreparedElement {
    public static final String KEY_TYPE_UNORDERED_MULTI = Services.getInstance().getConfiguration().makeKey("codeGen", "java", "unorderedMultiplicity");
    public static final String KEY_TYPE_ORDERED_MULTI = Services.getInstance().getConfiguration().makeKey("codeGen", "java", "orderedMultiplicity");
    public static final String KEY_TYPE_SORTED_MULTI = Services.getInstance().getConfiguration().makeKey("codeGen", "java", "sortedMultiplicity");
    protected static final String DOCUMENTATION_TAG_NAME = "documentation";

    public UmlProject getProject() {
        return (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
    }

    public String getDocs() {
        UmlProject umlProject = this.getProject();
        DocumentationManager documentationManager = umlProject.getDocumentationManager();
        Object object = this.getElement();
        return documentationManager.getDocAndNotes(object);
    }

    public String getParsedDocs() {
        return this.getProject().getDocumentationManager().getHTMLDocs(this.getElement(), null);
    }

    public String getPlainDocs() {
        String string = this.getProject().getUml1SmAccessory().getTaggedValue((ModelElement)this.getElement(), DOCUMENTATION_TAG_NAME);
        if (string != null && !"".equals(string)) {
            Services.logDebug((Object)("getPlainDocs: docTaggedVal=" + string));
            return string;
        }
        return "";
    }

    public PreparedElement getPreparedParent() {
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return null;
        }
        Namespace namespace = this.getProject().getUml1SmAccessory().getNamespace((ModelElement)object);
        if (namespace != null) {
            return (PreparedModelElement)this.getPreparator().getPreparedElement((Object)namespace);
        }
        return null;
    }

    public String getPath(boolean bl, boolean bl2, String string) {
        List list = this.getNamespaceList(bl, bl2);
        String string2 = "";
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            String string3 = PreparedElement.replaceIllegalChars((String)((String)list.get(j)));
            string2 = string2 + string3 + string;
        }
        return string2;
    }

    public String getPathAsString(boolean bl, boolean bl2) {
        List list = this.getNamespaceList(bl, bl2);
        String string = "";
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            String string2 = PreparedElement.replaceIllegalChars((String)((String)list.get(j)));
            string = j < n - 1 ? string + string2 + "_" : string + string2;
        }
        return string;
    }

    public String getNameOfElementAsString(Object object) {
        return this.getNameOfElementAsString(object, false);
    }

    protected String getNameOfElementAsString(Object object, boolean bl) {
        if (!(object instanceof ModelElement)) {
            return "";
        }
        ModelElement modelElement = (ModelElement)object;
        if (modelElement.getName() != null) {
            StringBuffer stringBuffer = new StringBuffer(modelElement.getName());
            if (modelElement instanceof Classifier) {
                String string;
                Uml1SmAccessory uml1SmAccessory = this.getProject().getUml1SmAccessory();
                Namespace namespace = uml1SmAccessory.getNamespace(modelElement);
                while (namespace instanceof Classifier) {
                    stringBuffer.insert(0, namespace.getName() + ".");
                    namespace = this.getProject().getUml1SmAccessory().getNamespace(namespace);
                }
                if (bl && !"".equals(string = uml1SmAccessory.generateJavaPackageName(modelElement)) && !"java.lang".equals(string)) {
                    stringBuffer.insert(0, string + ".");
                }
            }
            return PreparedModelElement.getNameAsString((String)stringBuffer.toString());
        }
        return "";
    }

    public String check() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.checkName());
        stringBuffer.append(this.checkVisibility());
        return stringBuffer.toString();
    }

    protected String checkName() {
        String string = "";
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return string;
        }
        ModelElement modelElement = (ModelElement)object;
        String string2 = modelElement.getName();
        if (string2 == null || string2.equals("")) {
            string = "Illegal name (empty) of model element " + modelElement + "\n";
        } else if (string2.indexOf(92) > 0 || string2.indexOf(47) > 0) {
            string = string + "Element name contains file separator characters [e.g. /, \\]: " + string2 + "\n";
        } else {
            String string3 = this.getNameAsString();
            if (!string3.endsWith(string2)) {
                string = string + "  Element '" + string2 + "' contains illegal characters, it will be generated as '" + string3 + "'.\n    Generating this element and re-importing it may lead to duplicates.\n";
            }
        }
        return string;
    }

    public String getVisibilityAsString() {
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return "";
        }
        ModelElement modelElement = (ModelElement)object;
        if (modelElement.getVisibility() != null && modelElement.getVisibility().toString() != null) {
            String string = modelElement.getVisibility().toString();
            if (string.equals("vk_package")) {
                return "";
            }
            if (string.startsWith("vk_")) {
                string = string.substring(3);
            }
            return string + " ";
        }
        return "";
    }

    public List getNamespaceList(boolean bl, boolean bl2) {
        if (!(this.getElement() instanceof ModelElement)) {
            return CollectionFactory.createArrayList();
        }
        List list = this.getParentNamespaces((ModelElement)this.getElement());
        List list2 = CollectionFactory.createArrayList();
        int n = bl ? list.size() - 1 : list.size() - 2;
        for (int j = n; j >= 0; --j) {
            String string = PreparedModelElement.getNameAsString((String)((Namespace)list.get(j)).getName());
            list2.addAll(this.parseNamespace(string));
        }
        if (bl2) {
            list2.addAll(this.parseNamespace(this.getNameAsString("", "")));
        }
        return list2;
    }

    public String getRelativePathToModel(boolean bl, boolean bl2, String string) {
        List list = this.getNamespaceList(bl, bl2);
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("..");
            stringBuffer.append(string);
            iterator.next();
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(".");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public int getNamespaceHierarchyPosition() {
        List list = this.getNamespaceList(false, false);
        int n = list.size();
        return n;
    }

    public String checkVisibility() {
        return "";
    }

    public String getNamespaceListAsString(boolean bl, boolean bl2, String string) {
        List list = this.getNamespaceList(bl, bl2);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getTaggedValue(String string) {
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return null;
        }
        return this.getProject().getUml1SmAccessory().getTaggedValue((ModelElement)object, string);
    }

    public List parseNamespace(String string) {
        String string2 = ".";
        List list = CollectionFactory.createArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreElements()) {
            while (stringTokenizer.hasMoreElements()) {
                String string3 = PreparedModelElement.getNameAsString((String)stringTokenizer.nextToken());
                list.add(string3);
            }
        } else {
            list.add(string);
        }
        return list;
    }

    public List getParentNamespaces(ModelElement modelElement) {
        Uml1SmAccessory uml1SmAccessory = this.getProject().getUml1SmAccessory();
        List list = uml1SmAccessory.getNamespaces(modelElement);
        return list;
    }

    public void init(Object object, ElementPreparator elementPreparator) {
        this.setElement(object);
        this.setPreparator(elementPreparator);
    }

    public static String addLinePrefix(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Cannot use null as prefix in addLinePrefix.");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, string2);
        }
        for (int j = stringBuffer.length() - 2; j > 0; --j) {
            if (stringBuffer.charAt(j) != '\n') continue;
            stringBuffer.insert(j + 1, string2);
        }
        return stringBuffer.toString();
    }

    public final boolean isOperation() {
        return this.getElement() instanceof Operation;
    }

    public final boolean isAttribute() {
        return this.getElement() instanceof Attribute;
    }

    public final boolean isAssociationEnd() {
        return this.getElement() instanceof AssociationEnd;
    }

    public final boolean isClassifier() {
        return this.getElement() instanceof Classifier;
    }

    public final boolean isComment() {
        return this.getElement() instanceof Comment;
    }
}

