/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator;

import com.gentleware.poseidon.ProfileJava;
import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.generator.ModelElementPreparator;
import com.gentleware.poseidon.uml.generator.PreparedFeature;
import com.gentleware.poseidon.uml.generator.PreparedParameter;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.omg.uml.behavioralelements.commonbehavior.UmlException;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.CallConcurrencyKindEnum;
import org.omg.uml.foundation.datatypes.ScopeKindEnum;

public class PreparedOperation
extends PreparedFeature {
    public static final String STEREOTYPE_INITIALIZER = "initializer";
    public static final String ABSTRACT_STRING = "abstract ";
    public static final String FINAL_STRING = "final ";
    public static final String STATIC_STRING = "static ";
    public static final String SYNCHRONIZED_STRING = "synchronized ";
    public static final String THROWS_STRING = " throws ";
    public static final String NULL_STRING = "null";
    public static final String VOID_STRING = "void";
    protected static final String COMMA_SEPARATOR = ", ";
    private List k;
    private PreparedParameter m;
    private List n = CollectionFactory.createArrayList();
    private static final Map l = CollectionFactory.createHashMap();

    public void init(Operation operation, ModelElementPreparator modelElementPreparator) {
        try {
            super.init(operation, modelElementPreparator);
            if (!this.isAbstract()) {
                this.k = this.Q();
            }
            this.P();
        }
        catch (PreparationException preparationException) {
            Services.logError((Object)"Exception caught while preparing operation!", (Throwable)preparationException);
        }
    }

    public List getPreparedParameters() {
        return this.n;
    }

    public boolean isAbstract() {
        if (!(this.getElement() instanceof Operation)) {
            return false;
        }
        return ((Operation)this.getElement()).isAbstract();
    }

    public boolean isNative() {
        String string;
        if (!(this.getElement() instanceof Operation)) {
            return false;
        }
        try {
            string = this.getTaggedValue("native");
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return string != null && "true".equals(string.toLowerCase());
    }

    public String getAbstractAsString() {
        if (this.isAbstract()) {
            return ABSTRACT_STRING;
        }
        return "";
    }

    public String getNativeAsString() {
        String string = null;
        try {
            string = this.getTaggedValue("native");
        }
        catch (NullPointerException nullPointerException) {
            Services.logError((Object)("Tagged value read error: operation " + this.getNameAsString()));
        }
        if (string == null) {
            return "";
        }
        if ("true".equals(string)) {
            return "native ";
        }
        return "";
    }

    public String getStrictfpAsString() {
        String string = null;
        try {
            string = this.getTaggedValue("strictfp");
        }
        catch (NullPointerException nullPointerException) {
            Services.logError((Object)("Tagged value read error: operation " + this.getNameAsString()));
        }
        if (string == null) {
            return "";
        }
        if ("true".equals(string)) {
            return "strictfp ";
        }
        return "";
    }

    public boolean isLeaf() {
        if (!(this.getElement() instanceof Operation)) {
            return false;
        }
        return ((Operation)this.getElement()).isLeaf();
    }

    public String getLeafAsString() {
        if (this.isLeaf()) {
            return FINAL_STRING;
        }
        return "";
    }

    public String getOwnerScopeAsString() {
        if (!(this.getElement() instanceof Operation)) {
            return "";
        }
        if (ScopeKindEnum.SK_CLASSIFIER == ((Operation)this.getElement()).getOwnerScope()) {
            return STATIC_STRING;
        }
        return "";
    }

    public String getConcurrencyAsString() {
        if (!(this.getElement() instanceof Operation)) {
            return "";
        }
        if (CallConcurrencyKindEnum.CCK_GUARDED.equals(((Operation)this.getElement()).getConcurrency())) {
            return SYNCHRONIZED_STRING;
        }
        return "";
    }

    public boolean isInitializer() {
        Object object = this.getElement();
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        return Uml1SmAccessory.hasStereotype(operation, STEREOTYPE_INITIALIZER);
    }

    public String getThrownExceptionsSignature() {
        if (!(this.getElement() instanceof Operation)) {
            return "";
        }
        Operation operation = (Operation)this.getElement();
        List list = Uml1SmAccessory.getThrownExceptions(operation);
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getNameOfElementAsString(operation.getOwner());
        for (int j = 0; j < list.size(); ++j) {
            String string2;
            UmlException umlException = (UmlException)list.get(j);
            boolean bl = !Uml1SmAccessory.hasStereotype(umlException, "gentleware-type-unqualified");
            Namespace namespace = umlException.getNamespace();
            if (namespace == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            if ((string2 = this.getNameOfElementAsString(namespace, bl)).startsWith(string + ".")) {
                string2 = string2.substring(string.length() + 1);
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, THROWS_STRING);
        }
        return stringBuffer.toString();
    }

    public List getPreparedInOutParameters() {
        List list = CollectionFactory.createArrayList((Collection)this.n);
        if (this.m != null) {
            list.remove((Object)this.m);
        }
        return list;
    }

    protected PreparedParameter getReturnParameter() {
        return this.m;
    }

    public String getReturnParameterSignature() {
        if (this.m != null && !this.isConstructor()) {
            if (this.getElement() instanceof Operation) {
                Operation operation = (Operation)this.getElement();
                String string = this.getNameOfElementAsString(operation.getOwner());
                return this.m.getSignature(string);
            }
            return this.m.getSignature();
        }
        return "";
    }

    public String getParametersSignature() {
        String string = this.getNameOfElementAsString(((Operation)this.getElement()).getOwner());
        List list = this.getPreparedInOutParameters();
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < list.size(); ++j) {
            if (j > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            PreparedParameter preparedParameter = (PreparedParameter)((Object)list.get(j));
            String string2 = preparedParameter.getSignature(string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getParameterTypes() {
        List list = this.getPreparedInOutParameters();
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < list.size(); ++j) {
            if (j > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            PreparedParameter preparedParameter = (PreparedParameter)((Object)list.get(j));
            stringBuffer.append(preparedParameter.getElementType());
        }
        return stringBuffer.toString();
    }

    public String getParameterNames() {
        List list = this.getPreparedInOutParameters();
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < list.size(); ++j) {
            PreparedParameter preparedParameter = (PreparedParameter)((Object)list.get(j));
            if (j > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            stringBuffer.append(preparedParameter.getNameAsString());
        }
        return stringBuffer.toString();
    }

    public List getMethodBody() {
        return this.k;
    }

    public String getDefaultReturnValue() {
        String string = "";
        if (this.hasReturnType()) {
            String string2 = this.getReturnParameter().getElementType();
            string = (String)PreparedOperation.getJavaDefaultReturnValues().get(string2);
            if (string == null) {
                string = NULL_STRING;
            }
        }
        return string;
    }

    public boolean isConstructor() {
        Object object = this.getElement();
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        UmlProject umlProject = this.getProject();
        Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
        return uml1SmAccessory.isConstructor(operation);
    }

    public boolean isDestructor() {
        Object object = this.getElement();
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        UmlProject umlProject = this.getProject();
        Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
        return uml1SmAccessory.isDestructor(operation);
    }

    public boolean hasReturnType() {
        String string;
        return !this.isConstructor() && this.m != null && !(string = this.m.getSignature()).equals("") && !string.equals(VOID_STRING);
    }

    public boolean isAccessorFor(String string) {
        if (string == null) {
            return false;
        }
        Attribute attribute = this.getProject().getAccessorMethodsHelper().getAccessedAttribute((Operation)this.getElement());
        if (attribute == null) {
            return false;
        }
        return string.equals(attribute.getName());
    }

    public PreparedParameter getPreparedReturnParameter() {
        return this.m;
    }

    protected void addPreparedParameter(PreparedParameter preparedParameter) {
        this.n.add(preparedParameter);
    }

    protected void setPreparedReturnParameter(PreparedParameter preparedParameter) {
        this.m = preparedParameter;
    }

    private void P() throws PreparationException {
        List list = ((Operation)this.getElement()).getParameter();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter == null) continue;
            PreparedParameter preparedParameter = (PreparedParameter)this.getPreparator().prepare((Object)parameter);
            if (preparedParameter.isReturnParameter()) {
                this.setPreparedReturnParameter(preparedParameter);
            }
            this.n.add(preparedParameter);
        }
    }

    private List Q() {
        List list = CollectionFactory.createArrayList();
        if (!(this.getElement() instanceof Operation)) {
            return list;
        }
        String string = this.getProject().getUml1SmAccessory().getMethodBody((Operation)this.getElement(), this.getLanguageKey());
        String string2 = "\n\r";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        int n = 999;
        while (stringTokenizer.hasMoreElements()) {
            int n2;
            String string3 = stringTokenizer.nextToken();
            for (n2 = 0; n2 < string3.length() && string3.charAt(n2) == ' '; ++n2) {
            }
            n = Math.min(n, n2);
            list.add(string3);
        }
        for (int j = 0; j < list.size(); ++j) {
            list.set(j, ((String)list.get(j)).substring(n));
        }
        return list;
    }

    protected String getLanguageKey() {
        return ProfileJava.getJavaLowercase();
    }

    public static Map getJavaDefaultReturnValues() {
        if (l.isEmpty()) {
            l.put("int", "0");
            l.put("char", "\"\"");
            l.put("boolean", "false");
            l.put("byte", "0");
            l.put("long", "0");
            l.put("float", "0.0");
            l.put("double", "0.0");
        }
        return l;
    }
}

