/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator;

import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.generator.ModelElementPreparatorImpl;
import com.gentleware.poseidon.uml.generator.PreparedAssociationClass;
import com.gentleware.poseidon.uml.generator.PreparedAssociationEnd;
import com.gentleware.poseidon.uml.generator.PreparedAttribute;
import com.gentleware.poseidon.uml.generator.PreparedClassifier;
import com.gentleware.poseidon.uml.generator.PreparedComment;
import com.gentleware.poseidon.uml.generator.PreparedModelElement;
import com.gentleware.poseidon.uml.generator.PreparedOperation;
import com.gentleware.poseidon.uml.generator.PreparedPackage;
import com.gentleware.poseidon.uml.generator.PreparedParameter;
import com.gentleware.poseidon.uml.generator.StaticElementPreparator;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.util.List;
import java.util.Map;
import org.omg.uml.foundation.core.AssociationClass;
import org.omg.uml.foundation.core.AssociationEnd;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.modelmanagement.Model;
import org.omg.uml.modelmanagement.UmlPackage;

public class StaticElementPreparatorImpl
extends ModelElementPreparatorImpl
implements StaticElementPreparator {
    private Map G;
    private Map H;

    public StaticElementPreparatorImpl() {
        this.init();
        this.G = CollectionFactory.createHashMap();
        this.H = CollectionFactory.createHashMap();
    }

    public boolean canHandlePrimaryAndSecondaryClasses() {
        return true;
    }

    public PreparedPackage preparePackage(UmlPackage umlPackage) throws PreparationException {
        if (umlPackage == null) {
            throw new PreparationException("package to prepare is null", (Object)umlPackage);
        }
        PreparedPackage preparedPackage = (PreparedPackage)this.getPreparedElementInstance(umlPackage);
        if (preparedPackage != null) {
            preparedPackage.init(umlPackage, this);
        }
        return preparedPackage;
    }

    public PreparedComment prepareComment(Comment comment) throws PreparationException {
        if (comment == null) {
            throw new PreparationException("comment to prepare is null", (Object)comment);
        }
        PreparedComment preparedComment = (PreparedComment)this.getPreparedElementInstance(comment);
        if (preparedComment != null) {
            preparedComment.init(comment, this);
        }
        return preparedComment;
    }

    public PreparedClassifier prepareClassifier(Classifier classifier) throws PreparationException {
        if (classifier == null) {
            throw new PreparationException("classifier to prepare is null", (Object)classifier);
        }
        this.G = CollectionFactory.createHashMap();
        this.H = CollectionFactory.createHashMap();
        PreparedClassifier preparedClassifier = (PreparedClassifier)this.getPreparedElementInstance(classifier);
        if (preparedClassifier != null) {
            preparedClassifier.init(classifier, this);
        }
        return preparedClassifier;
    }

    public PreparedClassifier prepareClassifier(Classifier classifier, List list) throws PreparationException {
        if (classifier == null) {
            throw new PreparationException("classifier to prepare is null", (Object)classifier);
        }
        this.G = CollectionFactory.createHashMap();
        this.H = CollectionFactory.createHashMap();
        PreparedClassifier preparedClassifier = (PreparedClassifier)this.getPreparedElementInstance(classifier);
        if (preparedClassifier != null) {
            preparedClassifier.init(classifier, this, list);
        }
        this.addPreparedElement(classifier, preparedClassifier);
        return preparedClassifier;
    }

    public PreparedModelElement prepareAssociationClass(AssociationClass associationClass) throws PreparationException {
        if (associationClass == null) {
            throw new PreparationException("association class to prepare is null", (Object)associationClass);
        }
        PreparedAssociationClass preparedAssociationClass = (PreparedAssociationClass)this.getPreparedElementInstance(associationClass);
        if (preparedAssociationClass != null) {
            preparedAssociationClass.init(associationClass, this);
        }
        return preparedAssociationClass;
    }

    public PreparedAttribute prepareAttribute(Attribute attribute) throws PreparationException {
        if (attribute == null) {
            throw new PreparationException("attribute to prepare is null", (Object)attribute);
        }
        PreparedAttribute preparedAttribute = (PreparedAttribute)this.getPreparedElementInstance(attribute);
        if (preparedAttribute != null) {
            preparedAttribute.init(attribute, this);
        }
        return preparedAttribute;
    }

    public PreparedAssociationEnd prepareAssociationEnd(AssociationEnd associationEnd) throws PreparationException {
        if (associationEnd == null) {
            throw new PreparationException("assocEnd to prepare is null", (Object)associationEnd);
        }
        PreparedAssociationEnd preparedAssociationEnd = (PreparedAssociationEnd)this.getPreparedElementInstance(associationEnd);
        if (preparedAssociationEnd != null) {
            int n = this.A(associationEnd);
            preparedAssociationEnd.init(associationEnd, this, n);
        }
        AssociationEnd associationEnd2 = null;
        try {
            associationEnd2 = this.getProject().getUml1SmAccessory().getOppositeEnd(associationEnd);
        }
        catch (IllegalStateException illegalStateException) {
            Services.logInfo((Object)("association from " + associationEnd.getParticipant() + " has a broken association: " + associationEnd));
            Services.logInfo((Object)("offending association: " + associationEnd.getAssociation().refMofId()));
        }
        if (associationEnd2 == null) {
            throw new PreparationException("association end to prepare is null", (Object)associationEnd2);
        }
        if (associationEnd2.getParticipant() == null) {
            throw new PreparationException("type of associationEnd to prepare is null", (Object)associationEnd2);
        }
        PreparedAssociationEnd preparedAssociationEnd2 = (PreparedAssociationEnd)this.getPreparedElementInstance(associationEnd2);
        if (preparedAssociationEnd2 == null) {
            Services.logError((Object)("[" + this.getClass().getName() + "] prepared opposite end of association is null!"));
            throw new PreparationException("prepared opposite end of association is null!", (Object)associationEnd2);
        }
        int n = this.A(associationEnd, associationEnd2);
        preparedAssociationEnd2.init(associationEnd2, this, n);
        preparedAssociationEnd2.setPreparedOppositeEnd(preparedAssociationEnd);
        preparedAssociationEnd.setPreparedOppositeEnd(preparedAssociationEnd2);
        return preparedAssociationEnd;
    }

    public PreparedOperation prepareOperation(Operation operation) throws PreparationException {
        if (operation == null) {
            throw new PreparationException("operation to prepare is null", (Object)operation);
        }
        PreparedOperation preparedOperation = (PreparedOperation)this.getPreparedElementInstance(operation);
        if (preparedOperation != null) {
            preparedOperation.init(operation, this);
        }
        return preparedOperation;
    }

    public PreparedParameter prepareParameter(Parameter parameter) throws PreparationException {
        if (parameter == null) {
            throw new PreparationException("parameter to prepare is null", (Object)parameter);
        }
        PreparedParameter preparedParameter = (PreparedParameter)this.getPreparedElementInstance(parameter);
        if (preparedParameter != null) {
            preparedParameter.init(parameter, this);
        }
        return preparedParameter;
    }

    public PreparedModelElement prepare(ModelElement modelElement) throws PreparationException {
        if (modelElement == null) {
            throw new PreparationException("model element to prepare is null", (Object)modelElement);
        }
        PreparedModelElement preparedModelElement = null;
        try {
            if (modelElement instanceof UmlPackage) {
                UmlPackage umlPackage = (UmlPackage)modelElement;
                preparedModelElement = this.preparePackage(umlPackage);
                if (modelElement instanceof Model) {
                    this.setPreparedModel((PreparedPackage)preparedModelElement);
                }
            } else if (modelElement instanceof AssociationClass) {
                AssociationClass associationClass = (AssociationClass)modelElement;
                preparedModelElement = this.prepareAssociationClass(associationClass);
            } else if (modelElement instanceof Classifier) {
                Classifier classifier = (Classifier)modelElement;
                if (this.canHandlePrimaryAndSecondaryClasses()) {
                    UmlProject umlProject = this.getProject();
                    Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
                    boolean bl = uml1SmAccessory.isClassifierSecondaryClass(classifier);
                    if (bl) {
                        preparedModelElement = this.prepareClassifier(classifier);
                    } else {
                        List list = uml1SmAccessory.getSecondaryClasses(classifier);
                        preparedModelElement = this.prepareClassifier(classifier, list);
                    }
                } else {
                    preparedModelElement = this.prepareClassifier(classifier);
                }
            } else if (modelElement instanceof Attribute) {
                Attribute attribute = (Attribute)modelElement;
                preparedModelElement = this.prepareAttribute(attribute);
            } else if (modelElement instanceof Operation) {
                Operation operation = (Operation)modelElement;
                preparedModelElement = this.prepareOperation(operation);
            } else if (modelElement instanceof AssociationEnd) {
                AssociationEnd associationEnd = (AssociationEnd)modelElement;
                preparedModelElement = this.prepareAssociationEnd(associationEnd);
            } else if (modelElement instanceof Parameter) {
                Parameter parameter = (Parameter)modelElement;
                preparedModelElement = this.prepareParameter(parameter);
            } else if (modelElement instanceof Comment) {
                Comment comment = (Comment)modelElement;
                preparedModelElement = this.prepareComment(comment);
            } else {
                Services.logError((Object)("No prepared element registered for class " + modelElement.getClass().getName()));
                Services.logError((Object)("Problematic element is: " + modelElement.getName()));
            }
            this.addPreparedElement(modelElement, preparedModelElement);
        }
        catch (PreparationException preparationException) {
            Services.logError((Object)("[" + this.getClass().getName() + "] caught exception during preparation of " + modelElement), (Throwable)preparationException);
            preparedModelElement = null;
        }
        return preparedModelElement;
    }

    private int A(AssociationEnd associationEnd) {
        int n = 0;
        if ((associationEnd.getName() == null || associationEnd.getName().trim().equals("")) && associationEnd.getParticipant() != null) {
            Integer n2 = (Integer)this.G.get(associationEnd.getParticipant());
            if (n2 == null) {
                this.G.put(associationEnd.getParticipant(), new Integer(0));
                n = 0;
            } else {
                this.G.remove(associationEnd.getParticipant());
                n = n2 + 1;
                this.G.put(associationEnd.getParticipant(), new Integer(n));
            }
        }
        return n;
    }

    private int A(AssociationEnd associationEnd, AssociationEnd associationEnd2) {
        int n = 0;
        if ((associationEnd2.getName() == null || associationEnd2.getName().trim().equals("")) && associationEnd2.getParticipant() != null) {
            Integer n2 = (Integer)this.H.get(associationEnd.getParticipant());
            if (n2 == null) {
                this.H.put(associationEnd.getParticipant(), new Integer(0));
                n = 0;
            } else {
                this.H.remove(associationEnd.getParticipant());
                n = n2 + 1;
                this.H.put(associationEnd.getParticipant(), new Integer(n));
            }
        }
        return n;
    }
}

