/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator.ui;

import com.gentleware.poseidon.ui.CheckNode;
import com.gentleware.services.IconLoader;
import com.gentleware.services.Services;
import com.gentleware.services.util.CollectionFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import org.omg.uml.foundation.core.ModelElement;

public class UMLClassesTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected Map _iconCache = CollectionFactory.createHashMap();
    protected JLabel label;
    protected JCheckBox check;

    public UMLClassesTreeCellRenderer() {
        this.setLayout(null);
        this.check = new JCheckBox();
        this.add(this.check);
        this.label = new JLabel();
        this.add(this.label);
        this.check.setBackground(UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(UIManager.getColor("Color.Black"));
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        String string;
        CheckNode checkNode = (CheckNode)object;
        this.setEnabled(jTree.isEnabled());
        this.check.setSelected(checkNode.isSelected());
        this.label.setFont(jTree.getFont());
        Icon icon = (Icon)this._iconCache.get(checkNode.getUserObject().getClass());
        if (icon == null && (string = (object2 = checkNode.getUserObject()).getClass().getName()).startsWith("org")) {
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            if (string2.startsWith("UML")) {
                string2 = string2.substring(3);
            }
            if (string2.endsWith("$Impl")) {
                string2 = string2.substring(0, string2.length() - 5);
            }
            if ("UmlClass".equals(string2)) {
                string2 = "Class";
            } else if ("UmlAssociation".equals(string2)) {
                string2 = "Association";
            } else if ("UmlException".equals(string2)) {
                string2 = "Exception";
            } else if ("UmlPackage".equals(string2)) {
                string2 = "Package";
            }
            String string3 = string2;
            IconLoader iconLoader = Services.getInstance().getIconLoader();
            icon = iconLoader.get(string3, "", this.getClass().getClassLoader());
            if (icon != null) {
                this._iconCache.put(object.getClass(), icon);
            }
        }
        if (icon != null) {
            this.label.setIcon(icon);
        }
        if (checkNode.getUserObject() instanceof ModelElement) {
            this.label.setText(((ModelElement)checkNode.getUserObject()).getName());
        }
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.check.getPreferredSize();
        Dimension dimension2 = this.label.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
    }

    public void doLayout() {
        Dimension dimension = this.check.getPreferredSize();
        Dimension dimension2 = this.label.getPreferredSize();
        int n = 0;
        int n2 = 0;
        if (dimension.height < dimension2.height) {
            n = (dimension2.height - dimension.height) / 2;
        } else {
            n2 = (dimension.height - dimension2.height) / 2;
        }
        this.check.setLocation(0, n);
        this.check.setBounds(0, n, dimension.width, dimension.height);
        this.label.setLocation(dimension.width, n2);
        this.label.setBounds(dimension.width, n2, dimension2.width, dimension2.height);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }
}

