/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator.util;

import com.gentleware.poseidon.generator.PreparedElement;
import com.gentleware.poseidon.generator.ui.DialogController;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.uml.UmlDocumentationManager;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.generator.PreparedModelElement;
import com.gentleware.poseidon.uml.generator.util.JavaDocHelper;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.poseidon.uml.ui.documentation.A.A;
import com.gentleware.services.Services;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.util.Strings;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmi.reflect.RefObject;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.DataType;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.modelmanagement.Model;

public class HTMLHelper {
    private static String B = "java/";
    private static final Pattern C = Pattern.compile("^(.+?(?:(?=\\<\\/?(?:address|blockquote|br|dir|div|dl|h[1-6]|hr|ol|p|pre|table|ul)\\b[^\\>]*\\>)|\\.(?=\\s|$))).*", 42);
    private static HTMLHelper A = new HTMLHelper();

    private HTMLHelper() {
    }

    public static HTMLHelper getInstance() {
        return A;
    }

    public String getTagIndentationString(String string, int n, int n2) {
        int n3 = n2 - n;
        if (n3 == 0) {
            return "";
        }
        String string2 = "<" + (n3 > 0 ? "" : "/") + string + ">";
        n3 = Math.abs(n3);
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < n3; ++j) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getParsedUMLDoc(String string) {
        return this.getParsedUMLDoc(null, string);
    }

    public String getParsedUMLDoc(PreparedElement preparedElement, String string) {
        if (string == null) {
            return "";
        }
        String string2 = new A().A(string);
        if (preparedElement instanceof PreparedModelElement) {
            string2 = JavaDocHelper.expandedJavaDocTags(string2, (PreparedModelElement)preparedElement);
        }
        return string2;
    }

    public String getSummaryUMLDoc(PreparedElement preparedElement, String string) {
        String string2 = this.getParsedUMLDoc(preparedElement, string);
        Matcher matcher = C.matcher(string2);
        String string3 = string2;
        if (matcher.matches()) {
            string3 = matcher.group(1);
        }
        return UmlDocumentationManager.stripHTMLIntroAndExtro(string3);
    }

    public String getSummaryUMLDoc(String string) {
        return this.getSummaryUMLDoc(null, string);
    }

    public static void main(String[] stringArray) {
        for (int j = 0; j < stringArray.length; ++j) {
            String string = stringArray[j];
            HTMLHelper hTMLHelper = new HTMLHelper();
            System.out.println("Original: " + string);
            System.out.println("New     : " + hTMLHelper.getSummaryUMLDoc(null, string));
        }
    }

    public String getSpaces(int n) {
        return Strings.repeat((String)"&nbsp;", (int)n);
    }

    public void reverseList(List list) {
        Collections.reverse(list);
    }

    public String getExternLinkBase() {
        Configuration configuration = Services.getInstance().getConfiguration();
        return configuration.getString(DialogController.EXTERNAL_LINK_BASE);
    }

    public String getExternalLinkForType(PreparedModelElement preparedModelElement) {
        return this.getExternLinkBase() + "/" + this.getLinkForType(preparedModelElement);
    }

    public String getLinkForType(PreparedModelElement preparedModelElement) {
        String string = "";
        try {
            if (preparedModelElement != null) {
                Classifier classifier;
                RefObject refObject = (RefObject)preparedModelElement.getElement();
                if (refObject instanceof Attribute) {
                    Attribute attribute = (Attribute)refObject;
                    classifier = attribute.getType();
                } else if (refObject instanceof Parameter) {
                    Parameter parameter = (Parameter)refObject;
                    classifier = parameter.getType();
                } else {
                    Services.logError((Object)("IllegalArgument: expected Attribute or Parameter, get " + refObject));
                    return "";
                }
                if (!(classifier instanceof DataType)) {
                    string = this.A(classifier);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return string;
    }

    public boolean hasExternalLink(PreparedModelElement preparedModelElement) {
        String string = this.getLinkForType(preparedModelElement);
        boolean bl = !"".equals(string) && this.A(string) && this.A();
        return bl;
    }

    private boolean A(String string) {
        return string.indexOf(B) > -1;
    }

    private boolean A() {
        Configuration configuration = Services.getInstance().getConfiguration();
        return configuration.getBoolean(DialogController.GENERATE_EXTERNAL_LINKS, true);
    }

    private String A(Classifier classifier) {
        if (classifier == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        UmlProject umlProject = (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
        Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
        List list = uml1SmAccessory.getNamespaces(classifier);
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Namespace namespace = (Namespace)iterator.next();
            if (namespace instanceof Model) continue;
            stringBuffer.insert(0, string);
            stringBuffer.insert(0, namespace.getName());
            string = "/";
        }
        stringBuffer.append(string);
        stringBuffer.append(classifier.getName());
        stringBuffer.append(".html");
        return stringBuffer.toString();
    }

    public JavaDocHelper getJavaDocHelper(PreparedElement preparedElement) {
        if (preparedElement instanceof PreparedModelElement) {
            PreparedModelElement preparedModelElement = (PreparedModelElement)preparedElement;
            JavaDocHelper javaDocHelper = new JavaDocHelper(preparedModelElement);
            return javaDocHelper;
        }
        Services.logError((Object)"[HTMLHelper]: No JavaDocHelper created, because no ModelElement can be assigned");
        throw new NullPointerException(preparedElement.toString() + " contains no ModelElement");
    }
}

