/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.ui.documentation;

import com.gentleware.jboogie.openapi.MacroCommand;
import com.gentleware.jboogie.openapi.SmId;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.poseidon.uml.model_management.Uml1SmFactory;
import com.gentleware.services.util.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Interface;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.TaggedValue;
import org.omg.uml.foundation.core.UmlClass;
import org.omg.uml.modelmanagement.Model;
import org.omg.uml.modelmanagement.UmlPackage;

public final class JavaDocTagProvider {
    public static final String A = "author";
    public static final String L = "version";
    public static final String R = "exception";
    public static final String P = "throws";
    public static final String H = "see";
    public static final String D = "since";
    private static final String B = "serial";
    private static final String T = "serialField";
    private static final String F = "serialData";
    public static final String N = "deprecated";
    public static final String K = "param";
    public static final String M = "return";
    private static final String V = "link";
    private static final String E = "linkplain";
    private static final String J = "docRoot";
    private static final String S = "inheritDoc";
    private static final String Q = "value";
    public static final char O = '@';
    public static final char U = '#';
    private static final String C = "gentleware-";
    public static final String I = "gentleware-user-defined-java-doc-tags";
    private static SmId G;

    public static List getTags(Object object) {
        List list = null;
        if (object instanceof Operation) {
            list = JavaDocTagProvider.B();
        } else if (object instanceof UmlClass) {
            list = JavaDocTagProvider.A();
        } else if (object instanceof Interface) {
            list = JavaDocTagProvider.E();
        } else if (object instanceof UmlPackage) {
            list = JavaDocTagProvider.C();
        } else if (object instanceof Attribute) {
            list = JavaDocTagProvider.D();
        }
        return list;
    }

    private static List B() {
        List list = CollectionFactory.createArrayList();
        list.add(H);
        list.add(D);
        list.add(N);
        list.add(P);
        list.add(R);
        list.add(F);
        return list;
    }

    public static List getOverviewTags() {
        List list = CollectionFactory.createArrayList();
        list.add(H);
        list.add(D);
        list.add(A);
        list.add(L);
        return list;
    }

    private static List C() {
        List list = CollectionFactory.createArrayList();
        list.add(H);
        list.add(D);
        list.add(N);
        list.add(B);
        list.add(A);
        list.add(L);
        return list;
    }

    private static List A() {
        return JavaDocTagProvider.C();
    }

    private static List E() {
        return JavaDocTagProvider.C();
    }

    private static List D() {
        List list = CollectionFactory.createArrayList();
        list.add(H);
        list.add(D);
        list.add(N);
        list.add(B);
        list.add(T);
        return list;
    }

    public static List getKnownTags() {
        List list = CollectionFactory.createArrayList();
        list.add(A);
        list.add(L);
        list.add(R);
        list.add(P);
        list.add(H);
        list.add(D);
        list.add(B);
        list.add(T);
        list.add(F);
        list.add(N);
        list.add(M);
        list.add(K);
        list.addAll(JavaDocTagProvider.getUserDefinedTags());
        return list;
    }

    public static List getPureJavaDocTags() {
        List list = JavaDocTagProvider.getKnownTags();
        list.remove(M);
        list.remove(K);
        return list;
    }

    public static List getKnownInlineTags() {
        List list = CollectionFactory.createArrayList();
        list.add(V);
        list.add(E);
        list.add(J);
        list.add(S);
        list.add(Q);
        return list;
    }

    public static List getUserDefinedTags() {
        List list = CollectionFactory.createArrayList();
        UmlProject umlProject = (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
        if (umlProject != null) {
            Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
            Collection collection = umlProject.getModels();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Model model = (Model)iterator.next();
                TaggedValue taggedValue = uml1SmAccessory.getTaggedValueSingle(model, I);
                if (taggedValue == null) continue;
                Collection collection2 = taggedValue.getDataValue();
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    if (string == null || string.length() <= 0) continue;
                    list.add(string);
                }
            }
        }
        return list;
    }

    public static void addUserDefinedTag(String string, MacroCommand macroCommand) {
        UmlProject umlProject = (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
        macroCommand.addCommand(umlProject.getUml1SmCommandFactory().makeCommandCreateUserDefinedTag(string));
    }

    public static void addUserDefinedTag(String string) {
        UmlProject umlProject = (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
        if (umlProject != null) {
            Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
            Uml1SmFactory uml1SmFactory = umlProject.getUml1SmFactory();
            Collection collection = umlProject.getModels();
            if (!collection.isEmpty()) {
                Model model = (Model)collection.iterator().next();
                TaggedValue taggedValue = uml1SmAccessory.getTaggedValueSingle(model, I);
                if (taggedValue == null) {
                    taggedValue = uml1SmFactory.createTaggedValue(umlProject.getNextSmId(), model, I, string);
                }
                List list = JavaDocTagProvider.getUserDefinedTags();
                boolean bl = false;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                }
                if (!bl) {
                    taggedValue.getDataValue().add(string);
                }
            }
        }
    }
}

