/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.util;

import com.gentleware.jboogie.kernel.Id;
import com.gentleware.jboogie.kernel.IdMap;
import com.gentleware.jboogie.openapi.SmId;
import com.gentleware.poseidon.kernel.settings.CustomJavaRoundtripSettings;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.util.ClassifierHistoryEntry;
import com.gentleware.services.Services;
import com.gentleware.services.configuration.Configuration;
import com.gentleware.services.util.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.omg.uml.foundation.core.Classifier;

public class ClassifierHistory {
    public static final String C = "classifier_history/";
    private Map B;
    private UmlProject A;

    public ClassifierHistory(UmlProject umlProject) {
        this.A = umlProject;
        this.B = CollectionFactory.createHashMap();
    }

    public boolean restoreHistoryFromProjectSettings() {
        Configuration configuration = this.A.getConfiguration();
        return this.restoreHistoryFromProjectSettings(configuration);
    }

    public boolean restoreHistoryFromProjectSettings(Configuration configuration) {
        boolean bl;
        Map map = configuration.getAllEntriesMatching(C);
        Set set = map.keySet();
        boolean bl2 = bl = set.size() == 0;
        if (!bl) {
            this.B = this.restoreHistoryFromProject(configuration);
        }
        return !bl;
    }

    public void clear() {
        this.B.clear();
        Configuration configuration = this.A.getConfiguration();
        if (configuration != null) {
            Map map = configuration.getAllEntriesMatching(C);
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                configuration.removeKey(string);
            }
        }
    }

    public Map getEntryMap() {
        return this.B;
    }

    public ClassifierHistoryEntry getEntryFor(SmId smId) {
        String string = smId.getXmiId();
        ClassifierHistoryEntry classifierHistoryEntry = this.getEntryFor(string);
        return classifierHistoryEntry;
    }

    public ClassifierHistoryEntry getEntryFor(String string) {
        Object v = this.B.get(string);
        ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)v;
        return classifierHistoryEntry;
    }

    public Collection getElementsChangedSince(long l) {
        Collection collection = this.A(l, false);
        return collection;
    }

    public Collection getNamesOfDeletedElements() {
        Collection collection = this.B.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (!bl) continue;
            String string = classifierHistoryEntry.getFullyQualifiedNameForDeletedElement();
            list.add(string);
        }
        return list;
    }

    public Collection getEntriesOfDeletedElements() {
        Collection collection = this.B.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (!bl) continue;
            list.add(classifierHistoryEntry);
        }
        return list;
    }

    public Collection getElementsModifiedAfterLastGeneration() {
        Collection collection = this.B.values();
        List list = CollectionFactory.createArrayList();
        IdMap idMap = this.A.getSmIdMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            boolean bl2 = classifierHistoryEntry.isModifiedAfterLastGeneration();
            if (bl || !bl2) continue;
            String string = classifierHistoryEntry.getXmiId();
            Id id = idMap.getIdWithXmiid(string);
            if (id == null) {
                Services.logError((Object)("Classifier history contains element with xmi id= " + string + ". without element."));
                continue;
            }
            list.add(id.getElement());
        }
        return list;
    }

    public Collection getNotGeneratedOuterClassifiers() {
        Collection collection = this.B.values();
        List list = CollectionFactory.createArrayList();
        IdMap idMap = this.A.getSmIdMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (bl || classifierHistoryEntry.isGenerated()) continue;
            String string = classifierHistoryEntry.getXmiId();
            Id id = idMap.getIdWithXmiid(string);
            if (id == null) {
                Services.logError((Object)("Classifier history contains element with xmi id= " + string + ". without element."));
                continue;
            }
            Classifier classifier = (Classifier)id.getElement();
            if (classifier.getNamespace() instanceof Classifier) continue;
            list.add(classifier);
        }
        return list;
    }

    public Collection getXmiIdsDeleted() {
        Collection collection = this.B.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (!bl) continue;
            String string = classifierHistoryEntry.getXmiId();
            list.add(string);
        }
        return list;
    }

    public Collection getSmIdsChangedSince(long l) {
        Collection collection = this.A(l, true);
        return collection;
    }

    private Collection A(long l, boolean bl) {
        if (l == (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP) {
            Collection collection = this.A.getSmAccessory().getAllClassesAndInterfaces(this.A.getFirstModel());
            if (bl) {
                List list = CollectionFactory.createArrayList();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    RefObject refObject = (RefObject)iterator.next();
                    SmId smId = this.A.getSmId(refObject);
                    list.add(smId);
                }
                return list;
            }
            return collection;
        }
        Collection collection = this.B.values();
        List list = CollectionFactory.createArrayList();
        IdMap idMap = this.A.getSmIdMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            long l2 = classifierHistoryEntry.getLastModifiedTimestamp();
            boolean bl2 = classifierHistoryEntry.isDeleted();
            if (l2 <= l || bl2) continue;
            String string = classifierHistoryEntry.getXmiId();
            Id id = idMap.getIdWithXmiid(string);
            if (id == null) {
                Services.logError((Object)("Classifier history contains element with xmi id= " + string + ". without element."));
                continue;
            }
            Classifier classifier = (Classifier)id.getElement();
            boolean bl3 = classifier.getNamespace() instanceof Classifier;
            if (bl3) continue;
            if (bl) {
                list.add(id);
                continue;
            }
            list.add(classifier);
        }
        return list;
    }

    public void postImport(List list, List list2) {
        this.A(list, true);
        this.removeEntries(list2);
    }

    public void setSmIdsModifiedNow(Collection collection) {
        this.A(collection, false);
    }

    public void forceAllElementsModifiedAt(long l) {
        Collection collection = this.B.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            classifierHistoryEntry.setLastModifiedTimestamp(l);
        }
    }

    public void forceAllElementsLastGeneratedAt(long l) {
        Collection collection = this.B.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            classifierHistoryEntry.setLastGeneratedTimestamp(l);
        }
    }

    public void forceAllElementsModifiedNow() {
        long l = System.currentTimeMillis();
        this.forceAllElementsModifiedAt(l);
    }

    private void A(Collection collection, boolean bl) {
        long l = System.currentTimeMillis();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            String string = smId.getXmiId();
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)this.B.get(string);
            if (classifierHistoryEntry != null) {
                if (classifierHistoryEntry.isDeleted() && bl) {
                    classifierHistoryEntry.undoDeletion();
                }
                classifierHistoryEntry.setLastModifiedTimestamp(l);
                continue;
            }
            Configuration configuration = this.A.getConfiguration();
            ClassifierHistoryEntry classifierHistoryEntry2 = new ClassifierHistoryEntry(configuration, string, l);
            this.B.put(string, classifierHistoryEntry2);
        }
    }

    public void setGeneratedSmIds(Collection collection) {
        long l = System.currentTimeMillis();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            String string = smId.getXmiId();
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)this.B.get(string);
            if (classifierHistoryEntry != null) {
                classifierHistoryEntry.setLastGeneratedTimestamp(l);
                continue;
            }
            Services.logError((Object)("TRYING TO SET A LASTGENERATION-TIMESTAMP FOR UNKNOWN ELEMENT IN ELEMENTHISTORY! " + smId));
            Configuration configuration = this.A.getConfiguration();
            ClassifierHistoryEntry classifierHistoryEntry2 = new ClassifierHistoryEntry(configuration, string, l);
            classifierHistoryEntry2.setLastGeneratedTimestamp(l);
            this.B.put(string, classifierHistoryEntry2);
        }
    }

    public void initializeFromLegacyProject(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            String string = smId.getXmiId();
            Configuration configuration = this.A.getConfiguration();
            ClassifierHistoryEntry classifierHistoryEntry = new ClassifierHistoryEntry(configuration, string, System.currentTimeMillis());
            this.B.put(string, classifierHistoryEntry);
        }
    }

    public void setSmIdsDeleted(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            ClassifierHistoryEntry classifierHistoryEntry = this.getEntryFor(smId);
            Classifier classifier = (Classifier)smId.getElement();
            String string = this.A.getUml1SmAccessory().generateFullyQualifiedJavaName(classifier);
            classifierHistoryEntry.setDeleted();
            classifierHistoryEntry.setFullyQualifiedNameForDeletedElement(string);
        }
    }

    public Map restoreHistoryFromProject(Configuration configuration) {
        Object object;
        String string;
        Map map = CollectionFactory.createHashMap();
        Map map2 = configuration.getAllEntriesMatching(C);
        Set set = map2.keySet();
        Set set2 = CollectionFactory.createHashSet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = string.substring(C.length());
            int n = ((String)object).indexOf(47);
            Object object2 = n > -1 ? ((String)object).substring(0, n) : object;
            set2.add(object2);
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = new ClassifierHistoryEntry(configuration, string);
            map.put(string, object);
        }
        return map;
    }

    public void removeDeletedEntry(String string) {
        ClassifierHistoryEntry classifierHistoryEntry = this.getEntryFor(string);
        if (classifierHistoryEntry != null && classifierHistoryEntry.isDeleted()) {
            this.B.remove(string);
            classifierHistoryEntry.removeFromConfiguration();
        }
    }

    public void removeAllDeletedEntries() {
        Set set = CollectionFactory.createHashSet(this.B.keySet());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.removeDeletedEntry(string);
        }
    }

    public void removeEntries(List list) {
        for (int j = 0; j < list.size(); ++j) {
            SmId smId = (SmId)list.get(j);
            this.B.remove(smId.getXmiId());
        }
    }
}

