/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.util;

import com.gentleware.poseidon.kernel.settings.CustomJavaRoundtripSettings;
import com.gentleware.services.configuration.Configuration;
import java.util.Set;

public class ClassifierHistoryEntry {
    public static final String G = "last_generated_timestamp";
    public static final String F = "last_modified_timestamp";
    public static final String D = "is_deleted";
    public static final String C = "fully_qualified_name";
    private Configuration E;
    private String A;
    private String B;

    public ClassifierHistoryEntry(Configuration configuration, String string) {
        this.E = configuration;
        this.A = string;
        this.B = "classifier_history/" + string + "/";
    }

    public ClassifierHistoryEntry(Configuration configuration, String string, long l) {
        this(configuration, string);
        this.E.putLong(this.B + F, l);
    }

    public void removeFromConfiguration() {
        Set set = this.E.getAllEntriesMatching(this.B).keySet();
        Object object = set.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.E.removeKey(string);
        }
        object = this.B.substring(0, this.B.length() - 1);
        this.E.removeKey((String)object);
    }

    public String getXmiId() {
        return this.A;
    }

    public long getLastGeneratedTimestamp() {
        return this.E.getLong(this.B + G, (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP);
    }

    public long getLastModifiedTimestamp() {
        return this.E.getLong(this.B + F, (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP);
    }

    public boolean isDeleted() {
        return this.E.getBoolean(this.B + D, false);
    }

    public void setLastGeneratedTimestamp(long l) {
        this.E.putLong(this.B + G, l);
    }

    public void setLastModifiedTimestamp(long l) {
        if (!this.isDeleted()) {
            this.E.putLong(this.B + F, l);
        }
    }

    public void undoDeletion() {
        if (!this.isDeleted()) {
            throw new IllegalStateException("Cannot undo deletetion of non-deleted element");
        }
        this.E.putBoolean(this.B + D, false);
    }

    public void setDeleted() {
        this.E.putBoolean(this.B + D, true);
    }

    public String getFullyQualifiedNameForDeletedElement() {
        return this.E.getString(this.B + C);
    }

    public void setFullyQualifiedNameForDeletedElement(String string) {
        this.E.putString(this.B + C, string);
    }

    public boolean isModifiedAfterLastGeneration() {
        return this.isGenerated() && this.getLastModifiedTimestamp() > this.getLastGeneratedTimestamp();
    }

    public boolean isGenerated() {
        return this.getLastGeneratedTimestamp() != (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP;
    }
}

