/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.mapping;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.Constant;
import javax.jmi.model.DataType;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.Parameter;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.model.VisibilityKindEnum;
import org.netbeans.api.mdr.JMIStreamFactory;
import org.netbeans.lib.jmi.mapping.GenericMapper;
import org.netbeans.lib.jmi.util.ClassFileGenerator;
import org.netbeans.lib.jmi.util.ContainsIterator;
import org.netbeans.lib.jmi.util.TagProvider;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class ClassFileMapper
extends GenericMapper {
    private final JMIStreamFactory generator;
    private OutputStream stream;

    protected String[] getAncestorNames(GeneralizableElement ge, String postfix, String defaultAncestor) {
        List supertypes = ge.getSupertypes();
        if (supertypes.size() == 0) {
            return new String[]{defaultAncestor};
        }
        String[] ancestors = new String[supertypes.size()];
        int i = 0;
        Iterator it = supertypes.iterator();
        while (it.hasNext()) {
            ancestors[i] = this.tagProvider.getTypeFullName((ModelElement)it.next()) + postfix;
            ++i;
        }
        return ancestors;
    }

    protected static Object getTypedValue(String typeName, String value) {
        if (value == null) {
            return null;
        }
        if (typeName.equals("String")) {
            return value;
        }
        if (typeName.equals("Integer")) {
            return new Integer(value);
        }
        if (typeName.equals("Boolean")) {
            return new Integer(value.equalsIgnoreCase("true") ? 1 : 0);
        }
        if (typeName.equals("Double")) {
            return new Double(value);
        }
        if (typeName.equals("Float")) {
            return new Float(value);
        }
        if (typeName.equals("Long")) {
            return new Long(value);
        }
        return null;
    }

    public ClassFileMapper(JMIStreamFactory sf) {
        this.generator = sf;
    }

    protected boolean createStream(List pkg, String fileName) throws IOException {
        if (this.stream != null) {
            this.closeStream();
            throw new IllegalStateException("Attempting to create stream before previous stream was closed.");
        }
        this.stream = this.generator.createStream(pkg, fileName, "class");
        return this.stream != null;
    }

    protected void closeStream() throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Attempting to close the stream without opening it first.");
        }
        OutputStream os = this.stream;
        this.stream = null;
        os.close();
    }

    protected void classProxyTemplate(MofClass objClass) throws IOException {
        new ClassProxyGenerator(objClass).generate();
    }

    protected void classInstanceTemplate(MofClass objClass) throws IOException {
        new ClassInstanceGenerator(objClass).generate();
    }

    protected void associationTemplate(Association objAssociation) throws IOException {
        new AssociationGenerator(objAssociation).generate();
    }

    protected void packageTemplate(MofPackage objPackage) throws IOException {
        new PackageGenerator(objPackage).generate();
    }

    protected void exceptionTemplate(MofException objException) throws IOException {
        new ExceptionGenerator(objException).generate();
    }

    protected void enumerationInterfaceTemplate(EnumerationType objEnumeration) throws IOException {
        new EnumerationGenerator(objEnumeration).generate();
    }

    protected void enumerationClassTemplate(EnumerationType objEnumeration) throws IOException {
        new EnumerationImplGenerator(objEnumeration).generate();
    }

    protected void structureTemplate(StructureType objStructure) throws IOException {
        new StructureGenerator(objStructure).generate();
    }

    class StructureGenerator
    extends JMIClassFileGenerator {
        protected StructureType objStructure;

        public StructureGenerator(StructureType objStructure) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objStructure), new String[]{"javax.jmi.reflect.RefStruct"}, "java.lang.Object", 1537);
            this.objStructure = objStructure;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objStructure.getContents().iterator();
            while (it.hasNext()) {
                ModelElement field = (ModelElement)it.next();
                if (!(field instanceof StructureField)) continue;
                Classifier fieldType = ((StructureField)field).getType();
                String memberName = StructureGenerator.firstUpper(ClassFileMapper.this.tagProvider.getSubstName(field));
                memberName = fieldType instanceof PrimitiveType && fieldType.getName().equals("Boolean") ? (memberName.indexOf("Is") != 0 ? "is" + memberName : StructureGenerator.firstLower(memberName)) : "get" + memberName;
                ClassFileGenerator.MethodInfo mInfo = new ClassFileGenerator.MethodInfo(this, memberName, StructureGenerator.getMethodDescriptor(new String[0], ClassFileMapper.this.getPrimitiveName(ClassFileMapper.this.getTypeName(fieldType))), 1025);
                methods.add(mInfo);
            }
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            return new ClassFileGenerator.FieldInfo[0];
        }
    }

    class EnumerationImplGenerator
    extends JMIClassFileGenerator {
        protected EnumerationType objEnumeration;

        public EnumerationImplGenerator(EnumerationType objEnumeration) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objEnumeration) + GenericMapper.ENUM_POSTFIX, new String[]{ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objEnumeration)}, "java.lang.Object", 49);
            this.objEnumeration = objEnumeration;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            ClassFileGenerator.MethodInfo mInfo = new ClassFileGenerator.MethodInfo(this, "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "void"), 2);
            DataOutputStream code = new DataOutputStream(mInfo.getCodeStream());
            this.code_aload(0, code);
            code.writeByte(183);
            code.writeShort(this.cp.getMethodRef("java/lang/Object", "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[0], "void")));
            this.code_aload(0, code);
            this.code_aload(1, code);
            code.writeByte(181);
            code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "literalName", EnumerationImplGenerator.getFieldType("java.lang.String")));
            code.writeByte(177);
            mInfo.setMaxStack((short)2);
            mInfo.setMaxLocals((short)2);
            methods.add(mInfo);
            mInfo = new ClassFileGenerator.MethodInfo(this, "refTypeName", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.util.List"), 1);
            code = new DataOutputStream(mInfo.getCodeStream());
            this.codeReturnFieldValue(this.className, "typeName", EnumerationImplGenerator.getFieldType("java.util.List"), false, code);
            mInfo.setMaxStack((short)1);
            mInfo.setMaxLocals((short)1);
            methods.add(mInfo);
            mInfo = new ClassFileGenerator.MethodInfo(this, "toString", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.lang.String"), 1);
            code = new DataOutputStream(mInfo.getCodeStream());
            this.codeReturnFieldValue(this.className, "literalName", EnumerationImplGenerator.getFieldType("java.lang.String"), false, code);
            mInfo.setMaxStack((short)1);
            mInfo.setMaxLocals((short)1);
            methods.add(mInfo);
            mInfo = new ClassFileGenerator.MethodInfo(this, "hashCode", EnumerationImplGenerator.getMethodDescriptor(new String[0], "int"), 1);
            code = new DataOutputStream(mInfo.getCodeStream());
            this.code_aload(0, code);
            code.writeByte(180);
            code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "literalName", EnumerationImplGenerator.getFieldType("java.lang.String")));
            code.write(182);
            code.writeShort(this.cp.getMethodRef("java/lang/Object", "hashCode", EnumerationImplGenerator.getMethodDescriptor(new String[0], "int")));
            code.writeByte(172);
            mInfo.setMaxStack((short)1);
            mInfo.setMaxLocals((short)1);
            methods.add(mInfo);
            mInfo = new ClassFileGenerator.MethodInfo(this, "equals", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.Object"}, "boolean"), 1);
            code = new DataOutputStream(mInfo.getCodeStream());
            this.code_aload(1, code);
            code.writeByte(193);
            code.writeShort(this.cp.getClass(EnumerationImplGenerator.dotToSlash(this.className)));
            code.writeByte(153);
            code.writeShort(12);
            code.writeByte(43);
            code.writeByte(42);
            code.writeByte(166);
            code.writeShort(5);
            code.writeByte(4);
            code.writeByte(172);
            code.writeByte(3);
            code.writeByte(172);
            this.code_aload(1, code);
            code.writeByte(193);
            code.writeShort(this.cp.getClass(EnumerationImplGenerator.dotToSlash(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)this.objEnumeration))));
            code.writeByte(153);
            code.writeShort(15);
            code.writeByte(43);
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/Object", "toString", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.lang.String")));
            code.writeByte(42);
            code.writeByte(180);
            code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "literalName", EnumerationImplGenerator.getFieldType("java.lang.String")));
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/Object", "equals", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.Object"}, "boolean")));
            code.writeByte(172);
            this.code_aload(1, code);
            code.writeByte(193);
            code.writeShort(this.cp.getClass(EnumerationImplGenerator.dotToSlash("javax.jmi.reflect.RefEnum")));
            code.writeByte(153);
            code.writeShort(39);
            code.writeByte(43);
            code.writeByte(192);
            code.writeShort(this.cp.getClass(EnumerationImplGenerator.dotToSlash("javax.jmi.reflect.RefEnum")));
            code.writeByte(185);
            code.writeShort(this.cp.getInterfaceMethodRef(EnumerationImplGenerator.dotToSlash("javax.jmi.reflect.RefEnum"), "refTypeName", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.util.List")));
            code.writeByte(1);
            code.writeByte(0);
            code.writeByte(178);
            code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "typeName", EnumerationImplGenerator.getFieldType("java.util.List")));
            code.writeByte(185);
            code.writeShort(this.cp.getInterfaceMethodRef("java/lang/Object", "equals", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.Object"}, "boolean")));
            code.writeByte(2);
            code.writeByte(0);
            code.writeByte(153);
            code.writeShort(19);
            code.writeByte(43);
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/Object", "toString", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.lang.String")));
            code.writeByte(42);
            code.writeByte(180);
            code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "literalName", EnumerationImplGenerator.getFieldType("java.lang.String")));
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/Object", "equals", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.Object"}, "boolean")));
            code.writeByte(153);
            code.writeShort(5);
            code.writeByte(4);
            code.writeByte(172);
            code.writeByte(3);
            code.writeByte(172);
            mInfo.setMaxStack((short)2);
            mInfo.setMaxLocals((short)2);
            methods.add(mInfo);
            mInfo = new ClassFileGenerator.MethodInfo(this, "readResolve", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.lang.Object"), 4);
            mInfo.setDeclaredExceptions(new short[]{this.cp.getClass("java/io/ObjectStreamException")});
            code = new DataOutputStream(mInfo.getCodeStream());
            this.code_aload(0, code);
            code.write(180);
            code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "literalName", EnumerationImplGenerator.getFieldType("java.lang.String")));
            code.writeByte(184);
            code.writeShort(this.cp.getMethodRef(EnumerationImplGenerator.dotToSlash(this.className), "forName", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)this.objEnumeration))));
            code.writeByte(176);
            this.code_astore(1, code);
            code.writeByte(187);
            code.writeShort(this.cp.getClass("java/io/ObjectStreamException"));
            code.writeByte(89);
            this.code_aload(1, code);
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.lang.String")));
            code.writeByte(183);
            code.writeShort(this.cp.getMethodRef("java/io/ObjectStreamException", "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "void")));
            code.writeByte(191);
            mInfo.getExceptionTable().add(new ClassFileGenerator.ExceptionTableEntry(0, 8, 8, this.cp.getClass("java/lang/IllegalArgumentException")));
            mInfo.setMaxStack((short)3);
            mInfo.setMaxLocals((short)2);
            methods.add(mInfo);
            mInfo = new ClassFileGenerator.MethodInfo(this, "forName", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)this.objEnumeration)), 9);
            code = new DataOutputStream(mInfo.getCodeStream());
            ClassFileGenerator.MethodInfo initInfo = new ClassFileGenerator.MethodInfo(this, "<clinit>", EnumerationImplGenerator.getMethodDescriptor(new String[0], "void"), 8);
            DataOutputStream initCode = new DataOutputStream(initInfo.getCodeStream());
            Iterator it = this.objEnumeration.getLabels().iterator();
            while (it.hasNext()) {
                String literal = (String)it.next();
                this.code_aload(0, code);
                this.code_ldc(this.cp.getString(literal), code);
                code.writeByte(182);
                code.writeShort(this.cp.getMethodRef("java/lang/String", "equals", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.Object"}, "boolean")));
                code.writeByte(153);
                code.writeShort(7);
                code.writeByte(178);
                TagProvider cfr_ignored_0 = ClassFileMapper.this.tagProvider;
                code.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), TagProvider.mapEnumLiteral(literal), EnumerationImplGenerator.getFieldType(this.className)));
                code.write(176);
                initCode.writeByte(187);
                initCode.writeShort(this.cp.getClass(EnumerationImplGenerator.dotToSlash(this.className)));
                initCode.writeByte(89);
                this.code_ldc(this.cp.getString(literal), initCode);
                initCode.writeByte(183);
                initCode.writeShort(this.cp.getMethodRef(EnumerationImplGenerator.dotToSlash(this.className), "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "void")));
                initCode.writeByte(179);
                TagProvider cfr_ignored_1 = ClassFileMapper.this.tagProvider;
                initCode.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), TagProvider.mapEnumLiteral(literal), EnumerationImplGenerator.getFieldType(this.className)));
            }
            code.writeByte(187);
            code.writeShort(this.cp.getClass("java/lang/IllegalArgumentException"));
            code.writeByte(89);
            code.writeByte(187);
            code.writeShort(this.cp.getClass("java/lang/StringBuffer"));
            code.writeByte(89);
            code.writeByte(183);
            code.writeShort(this.cp.getMethodRef("java/lang/StringBuffer", "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[0], "void")));
            this.code_ldc(this.cp.getString("Unknown enumeration value "), code);
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/StringBuffer", "append", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "java.lang.StringBuffer")));
            this.code_aload(0, code);
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/StringBuffer", "append", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "java.lang.StringBuffer")));
            this.code_ldc(this.cp.getString(" for type " + ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)this.objEnumeration)), code);
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/StringBuffer", "append", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "java.lang.StringBuffer")));
            code.writeByte(182);
            code.writeShort(this.cp.getMethodRef("java/lang/StringBuffer", "toString", EnumerationImplGenerator.getMethodDescriptor(new String[0], "java.lang.String")));
            code.writeByte(183);
            code.writeShort(this.cp.getMethodRef("java/lang/IllegalArgumentException", "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.String"}, "void")));
            code.writeByte(191);
            mInfo.setMaxStack((short)4);
            mInfo.setMaxLocals((short)1);
            methods.add(mInfo);
            initCode.writeByte(187);
            initCode.writeShort(this.cp.getClass("java/util/ArrayList"));
            initCode.writeByte(89);
            initCode.writeByte(183);
            initCode.writeShort(this.cp.getMethodRef("java/util/ArrayList", "<init>", EnumerationImplGenerator.getMethodDescriptor(new String[0], "void")));
            this.code_astore(0, initCode);
            it = this.objEnumeration.getQualifiedName().iterator();
            while (it.hasNext()) {
                this.code_aload(0, initCode);
                this.code_ldc(this.cp.getString((String)it.next()), initCode);
                initCode.writeByte(182);
                initCode.writeShort(this.cp.getMethodRef("java/util/ArrayList", "add", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.lang.Object"}, "boolean")));
                initCode.writeByte(87);
            }
            this.code_aload(0, initCode);
            initCode.writeByte(184);
            initCode.writeShort(this.cp.getMethodRef("java/util/Collections", "unmodifiableList", EnumerationImplGenerator.getMethodDescriptor(new String[]{"java.util.List"}, "java.util.List")));
            initCode.writeByte(179);
            initCode.writeShort(this.cp.getFieldRef(EnumerationImplGenerator.dotToSlash(this.className), "typeName", EnumerationImplGenerator.getFieldType("java.util.List")));
            initCode.writeByte(177);
            initInfo.setMaxStack((short)3);
            initInfo.setMaxLocals((short)1);
            methods.add(initInfo);
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            List fields = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objEnumeration.getLabels().iterator();
            while (it.hasNext()) {
                String literal = (String)it.next();
                TagProvider cfr_ignored_0 = ClassFileMapper.this.tagProvider;
                ClassFileGenerator.FieldInfo fInfo = new ClassFileGenerator.FieldInfo(this, TagProvider.mapEnumLiteral(literal), EnumerationImplGenerator.getFieldType(this.className), 25);
                fields.add(fInfo);
            }
            fields.add(new ClassFileGenerator.FieldInfo(this, "typeName", EnumerationImplGenerator.getFieldType("java.util.List"), 26));
            fields.add(new ClassFileGenerator.FieldInfo(this, "literalName", EnumerationImplGenerator.getFieldType("java.lang.String"), 18));
            return fields.toArray(new ClassFileGenerator.FieldInfo[fields.size()]);
        }
    }

    class EnumerationGenerator
    extends JMIClassFileGenerator {
        protected EnumerationType objEnumeration;

        public EnumerationGenerator(EnumerationType objEnumeration) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objEnumeration), new String[]{"javax.jmi.reflect.RefEnum"}, "java.lang.Object", 1537);
            this.objEnumeration = objEnumeration;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            return new ClassFileGenerator.MethodInfo[0];
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            return new ClassFileGenerator.FieldInfo[0];
        }
    }

    class ExceptionGenerator
    extends JMIClassFileGenerator {
        protected MofException objException;

        public ExceptionGenerator(MofException objException) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objException), new String[0], "javax.jmi.reflect.RefException", 33);
            this.objException = objException;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            List paramInits = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            List paramTypes = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            short i = 1;
            Iterator it = this.objException.getContents().iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof Parameter)) continue;
                Parameter param = (Parameter)element;
                String typeName = ClassFileMapper.this.getTypeName(param);
                paramTypes.add(typeName);
                String getterName = ExceptionGenerator.firstLower(ClassFileMapper.this.tagProvider.getSubstName((ModelElement)param));
                String paramName = GenericMapper.removeUnderscores(getterName);
                if (param.getType() instanceof PrimitiveType && param.getType().getName().equals("Boolean")) {
                    if (getterName.indexOf("is") != 0) {
                        getterName = GenericMapper.removeUnderscores("is_" + getterName);
                    }
                } else {
                    getterName = GenericMapper.removeUnderscores("get_" + getterName);
                }
                ClassFileGenerator.MethodInfo mInfo = new ClassFileGenerator.MethodInfo(this, getterName, ExceptionGenerator.getMethodDescriptor(new String[0], typeName), 1);
                DataOutputStream code = new DataOutputStream(mInfo.getCodeStream());
                this.codeReturnFieldValue(this.className, paramName, ExceptionGenerator.getFieldType(typeName), false, code);
                mInfo.setMaxStack((short)1);
                mInfo.setMaxLocals((short)1);
                methods.add(mInfo);
                ByteArrayOutputStream bout = new ByteArrayOutputStream(6);
                DataOutputStream paramInitCode = new DataOutputStream(bout);
                this.code_aload(0, paramInitCode);
                short s = i;
                i = (short)(i + 1);
                this.code_aload(s, paramInitCode);
                paramInitCode.writeByte(181);
                paramInitCode.writeShort(this.cp.getFieldRef(ExceptionGenerator.dotToSlash(this.className), paramName, ExceptionGenerator.getFieldType(typeName)));
                paramInits.add(bout.toByteArray());
            }
            ClassFileGenerator.MethodInfo mInfo = new ClassFileGenerator.MethodInfo(this, "<init>", ExceptionGenerator.getMethodDescriptor(paramTypes.toArray(new String[paramTypes.size()]), "void"), 1);
            DataOutputStream code = new DataOutputStream(mInfo.getCodeStream());
            this.code_aload(0, code);
            code.writeByte(183);
            code.writeShort(this.cp.getMethodRef(ExceptionGenerator.dotToSlash(this.className), "<init>", ExceptionGenerator.getMethodDescriptor(new String[0], "void")));
            Iterator it2 = paramInits.iterator();
            while (it2.hasNext()) {
                code.write((byte[])it2.next());
            }
            code.writeByte(177);
            mInfo.setMaxStack((short)2);
            mInfo.setMaxLocals(i);
            methods.add(mInfo);
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            List fields = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objException.getContents().iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof Parameter)) continue;
                Parameter param = (Parameter)element;
                String typeName = ClassFileMapper.this.getTypeName(param);
                String paramName = GenericMapper.removeUnderscores(ExceptionGenerator.firstLower(ClassFileMapper.this.tagProvider.getSubstName((ModelElement)param)));
                fields.add(new ClassFileGenerator.FieldInfo(this, paramName, ExceptionGenerator.getFieldType(typeName), 18));
            }
            return fields.toArray(new ClassFileGenerator.FieldInfo[fields.size()]);
        }
    }

    class PackageGenerator
    extends JMIClassFileGenerator {
        protected MofPackage objPackage;

        public PackageGenerator(MofPackage objPackage) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objPackage) + GenericMapper.PACKAGE_POSTFIX, ClassFileMapper.this.getAncestorNames((GeneralizableElement)objPackage, GenericMapper.PACKAGE_POSTFIX, "javax.jmi.reflect.RefPackage"), "java.lang.Object", 1537);
            this.objPackage = objPackage;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objPackage.getContents().iterator();
            while (it.hasNext()) {
                ModelElement element = (ModelElement)it.next();
                String typeName = ClassFileMapper.this.tagProvider.getTypeFullName(element);
                String elementName = ClassFileMapper.this.tagProvider.getSubstName(element);
                if (!(element instanceof Association)) {
                    if (element instanceof MofClass) {
                        typeName = typeName + GenericMapper.CLASS_POSTFIX;
                    } else if (element instanceof MofPackage) {
                        typeName = typeName + GenericMapper.PACKAGE_POSTFIX;
                    } else {
                        Import imp;
                        if (element instanceof EnumerationType) continue;
                        if (element instanceof StructureType) {
                            List parameters = AbstractCollectionFactory.getCollectionFactory().createArrayList();
                            Iterator itt = ((StructureType)element).getContents().iterator();
                            while (itt.hasNext()) {
                                ModelElement field = (ModelElement)itt.next();
                                if (!(field instanceof StructureField)) continue;
                                parameters.add(ClassFileMapper.this.getTypeName2((TypedElement)((StructureField)field)));
                            }
                            methods.add(new ClassFileGenerator.MethodInfo(this, "create" + PackageGenerator.firstUpper(ClassFileMapper.this.tagProvider.getSubstName(element)), PackageGenerator.getMethodDescriptor(parameters.toArray(new String[parameters.size()]), ClassFileMapper.this.tagProvider.getTypeFullName(element)), 1025));
                            continue;
                        }
                        if (!(element instanceof Import) || !(imp = (Import)element).isClustered() || !imp.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) continue;
                        Namespace namespace = imp.getImportedNamespace();
                        if (namespace instanceof MofPackage) {
                            typeName = ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)namespace) + GenericMapper.PACKAGE_POSTFIX;
                            element = namespace;
                        }
                    }
                }
                if (!((GeneralizableElement)element).getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) continue;
                methods.add(new ClassFileGenerator.MethodInfo(this, "get" + elementName, PackageGenerator.getMethodDescriptor(new String[0], typeName), 1025));
            }
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            return new ClassFileGenerator.FieldInfo[0];
        }
    }

    class AssociationGenerator
    extends JMIClassFileGenerator {
        protected Association objAssociation;

        public AssociationGenerator(Association objAssociation) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objAssociation), new String[]{"javax.jmi.reflect.RefAssociation"}, "java.lang.Object", 1537);
            this.objAssociation = objAssociation;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            AssociationEnd[] ends = new AssociationEnd[2];
            int i = 0;
            Iterator it = this.objAssociation.getContents().iterator();
            while (it.hasNext() && i < 2) {
                Object element = it.next();
                if (!(element instanceof AssociationEnd)) continue;
                ends[i++] = (AssociationEnd)element;
            }
            String end1Name = ClassFileMapper.this.tagProvider.getSubstName((ModelElement)ends[0]);
            String end1Class = ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)ClassFileMapper.this.getAttrType((TypedElement)ends[0]));
            String end2Name = ClassFileMapper.this.tagProvider.getSubstName((ModelElement)ends[1]);
            String end2Class = ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)ClassFileMapper.this.getAttrType((TypedElement)ends[1]));
            methods.add(new ClassFileGenerator.MethodInfo(this, "exists", AssociationGenerator.getMethodDescriptor(new String[]{end1Class, end2Class}, "boolean"), 1025));
            if (ends[0].isNavigable()) {
                methods.add(new ClassFileGenerator.MethodInfo(this, "get" + AssociationGenerator.firstUpper(end1Name), AssociationGenerator.getMethodDescriptor(new String[]{end2Class}, ends[0].getMultiplicity().getUpper() == 1 ? end1Class : (ends[0].getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection")), 1025));
            }
            if (ends[1].isNavigable()) {
                methods.add(new ClassFileGenerator.MethodInfo(this, "get" + AssociationGenerator.firstUpper(end2Name), AssociationGenerator.getMethodDescriptor(new String[]{end1Class}, ends[1].getMultiplicity().getUpper() == 1 ? end2Class : (ends[1].getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection")), 1025));
            }
            if (ends[0].isChangeable() && ends[1].isChangeable()) {
                methods.add(new ClassFileGenerator.MethodInfo(this, "add", AssociationGenerator.getMethodDescriptor(new String[]{end1Class, end2Class}, "boolean"), 1025));
                methods.add(new ClassFileGenerator.MethodInfo(this, "remove", AssociationGenerator.getMethodDescriptor(new String[]{end1Class, end2Class}, "boolean"), 1025));
            }
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            return new ClassFileGenerator.FieldInfo[0];
        }
    }

    class ClassInstanceGenerator
    extends JMIClassFileGenerator {
        protected MofClass objClass;

        public ClassInstanceGenerator(MofClass objClass) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objClass), ClassFileMapper.this.getAncestorNames((GeneralizableElement)objClass, "", "javax.jmi.reflect.RefObject"), "java.lang.Object", 1537);
            this.objClass = objClass;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objClass.getContents().iterator();
            while (it.hasNext()) {
                Feature feature;
                ModelElement element = (ModelElement)it.next();
                if (!(element instanceof Feature) || !(feature = (Feature)element).getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) continue;
                if (feature instanceof Attribute) {
                    Attribute attr = (Attribute)feature;
                    String attrName = ClassInstanceGenerator.firstUpper(ClassFileMapper.this.tagProvider.getSubstName((ModelElement)attr));
                    Classifier attrType = ClassFileMapper.this.getAttrType((TypedElement)attr);
                    String attrTypeName = ClassFileMapper.this.getTypeName(attrType);
                    if (attr.getMultiplicity().getUpper() == 1) {
                        String setterName;
                        String name;
                        if (attrType instanceof PrimitiveType && attrType.getName().equals("Boolean")) {
                            name = attrName.substring(0, 2).equals("Is") ? ClassInstanceGenerator.firstLower(attrName) : "is" + attrName;
                            setterName = "set" + name.substring(2);
                        } else {
                            name = "get" + attrName;
                            setterName = "set" + attrName;
                        }
                        String getterType = attrTypeName;
                        if (attr.getMultiplicity().getLower() == 1) {
                            getterType = ClassFileMapper.this.getPrimitiveName(getterType);
                        }
                        methods.add(new ClassFileGenerator.MethodInfo(this, name, ClassInstanceGenerator.getMethodDescriptor(new String[0], getterType), 1025));
                        if (!attr.isChangeable()) continue;
                        methods.add(new ClassFileGenerator.MethodInfo(this, setterName, ClassInstanceGenerator.getMethodDescriptor(new String[]{getterType}, "void"), 1025));
                        continue;
                    }
                    if (attr.getMultiplicity().getUpper() == 0) continue;
                    methods.add(new ClassFileGenerator.MethodInfo(this, "get" + attrName, ClassInstanceGenerator.getMethodDescriptor(new String[]{}, attr.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection"), 1025));
                    continue;
                }
                if (feature instanceof Operation) {
                    Operation oper = (Operation)feature;
                    List parameters = AbstractCollectionFactory.getCollectionFactory().createArrayList();
                    String operType = "void";
                    Iterator itt = oper.getContents().iterator();
                    while (itt.hasNext()) {
                        ModelElement el = (ModelElement)itt.next();
                        if (!(el instanceof Parameter)) continue;
                        Parameter param = (Parameter)el;
                        if (param.getDirection().equals(DirectionKindEnum.RETURN_DIR)) {
                            operType = ClassFileMapper.this.getTypeName(param);
                            continue;
                        }
                        parameters.add(ClassFileMapper.this.getTypeName(param) + (param.getDirection().equals(DirectionKindEnum.IN_DIR) ? "" : "[]"));
                    }
                    ClassFileGenerator.MethodInfo mInfo = new ClassFileGenerator.MethodInfo(this, ClassFileMapper.this.tagProvider.getSubstName((ModelElement)oper), ClassInstanceGenerator.getMethodDescriptor(parameters.toArray(new String[parameters.size()]), operType), 1025);
                    List exceptions = oper.getExceptions();
                    short[] declaredExceptions = new short[exceptions.size()];
                    int i = 0;
                    Iterator itt2 = exceptions.iterator();
                    while (itt2.hasNext()) {
                        declaredExceptions[i] = this.cp.getClass(ClassInstanceGenerator.dotToSlash(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)itt2.next())));
                        ++i;
                    }
                    mInfo.setDeclaredExceptions(declaredExceptions);
                    methods.add(mInfo);
                    continue;
                }
                if (!(feature instanceof Reference)) continue;
                Reference ref = (Reference)feature;
                String refName = ClassInstanceGenerator.firstUpper(ClassFileMapper.this.tagProvider.getSubstName((ModelElement)ref));
                String refType = ClassFileMapper.this.getTypeName(ClassFileMapper.this.getAttrType((TypedElement)ref));
                if (ref.getMultiplicity().getUpper() == 1) {
                    methods.add(new ClassFileGenerator.MethodInfo(this, "get" + refName, ClassInstanceGenerator.getMethodDescriptor(new String[0], refType), 1025));
                    if (!ref.isChangeable()) continue;
                    methods.add(new ClassFileGenerator.MethodInfo(this, "set" + refName, ClassInstanceGenerator.getMethodDescriptor(new String[]{refType}, "void"), 1025));
                    continue;
                }
                if (ref.getMultiplicity().getUpper() == 0) continue;
                methods.add(new ClassFileGenerator.MethodInfo(this, "get" + refName, ClassInstanceGenerator.getMethodDescriptor(new String[]{}, ref.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection"), 1025));
            }
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            List fields = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objClass.getContents().iterator();
            while (it.hasNext()) {
                ModelElement element = (ModelElement)it.next();
                if (!(element instanceof Constant)) continue;
                DataType type = (DataType)ClassFileMapper.this.getAttrType((TypedElement)((Constant)element));
                String value = ((Constant)element).getValue();
                ClassFileGenerator.FieldInfo fInfo = new ClassFileGenerator.FieldInfo(this, ClassFileMapper.this.tagProvider.getSubstName(element), ClassInstanceGenerator.getFieldType(ClassFileMapper.this.getTypeName2((TypedElement)((Constant)element))), 25);
                fInfo.setConstValue(ClassFileMapper.getTypedValue(type.getName(), value));
                fields.add(fInfo);
            }
            return fields.toArray(new ClassFileGenerator.FieldInfo[fields.size()]);
        }
    }

    class ClassProxyGenerator
    extends JMIClassFileGenerator {
        protected MofClass objClass;

        public ClassProxyGenerator(MofClass objClass) {
            super(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)objClass) + GenericMapper.CLASS_POSTFIX, new String[]{"javax.jmi.reflect.RefClass"}, "java.lang.Object", 1537);
            this.objClass = objClass;
        }

        protected ClassFileGenerator.MethodInfo[] generateMethods() throws IOException {
            List methods = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            Iterator it = this.objClass.getContents().iterator();
            while (it.hasNext()) {
                ModelElement element = (ModelElement)it.next();
                if (!(element instanceof StructureType)) continue;
                List parameters = AbstractCollectionFactory.getCollectionFactory().createArrayList();
                Iterator itt = ((StructureType)element).getContents().iterator();
                while (itt.hasNext()) {
                    ModelElement field = (ModelElement)itt.next();
                    if (!(field instanceof StructureField)) continue;
                    parameters.add(ClassFileMapper.this.getTypeName2((TypedElement)((StructureField)field)));
                }
                methods.add(new ClassFileGenerator.MethodInfo(this, "create" + ClassProxyGenerator.firstUpper(ClassFileMapper.this.tagProvider.getSubstName(element)), ClassProxyGenerator.getMethodDescriptor(parameters.toArray(new String[parameters.size()]), ClassFileMapper.this.tagProvider.getTypeFullName(element)), 1025));
            }
            List allAttributes = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            ContainsIterator it2 = new ContainsIterator((GeneralizableElement)this.objClass);
            while (it2.hasNext()) {
                Operation oper;
                ModelElement element = (ModelElement)it2.next();
                if (element instanceof Attribute) {
                    Attribute attr = (Attribute)element;
                    if (attr.getScope().equals(ScopeKindEnum.CLASSIFIER_LEVEL)) {
                        String attrName = ClassProxyGenerator.firstUpper(ClassFileMapper.this.tagProvider.getSubstName((ModelElement)attr));
                        Classifier attrType = ClassFileMapper.this.getAttrType((TypedElement)attr);
                        String attrTypeName = ClassFileMapper.this.getTypeName(attrType);
                        if (attr.getMultiplicity().getUpper() == 1) {
                            String setterName;
                            String name;
                            if (attrType instanceof PrimitiveType && attrType.getName().equals("Boolean")) {
                                name = attrName.substring(0, 2).equals("Is") ? ClassProxyGenerator.firstLower(attrName) : "is" + attrName;
                                setterName = "set" + name.substring(2);
                            } else {
                                name = "get" + attrName;
                                setterName = "set" + attrName;
                            }
                            String getterType = attrTypeName;
                            if (attr.getMultiplicity().getLower() == 1) {
                                getterType = ClassFileMapper.this.getPrimitiveName(getterType);
                            }
                            methods.add(new ClassFileGenerator.MethodInfo(this, name, ClassProxyGenerator.getMethodDescriptor(new String[0], getterType), 1025));
                            if (!attr.isChangeable()) continue;
                            methods.add(new ClassFileGenerator.MethodInfo(this, setterName, ClassProxyGenerator.getMethodDescriptor(new String[]{getterType}, "void"), 1025));
                            continue;
                        }
                        if (attr.getMultiplicity().getUpper() == 0) continue;
                        methods.add(new ClassFileGenerator.MethodInfo(this, "get" + attrName, ClassProxyGenerator.getMethodDescriptor(new String[]{}, attr.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection"), 1025));
                        continue;
                    }
                    if (attr.isDerived()) continue;
                    allAttributes.add(ClassFileMapper.this.getTypeName(attr));
                    continue;
                }
                if (!(element instanceof Operation) || !(oper = (Operation)element).getScope().equals(ScopeKindEnum.CLASSIFIER_LEVEL)) continue;
                List parameters = AbstractCollectionFactory.getCollectionFactory().createArrayList();
                String operType = "void";
                Iterator itt = oper.getContents().iterator();
                while (itt.hasNext()) {
                    ModelElement el = (ModelElement)itt.next();
                    if (!(el instanceof Parameter)) continue;
                    Parameter param = (Parameter)el;
                    if (param.getDirection().equals(DirectionKindEnum.RETURN_DIR)) {
                        operType = ClassFileMapper.this.getTypeName(param);
                        continue;
                    }
                    parameters.add(ClassFileMapper.this.getTypeName(param) + (param.getDirection().equals(DirectionKindEnum.IN_DIR) ? "" : "[]"));
                }
                ClassFileGenerator.MethodInfo mInfo = new ClassFileGenerator.MethodInfo(this, ClassFileMapper.this.tagProvider.getSubstName((ModelElement)oper), ClassProxyGenerator.getMethodDescriptor(parameters.toArray(new String[parameters.size()]), operType), 1025);
                List exceptions = oper.getExceptions();
                short[] declaredExceptions = new short[exceptions.size()];
                int i = 0;
                Iterator itt2 = exceptions.iterator();
                while (itt2.hasNext()) {
                    declaredExceptions[i] = this.cp.getClass(ClassProxyGenerator.dotToSlash(ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)itt2.next())));
                    ++i;
                }
                mInfo.setDeclaredExceptions(declaredExceptions);
                methods.add(mInfo);
            }
            if (!this.objClass.isAbstract()) {
                methods.add(new ClassFileGenerator.MethodInfo(this, "create" + ClassFileMapper.this.tagProvider.getSubstName((ModelElement)this.objClass), ClassProxyGenerator.getMethodDescriptor(new String[0], ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)this.objClass)), 1025));
                if (allAttributes.size() > 0) {
                    methods.add(new ClassFileGenerator.MethodInfo(this, "create" + ClassFileMapper.this.tagProvider.getSubstName((ModelElement)this.objClass), ClassProxyGenerator.getMethodDescriptor(allAttributes.toArray(new String[allAttributes.size()]), ClassFileMapper.this.tagProvider.getTypeFullName((ModelElement)this.objClass)), 1025));
                }
            }
            return methods.toArray(new ClassFileGenerator.MethodInfo[methods.size()]);
        }

        protected ClassFileGenerator.FieldInfo[] generateFields() throws IOException {
            return new ClassFileGenerator.FieldInfo[0];
        }
    }

    abstract class JMIClassFileGenerator
    extends ClassFileGenerator {
        protected JMIClassFileGenerator(String className, String[] interfaces, String superclass, int accessFlags) {
            super(className, interfaces, superclass, accessFlags);
        }

        protected void generate() throws IOException {
            this.generateClassFile(ClassFileMapper.this.stream);
        }
    }
}

