/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;

public class DebugException
extends RuntimeException {
    private Throwable nestedException;
    private Object[] formatObjects;

    private DebugException() {
    }

    public DebugException(Throwable nextedException) {
        this.nestedException = nextedException;
    }

    public DebugException(String msg) {
        super(msg);
    }

    public DebugException(String msg, Object[] messageObjects) {
        super(msg);
        this.formatObjects = messageObjects;
    }

    public DebugException(String msg, Throwable nestedException) {
        this(msg);
        this.nestedException = nestedException;
    }

    public DebugException(String msg, Object[] messageObjects, Throwable nestedException) {
        this(msg);
        this.formatObjects = messageObjects;
        this.nestedException = nestedException;
    }

    public Throwable getNestedException() {
        return this.nestedException;
    }

    public String getStackTraceString() {
        StringBuffer traceBuffer = new StringBuffer();
        if (this.nestedException != null) {
            if (this.nestedException instanceof org.netbeans.mdr.util.DebugException) {
                traceBuffer.append(((org.netbeans.mdr.util.DebugException)this.nestedException).getStackTraceString());
            } else {
                traceBuffer.append(this.generateStackTraceString(this.nestedException));
            }
            traceBuffer.append("-------- nested by:\n");
        }
        traceBuffer.append(this.generateStackTraceString());
        return traceBuffer.toString();
    }

    public String getMessage() {
        String nestedString;
        Throwable nestedException;
        StringBuffer retVal = new StringBuffer();
        String superMessage = super.getMessage();
        if (superMessage != null && superMessage.length() > 0) {
            if (this.formatObjects == null || this.formatObjects.length == 0) {
                retVal.append(superMessage);
            } else {
                retVal.append(MessageFormat.format(superMessage, this.formatObjects));
            }
        }
        if ((nestedException = this.getNestedException()) != null && (nestedString = nestedException.toString()) != null && nestedString.length() > 0) {
            if (retVal.length() > 0) {
                retVal.append("\r\nNestedException: ");
            }
            retVal.append(nestedString);
        }
        return retVal.toString();
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer(super.toString());
        return retVal.toString();
    }

    public void printStackTrace() {
        System.out.println(this.getStackTraceString());
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print(this.getStackTraceString());
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.print(this.getStackTraceString());
    }

    private String generateStackTraceString() {
        StringWriter stringWriter = new StringWriter();
        super.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String generateStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public void setNestedException(Throwable nestedException) {
        this.nestedException = nestedException;
    }
}

