/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;

public abstract class PPathActivity
extends PInterpolatingActivity {
    protected float[] knots;

    public PPathActivity(long duration, long stepRate, float[] knots) {
        this(duration, stepRate, 0, 1, knots);
    }

    public PPathActivity(long duration, long stepRate, int loopCount, int mode, float[] knots) {
        super(duration, stepRate, loopCount, mode);
        this.setKnots(knots);
    }

    public int getKnotsLength() {
        return this.knots.length;
    }

    public void setKnots(float[] knots) {
        this.knots = knots;
    }

    public float[] getKnots() {
        return this.knots;
    }

    public void setKnot(int index, float knot) {
        this.knots[index] = knot;
    }

    public float getKnot(int index) {
        return this.knots[index];
    }

    public void setRelativeTargetValue(float zeroToOne) {
        float currentPointOnRange;
        int currentKnotIndex = 0;
        while (zeroToOne > this.knots[currentKnotIndex]) {
            ++currentKnotIndex;
        }
        int startKnot = currentKnotIndex - 1;
        int endKnot = currentKnotIndex;
        if (startKnot < 0) {
            startKnot = 0;
        }
        if (endKnot > this.getKnotsLength() - 1) {
            endKnot = this.getKnotsLength() - 1;
        }
        float currentRange = this.knots[endKnot] - this.knots[startKnot];
        float normalizedPointOnRange = currentPointOnRange = zeroToOne - this.knots[startKnot];
        if (currentRange != 0.0f) {
            normalizedPointOnRange = currentPointOnRange / currentRange;
        }
        this.setRelativeTargetValue(normalizedPointOnRange, startKnot, endKnot);
    }

    public abstract void setRelativeTargetValue(float var1, int var2, int var3);
}

