/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.openapi.util;

import com.gentleware.openapi.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceRegistry {
    private static final Logger B = Logger.getLogger((String)"com.gentleware.openapi.util.ServiceRegistry");
    private static final Object[] C = new Object[0];
    private static final Class[] E = new Class[0];
    private static final ServiceRegistry A = new ServiceRegistry();
    private Map D = new HashMap();

    private ServiceRegistry() {
    }

    public static ServiceRegistry get() {
        return A;
    }

    public void registerService(Object object, Class clazz) {
        this.registerService(object, clazz, E);
    }

    public void registerService(Object object, Class clazz, Class[] classArray) {
        ArrayList<Class> arrayList;
        String string = clazz.getName();
        B.info((Object)("Register service " + object + " with implementation " + string));
        if (clazz.isInterface()) {
            Utils.logErrorOrThrow(B, "Cannot register interface " + string + " as implementation for service " + object);
            return;
        }
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n)) {
            Utils.logErrorOrThrow(B, "Cannot register abstract class " + string + " as implementation for service " + object);
            return;
        }
        if (!Modifier.isPublic(n)) {
            Utils.logErrorOrThrow(B, "Cannot register non-public class " + string + " as implementation for service " + object);
            return;
        }
        try {
            arrayList = clazz.getConstructor(classArray);
            if (arrayList == null) {
                Utils.logErrorOrThrow(B, "Cannot find proper constructor" + string + " as implementation for service " + object + "with parameters: " + classArray);
                return;
            }
            int n2 = ((Constructor)((Object)arrayList)).getModifiers();
            if (!Modifier.isPublic(n2)) {
                Utils.logErrorOrThrow(B, "Cannot register class without public default constructor " + string + " as implementation for service " + object);
                return;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Utils.logErrorOrThrow(B, "Cannot register class without appriopriate constructor " + string + " as implementation for service " + object);
            return;
        }
        arrayList = (List)this.D.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Class>(1);
            this.D.put(object, arrayList);
        }
        arrayList.add(clazz);
    }

    public void deregisterService(Object object, Class clazz) {
        int n;
        List list = (List)this.D.get(object);
        int n2 = n = list == null ? -1 : list.indexOf(clazz);
        if (n == -1) {
            Utils.logErrorOrThrow(B, "Class " + clazz.getName() + " was not registered as a service implementation for " + object);
            return;
        }
        list.remove(n);
    }

    public List getServices(Object object) {
        List list = (List)this.D.get(object);
        if (list == null || list.isEmpty()) {
            Utils.logErrorOrThrow(B, "No service registered for " + object);
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public Object getService(Object object) {
        return this.getService(object, C);
    }

    public Object getService(Object object, Object[] objectArray) {
        return this.getService(object, objectArray, true);
    }

    public Object getService(Object object, Object[] objectArray, boolean bl) {
        Object object2;
        List list = (List)this.D.get(object);
        if (list == null || list.isEmpty()) {
            if (bl) {
                Utils.logErrorOrThrow(B, "No service registered (yet) for " + object);
            } else {
                B.debug((Object)("No service registered (yet) for " + object));
            }
            return null;
        }
        Class clazz = (Class)list.get(list.size() - 1);
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            object2 = constructor.getParameterTypes();
            if (!this.A((Class[])object2, objectArray)) continue;
            try {
                Object obj = constructor.newInstance(objectArray);
                return obj;
            }
            catch (InstantiationException instantiationException) {
                this.A(object, clazz, instantiationException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.A(object, clazz, illegalAccessException);
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.A(object, clazz, invocationTargetException);
                return null;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("No matching constructor found in ");
        stringBuffer.append(clazz.getName());
        stringBuffer.append(" for arguments:\n");
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = objectArray[i];
            stringBuffer.append("   ");
            stringBuffer.append(object2);
        }
        Utils.logErrorOrThrow(B, stringBuffer);
        return null;
    }

    private void A(Object object, Class clazz, Exception exception) {
        ServiceException serviceException = new ServiceException("Cannot instantiate service " + object + " using implementation " + clazz.getName(), exception);
        Utils.logErrorOrThrow(B, "", serviceException);
    }

    private boolean A(Class[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Object object = objectArray[i];
            if (object == null || clazz.isInstance(object)) continue;
            return false;
        }
        return true;
    }

    public static class ServiceException
    extends RuntimeException {
        public ServiceException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

