/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.openapi.util;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TopLevelDomain {
    private static final Map E = CollectionFactory.createHashMap();
    private static Map B = CollectionFactory.createHashMap();
    private String A;
    private String C;
    private String D;

    private TopLevelDomain(String string, String string2) {
        this(string, string2, string2);
    }

    private TopLevelDomain(String string, String string2, String string3) {
        this.A = string;
        this.C = string2;
        if (!Strings.isEmpty(this.C)) {
            this.D = string3 != null ? string3.toUpperCase() : null;
        }
        E.put(this.A, this);
        if (this.C != null) {
            B.put(this.C.toLowerCase(), this);
        }
    }

    public String getName() {
        return this.A;
    }

    public String getCountry() {
        return this.C;
    }

    public String getCountryCode() {
        return this.D;
    }

    public boolean isCountryDomain() {
        return this.C != null;
    }

    public static String[] getAllCountries() {
        Collection collection = B.values();
        List list = CollectionFactory.createArrayList();
        String[] stringArray = collection.iterator();
        while (stringArray.hasNext()) {
            TopLevelDomain topLevelDomain = (TopLevelDomain)stringArray.next();
            String string = topLevelDomain.getCountry();
            list.add(string);
        }
        Collections.sort(list);
        stringArray = list.toArray(new String[list.size()]);
        return stringArray;
    }

    public static TopLevelDomain getByCountry(String string) {
        String string2 = string.toLowerCase();
        TopLevelDomain topLevelDomain = (TopLevelDomain)B.get(string2);
        return topLevelDomain;
    }

    public static TopLevelDomain getByDomainName(String string) {
        String string2 = string.toLowerCase();
        TopLevelDomain topLevelDomain = (TopLevelDomain)E.get(string2);
        return topLevelDomain;
    }

    public static boolean isValidDomainName(String string) {
        TopLevelDomain topLevelDomain = TopLevelDomain.getByDomainName(string);
        return topLevelDomain != null;
    }

    static {
        new TopLevelDomain("com", null);
        new TopLevelDomain("edu", null);
        new TopLevelDomain("gov", null);
        new TopLevelDomain("net", null);
        new TopLevelDomain("org", null);
        new TopLevelDomain("info", null);
        new TopLevelDomain("mil", null);
        new TopLevelDomain("biz", null);
        new TopLevelDomain("name", null);
        new TopLevelDomain("aero", null);
        new TopLevelDomain("coop", null);
        new TopLevelDomain("museum", null);
        new TopLevelDomain("int", null);
        new TopLevelDomain("su", null);
        new TopLevelDomain("pro", null);
        new TopLevelDomain("ac", "Ascension Island");
        new TopLevelDomain("ad", "Andorra");
        new TopLevelDomain("ae", "United Arab Emirates");
        new TopLevelDomain("af", "Afghanistan");
        new TopLevelDomain("ag", "Antigua and Barbuda");
        new TopLevelDomain("ai", "Anguilla");
        new TopLevelDomain("al", "Albania");
        new TopLevelDomain("am", "Armenia");
        new TopLevelDomain("an", "Netherlands Antilles");
        new TopLevelDomain("ao", "Angola");
        new TopLevelDomain("aq", "Antarctica");
        new TopLevelDomain("ar", "Argentina");
        new TopLevelDomain("as", "American Samoa");
        new TopLevelDomain("at", "Austria");
        new TopLevelDomain("au", "Australia");
        new TopLevelDomain("aw", "Aruba");
        new TopLevelDomain("az", "Azerbaijan");
        new TopLevelDomain("ba", "Bosnia and Herzegovina");
        new TopLevelDomain("bb", "Barbados");
        new TopLevelDomain("bd", "Bangladesh");
        new TopLevelDomain("be", "Belgium");
        new TopLevelDomain("bf", "Burkina Faso");
        new TopLevelDomain("bg", "Bulgaria");
        new TopLevelDomain("bh", "Bahrain");
        new TopLevelDomain("bi", "Burundi");
        new TopLevelDomain("bj", "Benin");
        new TopLevelDomain("bm", "Bermuda");
        new TopLevelDomain("bn", "Brunei Darussalam");
        new TopLevelDomain("bo", "Bolivia");
        new TopLevelDomain("br", "Brazil");
        new TopLevelDomain("bs", "Bahamas");
        new TopLevelDomain("bt", "Bhutan");
        new TopLevelDomain("bv", "Bouvet Island");
        new TopLevelDomain("bw", "Botswana");
        new TopLevelDomain("by", "Belarus");
        new TopLevelDomain("bz", "Belize");
        new TopLevelDomain("ca", "Canada");
        new TopLevelDomain("cc", "Cocos (Keeling) Islands");
        new TopLevelDomain("cd", "Congo, Democratic Republic of the");
        new TopLevelDomain("cf", "Central African Republic");
        new TopLevelDomain("cg", "Congo, Republic of");
        new TopLevelDomain("ch", "Switzerland");
        new TopLevelDomain("ci", "Cote d'Ivoire");
        new TopLevelDomain("ck", "Cook Islands");
        new TopLevelDomain("cl", "Chile");
        new TopLevelDomain("cm", "Cameroon");
        new TopLevelDomain("cn", "China");
        new TopLevelDomain("co", "Colombia");
        new TopLevelDomain("cr", "Costa Rica");
        new TopLevelDomain("cu", "Cuba");
        new TopLevelDomain("cv", "Cap Verde");
        new TopLevelDomain("cx", "Christmas Island");
        new TopLevelDomain("cy", "Cyprus");
        new TopLevelDomain("cz", "Czech Republic");
        new TopLevelDomain("de", "Germany");
        new TopLevelDomain("dj", "Djibouti");
        new TopLevelDomain("dk", "Denmark");
        new TopLevelDomain("dm", "Dominica");
        new TopLevelDomain("do", "Dominican Republic");
        new TopLevelDomain("dz", "Algeria");
        new TopLevelDomain("ec", "Ecuador");
        new TopLevelDomain("ee", "Estonia");
        new TopLevelDomain("eg", "Egypt");
        new TopLevelDomain("eh", "Western Sahara");
        new TopLevelDomain("er", "Eritrea");
        new TopLevelDomain("es", "Spain");
        new TopLevelDomain("et", "Ethiopia");
        new TopLevelDomain("fi", "Finland");
        new TopLevelDomain("fj", "Fiji");
        new TopLevelDomain("fk", "Falkland Islands (Malvina)");
        new TopLevelDomain("fm", "Micronesia, Federal State of");
        new TopLevelDomain("fo", "Faroe Islands");
        new TopLevelDomain("fr", "France");
        new TopLevelDomain("ga", "Gabon");
        new TopLevelDomain("gd", "Grenada");
        new TopLevelDomain("ge", "Georgia");
        new TopLevelDomain("gf", "French Guiana");
        new TopLevelDomain("gg", "Guernsey");
        new TopLevelDomain("gh", "Ghana");
        new TopLevelDomain("gi", "Gibraltar");
        new TopLevelDomain("gl", "Greenland");
        new TopLevelDomain("gm", "Gambia");
        new TopLevelDomain("gn", "Guinea");
        new TopLevelDomain("gp", "Guadeloupe");
        new TopLevelDomain("gq", "Equatorial Guinea");
        new TopLevelDomain("gr", "Greece");
        new TopLevelDomain("gs", "South Georgia and the South Sandwich Islands");
        new TopLevelDomain("gt", "Guatemala");
        new TopLevelDomain("gu", "Guam");
        new TopLevelDomain("gw", "Guinea-Bissau");
        new TopLevelDomain("gy", "Guyana");
        new TopLevelDomain("hk", "Hong Kong");
        new TopLevelDomain("hm", "Heard and McDonald Islands");
        new TopLevelDomain("hn", "Honduras");
        new TopLevelDomain("hr", "Croatia/Hrvatska");
        new TopLevelDomain("ht", "Haiti");
        new TopLevelDomain("hu", "Hungary");
        new TopLevelDomain("id", "Indonesia");
        new TopLevelDomain("ie", "Ireland");
        new TopLevelDomain("il", "Israel");
        new TopLevelDomain("im", "Isle of Man");
        new TopLevelDomain("in", "India");
        new TopLevelDomain("io", "British Indian Ocean Territory");
        new TopLevelDomain("iq", "Iraq");
        new TopLevelDomain("ir", "Iran (Islamic Republic of)");
        new TopLevelDomain("is", "Iceland");
        new TopLevelDomain("it", "Italy");
        new TopLevelDomain("je", "Jersey");
        new TopLevelDomain("jm", "Jamaica");
        new TopLevelDomain("jo", "Jordan");
        new TopLevelDomain("jp", "Japan");
        new TopLevelDomain("ke", "Kenya");
        new TopLevelDomain("kg", "Kyrgyzstan");
        new TopLevelDomain("kh", "Cambodia");
        new TopLevelDomain("ki", "Kiribati");
        new TopLevelDomain("km", "Comoros");
        new TopLevelDomain("kn", "Saint Kitts and Nevis");
        new TopLevelDomain("kp", "Korea, Democratic People's Republic");
        new TopLevelDomain("kr", "Korea, Republic of");
        new TopLevelDomain("kw", "Kuwait");
        new TopLevelDomain("ky", "Cayman Islands");
        new TopLevelDomain("kz", "Kazakhstan");
        new TopLevelDomain("la", "Lao People's Democratic Republic");
        new TopLevelDomain("lb", "Lebanon");
        new TopLevelDomain("lc", "Saint Lucia");
        new TopLevelDomain("li", "Liechtenstein");
        new TopLevelDomain("lk", "Sri Lanka");
        new TopLevelDomain("lr", "Liberia");
        new TopLevelDomain("ls", "Lesotho");
        new TopLevelDomain("lt", "Lithuania");
        new TopLevelDomain("lu", "Luxembourg");
        new TopLevelDomain("lv", "Latvia");
        new TopLevelDomain("ly", "Libyan Arab Jamahiriya");
        new TopLevelDomain("ma", "Morocco");
        new TopLevelDomain("mc", "Monaco");
        new TopLevelDomain("md", "Moldova, Republic of");
        new TopLevelDomain("mg", "Madagascar");
        new TopLevelDomain("mh", "Marshall Islands");
        new TopLevelDomain("mk", "Macedonia, Former Yugoslav Republic");
        new TopLevelDomain("ml", "Mali");
        new TopLevelDomain("mm", "Myanmar");
        new TopLevelDomain("mn", "Mongolia");
        new TopLevelDomain("mo", "Macau");
        new TopLevelDomain("mp", "Northern Mariana Islands");
        new TopLevelDomain("mq", "Martinique");
        new TopLevelDomain("mr", "Mauritania");
        new TopLevelDomain("ms", "Montserrat");
        new TopLevelDomain("mt", "Malta");
        new TopLevelDomain("mu", "Mauritius");
        new TopLevelDomain("mv", "Maldives");
        new TopLevelDomain("mw", "Malawi");
        new TopLevelDomain("mx", "Mexico");
        new TopLevelDomain("my", "Malaysia");
        new TopLevelDomain("mz", "Mozambique");
        new TopLevelDomain("na", "Namibia");
        new TopLevelDomain("nc", "New Caledonia");
        new TopLevelDomain("ne", "Niger");
        new TopLevelDomain("nf", "Norfolk Island");
        new TopLevelDomain("ng", "Nigeria");
        new TopLevelDomain("ni", "Nicaragua");
        new TopLevelDomain("nl", "Netherlands");
        new TopLevelDomain("no", "Norway");
        new TopLevelDomain("np", "Nepal");
        new TopLevelDomain("nr", "Nauru");
        new TopLevelDomain("nu", "Niue");
        new TopLevelDomain("nz", "New Zealand");
        new TopLevelDomain("om", "Oman");
        new TopLevelDomain("pa", "Panama");
        new TopLevelDomain("pe", "Peru");
        new TopLevelDomain("pf", "French Polynesia");
        new TopLevelDomain("pg", "Papua New Guinea");
        new TopLevelDomain("ph", "Philippines");
        new TopLevelDomain("pk", "Pakistan");
        new TopLevelDomain("pl", "Poland");
        new TopLevelDomain("pm", "St. Pierre and Miquelon");
        new TopLevelDomain("pn", "Pitcairn Island");
        new TopLevelDomain("pr", "Puerto Rico");
        new TopLevelDomain("ps", "Palestinian Territories");
        new TopLevelDomain("pt", "Portugal");
        new TopLevelDomain("pw", "Palau");
        new TopLevelDomain("py", "Paraguay");
        new TopLevelDomain("qa", "Qatar");
        new TopLevelDomain("re", "Reunion Island");
        new TopLevelDomain("ro", "Romania");
        new TopLevelDomain("ru", "Russian Federation");
        new TopLevelDomain("rw", "Rwanda");
        new TopLevelDomain("sa", "Saudi Arabia");
        new TopLevelDomain("sb", "Solomon Islands");
        new TopLevelDomain("sc", "Seychelles");
        new TopLevelDomain("sd", "Sudan");
        new TopLevelDomain("se", "Sweden");
        new TopLevelDomain("sg", "Singapore");
        new TopLevelDomain("sh", "St. Helena");
        new TopLevelDomain("si", "Slovenia");
        new TopLevelDomain("sj", "Svalbard and Jan Mayen Islands");
        new TopLevelDomain("sk", "Slovak Republic");
        new TopLevelDomain("sl", "Sierra Leone");
        new TopLevelDomain("sm", "San Marino");
        new TopLevelDomain("sn", "Senegal");
        new TopLevelDomain("so", "Somalia");
        new TopLevelDomain("sr", "Suriname");
        new TopLevelDomain("st", "Sao Tome and Principe");
        new TopLevelDomain("sv", "El Salvador");
        new TopLevelDomain("sy", "Syrian Arab Republic");
        new TopLevelDomain("sz", "Swaziland");
        new TopLevelDomain("tc", "Turks and Caicos Islands");
        new TopLevelDomain("td", "Chad");
        new TopLevelDomain("tf", "French Southern Territories");
        new TopLevelDomain("tg", "Togo");
        new TopLevelDomain("th", "Thailand");
        new TopLevelDomain("tj", "Tajikistan");
        new TopLevelDomain("tk", "Tokelau");
        new TopLevelDomain("tm", "Turkmenistan");
        new TopLevelDomain("tn", "Tunisia");
        new TopLevelDomain("to", "Tonga");
        new TopLevelDomain("tp", "East Timor");
        new TopLevelDomain("tr", "Turkey");
        new TopLevelDomain("tt", "Trinidad and Tobago");
        new TopLevelDomain("tv", "Tuvalu");
        new TopLevelDomain("tw", "Taiwan");
        new TopLevelDomain("tz", "Tanzania");
        new TopLevelDomain("ua", "Ukraine");
        new TopLevelDomain("ug", "Uganda");
        new TopLevelDomain("uk", "United Kingdom", "GB");
        new TopLevelDomain("um", "US Minor Outlying Islands");
        new TopLevelDomain("us", "United States");
        new TopLevelDomain("uy", "Uruguay");
        new TopLevelDomain("uz", "Uzbekistan");
        new TopLevelDomain("va", "Holy See (City Vatican State)");
        new TopLevelDomain("vc", "Saint Vincent and the Grenadines");
        new TopLevelDomain("ve", "Venezuela");
        new TopLevelDomain("vg", "Virgin Islands (British)");
        new TopLevelDomain("vi", "Virgin Islands (USA)");
        new TopLevelDomain("vn", "Vietnam");
        new TopLevelDomain("vu", "Vanuatu");
        new TopLevelDomain("wf", "Wallis and Futuna Islands");
        new TopLevelDomain("ws", "Western Samoa");
        new TopLevelDomain("ye", "Yemen");
        new TopLevelDomain("yt", "Mayotte");
        new TopLevelDomain("yu", "Yugoslavia");
        new TopLevelDomain("za", "South Africa");
        new TopLevelDomain("zm", "Zambia");
        new TopLevelDomain("zw", "Zimbabwe");
    }
}

