/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.layout.LayoutStrategy;
import com.gentleware.jboogie.layout.LayoutValidator;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.piccolo.nodes.PDiagram;
import com.gentleware.jboogie.util.DiMacroMemento;
import com.gentleware.jboogie.util.Insets2D;
import com.gentleware.openapi.jboogie.Project;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public class DiagramLayout
extends LayoutStrategy {
    protected final PDimension _minimumSize;
    protected final Insets2D _insets;
    public static int EMPTY_DIAGRAM_WIDTH = 500;
    public static int EMPTY_DIAGRAM_HEIGHT = 300;

    public DiagramLayout(Project project, PDimension pDimension) {
        this(project, pDimension, LayoutStrategy.DIAGRAM_INSETS);
    }

    public DiagramLayout(Project project, PDimension pDimension, Insets2D insets2D) {
        super(project, true);
        this._minimumSize = pDimension;
        this._insets = insets2D;
    }

    public void layoutContainer(LayoutableElement layoutableElement, DiMacroMemento diMacroMemento) {
        super.layoutContainer(layoutableElement, diMacroMemento);
        this.setBounds(layoutableElement, diMacroMemento);
    }

    public void reshapeElements(LayoutableElement layoutableElement, List list, DiMacroMemento diMacroMemento) {
        LayoutValidator layoutValidator = this.getProject().getLayoutValidator();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SimpleTypeInfo simpleTypeInfo;
            LayoutableNode layoutableNode = (LayoutableNode)list.get(i2);
            if (!layoutableNode.isVisible() || SimpleTypeInfo.NAME_COMPARTMENT.equals(simpleTypeInfo = layoutableNode.getSimpleTypeInfo(this.getProject())) || !layoutValidator.isDirty(layoutableNode)) continue;
            LayoutStrategy layoutStrategy = this.getLayout(layoutableNode);
            PBounds pBounds = layoutStrategy.getPreferredBounds(layoutableNode);
            double d2 = layoutableNode.getTranslateX();
            double d3 = layoutableNode.getTranslateY();
            this.setNodeShape(layoutableNode, d2, d3, pBounds.getWidth(), pBounds.getHeight(), diMacroMemento);
        }
    }

    protected PBounds setBounds(LayoutableElement layoutableElement, DiMacroMemento diMacroMemento) {
        Object object;
        LayoutableNode layoutableNode = (LayoutableNode)LayoutableElements.findContainedWithTypeInfo(this.getProject(), layoutableElement, SimpleTypeInfo.NAME_COMPARTMENT);
        PBounds pBounds = this.getPreferredBoundsImpl(layoutableElement, layoutableElement.getContainedElements(), false, true);
        if (layoutableNode != null) {
            object = this.getLayout(layoutableNode);
            PBounds pBounds2 = ((LayoutStrategy)object).getPreferredBounds(layoutableNode);
            double d2 = pBounds2.width;
            double d3 = pBounds2.height;
            double d4 = pBounds.x;
            double d5 = pBounds.y - d3;
            this.setNodeShape(layoutableNode, d4, d5, d2, d3, diMacroMemento);
            pBounds.add(pBounds.x + d2, pBounds.y - d3);
        }
        if ((object = LayoutableElements.getPNode(layoutableElement)) instanceof PDiagram) {
            object.setBounds((Rectangle2D)pBounds);
            layoutableElement.setPreferredBoundsCache(pBounds);
        }
        return pBounds;
    }

    protected PBounds getPreferredBoundsImpl(LayoutableElement layoutableElement, List list) {
        return this.getPreferredBoundsImpl(layoutableElement, layoutableElement.getContainedElements(), true, true);
    }

    public PBounds getPreferredBoundsImpl(LayoutableElement layoutableElement, List list, boolean bl, boolean bl2) {
        double d2;
        PBounds pBounds = new PBounds();
        Project project = this.getProject();
        LayoutableNode layoutableNode = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LayoutableElement layoutableElement2 = (LayoutableElement)iterator.next();
            if (!layoutableElement2.isVisible()) continue;
            if (SimpleTypeInfo.NAME_COMPARTMENT.equals(layoutableElement2.getSimpleTypeInfo(project))) {
                layoutableNode = (LayoutableNode)layoutableElement2;
                continue;
            }
            PBounds pBounds2 = this.getDiagramBoundsOfContainedElement(layoutableElement, layoutableElement2);
            pBounds.add(pBounds2);
        }
        boolean bl3 = pBounds.isEmpty();
        if (bl3) {
            pBounds = new PBounds(0.0, 0.0, 0.0, 0.0);
        }
        if (layoutableNode != null || bl2) {
            double d3 = this._insets.getLeft() + this._insets.getRight();
            d2 = this._insets.getTop() + this._insets.getBottom();
            pBounds.width += d3;
            pBounds.height += d2;
            pBounds.x -= this._insets.getLeft();
            pBounds.y -= this._insets.getTop();
        }
        pBounds.width = Math.max(pBounds.width, this._minimumSize.width);
        pBounds.height = Math.max(pBounds.height, this._minimumSize.height);
        double d4 = 0.0;
        d2 = 0.0;
        if (layoutableNode != null) {
            d4 = layoutableNode.getHeight();
            d2 = layoutableNode.getWidth();
        }
        if (bl) {
            pBounds.add(pBounds.x + d2, pBounds.y - d4);
        }
        if (bl3) {
            pBounds.x = Math.max(19.0, pBounds.x);
            if (!bl) {
                pBounds.y = Math.max(Math.max(d4, 19.0), pBounds.y);
                pBounds.height = Math.max((double)EMPTY_DIAGRAM_HEIGHT - Math.max(d4, 19.0), pBounds.height);
            } else {
                pBounds.y = Math.max(0.0, pBounds.y);
                pBounds.height = Math.max((double)EMPTY_DIAGRAM_HEIGHT, pBounds.height);
            }
            pBounds.width = Math.max((double)EMPTY_DIAGRAM_WIDTH, pBounds.width);
        }
        return pBounds;
    }

    protected PBounds getDiagramBoundsOfContainedElement(LayoutableElement layoutableElement, LayoutableElement layoutableElement2) {
        LayoutStrategy layoutStrategy = this.getLayout(layoutableElement2);
        PBounds pBounds = layoutStrategy.getFullBoundsIncludingShapes(layoutableElement2);
        double d2 = layoutableElement.getTranslateX();
        double d3 = layoutableElement.getTranslateY();
        pBounds.x += d2;
        pBounds.y += d3;
        return pBounds;
    }
}

