/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.layout.LayoutStrategy;
import com.gentleware.jboogie.layout.LayoutValidator;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableEdges;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.util.DiMacroMemento;
import com.gentleware.openapi.jboogie.Project;
import edu.umd.cs.piccolo.util.PBounds;
import java.util.List;

public class EdgeLayout
extends LayoutStrategy {
    public EdgeLayout(Project project) {
        super(project, true);
    }

    public void reshapeElements(LayoutableElement layoutableElement, List list, DiMacroMemento diMacroMemento) {
        LayoutValidator layoutValidator = this.getProject().getLayoutValidator();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            LayoutStrategy layoutStrategy;
            LayoutableNode layoutableNode = (LayoutableNode)list.get(i2);
            if (!layoutValidator.isDirty(layoutableNode) || (layoutStrategy = this.getLayout(layoutableNode)) == null) continue;
            PBounds pBounds = layoutStrategy.getPreferredBounds(layoutableNode);
            this.setNodeShape(layoutableNode, Double.NaN, Double.NaN, pBounds.getWidth(), pBounds.getHeight(), diMacroMemento);
        }
    }

    protected PBounds getPreferredBoundsImpl(LayoutableElement layoutableElement, List list) {
        LayoutableEdge layoutableEdge = (LayoutableEdge)layoutableElement;
        PBounds pBounds = layoutableEdge.isVisible() ? this.A(layoutableEdge, list) : new PBounds();
        return pBounds;
    }

    private PBounds A(LayoutableEdge layoutableEdge, List list) {
        PBounds pBounds = this.getPreferredWaypointBounds(layoutableEdge);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            LayoutableElement layoutableElement = (LayoutableElement)list.get(i2);
            LayoutStrategy layoutStrategy = this.getLayout(layoutableElement);
            PBounds pBounds2 = new PBounds(layoutStrategy.getPreferredBounds(layoutableElement));
            double d2 = layoutableElement.getTranslateX();
            double d3 = layoutableElement.getTranslateY();
            pBounds2.moveBy(d2, d3);
            if (d2 == 0.0 || d3 == 0.0) continue;
            pBounds.add(pBounds2);
        }
        return pBounds;
    }

    protected PBounds getPreferredWaypointBounds(LayoutableEdge layoutableEdge) {
        PBounds pBounds = LayoutableEdges.getWaypointLocalBounds(layoutableEdge);
        return pBounds;
    }
}

