/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.layout;

import com.gentleware.jboogie.event.piccolo.QSelectionEventHandler;
import com.gentleware.jboogie.kernel.TargetManager;
import com.gentleware.jboogie.layout.EdgeShape;
import com.gentleware.jboogie.layout.LayoutValidator;
import com.gentleware.jboogie.layout.LayoutableConnector;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.layout.ShapeStrategy;
import com.gentleware.jboogie.util.DiMacroMemento;
import com.gentleware.jboogie.util.DiMemento;
import com.gentleware.jboogie.util.Insets2D;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Utils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;

public class LayoutStrategy {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.jboogie.layout.LayoutStrategy");
    public static final Insets2D DIAGRAM_INSETS = new Insets2D(30.0);
    private Project B;
    private boolean C;

    public LayoutStrategy(Project project) {
        this(project, false);
    }

    public LayoutStrategy(Project project, boolean bl) {
        this.B = project;
        this.C = bl;
    }

    public Project getProject() {
        return this.B;
    }

    protected boolean isFrozen(LayoutableElement layoutableElement) {
        return this.B.getLayoutValidator().isFrozen(layoutableElement);
    }

    protected boolean useBoundsCache() {
        return true;
    }

    public void layoutContainer(LayoutableElement layoutableElement, DiMacroMemento diMacroMemento) {
        try {
            List list = CollectionFactory.createArrayList();
            List list2 = CollectionFactory.createArrayList();
            List list3 = CollectionFactory.createArrayList();
            this.sortContainedElements(layoutableElement, list, list2, list3);
            ShapeStrategy shapeStrategy = this.B.getLayoutValidator().getShape(layoutableElement);
            if (shapeStrategy != null && shapeStrategy.isReshapeable(layoutableElement)) {
                shapeStrategy.reshapeElement(layoutableElement, diMacroMemento);
            }
            this.reshapeElements(layoutableElement, list, diMacroMemento);
            list.addAll(list3);
            this.layoutCollection(list, diMacroMemento);
            this.layoutCollection(list2, diMacroMemento);
        }
        catch (RuntimeException runtimeException) {
            A.error((Object)runtimeException);
        }
    }

    protected void sortContainedElements(LayoutableElement layoutableElement, List list, List list2, List list3) {
        List list4 = layoutableElement.getContainedElements();
        int n2 = list4.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            boolean bl2;
            LayoutableElement layoutableElement2 = (LayoutableElement)list4.get(i2);
            if (!layoutableElement2.isVisible()) continue;
            ShapeStrategy shapeStrategy = this.B.getLayoutValidator().getShape(layoutableElement2);
            boolean bl3 = bl2 = shapeStrategy == null || !shapeStrategy.isReshapeable(layoutableElement2);
            if (bl2) {
                if (this.isFrozen(layoutableElement2) && list3 != null) {
                    list3.add(layoutableElement2);
                    continue;
                }
                if (list == null) continue;
                list.add(layoutableElement2);
                continue;
            }
            if (this.isFrozen(layoutableElement2) && list3 != null) continue;
            boolean bl4 = bl = list2 != null && !this.A(layoutableElement2);
            if (!bl) continue;
            list2.add(layoutableElement2);
        }
        if (list != null) {
            Collections.sort(list, new _A());
        }
        if (list2 != null) {
            Collections.sort(list2, new _A());
        }
    }

    private boolean A(LayoutableElement layoutableElement) {
        QSelectionEventHandler qSelectionEventHandler;
        TargetManager targetManager;
        ShapeStrategy shapeStrategy = this.B.getLayoutValidator().getShape(layoutableElement);
        boolean bl = false;
        if (shapeStrategy != null && (targetManager = this.B.getTargetManager()) != null && (qSelectionEventHandler = targetManager.getCurrentSelectionHandler()) != null) {
            PNode pNode = null;
            if (layoutableElement instanceof PNode) {
                pNode = (PNode)layoutableElement;
            } else if (layoutableElement instanceof DiagramElementImpl) {
                DiagramElementImpl diagramElementImpl = (DiagramElementImpl)layoutableElement;
                pNode = diagramElementImpl.getPNode();
            }
            if (pNode != null) {
                bl = qSelectionEventHandler.isNodeCurrentlyMovedByUser(pNode);
            }
        }
        return bl;
    }

    private List A(List list) {
        List list2 = CollectionFactory.createArrayList((int)list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            LayoutableElement layoutableElement = (LayoutableElement)list.get(i2);
            if (!layoutableElement.isVisible()) continue;
            ShapeStrategy shapeStrategy = this.B.getLayoutValidator().getShape(layoutableElement);
            if (!this.C && shapeStrategy != null && shapeStrategy.isReshapeable(layoutableElement)) continue;
            list2.add(layoutableElement);
        }
        return list2;
    }

    protected void layoutCollection(List list, DiMacroMemento diMacroMemento) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LayoutStrategy layoutStrategy;
            LayoutableElement layoutableElement = (LayoutableElement)iterator.next();
            LayoutValidator layoutValidator = this.B.getLayoutValidator();
            if (!layoutValidator.isDirty(layoutableElement) || (layoutStrategy = layoutValidator.getLayout(layoutableElement)) == null) continue;
            layoutStrategy.layoutContainer(layoutableElement, diMacroMemento);
        }
    }

    public void reshapeElements(LayoutableElement layoutableElement, List list, DiMacroMemento diMacroMemento) {
    }

    public final PBounds getPreferredBounds(LayoutableElement layoutableElement) {
        Object object;
        PBounds pBounds;
        PBounds pBounds2 = pBounds = this.useBoundsCache() ? layoutableElement.getPreferredBoundsCache() : null;
        if (pBounds == null) {
            object = layoutableElement.getContainedElements();
            List list = this.A((List)object);
            boolean bl = this.B.getLayoutValidator().isFrozen(layoutableElement);
            if (bl) {
                if (layoutableElement instanceof LayoutableNode) {
                    LayoutableNode layoutableNode = (LayoutableNode)layoutableElement;
                    pBounds = new PBounds(0.0, 0.0, layoutableNode.getWidth(), layoutableNode.getHeight());
                } else {
                    pBounds = new PBounds();
                }
            } else {
                pBounds = this.getPreferredBoundsImpl(layoutableElement, list);
            }
            layoutableElement.setPreferredBoundsCache(pBounds);
        }
        if (layoutableElement instanceof LayoutableNode) {
            object = (LayoutableNode)layoutableElement;
            double d2 = this.B.getStyle().getCustomWidth().get((LayoutableElement)object);
            double d3 = this.B.getStyle().getCustomHeight().get((LayoutableElement)object);
            pBounds.width = Math.max(d2, pBounds.width);
            pBounds.height = Math.max(d3, pBounds.height);
        }
        return pBounds;
    }

    protected PBounds getPreferredBoundsImpl(LayoutableElement layoutableElement, List list) {
        return new PBounds();
    }

    public final PDimension getMinimumSize(LayoutableElement layoutableElement) {
        List list = CollectionFactory.createArrayList();
        this.sortContainedElements(layoutableElement, list, null, null);
        PDimension pDimension = this.getMinimumSizeImpl(layoutableElement, list);
        return pDimension;
    }

    protected PDimension getMinimumSizeImpl(LayoutableElement layoutableElement, List list) {
        PBounds pBounds = this.getPreferredBoundsImpl(layoutableElement, list);
        PDimension pDimension = new PDimension(pBounds.getWidth(), pBounds.getHeight());
        return pDimension;
    }

    public PBounds getFullBoundsIncludingShapes(LayoutableElement layoutableElement) {
        PBounds pBounds = LayoutableElements.getLocalBounds(layoutableElement);
        List list = layoutableElement.getContainedElements();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            LayoutStrategy layoutStrategy;
            PBounds pBounds2;
            LayoutableElement layoutableElement2 = (LayoutableElement)list.get(i2);
            if (!layoutableElement2.isVisible() || !((pBounds2 = (layoutStrategy = this.getLayout(layoutableElement2)) != null ? layoutStrategy.getFullBoundsIncludingShapes(layoutableElement2) : LayoutableElements.getLocalBounds(layoutableElement2)).getWidth() > 0.0 | pBounds2.getHeight() > 0.0)) continue;
            pBounds2.x += layoutableElement.getTranslateX();
            pBounds2.y += layoutableElement.getTranslateY();
            pBounds.add(pBounds2);
        }
        return pBounds;
    }

    public final void setNodeShape(LayoutableNode layoutableNode, PBounds pBounds, DiMacroMemento diMacroMemento) {
        this.setNodeShape(layoutableNode, pBounds.getX(), pBounds.getY(), pBounds.getWidth(), pBounds.getHeight(), diMacroMemento);
    }

    public final void setNodeShape(LayoutableNode layoutableNode, double d2, double d3, double d4, double d5, DiMacroMemento diMacroMemento) {
        Object object;
        boolean bl;
        Project project = this.getProject();
        double d6 = Double.isNaN(d2) ? layoutableNode.getTranslateX() : d2;
        double d7 = Double.isNaN(d3) ? layoutableNode.getTranslateY() : d3;
        double d8 = Double.isNaN(d4) ? layoutableNode.getWidth() : d4;
        double d9 = Double.isNaN(d5) ? layoutableNode.getHeight() : d5;
        double d10 = layoutableNode.getTranslateX();
        double d11 = layoutableNode.getTranslateY();
        double d12 = layoutableNode.getWidth();
        double d13 = layoutableNode.getHeight();
        boolean bl2 = d10 != d6 || d11 != d7;
        boolean bl3 = bl = d12 != d8 || d13 != d9;
        if (diMacroMemento != null && (object = layoutableNode.getLayoutMemento(project)) != null) {
            diMacroMemento.add((DiMemento)object);
        }
        if (bl2 || bl) {
            object = this.getProject().getLayoutValidator().getLayout(layoutableNode);
            ((LayoutStrategy)object).adjustChildren(layoutableNode, d10, d11, d12, d13, d6, d7, d8, d9, diMacroMemento);
            if (bl2) {
                layoutableNode.setTranslation(d6, d7);
            }
            if (bl) {
                layoutableNode.setSize(d8, d9);
                this.B.getLayoutValidator().setDirty(layoutableNode);
            }
            this.updateSelfEdges(layoutableNode, d6, d7, d8, d9, d10, d11, d12, d13, diMacroMemento);
        }
    }

    protected void adjustChildren(LayoutableNode layoutableNode, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, DiMacroMemento diMacroMemento) {
    }

    public LayoutStrategy getLayout(LayoutableElement layoutableElement) {
        LayoutStrategy layoutStrategy = this.B.getLayoutValidator().getLayout(layoutableElement);
        return layoutStrategy;
    }

    public ShapeStrategy getShape(LayoutableElement layoutableElement) {
        ShapeStrategy shapeStrategy = this.B.getLayoutValidator().getShape(layoutableElement);
        return shapeStrategy;
    }

    public void updateSelfEdges(LayoutableNode layoutableNode, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, DiMacroMemento diMacroMemento) {
        double d10 = d2 - d6;
        double d11 = d2 + d4 - (d6 + d8);
        double d12 = d3 - d7;
        double d13 = d3 + d5 - (d7 + d9);
        boolean bl = Utils.compare((double)d10, (double)0.0) != 0;
        boolean bl2 = Utils.compare((double)d11, (double)0.0) != 0;
        boolean bl3 = Utils.compare((double)d12, (double)0.0) != 0;
        boolean bl4 = Utils.compare((double)d13, (double)0.0) != 0;
        Collection collection = layoutableNode.getConnectors();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            double d14;
            double d15;
            int n2;
            LayoutableElement layoutableElement;
            LayoutableElement layoutableElement2;
            LayoutableConnector layoutableConnector = (LayoutableConnector)iterator.next();
            Collection collection2 = layoutableConnector.getLayoutableEdges();
            if (collection2.size() != 1) continue;
            LayoutableEdge layoutableEdge = (LayoutableEdge)collection2.iterator().next();
            LayoutableConnector layoutableConnector2 = layoutableEdge.getSourceConnector();
            LayoutableConnector layoutableConnector3 = layoutableEdge.getTargetConnector();
            if (layoutableConnector2 == null || layoutableConnector3 == null || (layoutableElement2 = layoutableConnector2.getLayoutableElement()) != (layoutableElement = layoutableConnector3.getLayoutableElement()) || layoutableConnector2 != layoutableConnector) continue;
            if (diMacroMemento != null) {
                diMacroMemento.add(layoutableEdge.getLayoutMemento(this.B));
            }
            double d16 = layoutableEdge.getTranslateX();
            double d17 = layoutableEdge.getTranslateY();
            if (d4 == d8 && d5 == d9) {
                if (d2 != d6 || d3 != d7) {
                    double d18 = d2 - d6;
                    double d19 = d3 - d7;
                    layoutableEdge.setTranslation(d16 + d18, d17 + d19);
                }
                return;
            }
            int n3 = layoutableEdge.getWaypointCount();
            if (n3 <= 1) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            for (n2 = 1; n2 < n3 - 1; ++n2) {
                d15 = layoutableEdge.getWaypointX(n2) + d16;
                d14 = layoutableEdge.getWaypointY(n2) + d17;
                bl5 |= d15 <= d6;
                bl6 |= d15 >= d6 + d8;
                bl7 |= d14 <= d7;
                bl8 |= d14 >= d7 + d9;
            }
            for (n2 = 1; n2 < n3 - 1; ++n2) {
                d15 = layoutableEdge.getWaypointX(n2);
                d14 = layoutableEdge.getWaypointY(n2);
                double d20 = d15;
                double d21 = d14;
                if (bl && bl5 && (!bl6 || d15 + d16 < d6)) {
                    d20 = d15 + d10;
                }
                if (bl2 && bl6 && (!bl5 || d15 + d16 > d6)) {
                    d20 = d15 + d11;
                }
                if (bl3 && bl7 && (!bl8 || d14 + d17 < d7)) {
                    d21 = d14 + d12;
                }
                if (bl4 && bl8 && (!bl7 || d14 + d17 > d7)) {
                    d21 = d14 + d13;
                }
                if (d15 == d20 && d14 == d21) continue;
                layoutableEdge.setWaypoint(n2, d20, d21);
            }
            EdgeShape.setEdgeEndpointsToShortestPath(layoutableEdge, this.B);
        }
    }

    public List getDependentElementsToInvalidate(LayoutableElement layoutableElement) {
        return Collections.EMPTY_LIST;
    }

    public static class _A
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n2;
            boolean bl = object instanceof LayoutableNode;
            boolean bl2 = object2 instanceof LayoutableNode;
            if (bl && bl2) {
                n2 = 0;
            } else if (bl) {
                n2 = -1;
            } else if (bl2) {
                n2 = 1;
            } else {
                LayoutableEdge layoutableEdge = (LayoutableEdge)object;
                LayoutableEdge layoutableEdge2 = (LayoutableEdge)object2;
                LayoutableConnector layoutableConnector = layoutableEdge.getSourceConnector();
                LayoutableConnector layoutableConnector2 = layoutableEdge.getTargetConnector();
                if (layoutableConnector2 == null || layoutableConnector == null) {
                    return -1;
                }
                if (Utils.equals((Object)layoutableConnector.getLayoutableElement(), (Object)layoutableEdge2) || Utils.equals((Object)layoutableConnector2.getLayoutableElement(), (Object)layoutableEdge2)) {
                    n2 = -1;
                } else {
                    LayoutableConnector layoutableConnector3 = layoutableEdge2.getSourceConnector();
                    LayoutableConnector layoutableConnector4 = layoutableEdge2.getTargetConnector();
                    if (layoutableConnector4 == null || layoutableConnector3 == null) {
                        return 1;
                    }
                    n2 = Utils.equals((Object)layoutableConnector3.getLayoutableElement(), (Object)layoutableEdge) || Utils.equals((Object)layoutableConnector4.getLayoutableElement(), (Object)layoutableEdge) ? 1 : 0;
                }
            }
            return n2;
        }
    }
}

