/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.piccolo.nodes;

import com.gentleware.jboogie.layout.LayoutableDiagram;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.layout.LayoutableNode;
import com.gentleware.jboogie.model_management.SemanticModelBridgePresentation;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.piccolo.nodes.P;
import com.gentleware.jboogie.util.DiMemento;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.jboogie.util.RenderingQuality;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Strings;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;

public class PDiagram
extends PLayer
implements LayoutableDiagram {
    private static final Logger x = Logger.getLogger((String)"com.gentleware.jboogie.piccolo.nodes.PGridLayer");
    public static final String CLIENT_KEY_RENDERING_QUALITY = "RENDERING_QUALITY";
    public static final String MAIN_DIAGRAM = "MAIN_DIAGRAM";
    public static final String BIRDVIEW = "BIRDVIEW";
    public static final String PAINTGRID = "PAINTGRID";
    public static final String PAINT = "PAINT";
    public static final String DRAWING_SHAPE = "DRAWING_SHAPE";
    public static final String EXPORT_TYPE = "EXPORT_TYPE";
    private static final int \u00b5 = 10;
    private static boolean v = true;
    private static final Color \u00a5 = new Color(164, 164, 164);
    private static final Color q = new Color(192, 192, 192);
    public static final Color BACKGROUND_COLOR = new Color(236, 236, 236);
    private static final int r = 2;
    private static final BasicStroke \u00ba = new BasicStroke(2.0f);
    private static final BasicStroke \u00aa = new BasicStroke(0.0f);
    private static final BasicStroke t = new BasicStroke(1.0f);
    private Rectangle2D \u00a4;
    private double \u00a2 = 0.5;
    private P \u00a3;
    private Project y;
    private static final int w = 40;
    private Paint p;
    private boolean z = true;
    private boolean u = false;
    private int s = 10;

    public PDiagram(Project project) {
        this.y = project;
        this.\u00a3 = new P((PNode)this);
    }

    public static void setGridSpacing(int n2) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putInteger("jboogie/gui.grid2.spacing", n2);
    }

    public static int getGridSpacing() {
        Configuration configuration = Services.getInstance().getConfiguration();
        int n2 = configuration.getInteger("jboogie/gui.grid2.spacing", 20);
        return n2;
    }

    public static boolean paintDots() {
        Configuration configuration = Services.getInstance().getConfiguration();
        boolean bl = configuration.getBoolean("jboogie/gui.grid2.dots", false);
        return bl;
    }

    public static void setPaintDots(boolean bl) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putBoolean("jboogie/gui.grid2.dots", bl);
    }

    public static boolean isGridVisible() {
        Configuration configuration = Services.getInstance().getConfiguration();
        boolean bl = configuration.getBoolean("jboogie/gui/grid2/visible", true);
        return bl;
    }

    public static void setGridVisible(boolean bl) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putBoolean("jboogie/gui/grid2/visible", bl);
    }

    public static void setGridSnap(boolean bl) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putBoolean("jboogie/gui.grid2.snap", bl);
    }

    public static boolean isGridSnap() {
        Configuration configuration = Services.getInstance().getConfiguration();
        boolean bl = configuration.getBoolean("jboogie/gui.grid2.snap", true);
        return bl;
    }

    public static void setGridSnapSpacing(int n2) {
        Configuration configuration = Services.getInstance().getConfiguration();
        configuration.putInteger("jboogie/gui.grid2.snap_spacing", n2);
    }

    public static int getGridSnapSpacing() {
        Configuration configuration = Services.getInstance().getConfiguration();
        int n2 = configuration.getInteger("jboogie/gui.grid2.snap_spacing", 10);
        return n2;
    }

    public PBounds computeFullBounds(PBounds pBounds) {
        PBounds pBounds2 = super.computeFullBounds(pBounds);
        pBounds2.x -= 40.0;
        pBounds2.y -= 40.0;
        pBounds2.width += 80.0;
        pBounds2.height += 80.0;
        return pBounds2;
    }

    public void fullPaint(PPaintContext pPaintContext) {
        if (this.getVisible()) {
            PAffineTransform pAffineTransform = this.getTransformReference(true);
            float f2 = this.getTransparency();
            pPaintContext.pushTransform(pAffineTransform);
            pPaintContext.pushTransparency(f2);
            this.paint(pPaintContext);
            if (this.fullIntersects(pPaintContext.getLocalClip())) {
                int n2 = this.getChildrenCount();
                List list = this.getChildrenReference();
                for (int i2 = 0; i2 < n2; ++i2) {
                    PNode pNode = (PNode)list.get(i2);
                    pNode.fullPaint(pPaintContext);
                }
                this.paintAfterChildren(pPaintContext);
            }
            pPaintContext.popTransparency(f2);
            pPaintContext.popTransform(pAffineTransform);
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        Shape shape;
        PCamera pCamera = pPaintContext.getCamera();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        try {
            RenderingQuality renderingQuality = (RenderingQuality)pCamera.getClientProperty((Object)CLIENT_KEY_RENDERING_QUALITY);
            if (renderingQuality != null) {
                renderingQuality.configureGraphics(graphics2D);
            }
        }
        catch (RuntimeException runtimeException) {
            x.error((Object)runtimeException);
        }
        boolean bl = false;
        boolean bl2 = true;
        Paint paint = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if (pCamera != null) {
            bl = pCamera.getClientProperty((Object)BIRDVIEW) != null;
            bl2 = pCamera.getClientProperty((Object)PAINTGRID) == null;
            paint = (Paint)pCamera.getClientProperty((Object)PAINT);
            if (paint != null) {
                bl3 = true;
            }
            bl4 = pCamera.getClientProperty((Object)JBoogieUtils.IS_EXPORTING) != null;
            string = (String)pCamera.getClientProperty((Object)EXPORT_TYPE);
        }
        PBounds pBounds = this.getBoundsReference();
        if (bl3) {
            shape = (Shape)pCamera.getClientProperty((Object)DRAWING_SHAPE);
            if (shape == null) {
                shape = pBounds;
            }
            graphics2D.setPaint(paint);
        } else {
            paint = this.getPaint();
            shape = pBounds;
            if (paint != null) {
                graphics2D.setPaint(paint);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
        BufferedImage bufferedImage = null;
        if (bufferedImage != null && bl4) {
            boolean bl5 = "ps".equals(string) || "eps".equals(string);
            String string2 = null;
            this.A(shape.getBounds(), bufferedImage, graphics2D, bl5 ? string2 : null);
        }
        if (!bl && PDiagram.isGridVisible() && pPaintContext.getScale() > this.\u00a2 && bl2) {
            this.A(pPaintContext);
        }
        this.A(pBounds, graphics2D);
        this.B(graphics2D);
    }

    private void A(PBounds pBounds, Graphics2D graphics2D) {
        if (this.u) {
            double d2 = pBounds.getWidth() - 2.0 * (double)this.s;
            double d3 = pBounds.getHeight() - 2.0 * (double)this.s;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(pBounds.getX() + (double)this.s, pBounds.getY() + (double)this.s, d2, d3, 15.0, 15.0);
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0);
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(Color.black);
            graphics2D.draw(double_);
        }
    }

    private void B(Graphics2D graphics2D) {
        if (this.z) {
            PBounds pBounds = this.getBoundsReference();
            graphics2D.setStroke(t);
            graphics2D.setPaint(this.p);
            graphics2D.draw((Shape)pBounds);
        }
    }

    public void setBorderLinePaint(Paint paint) {
        this.p = paint;
        this.invalidatePaint();
    }

    public void setPaintBorder(boolean bl) {
        this.z = bl;
        this.invalidatePaint();
    }

    public void setPaintDottedLine(boolean bl) {
        this.u = bl;
        this.invalidatePaint();
    }

    private void A(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.\u00a4 = graphics2D.getClipBounds();
        if (PDiagram.paintDots()) {
            this.C(graphics2D);
        } else {
            this.A(graphics2D);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
    }

    private void A(Rectangle rectangle, BufferedImage bufferedImage, Graphics2D graphics2D, String string) {
        if (rectangle.getWidth() > 10.0 && rectangle.getHeight() > 10.0) {
            if (string != null) {
                this.A(rectangle, string, graphics2D);
            } else if (v) {
                this.B(rectangle, bufferedImage, graphics2D);
            } else {
                this.A(rectangle, bufferedImage, graphics2D);
            }
        }
    }

    private void A(Rectangle rectangle, String string, Graphics2D graphics2D) {
        int n2 = 20;
        Font font = new Font("SansSerif", 2, 20);
        Color color = new Color(224, 224, 224);
        double d2 = -0.15707963267948966;
        this.A(rectangle, string, graphics2D, 20, font, color, -0.15707963267948966);
    }

    private void A(Rectangle rectangle, String string, Graphics2D graphics2D, int n2, Font font, Paint paint, double d2) {
        Font font2 = graphics2D.getFont();
        Paint paint2 = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
        graphics2D.rotate(d2, rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY() + rectangle.getHeight() / 2.0);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        int n3 = (int)(rectangle.getWidth() / rectangle2D.getWidth()) + 1;
        String string2 = Strings.repeat((String)(string + "  "), (int)(2 * n3));
        int n4 = (int)(-rectangle.getHeight());
        while ((double)n4 < 2.0 * rectangle.getHeight()) {
            graphics2D.drawString(string2, (float)(rectangle.getX() - rectangle.getWidth() / 2.0), (float)rectangle.getY() + (float)n4);
            n4 += 2 * n2;
        }
        graphics2D.setPaint(paint2);
        graphics2D.setFont(font2);
        graphics2D.setTransform(affineTransform);
    }

    private void A(Rectangle rectangle, BufferedImage bufferedImage, Graphics2D graphics2D) {
        double d2;
        double d3;
        AffineTransform affineTransform = new AffineTransform();
        double d4 = rectangle.getWidth() / (double)bufferedImage.getWidth();
        double d5 = rectangle.getHeight() / (double)bufferedImage.getHeight();
        double d6 = Math.min(d4, d5);
        if (d4 < d5) {
            d3 = rectangle.getX();
            d2 = rectangle.getY() + (rectangle.getHeight() - (double)bufferedImage.getHeight() * d6) / 2.0;
        } else {
            d3 = rectangle.getX() + (rectangle.getWidth() - (double)bufferedImage.getWidth() * d6) / 2.0;
            d2 = rectangle.getY();
        }
        affineTransform.setToTranslation(d3, d2);
        if (d6 > 1.0) {
            affineTransform.scale(d6, d6);
        }
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
    }

    private void B(Rectangle rectangle, BufferedImage bufferedImage, Graphics2D graphics2D) {
        AffineTransform affineTransform;
        BufferedImage bufferedImage2 = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 1);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage2.getGraphics();
        for (double d2 = 0.0; d2 < rectangle.getHeight(); d2 += (double)bufferedImage.getHeight()) {
            for (double d3 = 0.0; d3 < rectangle.getWidth(); d3 += (double)bufferedImage.getWidth()) {
                affineTransform = new AffineTransform();
                affineTransform.setToTranslation(d3, d2);
                graphics2D2.drawRenderedImage(bufferedImage, affineTransform);
            }
        }
        graphics2D2.dispose();
        affineTransform = new AffineTransform();
        affineTransform.setToTranslation(rectangle.getX(), rectangle.getY());
        graphics2D.drawRenderedImage(bufferedImage2, affineTransform);
    }

    private void A(Graphics2D graphics2D) {
        int n2 = PDiagram.getGridSpacing();
        int n3 = (int)this.\u00a4.getX() / n2 * n2 - n2;
        int n4 = (int)this.\u00a4.getY() / n2 * n2 - n2;
        int n5 = (int)this.\u00a4.getHeight() / n2 + 3;
        int n6 = (int)this.\u00a4.getX() + (int)this.\u00a4.getWidth();
        int n7 = (int)this.\u00a4.getY() + (int)this.\u00a4.getHeight();
        graphics2D.setColor(q);
        graphics2D.setStroke(\u00aa);
        int n8 = n3;
        for (int i2 = (int)this.\u00a4.getWidth() / n2 + 3; i2 > 0; --i2) {
            graphics2D.drawLine(n8, n4, n8, n7);
            n8 += n2;
        }
        int n9 = n4;
        while (n5 > 0) {
            graphics2D.drawLine(n3, n9, n6, n9);
            n9 += n2;
            --n5;
        }
    }

    private void C(Graphics2D graphics2D) {
        int n2 = PDiagram.getGridSpacing();
        int n3 = (int)this.\u00a4.getX() / n2 * n2 - n2;
        int n4 = (int)this.\u00a4.getY() / n2 * n2 - n2;
        int n5 = (int)this.\u00a4.getHeight() / n2 + 3;
        int n6 = (int)(this.\u00a4.getX() + (double)((int)this.\u00a4.getWidth())) / n2 * n2 + n2;
        int n7 = (int)(this.\u00a4.getY() + (double)((int)this.\u00a4.getHeight())) / n2 * n2 + n2;
        PBounds pBounds = this.getBoundsReference();
        Color color = (Color)this.getPaint();
        graphics2D.setColor(\u00a5);
        graphics2D.setStroke(\u00ba);
        int n8 = n3;
        for (int i2 = (int)this.\u00a4.getWidth() / n2 + 3; i2 > 0; --i2) {
            graphics2D.drawLine(n8, n4, n8, n7);
            n8 += n2;
        }
        int n9 = n4;
        while (n5 > 0) {
            Rectangle2D rectangle2D = new Rectangle2D.Double(n3, n9 + 1, n6 - n3, n2 - 2);
            if (pBounds.intersects(rectangle2D)) {
                graphics2D.setColor(BACKGROUND_COLOR);
                graphics2D.fill(rectangle2D);
                graphics2D.setColor(color);
                rectangle2D = pBounds.createIntersection(rectangle2D);
                graphics2D.fill(rectangle2D);
            } else {
                graphics2D.setColor(BACKGROUND_COLOR);
                graphics2D.fill(rectangle2D);
            }
            n9 += n2;
            --n5;
        }
    }

    public void setPreferredBoundsCache(PBounds pBounds) {
        this.\u00a3.A(pBounds);
    }

    public PBounds getPreferredBoundsCache() {
        return this.\u00a3.H();
    }

    public void setSize(double d2, double d3) {
        this.\u00a3.B(d2, d3);
    }

    public double getWidth() {
        return this.\u00a3.I();
    }

    public double getHeight() {
        return this.\u00a3.J();
    }

    public void setTranslation(double d2, double d3) {
        this.\u00a3.A(d2, d3);
    }

    public double getTranslateX() {
        return this.\u00a3.E();
    }

    public double getTranslateY() {
        return this.\u00a3.F();
    }

    public boolean isVisible() {
        return this.\u00a3.C();
    }

    public List getContainedElements() {
        return this.\u00a3.G();
    }

    public LayoutableElement getContainerElement() {
        return null;
    }

    public DiMemento getLayoutMemento(Project project) {
        return this.\u00a3.B(project);
    }

    public SimpleTypeInfo getSimpleTypeInfo(Project project) {
        return this.\u00a3.C(project);
    }

    public SemanticModelBridgePresentation getPresentation(Project project) {
        return this.\u00a3.A(project);
    }

    public RefObject getSmElement(Project project, boolean bl) {
        return this.\u00a3.A(project, bl);
    }

    public LayoutableElement findContainedWithModelElement(Project project, RefObject refObject) {
        return this.\u00a3.A(project, refObject);
    }

    public Point2D getClosestPointOnBorder(Project project, Point2D point2D) {
        return this.\u00a3.A(project, point2D);
    }

    public void transferToDi(Project project) {
        this.\u00a3.D(project);
    }

    public Collection getConnectors() {
        return this.\u00a3.B();
    }

    public String getProperty(String string, boolean bl, String string2) {
        return this.\u00a3.A(string, bl, string2);
    }

    public void setProperty(Project project, String string, String string2) {
        this.\u00a3.A(string, string2);
    }

    public Project getProject() {
        return this.y;
    }

    public static Point2D snapDelta(Point2D point2D) {
        Point2D point2D2 = PDiagram.snapPosition(point2D);
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = point2D2.getY() - point2D.getY();
        return new Point2D.Double(d2, d3);
    }

    public static Point2D snapPosition(double d2, double d3) {
        if (PDiagram.isGridSnap()) {
            int n2 = PDiagram.getGridSnapSpacing();
            d2 = ((int)d2 + n2 / 2) / n2 * n2;
            d3 = ((int)d3 + n2 / 2) / n2 * n2;
        }
        return new Point2D.Double(d2, d3);
    }

    public static Point2D snapPosition(Point2D point2D) {
        return PDiagram.snapPosition(point2D.getX(), point2D.getY());
    }

    public static void snapPosition(LayoutableNode layoutableNode) {
        if (PDiagram.isGridSnap()) {
            Point2D point2D = LayoutableElements.getGlobalPosition(layoutableNode);
            Point2D point2D2 = PDiagram.snapDelta(point2D);
            double d2 = layoutableNode.getTranslateX() + point2D2.getX();
            double d3 = layoutableNode.getTranslateY() + point2D2.getY();
            layoutableNode.setTranslation(d2, d3);
        }
    }

    public static void snapBounds(LayoutableNode layoutableNode, PBounds pBounds, boolean bl, boolean bl2, int n2) {
        if (PDiagram.isGridSnap()) {
            double d2 = pBounds.getWidth();
            double d3 = pBounds.getHeight();
            boolean bl3 = n2 == 2 || n2 == 3 || n2 == 4;
            boolean bl4 = n2 == 8 || n2 == 7 || n2 == 6;
            boolean bl5 = n2 == 8 || n2 == 1 || n2 == 2;
            boolean bl6 = n2 == 6 || n2 == 5 || n2 == 4;
            double d4 = pBounds.getX();
            if (bl3) {
                d4 += d2;
            }
            double d5 = pBounds.getY();
            if (bl6) {
                d5 += d3;
            }
            Point2D.Double double_ = new Point2D.Double(d4, d5);
            LayoutableElement layoutableElement = layoutableNode.getContainerElement();
            if (layoutableElement != null) {
                LayoutableElements.convertToGlobal(layoutableElement, double_);
            }
            Point2D point2D = PDiagram.snapDelta(double_);
            if (!bl) {
                d2 += (bl4 ? -1.0 : 1.0) * point2D.getX();
            }
            if (!bl2) {
                d3 += (bl5 ? -1.0 : 1.0) * point2D.getY();
            }
            double d6 = pBounds.getX();
            if (bl4) {
                d6 += point2D.getX();
            }
            double d7 = pBounds.getY();
            if (bl5) {
                d7 += point2D.getY();
            }
            pBounds.setOrigin(d6, d7);
            pBounds.setSize(d2, d3);
        }
    }
}

