/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.renderer;

import com.gentleware.jboogie.event.piccolo.PCursorHandler;
import com.gentleware.jboogie.kernel.JBoogieResourceBundle;
import com.gentleware.jboogie.layout.LayoutableEdge;
import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.layout.LayoutableElements;
import com.gentleware.jboogie.piccolo.nodes.PShape;
import com.gentleware.jboogie.piccolo.nodes.QConnector;
import com.gentleware.jboogie.piccolo.nodes.QEdge;
import com.gentleware.jboogie.renderer.C;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingFactory;
import com.gentleware.openapi.util.Geometry;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphConnectorImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphEdgeImpl;
import org.omg.uml2.diagraminterchange.GraphElement;

public class GraphEdgeRenderer
extends C {
    public static final Cursor WAYPOINT_CURSOR = SwingFactory.makeCursor((ResourceId)JBoogieResourceBundle.CursorWaypoint);
    private boolean i;

    public GraphEdgeRenderer(Project project) {
        this(project, true);
    }

    public GraphEdgeRenderer(Project project, boolean bl) {
        super(project);
        this.i = bl;
    }

    protected void updateSingle(DiagramElementImpl diagramElementImpl) {
        super.updateSingle(diagramElementImpl);
        this.updateWaypoints(diagramElementImpl);
    }

    protected void updateWaypoints(DiagramElementImpl diagramElementImpl) {
        QEdge qEdge = this.getEdgeComponent(diagramElementImpl);
        this.A(qEdge, (RefObject)diagramElementImpl);
    }

    private void A(QEdge qEdge, RefObject refObject) {
        LayoutableEdge layoutableEdge = (LayoutableEdge)refObject;
        int n2 = layoutableEdge.getWaypointCount();
        Point2D[] point2DArray = new Point2D[n2];
        for (int i2 = 0; i2 < point2DArray.length; ++i2) {
            double d2 = layoutableEdge.getWaypointX(i2);
            double d3 = layoutableEdge.getWaypointY(i2);
            point2DArray[i2] = new Point2D.Double(d2, d3);
        }
        qEdge.setWaypoints(point2DArray);
    }

    protected PNode createPiccoloNodeInt(DiagramElementImpl diagramElementImpl) {
        GraphEdgeImpl graphEdgeImpl = (GraphEdgeImpl)diagramElementImpl;
        List list = graphEdgeImpl.getAnchor();
        if (list.size() < 2) {
            return null;
        }
        GraphConnectorImpl graphConnectorImpl = (GraphConnectorImpl)list.get(0);
        GraphConnectorImpl graphConnectorImpl2 = (GraphConnectorImpl)list.get(1);
        GraphElement graphElement = graphConnectorImpl.getGraphElement();
        GraphElement graphElement2 = graphConnectorImpl2.getGraphElement();
        if (graphElement == null || graphElement2 == null) {
            return null;
        }
        QConnector qConnector = new QConnector(this.getProject(), graphConnectorImpl);
        QConnector qConnector2 = new QConnector(this.getProject(), graphConnectorImpl2);
        QEdge qEdge = this.createQEdgeInternal(qConnector, qConnector2, this.i);
        this.setPiccoloNode(qEdge, diagramElementImpl);
        this.updateStartSymbol(diagramElementImpl);
        this.updateEndSymbol(diagramElementImpl);
        PCursorHandler.setCursor(qEdge, WAYPOINT_CURSOR);
        return qEdge;
    }

    protected QEdge createQEdgeInternal(QConnector qConnector, QConnector qConnector2, boolean bl) {
        return new QEdge(qConnector, qConnector2, bl);
    }

    protected PNode getSourceSymbol(DiagramElementImpl diagramElementImpl) {
        return null;
    }

    protected PNode getTargetSymbol(DiagramElementImpl diagramElementImpl) {
        return null;
    }

    protected final void updateStartSymbol(DiagramElementImpl diagramElementImpl) {
        PNode pNode = this.getSourceSymbol(diagramElementImpl);
        this.getEdgeComponent(diagramElementImpl).setSourceSymbol(pNode);
        if (pNode instanceof PShape) {
            PShape pShape = (PShape)pNode;
            Color color = this.getStrokeColor(diagramElementImpl);
            pShape.setStrokePaint(color);
        }
    }

    protected final void updateEndSymbol(DiagramElementImpl diagramElementImpl) {
        PNode pNode = this.getTargetSymbol(diagramElementImpl);
        this.getEdgeComponent(diagramElementImpl).setTargetSymbol(pNode);
        if (pNode instanceof PShape) {
            PShape pShape = (PShape)pNode;
            Color color = this.getStrokeColor(diagramElementImpl);
            pShape.setStrokePaint(color);
        }
    }

    protected void updateColors(DiagramElementImpl diagramElementImpl) {
        PShape pShape;
        super.updateColors(diagramElementImpl);
        QEdge qEdge = this.getEdgeComponent(diagramElementImpl);
        Color color = this.getStrokeColor(diagramElementImpl);
        PNode pNode = qEdge.getSourceSymbol();
        if (pNode instanceof PShape) {
            pShape = (PShape)pNode;
            pShape.setStrokePaint(color);
        }
        if ((pShape = qEdge.getTargetSymbol()) instanceof PShape) {
            PShape pShape2 = pShape;
            pShape2.setStrokePaint(color);
        }
    }

    protected QEdge getEdgeComponent(DiagramElementImpl diagramElementImpl) {
        return (QEdge)this.getPiccoloNode(diagramElementImpl);
    }

    public Point2D getViewWaypoint(int n2, DiagramElementImpl diagramElementImpl) {
        QEdge qEdge = (QEdge)this.getPiccoloNode(diagramElementImpl);
        Point2D point2D = qEdge.getPoint(n2);
        return point2D;
    }

    public double getSymbolRotation(boolean bl, DiagramElementImpl diagramElementImpl) {
        QEdge qEdge = (QEdge)this.getPiccoloNode(diagramElementImpl);
        return this.getSymbolRotation(bl, qEdge);
    }

    public double getSymbolRotation(boolean bl, QEdge qEdge) {
        double d2;
        if (qEdge.getWaypointCount() < 2) {
            d2 = 0.0;
        } else {
            Point2D point2D;
            Point2D point2D2;
            if (bl) {
                point2D2 = qEdge.getPoint(0);
                point2D = qEdge.getPoint(1);
            } else {
                int n2 = -1;
                point2D2 = qEdge.getPoint(-1);
                int n3 = -2;
                point2D = qEdge.getPoint(-2);
            }
            if (point2D2 == null || point2D == null) {
                return 0.0;
            }
            d2 = Geometry.getAngleBetween((Point2D)point2D2, (Point2D)point2D);
        }
        return d2;
    }

    public Point2D getClosestPointOnBorder(LayoutableElement layoutableElement, Point2D point2D) {
        LayoutableEdge layoutableEdge = (LayoutableEdge)layoutableElement;
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        LayoutableElements.convertFromGlobal((LayoutableElement)layoutableEdge, double_);
        Point2D.Double double_2 = new Point2D.Double(double_.getX(), double_.getY());
        double d2 = Double.MAX_VALUE;
        for (int i2 = 1; i2 < layoutableEdge.getWaypointCount(); ++i2) {
            double d3;
            double d4;
            double d5;
            double d6 = layoutableEdge.getWaypointX(i2 - 1);
            Point2D point2D2 = Geometry.getClosestPointOnSegment((double)d6, (double)(d5 = layoutableEdge.getWaypointY(i2 - 1)), (double)(d4 = layoutableEdge.getWaypointX(i2)), (double)(d3 = layoutableEdge.getWaypointY(i2)), (double)double_.getX(), (double)double_.getY());
            double d7 = double_.distance(point2D2);
            if (!(d7 < d2)) continue;
            d2 = d7;
            double_2.setLocation(point2D2);
        }
        LayoutableElements.convertToGlobal((LayoutableElement)layoutableEdge, double_2);
        return double_2;
    }
}

