/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.ui;

import com.gentleware.jboogie.controller.Controller;
import com.gentleware.jboogie.event.piccolo.PCursorHandler;
import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.ui.DiagramPanel;
import com.gentleware.jboogie.ui.mode.G;
import com.gentleware.openapi.jboogie.Command;
import com.gentleware.openapi.jboogie.DiId;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.SmId;
import com.gentleware.openapi.swingx.XAbstractAction;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import java.awt.geom.Point2D;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramElementImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.GraphNodeImpl;
import org.omg.uml2.diagraminterchange.DiagramElement;

public abstract class NodeCreationHandler
extends PBasicInputEventHandler {
    private static final Logger I = Logger.getLogger((String)"com.gentleware.jboogie.ui.NodeCreationHandler");
    private Project G;
    private final XAbstractAction H;
    private final G B;
    private final DiagramPanel J;
    private SmId E;
    private DiId F;
    private DiagramElementImpl C;
    private Point2D D;
    private static Class class$com$gentleware$jboogie$event$piccolo$PCursorHandler;

    protected abstract void updateTargetManager();

    protected abstract Command createNodeCommand();

    public NodeCreationHandler(Project project, DiagramPanel diagramPanel, XAbstractAction xAbstractAction, G g2) {
        this.J = diagramPanel;
        this.G = project;
        this.H = xAbstractAction;
        this.B = g2;
        PInputEventFilter pInputEventFilter = this.getEventFilter();
        pInputEventFilter.setAcceptsKeyPressed(true);
        pInputEventFilter.setAcceptsKeyTyped(true);
        this.setEventFilter(pInputEventFilter);
    }

    public void processEvent(PInputEvent pInputEvent, int n2) {
        try {
            super.processEvent(pInputEvent, n2);
        }
        catch (Throwable throwable) {
            I.error((Object)"caught exception in event handling", throwable);
        }
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        try {
            if (!ProjectImpl.isImporting()) {
                this.createNode(pInputEvent);
            }
        }
        catch (Exception exception) {
            I.error((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNode(PInputEvent pInputEvent) {
        try {
            PNode pNode = pInputEvent.getPickedNode();
            this.prepareNodeCreation(pNode, pInputEvent);
            Command command = this.createNodeCommand();
            command.execute();
            DiId diId = this.getNewNodeDiId();
            if (diId.hasElement()) {
                RefObject refObject = diId.getElement();
                if (refObject instanceof DiagramElement) {
                    Controller controller = this.getProject().getModelMapper().getController((DiagramElementImpl)refObject);
                    controller.startEditing(pInputEvent, refObject);
                }
                this.updateTargetManager();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (!this.getDiagramPanel().isToolbarselectionSticky()) {
                this.endMode();
            }
        }
    }

    protected void prepareNodeCreation(PNode pNode, PInputEvent pInputEvent) {
        if (pNode instanceof PCamera) {
            this.setContainerDiElement((GraphNodeImpl)this.getProject().getTargetManager().getActiveDiagram());
            this.setPosition(pInputEvent.getPosition());
        } else {
            PNode pNode2 = pNode;
            DiagramElementImpl diagramElementImpl = null;
            while (pNode2 != null && diagramElementImpl == null) {
                diagramElementImpl = this.getProject().getModelMapper().getDiElement(pNode2);
                if (diagramElementImpl != null) continue;
                pNode2 = pNode2.getParent();
            }
            this.setContainerDiElement(this.getMode().getTargetDiagramElement(diagramElementImpl));
            PNode pNode3 = (PNode)this.getContainerDiElement().getPiccoloElement();
            this.setPosition(pInputEvent.getPositionRelativeTo(pNode3));
        }
    }

    protected void endMode() {
        DiagramPanel diagramPanel = this.getDiagramPanel();
        diagramPanel.setModeInputListener(null);
        PCanvas pCanvas = diagramPanel.getCanvas();
        PCursorHandler pCursorHandler = (PCursorHandler)((Object)pCanvas.getClientProperty((Object)(class$com$gentleware$jboogie$event$piccolo$PCursorHandler == null ? (class$com$gentleware$jboogie$event$piccolo$PCursorHandler = NodeCreationHandler.A("com.gentleware.jboogie.event.piccolo.PCursorHandler")) : class$com$gentleware$jboogie$event$piccolo$PCursorHandler)));
        pCursorHandler.clearGlobalCursor(pCanvas);
        diagramPanel.resetToolBarButton(this.H);
    }

    public void keyPressed(PInputEvent pInputEvent) {
        try {
            super.keyPressed(pInputEvent);
            if (pInputEvent.getKeyCode() == 27) {
                this.endMode();
            }
        }
        catch (Exception exception) {
            I.error((Object)exception);
        }
    }

    protected SmId getNewNodeSmId() {
        return this.E;
    }

    protected G getMode() {
        return this.B;
    }

    protected Project getProject() {
        return this.G;
    }

    protected DiId getNewNodeDiId() {
        return this.F;
    }

    protected void setNewNodeDiId(DiId diId) {
        this.F = diId;
    }

    protected void setNewNodeSmId(SmId smId) {
        this.E = smId;
    }

    protected DiagramElementImpl getContainerDiElement() {
        return this.C;
    }

    protected void setContainerDiElement(DiagramElementImpl diagramElementImpl) {
        this.C = diagramElementImpl;
    }

    protected Point2D getPosition() {
        return this.D;
    }

    protected void setPosition(Point2D point2D) {
        this.D = point2D;
    }

    protected DiagramPanel getDiagramPanel() {
        return this.J;
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

