/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.jboogie.ui.actions;

import com.gentleware.jboogie.kernel.JBoogieResourceBundle;
import com.gentleware.jboogie.kernel.TargetManager;
import com.gentleware.jboogie.model_management.SimpleTypeInfo;
import com.gentleware.jboogie.util.Alignment;
import com.gentleware.openapi.jboogie.Command;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.ProjectAction;
import com.gentleware.openapi.swingx.ResourceId;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;

public class ActionAlign
extends ProjectAction {
    private Alignment N;
    private boolean O;

    public ActionAlign(Project project, ResourceId resourceId, Alignment alignment) {
        this(project, resourceId, alignment, true);
    }

    public ActionAlign(Project project, ResourceId resourceId, Alignment alignment, boolean bl) {
        super(project, resourceId);
        this.N = alignment;
        this.O = bl;
    }

    public void updateEnabled() {
        Project project = this.getProject();
        if (project == null) {
            this.setEnabled(false);
            return;
        }
        TargetManager targetManager = project.getTargetManager();
        Collection collection = targetManager.getSelectedDiElements();
        DiagramImpl diagramImpl = (DiagramImpl)targetManager.getActiveDiagram();
        if (diagramImpl == null || SimpleTypeInfo.SEQUENCE_DIAGRAM.equals(diagramImpl.getSimpleTypeInfo())) {
            this.setEnabled(false);
            return;
        }
        int n2 = this.O ? 1 : 0;
        boolean bl = collection.size() > n2;
        this.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.getProject().getTargetManager().getSelectedDiElements();
        List list = this.getProject().getDiId(collection);
        Alignment alignment = this.N;
        Command command = this.getProject().getDiCommandFactory().makeCommandAlign(list, alignment);
        command.execute();
    }

    public static class ToGrid
    extends ActionAlign {
        public ToGrid(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_TO_GRID, Alignment.ALIGN_TO_GRID, false);
        }
    }

    public static class VCenters
    extends ActionAlign {
        public VCenters(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_V_CENTERS, Alignment.ALIGN_V_CENTERS);
        }
    }

    public static class HCenters
    extends ActionAlign {
        public HCenters(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_H_CENTERS, Alignment.ALIGN_H_CENTERS);
        }
    }

    public static class Rights
    extends ActionAlign {
        public Rights(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_RIGHTS, Alignment.ALIGN_RIGHTS);
        }
    }

    public static class Lefts
    extends ActionAlign {
        public Lefts(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_LEFTS, Alignment.ALIGN_LEFTS);
        }
    }

    public static class Bottoms
    extends ActionAlign {
        public Bottoms(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_BOTTOMS, Alignment.ALIGN_BOTTOMS);
        }
    }

    public static class Tops
    extends ActionAlign {
        public Tops(Project project) {
            super(project, JBoogieResourceBundle.ActionAlign_ALIGN_TOPS, Alignment.ALIGN_TOPS);
        }
    }
}

